/***************************************************************************
 *                                                                         *
 *   WGSMM.H                                                               *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This is the interface to WGSMAINM.DLL's exported symbols.             *
 *                                                                         *
 *                                              - D. Pitchford 8/5/96      *
 *                                                                         *
 ***************************************************************************/

#ifndef __WGSMM_H
#define __WGSMM_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef GCWINNT
#ifdef __BUILDWGSMM
#define WGSMMEXP __export
#else
#define WGSMMEXP __import
#endif
#else
#define WGSMMEXP
#endif // GCWINNT

extern CHAR * WGSMMEXP medkey;     /* key required to use menu editor      */
                                   /*   NULL if menu editor not existent   */

struct pgllist {                   /* struct for top-of-tree page llists   */
     struct pgllist *next;         /*   next in linked list                */
     CHAR pagedata[1];             /*   page information, partially allocd */
};

extern
struct pgllist * WGSMMEXP aaftop;  /* first top-of-tree page for a/a       */
extern
struct pgllist * WGSMMEXP csftop;  /* first top-of-tree page for c/s       */
extern
struct pgllist * WGSMMEXP csfgop;  /* first goable page for c/s            */

extern
SHORT WGSMMEXP gofind;             /* option for main menu app go/find     */
                                   /* 0 = none  -1 = normal  1 = fast      */

CHAR *                             /*   returns "" for orphan              */
gofdesc(                           /* return description of page from menu */
struct mnupag *mp);                /*   page to get description of         */

VOID
pglset(                            /* set current linked list              */
struct pgllist **pgltop);

VOID
pglclear(VOID);                    /* destroy current linked list          */

VOID
pglopins(                          /* insert a page key in memory          */
CHAR *pagedata);                   /*   page name/data                     */

GBOOL                              /*   TRUE=succeeded, FALSE=no such page */
pglopdel(                          /* delete a page key from memory        */
CHAR *pagnam);                     /*   page name                          */

struct pgllist *                   /*   page, or NULL if no exist          */
pglopgeq(                          /* get page struct in memory            */
CHAR *pagnam);                     /*   page name                          */

struct pgllist *                   /*   page, or NULL if no exist          */
pglopggt(                          /* get next greater page struct in mem  */
CHAR *pagnam);                     /*   page name                          */

struct pgllist *                   /*   page, or NULL if no exist          */
pglopglt(                          /* get next lesser page struct in mem   */
CHAR *pagnam);                     /*   page name                          */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __WGSMM_H
