/***************************************************************************
 *                                                                         *
 *   XRFAH.H                                                               *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Find User Active HTML Decs.                                           *
 *                                                  - N.C. Osterc  6/13/98 *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "tvb.h"
#include "dnf.h"
#include "ahutil.h"
#include "ahusrxrf.h"
#include "ftg.h"
#include "iostream.h"
#include "fioapi.h"

///////////////////////////////////////////////////////////////////////////
//
// Xrf Agent declaration.
//
///////////////////////////////////////////////////////////////////////////

class xrfAgent : public acthAgent {              // xrf agent
public:

     VOID
     getMessageOptions();          // get finduser message options

     xrfAgent();                   // constructor

     ~xrfAgent();                  // destructor

     acthSynthesis *               // my session info (NULL=can't)
     newSynthesis(                 // instantiate my Synthesis class
     acthSession *ses);            // for passing to acthSynthesis's ctor
};

///////////////////////////////////////////////////////////////////////////
//
// Find User Synthesis.
//
///////////////////////////////////////////////////////////////////////////

class xrfSynthesis : public acthSynthesis {      // xrfah response synthesis
public:
     xrfSynthesis(acthSession *_ses); // constructor

     ~xrfSynthesis();              // destructor

private:

     dnfHandler *m_dnfPtr;         // Pointer to DNF object
     acthUserXrf *m_xrfPtr;        // Pointer to XRF-object

     CHAR m_inpBuf[UIDSIZ];        // buffer for input variables
     GBOOL m_bNoName;              // no name was passed
     GBOOL m_bNoItemName;          // no itemname was passed (where to send value back to parent form)
     CHAR m_ItemName[UIDSIZ];      // name of item in html form to ret value
     INT m_matches;                // max number of matches
     CHAR *m_matchPtr;             // points to current match
     CHAR m_query[UIDSIZ];         // query string
     GBOOL m_noneFound;            // no matches found
     INT m_found;                  // number of matches found

     ACTHCODE
     proceed();                    // acth derived method

     VOID
     clearAll();                   // clear all tvb values

     VOID
     setTvbError(                  // set error tvb
     const CHAR *errmsg);          // the error message
};

////////////////////////////////////////////////////////////////////////////
//
//  Xrf text variable class dec.
//
////////////////////////////////////////////////////////////////////////////

class xrfTvb : public tvbDefinition {
public:

     xrfTvb(                       // constructor
     const CHAR* name);            // name of text variable

     ~xrfTvb();                    // destructor

     virtual VOID
     set(                          // set value of text variable
     const CHAR* newValue);        // the value to set

     virtual const CHAR*           // the value gotten
     get() const;                  // get value of tvb

     VOID
     clr();                        // clear text variable value

     GBOOL
     htmlEncodeIt();               // should we HTML encode?

     VOID
     setHtmlEncode(                // enable HTML encoding?
     GBOOL bVal);                  // boolean set

     virtual const CHAR*           // value of variable
     resolve(                      // resolve the value of a tvb
     const CHAR *nam);             // tvb to resolve

protected:

     const CHAR* m_pVal;           // the tvb value
     GBOOL m_bHtmlEncode;          // html encode?
};
