/***************************************************************************
 *                                                                         *
 *   GALXRFAH.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Find User Active HTML.                                                *
 *                                                  - N.C. Osterc  6/13/97 *
 *                                                                         *
 *   N. Hammond                                                            *
 *   Allow user to click on name in find box and populate parent form      *
 *   by adding the itemname=parameter to indicate the parent window's      *
 *   formmame and field name (in the format "FORMNAME.FIELDNAME")          *
 *                                                                         *
 ***************************************************************************/

#include "xrfah.h"
#include "wgsmajor.h"
#include "dnfmgr.h"
#include "galxrfah.h"
#include "enctvb.h"
#include <cstring>

#define FILREV "$Revision: 7 $"

#define PPFIX "galacth/galxrfah/"
#define GETINPUT(X) (ses->param(X,m_inpBuf,UIDSIZ))

CHAR *noQueryValue=NULL;           // no query value given from .MSG
CHAR *noneAllowed=NULL;            // default number of xrfs is 0 from .MSG
CHAR *noneFound=NULL;              // no matches were found from .MSG

xrfAgent thexrfAgent;              // the one and only instance of xrfAgent

enum {XRFLIST};
dnfStep dnfXrfListSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,XRFLIST,"XRFLIST"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};

dnfStep dnfDefaultSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap xrfListMap(PPFIX "xrfout.htm", "Find User Response", dnfXrfListSteps);
dnfMap xrfDefaultMap(PPFIX "index.htm","Default Response", dnfDefaultSteps);

xrfTvb xrfUser("XRF_USER");
xrfTvb xrfUserEnc("XRF_USER_ENC");
xrfTvb xrfQuery("XRF_QUERY");
xrfTvb xrfError("XRF_ERROR");
xrfTvb xrfItemName("XRF_ITEMNAME");

//////////////////////////////////////////////////////////////////////////
//
//  Find User cross-ref agent class defs.
//
//////////////////////////////////////////////////////////////////////////

MARKSOURCE(galxrfah);

xrfAgent::xrfAgent() :
     acthAgent("Find Users","finduser")
{
     registerAgent(acthVersion);
     getMessageOptions();
}

xrfAgent::~xrfAgent()              // Agent destructor
{
     if (noQueryValue != NULL) {
          delete [] noQueryValue;
          noQueryValue=NULL;
     }
     if (noneAllowed != NULL) {
          delete [] noneAllowed;
          noneAllowed=NULL;
     }
     if (noneFound != NULL) {
          delete [] noneFound;
          noneFound=NULL;
     }
}

VOID
xrfAgent::getMessageOptions()      // get finduser message options
{
     HMCVFILE xrfmsg=opnmsg("GALXRFAH.MCV");
     setmbk(xrfmsg);
     CHAR *mPtr;
     noQueryValue=new CHAR[strlen(mPtr=getmsg(NOQRYVAL))+1];
     strcpy(noQueryValue,mPtr);
     noneAllowed=new CHAR[strlen(mPtr=getmsg(NONEALW))+1];
     strcpy(noneAllowed,mPtr);
     noneFound=new CHAR[strlen(mPtr=getmsg(NONEFND))+1];
     strcpy(noneFound,mPtr);
     rstmbk();
}

acthSynthesis *
xrfAgent::newSynthesis(            // return a new synth object
acthSession *ses)
{
     return(new xrfSynthesis(ses));
}

//////////////////////////////////////////////////////////////////////////
//
//  Find User cross-ref tvb defs.
//
//////////////////////////////////////////////////////////////////////////

xrfTvb::xrfTvb(                    // constructor
const CHAR* name) :
     tvbDefinition(name),
     m_bHtmlEncode(FALSE),
     m_pVal(NULL)
{
     registerDef();
}

xrfTvb::~xrfTvb()                  // destructor
{
     clr();
}

VOID
xrfTvb::set(                       // set text variable
const CHAR *newValue)              // text variable value
{
     ASSERT(newValue != NULL);
     if (m_pVal != NULL) {
          free((VOID*)m_pVal);
     }
     m_pVal=(const CHAR *)strdup(newValue);
}

const CHAR*                        // tvb value
xrfTvb::get() const                // get it
{
     return(m_pVal);
}

VOID
xrfTvb::clr()                      // clear tvb value
{
     if (m_pVal != NULL) {
          free((VOID*)m_pVal);
          m_pVal=NULL;
     }
}

GBOOL
xrfTvb::htmlEncodeIt()             // should we html encode?
{
     return(m_bHtmlEncode);
}

VOID
xrfTvb::setHtmlEncode(             // set html encode for tvb
GBOOL bVal)                        // boolean set value
{
     m_bHtmlEncode=bVal;
}

const CHAR*                        // the resolved value of the tvb
xrfTvb::resolve(                   // resolve the value of a tvb
const CHAR* nam)                   // the name of the tvb
{
     if (m_pVal != NULL) {
          if (htmlEncodeIt()) {
               return((const CHAR*)Stp4Html((CHAR*)m_pVal));
          }
          else {
               return(m_pVal);
          }
     }
     (VOID*)nam;
     return("");
}

//////////////////////////////////////////////////////////////////////////
//
//  Find User cross-ref synthesis class defs.
//
//////////////////////////////////////////////////////////////////////////


xrfSynthesis::xrfSynthesis(        // constructor
acthSession *_ses) :
     acthSynthesis(_ses),
     m_dnfPtr(NULL),
     m_xrfPtr(NULL),
     m_matchPtr(NULL),
     m_bNoName(FALSE),
     m_bNoItemName(FALSE),
     m_matches(0),
     m_found(0),
     m_noneFound(FALSE)
{
     m_query[0]='\0';
}

xrfSynthesis::~xrfSynthesis()      // destructor
{
     if (m_dnfPtr != NULL) {
          delete m_dnfPtr;
          m_dnfPtr = NULL;
     }
     if (m_xrfPtr != NULL) {
          delete m_xrfPtr;
          m_xrfPtr = NULL;
     }
}

VOID
xrfSynthesis::setTvbError(         // set error text variable
const CHAR *errmsg)
{
     xrfError.set(errmsg);
}

VOID
xrfSynthesis::clearAll()           // clear all text variables
{
     xrfError.clr();
     xrfQuery.clr();
     xrfUser.clr();
     xrfUserEnc.clr();
     xrfItemName.clr();
}

ACTHCODE
xrfSynthesis::proceed()            // proceed entry point on finduser synth
{
     ACTHCODE retval=ACTHMORE;

     if (strchr(ses->urlsfx(),'.') == NULL) {
          if (ses->forceDir()) {
               return(ACTHDONE);
          }
     }
     if (ses->urlargc() == 0) {
          if (m_dnfPtr == NULL) {
               if ((m_dnfPtr=dnfCreateHandlerURL(ses,&xrfDefaultMap,PPFIX))
                == NULL) {
                    return(ACTHNOTFND);
               }
          }
          switch(m_dnfPtr->process()) {
          case DNFEND:
               retval=ACTHDONE;
               break;
          }
     }
     else if (ses->urlargc() == 1 && sameas(ses->urlargv(0),"list")) {
          clearAll();
          if (m_dnfPtr == NULL) {
               GETINPUT("itemname");
               if (m_inpBuf[0] == '\0') {
                        m_bNoItemName=TRUE;
               }
               else {
                        stlcpy(m_ItemName,m_inpBuf,UIDSIZ);
               }
               if (m_ItemName != NULL) {
                       xrfItemName.set(m_ItemName);
               }
               GETINPUT("name");
               if (m_inpBuf[0] == '\0') {
                    m_bNoName=TRUE;
               }
               else {
                    stlcpy(m_query,m_inpBuf,UIDSIZ);
                    GETINPUT("matches");
                    if(m_inpBuf[0] != '\0' && alldgs(m_inpBuf)) {
                         m_matches=atoi(m_inpBuf);
                    }
                    else {
                         setmbk(mjrmb);
                         m_matches=numopt(NUMXRF,0,16);
                         rstmbk();
                    }
                    if (m_matches > 0 && !m_bNoName) {
                         m_xrfPtr=new acthUserXrf(m_query,m_matches);
                    }
               }
               if ((m_dnfPtr=dnfCreateHandlerURL(ses,&xrfListMap,PPFIX))
                == NULL) {
                    return(ACTHNOTFND);
               }
          }

          if (m_matchPtr != NULL) {
                  xrfUser.set(m_matchPtr);
               xrfUserEnc.set(urlEncode(m_matchPtr).c_str());
               xrfQuery.set(m_query);
          }
          if (m_ItemName != NULL) {
                  xrfItemName.set(m_ItemName);
          }
          if (m_bNoName) {
               setTvbError(noQueryValue);
          }
          else if (m_matches == 0) {
               setTvbError(noneAllowed);
          }
          else if (m_noneFound) {
               setTvbError(noneFound);
          }

          switch (m_dnfPtr->process()) {
          case DNFROWBEGIN:
               if (m_xrfPtr == NULL || m_bNoName) {
                    m_dnfPtr->tableDone();
                    break;
               }
               else if((m_matchPtr=m_xrfPtr->getmatch()) == NULL) {
                    if (m_found == 0) {
                         m_noneFound=TRUE;
                    }
                    m_dnfPtr->tableDone();
                    break;
               }
               ++m_found;
               break;
          case DNFEND:
               retval=ACTHDONE;
               break;
          }
     }
     else {
          retval=ACTHNOTFND;
     }
     return(retval);
}
