/***************************************************************************
 *                                                                         *
 *   UIEVAR.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Account Display/Edit Variables Class.                                 *
 *                                                 - N.C. Osterc  10/21/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __UIEVAR_H
#define __UIEVAR_H

#include "gcomm.h"

#undef min(a,b)
#undef max(a,b)

#include "enctvb.h"
#include "galuieah.h"
#include "wgsuext.h"

#define SEL "SELECTED"
#define CHK "CHECKED"

class uieVar {                     // Class objectifies "account" text variables
public:

     uieVar();                     // default constructor (not used)

     ~uieVar();                    // destructor

     VOID
     setVars(                      // set up variables given
     struct usracc *uptr);        // user account structure

     VOID
     setCreditVars(                // set up credit transfer vars
     LONG creds,                   // # of credits to transfer
     const CHAR *tuser);           // the transfer user

     VOID
     setVarsDefault();             // clear all text variables

     VOID
     uieVar::setAcctExt(           // Set extended account variables
     const char *userid);          // Userid to load for

};

// text variable declarations

extern basicTvb t_Userid;                 // UIE_USER_ID
extern urlEncodedTvb t_UserURLEnc;        // UIE_USER_U
extern basicTvb t_MinPerCall;             // UIE_MINPERCALL_LIM
extern basicTvb t_CallPerDay;             // UIE_CALLPERDAY_LIM
extern basicTvb t_CreateDate;             // UIE_CREATION_DATE
extern basicTvb t_LastLogon;              // UIE_LAST_LOGON
extern basicTvb t_Birthday;               // UIE_BIRTHDAY
extern basicTvb t_CurPassWord;            // UIE_CURPWD
extern basicTvb t_AccountClass;           // UIE_CLASS
extern basicTvb t_Credits;                // UIE_CREDITS

extern basicTvb t_ErrorMessage;           // UIE_ERROR

// editable fields - just values

extern basicTvb t_UserName;               // UIE_NAME
extern basicTvb t_Company;                // UIE_COMPANY
extern basicTvb t_Address1;               // UIE_ADDRESS_LINE1
extern basicTvb t_Address2;               // UIE_ADDRESS_LINE2
extern basicTvb t_Country;                // UIE_COUNTRY
extern basicTvb t_PhoneNumber;            // UIE_PHONE
extern basicTvb t_Computer;               // UIE_COMPUTER
extern basicTvb t_CompSelIBM;             // UIE_COMP_TYPE_IBM_SEL
extern basicTvb t_CompSelMac;             // UIE_COMP_TYPE_MAC_SEL
extern basicTvb t_CompSelApp;             // UIE_COMP_TYPE_APP_SEL
extern basicTvb t_CompSelOth;             // UIE_COMP_TYPE_OTH_SEL
extern basicTvb t_CompCheckIBM;           // UIE_COMP_TYPE_IBM_CHK
extern basicTvb t_CompCheckMac;           // UIE_COMP_TYPE_MAC_CHK
extern basicTvb t_CompCheckApp;           // UIE_COMP_TYPE_APP_CHK
extern basicTvb t_CompCheckOth;           // UIE_COMP_TYPE_OTH_CHK
extern basicTvb t_Sex;                    // UIE_SEX
extern basicTvb t_UserSexMChk;            // UIE_MALE_CHK
extern basicTvb t_UserSexMSel;            // UIE_MALE_SEL
extern basicTvb t_UserSexFChk;            // UIE_FEMALE_CHK
extern basicTvb t_UserSexFSel;            // UIE_FEMALE_SEL
extern basicTvb t_AnsiPref;               // UIE_ANSIPREF
extern basicTvb t_AnsiAutoSel;            // UIE_ANSI_AUTO_SEL
extern basicTvb t_AnsiOnSel;              // UIE_ANSI_ON_SEL
extern basicTvb t_AnsiOffSel;             // UIE_ANSI_OFF_SEL
extern basicTvb t_AnsiAutoCheck;          // UIE_ANSI_AUTO_CHK
extern basicTvb t_AnsiOnCheck;            // UIE_ANSI_ON_CHK
extern basicTvb t_AnsiOffCheck;           // UIE_ANSI_OFF_CHK
extern basicTvb t_Columns;                // UIE_COLUMNS
extern basicTvb t_Lines;                  // UIE_LINES
extern basicTvb t_Output;                 // UIE OUTPUT_TYPE
extern basicTvb t_OutputPauseSel;         // UIE_PAUSE_SEL
extern basicTvb t_OutputContSel;          // UIE_CONT_SEL
extern basicTvb t_OutputPauseChk;         // UIE_PAUSE_CHK
extern basicTvb t_OutputContChk;          // UIE_CONT_CHK
extern basicTvb t_Editor;                 // UIE_EDITOR
extern basicTvb t_EditorLineSel;          // UIE_EDITOR_LINE_SEL
extern basicTvb t_EditorFSESel;           // UIE_EDITOR_FSE_SEL
extern basicTvb t_EditorLineChk;          // UIE_EDITOR_LINE_CHK
extern basicTvb t_EditorFSEChk;           // UIE_EDITOR_FSE_CHK
extern basicTvb t_Language;               // UIE_LANGUAGE
extern basicTvb t_PasswordHint;           // UIE_PASSWORDHINT
extern basicTvb t_AltEmail;               // UID_ALTEMAIL

// editable fields w/ HTML

extern basicTvb t_UserNameHtml;               // UIE_NAME_HTML
extern basicTvb t_CompanyHtml;                // UIE_COMPANY_HTML
extern basicTvb t_Address1Html;               // UIE_ADDRESS_LINE1_HTML
extern basicTvb t_Address2Html;               // UIE_ADDRESS_LINE2_HTML
extern basicTvb t_CountryHtml;                // UIE_COUNTRY_HTML
extern basicTvb t_PhoneNumberHtml;            // UIE_PHONE_HTML
extern basicTvb t_ComputerHtml;               // UIE_COMPUTER_HTML
extern basicTvb t_SexHtml;                    // UIE_SEX_HTML
extern basicTvb t_AnsiPrefHtml;               // UIE_ANSIPREF_HTML
extern basicTvb t_ColumnsHtml;                // UIE_COLUMNS_HTML
extern basicTvb t_LinesHtml;                  // UIE_LINES_HTML
extern basicTvb t_OutputHtml;                 // UIE OUTPUT_HTML
extern basicTvb t_EditorHtml;                 // UIE_EDITOR_HTML
extern basicTvb t_LanguageHtml;               // UIE_LANGUAGE_HTML
extern basicTvb t_CredLinkHtml;               // UIE_CREDLINK_HTML
extern basicTvb t_PassLinkHtml;               // UIE_PASSLINK_HTML
extern basicTvb t_HowManyCreds;               // UIE_TRANS_CREDS
extern basicTvb t_TransUser;                  // UIE_TRANS_USER
extern urlEncodedTvb t_TransUserEnc;          // UIE_TRANS_USER_U
extern basicTvb t_PasswordHintHtml;           // UIE_PASSWORDHINT
extern basicTvb t_AltEmailHtml;               // UID_ALTEMAIL

#endif                             // __UIEVAR_H
