/***************************************************************************
 *                                                                         *
 *   UIEVAR.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Account Variables Class.                                              *
 *                                                 - N.C. Osterc  10/18/98 *
 *                                                                         *
 ***************************************************************************/

#include "galuieah.h"
#include "uievar.h"
#include "uiemsg.h"
#include "majorbbs.h"

#define FILREV "$Revision: 8 $"
#define HASKEY(x) uhskey(uptr->userid,x)

basicTvb t_ErrorMessage("UIE_ERROR");

basicTvb t_Userid("UIE_USER_ID");
urlEncodedTvb t_UserURLEnc("UIE_USER_U");
basicTvb t_MinPerCall("UIE_MINPERCALL_LIM");
basicTvb t_CurPassWord("UIE_CURPWD");
basicTvb t_CallPerDay("UIE_CALLPERDAY_LIM");
basicTvb t_CreateDate("UIE_CREATION_DATE");
basicTvb t_Birthday("UIE_BIRTHDAY");
basicTvb t_UserName("UIE_NAME");
basicTvb t_Company("UIE_COMPANY");
basicTvb t_Address1("UIE_ADDRESS_LINE1");
basicTvb t_Address2("UIE_ADDRESS_LINE2");
basicTvb t_Country("UIE_COUNTRY");
basicTvb t_PhoneNumber("UIE_PHONE");
basicTvb t_Computer("UIE_COMPUTER");
basicTvb t_CompSelIBM("UIE_COMP_TYPE_IBM_SEL");
basicTvb t_CompSelMac("UIE_COMP_TYPE_MAC_SEL");
basicTvb t_CompSelApp("UIE_COMP_TYPE_APP_SEL");
basicTvb t_CompSelOth("UIE_COMP_TYPE_OTH_SEL");
basicTvb t_CompCheckIBM("UIE_COMP_TYPE_IBM_CHK");
basicTvb t_CompCheckMac("UIE_COMP_TYPE_MAC_CHK");
basicTvb t_CompCheckApp("UIE_COMP_TYPE_APP_CHK");
basicTvb t_CompCheckOth("UIE_COMP_TYPE_OTH_CHK");
basicTvb t_Sex("UIE_SEX");
basicTvb t_UserSexMChk("UIE_MALE_CHK");
basicTvb t_UserSexMSel("UIE_MALE_SEL");
basicTvb t_UserSexFChk("UIE_FEMALE_CHK");
basicTvb t_UserSexFSel("UIE_FEMALE_SEL");
basicTvb t_AnsiPref("UIE_ANSIPREF");
basicTvb t_AnsiAutoSel("UIE_ANSI_AUTO_SEL");
basicTvb t_AnsiOnSel("UIE_ANSI_ON_SEL");
basicTvb t_AnsiOffSel("UIE_ANSI_OFF_SEL");
basicTvb t_AnsiAutoCheck("UIE_ANSI_AUTO_CHK");
basicTvb t_AnsiOnCheck("UIE_ANSI_ON_CHK");
basicTvb t_AnsiOffCheck("UIE_ANSI_OFF_CHK");
basicTvb t_Columns("UIE_COLUMNS");
basicTvb t_Lines("UIE_LINES");
basicTvb t_Output("UIE_OUTPUT");
basicTvb t_Editor("UIE_EDITOR");
basicTvb t_EditorLineSel("UIE_EDITOR_LINE_SEL");
basicTvb t_EditorFSESel("UIE_EDITOR_FSE_SEL");
basicTvb t_EditorLineChk("UIE_EDITOR_LINE_CHK");
basicTvb t_EditorFSEChk("UIE_EDITOR_FSE_CHK");
basicTvb t_Language("UIE_LANGUAGE");
basicTvb t_AccountClass("UIE_CLASS");
basicTvb t_Credits("UIE_CREDITS");
basicTvb t_Days("UIE_DAYS");
basicTvb t_PasswordHint("UIE_PASSWORDHINT");
basicTvb t_AltEmail("UIE_ALTEMAIL");

basicTvb t_UserNameHtml("UIE_NAME_HTML");
basicTvb t_CompanyHtml("UIE_COMPANY_HTML");
basicTvb t_Address1Html("UIE_ADDRESS_LINE1_HTML");
basicTvb t_Address2Html("UIE_ADDRESS_LINE2_HTML");
basicTvb t_CountryHtml("UIE_COUNTRY_HTML");
basicTvb t_PhoneNumberHtml("UIE_PHONE_HTML");
basicTvb t_ComputerHtml("UIE_COMPUTER_HTML");
basicTvb t_SexHtml("UIE_SEX_HTML");
basicTvb t_AnsiPrefHtml("UIE_ANSIPREF_HTML");
basicTvb t_ColumnsHtml("UIE_COLUMNS_HTML");
basicTvb t_LinesHtml("UIE_LINES_HTML");
basicTvb t_OutputHtml("UIE_OUTPUT_HTML");
basicTvb t_EditorHtml("UIE_EDITOR_HTML");
basicTvb t_LanguageHtml("UIE_LANGUAGE_HTML");
basicTvb t_PasswordHintHtml("UIE_PASSWORDHINT_HTML");
basicTvb t_AltEmailHtml("UIE_ALTEMAIL_HTML");

basicTvb t_HowManyCreds("UIE_TRANS_CREDS");
basicTvb t_TransUser("UIE_TRANS_USER");
urlEncodedTvb t_TransUserEnc("UIE_TRANS_USER_U");
basicTvb t_LastLogon("UIE_LAST_LOGON");
basicTvb t_OutputContSel("UIE_CONT_SEL");
basicTvb t_OutputContChk("UIE_CONT_CHK");
basicTvb t_OutputPauseSel("UIE_PAUSE_SEL");
basicTvb t_OutputPauseChk("UIE_PAUSE_CHK");

basicTvb t_PassLinkHtml("UIE_PASSLINK_HTML");
basicTvb t_CredLinkHtml("UIE_CREDLINK_HTML");

MARKSOURCE(uieVar);

uieVar::uieVar()                   // default constructor
{
}

uieVar::~uieVar()                  // destructor
{
}

VOID
uieVar::setVars(                   // set "Account" variables up
struct usracc *uptr)
{
     ASSERT(uptr != NULL);

     struct acclass uclass;
     dfaSetBlk(clsbb);
     if (dfaAcqEQ(&uclass,uptr->curcls,0)) {
          uclass.limcal == -1 ? t_MinPerCall=msg_ulmpcl: t_MinPerCall=uclass.limcal;
          uclass.limday == -1 ? t_CallPerDay=msg_ulcpday: t_CallPerDay=uclass.limday;
     }
     dfaRstBlk();

     t_UserURLEnc=t_Userid=uptr->userid;
     t_AccountClass=uptr->curcls;
     t_CreateDate=ncdatel(uptr->credat);
     INT y,m,d;
     CHAR tmpbdy[LDATSIZ];
     sDateDecode(uptr->birthd,&y,&m,&d);
     prnDate(y,m,d,tmpbdy,LDATSIZ,PRND_MDYY,'/');
     t_Birthday=tmpbdy;
     t_LastLogon=ncdatel(uptr->usedat);
     t_UserNameHtml=t_UserName=uptr->usrnam;
     t_CompanyHtml=t_Company=uptr->usrad1;
     t_Address1Html=t_Address1=uptr->usrad2;
     t_Address2Html=t_Address2=uptr->usrad3;
     t_CountryHtml=t_Country=uptr->usrad4;
     t_PhoneNumberHtml=t_PhoneNumber=uptr->usrpho;

     bbsgen g;
     getgen(&g,uptr->userid);
     g.lngnam[0] == '\0' ? t_LanguageHtml=t_Language=msg_autolang :
      t_LanguageHtml=t_Language=g.lngnam;
     switch (uptr->systyp) {
     case 0:
          t_CompSelOth=SEL;
          t_CompCheckOth=CHK;
          t_ComputerHtml=t_Computer=msg_comp4;
          break;
     case 1:
          t_CompSelIBM=SEL;
          t_CompCheckIBM=CHK;
          t_ComputerHtml=t_Computer=msg_comp1;
          break;
     case 2:
          t_CompSelMac=SEL;
          t_CompCheckMac=CHK;
          t_ComputerHtml=t_Computer=msg_comp2;
          break;
     case 3:
          t_CompSelApp=SEL;
          t_CompCheckApp=CHK;
          t_ComputerHtml=t_Computer=msg_comp3;
          break;
     }
     if (uptr->sex == 'M' || uptr->sex == 'm') {
          t_UserSexMChk=CHK;
          t_UserSexMSel=SEL;
          t_SexHtml=t_Sex=msg_sexmale;
     }
     else {
          t_UserSexFChk=CHK;
          t_UserSexFSel=SEL;
          t_SexHtml=t_Sex=msg_sexfem;
     }

     t_CurPassWord=uptr->psword;
     if (uptr->ansifl&ANSON) {
          t_AnsiOnSel=SEL;
          t_AnsiOnCheck=CHK;
          t_AnsiPrefHtml=t_AnsiPref=msg_ansion;
     }
     else if (uptr->ansifl&ANSMAN) {
          t_AnsiAutoSel=SEL;
          t_AnsiAutoCheck=CHK;
          t_AnsiPrefHtml=t_AnsiPref=msg_ansiauto;
     }
     else {
          t_AnsiOffSel=SEL;
          t_AnsiOffCheck=CHK;
          t_AnsiPrefHtml=t_AnsiPref=msg_ansioff;
     }
     t_Columns=(INT)uptr->scnwid;
     t_Lines=(INT)uptr->scnfse;
     if (uptr->scnbrk == CTNUOS) {
          t_OutputContSel=SEL;
          t_OutputContChk=CHK;
          t_OutputHtml=t_Output=msg_outcont;
     }
     else {
          t_OutputPauseSel=SEL;
          t_OutputPauseChk=CHK;
          t_OutputHtml=t_Output=msg_outpaus;
     }
     if (uptr->usrprf&PRFLIN) {
          t_EditorLineSel=SEL;
          t_EditorLineChk=CHK;
          t_EditorHtml=t_Editor=msg_lineedt;
     }
     else {
          t_EditorFSEChk=CHK;
          t_EditorFSESel=SEL;
          t_EditorHtml=t_Editor=msg_fseedt;
     }
     setmbk(uieAHMsg);
     if (HASKEY(namchgky)) {
          clrprf();
          prfmsg(NAMEHTML,uptr->usrnam);
          t_UserNameHtml=stpans(prfbuf);
     }

     if (HASKEY(comchgky)) {
          clrprf();
          prfmsg(COMHTML,uptr->usrad1);
          t_CompanyHtml=stpans(prfbuf);
     }

     if (HASKEY(adrchgky)) {
          clrprf();
          prfmsg(ADR1HTML,uptr->usrad2);
          t_Address1Html=stpans(prfbuf);
          clrprf();
          prfmsg(ADR2HTML,uptr->usrad3);
          t_Address2Html=stpans(prfbuf);
          clrprf();
          prfmsg(CTRYHTML,uptr->usrad4);
          t_CountryHtml=stpans(prfbuf);
     }

     if (HASKEY(phochgky)) {
          clrprf();
          prfmsg(PHOHTML,uptr->usrpho);
          t_PhoneNumberHtml=stpans(prfbuf);
     }

     if (HASKEY(syschgky)) {
          clrprf();
          prfmsg(COMPHTML,uptr->systyp == 1 ? SEL : "",
                          uptr->systyp == 2 ? SEL : "",
                          uptr->systyp == 3 ? SEL : "",
                          uptr->systyp == 0 ? SEL : "");
          t_ComputerHtml=stpans(prfbuf);
     }

     if (HASKEY(sexchgky)) {
          clrprf();
          prfmsg(SEXHTML,uptr->sex == 'm' || uptr->sex == 'M' ? SEL : "",
                         uptr->sex == 'f' || uptr->sex == 'F' ? SEL : "");
          t_SexHtml=stpans(prfbuf);
     }

     setAcctExt(uptr->userid);

     if (HASKEY(anschgky)) {
          clrprf();
          prfmsg(ANSIHTML,uptr->ansifl&ANSMAN != 0 ? SEL : "",
                          uptr->ansifl&ANSON != 0 ? SEL : "",
                          (uptr->ansifl&ANSON == 0 &&
                          uptr->ansifl&ANSMAN == 0) ? SEL : "");
          t_AnsiPrefHtml=stpans(prfbuf);
     }

     if (HASKEY(scwchgky)) {
          clrprf();
          prfmsg(SCWHTML,(INT)uptr->scnwid);
          t_ColumnsHtml=stpans(prfbuf);
     }

     if (HASKEY(sclchgky)) {
          clrprf();
          prfmsg(SCLHTML,(INT)uptr->scnfse);
          t_LinesHtml=stpans(prfbuf);
     }

     if (HASKEY(pauchgky)) {
          clrprf();
          prfmsg(OUTPHTML,uptr->scnbrk != CTNUOS ? SEL : "",
                          uptr->scnbrk == CTNUOS ? SEL : "");
          t_OutputHtml=stpans(prfbuf);
     }

     if (HASKEY(edtchgky)) {
          clrprf();
          bool flag=false;
          if (uptr->usrprf&PRFLIN) {
               flag=true;
          }
          prfmsg(EDITHTML,flag != false ? SEL : "",
                          flag == false ? SEL : "");
          t_EditorHtml=stpans(prfbuf);
     }
     clrprf();
     rstmbk();

     t_Days=uptr->daystt;

     if (shwcrd) {
          t_Credits=uptr->creds;
          if (uptr->creds >= mincreds) {
               t_CredLinkHtml=msg_credhtml;
          }
     }

     if (HASKEY(pswchgky)) {
          t_PassLinkHtml=msg_pswhtml;
     }
}

VOID
uieVar::setAcctExt(           // Set extended account variables
const char *userid)           // Userid to load for
{
     struct uaccext buf;

     ::memset(&buf, 0, sizeof(struct uaccext));
     ::dfaSetBlk(::dfaUserExt);
     ::dfaAcqEQ(&buf, userid, 0);
     t_PasswordHint=buf.pwdhint;
     t_AltEmail=buf.alteml;

     clrprf();
     prfmsg(PSWHINT, buf.pwdhint);
     t_PasswordHintHtml= stpans(prfbuf);

     clrprf();
     prfmsg(ALTEMAIL, buf.alteml);
     t_AltEmailHtml = stpans(prfbuf);
     ::dfaRstBlk();
}

VOID
uieVar::setCreditVars(             // set up credit transfer vars
LONG creds,                        // # of credits to transfer
const CHAR *tuser)                 // the transfer user
{
     ASSERT(tuser != NULL);

     t_HowManyCreds=creds;
     t_TransUserEnc=t_TransUser=tuser;
}

VOID
uieVar::setVarsDefault()           // set tvbs to default values
{
     t_Userid="";
     t_UserURLEnc="";
     t_MinPerCall="";
     t_CallPerDay="";
     t_CreateDate="";
     t_Birthday="";
     t_UserName="";
     t_Company="";
     t_Address1="";
     t_Address2="";
     t_Country="";
     t_PhoneNumber="";
     t_Computer="";
     t_CompSelIBM="";
     t_CompSelMac="";
     t_CompSelApp="";
     t_CompSelOth="";
     t_CompCheckIBM="";
     t_CompCheckMac="";
     t_CompCheckApp="";
     t_CompCheckOth="";
     t_UserSexMChk="";
     t_UserSexMSel="";
     t_UserSexFChk="";
     t_UserSexMChk="";
     t_CurPassWord="";
     t_AnsiPref="";
     t_AnsiAutoSel="";
     t_AnsiOnSel="";
     t_AnsiOffSel="";
     t_AnsiAutoCheck="";
     t_AnsiOnCheck="";
     t_AnsiOffCheck="";
     t_Columns="";
     t_Lines="";
     t_Output="";
     t_OutputPauseSel="";
     t_OutputContSel="";
     t_OutputPauseChk="";
     t_OutputContChk="";
     t_Editor="";
     t_EditorLineSel="";
     t_EditorFSESel="";
     t_EditorLineChk="";
     t_EditorFSEChk="";
     t_Language="";
     t_AccountClass="";
     t_UserNameHtml="";
     t_CompanyHtml="";
     t_Address1Html="";
     t_Address2Html="";
     t_CountryHtml="";
     t_PhoneNumberHtml="";
     t_ComputerHtml="";
     t_SexHtml="";
     t_AnsiPrefHtml="";
     t_ColumnsHtml="";
     t_LinesHtml="";
     t_OutputHtml="";
     t_EditorHtml="";
     t_LanguageHtml="";
     t_Credits="";
     t_Days="";
     t_CredLinkHtml="";
     t_HowManyCreds="";
     t_TransUser="";
     t_TransUserEnc="";
     t_ErrorMessage="";
     t_LastLogon="";
     t_UserSexFSel="";
     t_OutputContSel="";
     t_OutputContChk="";
     t_OutputPauseSel="";
     t_OutputPauseChk="";
     t_PassLinkHtml="";
     t_AltEmail="";
     t_AltEmailHtml="";
     t_PasswordHint="";
     t_PasswordHintHtml="";
}
