/***************************************************************************
 *                                                                         *
 *   UIESYN.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Account Synth Class.                                                  *
 *                                                 - N.C. Osterc  10/26/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __UIESYN_H
#define __UIESYN_H

#include "gcomm.h"
#include "majorbbs.h"
#include "galacth.h"
#include "dnfmgr.h"
#include "uievar.h"
#include "cyctimer.h"
#include "galuieah.h"
#include <cstring>

#define URLSIZ 1024
#define PVALBUFSIZ 16384
#define PPFIX "galacth/galuieah"
#define GETPARAMVAL(x) ses->param(x,m_pValBuf,PVALBUFSIZ)
#define ISPARAM(x) ses->paramIndex(x,m_index)
#define DFTERROR "error.htm"
#define DFTSUCCESS "confirm.htm"

typedef enum {
     ERR_NOERROR=0,                // no error
     ERR_UNRECOGNIZED=0,           // unrecognized error
     ERR_TOOSHORT=1,               // answer too short
     ERR_TOOLONG=2,                // answer too long
     ERR_PROFANE=3,                // profane input
     ERR_NOAXES=4,                 // no access to change
     ERR_INVALID=5,                // invalid value
     ERR_UNOTFOUND=6,              // user not found
     ERR_NOVAL=7,                  // no value specified
     ERR_NOCREDITS=8,              // insufficeient credits
     ERR_NOTSELF=9,                // can't transfer to self
     ERR_TRANSFAILED=10,           // transfer failed
     ERR_CURPW=11,                 // not current password
     ERR_NOTSEC=12,                // not a secure password
     ERR_NOMATCH=13,               // passwords don't match

     ERR_HIGHERROR            // this must be the highest err, insert new
                              // errors before and give them continuous values
} errorcodes;

class uieSynthesis: public acthSynthesis {
public:

     uieSynthesis(                // default constructor
     acthSession *_ses);           // session object

     virtual
     ~uieSynthesis();             // destructor

     virtual
     ACTHCODE
     proceed();                    // proceed entry point

protected:

     VOID
     setError(                     // set up error code
     errorcodes err,               // the errorcode
     const CHAR *arg1=NULL,        // first argument
     const CHAR *arg2=NULL);       // second argument

     VOID
     setErrorVbs();                // set error tvbs up

     INT
     translateError();             // translate m_err to a msg file err desc

     virtual ACTHCODE
     dynafile();                   // dynafile

     bool
     hasAgentAccess();             // does user have access?

     ACTHCODE
     initRequest();                // initialize request stuff

     ACTHCODE
     isUserOK();                   // check user specific stuff

     VOID
     setMap(                       // set map
     dnfMap *map);                 // map to set

     VOID
     saveAccount();                // save account

     bool
     lengthOK(                     // is input length ok?
     SHORT min,                    // min length
     SHORT max);                   // max length

     VOID
     setLangVar(                   // set language text variable
     bool select,                  // selected?
     const CHAR *optval);          // option value

     ACTHCODE                      //   continue synthesis?
     errorResponse(                // process an error
     dnfMap& map,                  //   map to use
     CHAR const * path);           //   path to template directory

     ACTHCODE                      //   continue synthesis?
     successResponse(              // process an onsuccess
     dnfMap& map,                  //   map to use
     CHAR const * path);           //   path to template directory


private:

     bool
     uieSynthesis::getPasswordHintParam();

     bool
     uieSynthesis::getAltEmailParam();

     VOID
     uieSynthesis::saveAccountExt(
     const char *userid);

     bool
     checkProfan();                // is input profane?

     bool
     hasKey(                       // does user have key?
     const CHAR *key);             // the key in question

     bool
     getNameParam();               // get the "name" parameter

     bool
     getCompanyParam();            // get the "company" parameter

     bool
     getAddress1Param();           // get the "address1" parameter

     bool
     getAddress2Param();           // get the "address2" parameter

     bool
     getCountryParam();            // get the "country" parameter

     bool
     getPhoneParam();              // get the "phone" parameter

     bool
     getWidthParam();              // get the "width" parameter

     bool
     getLinesParam();              // get the "lines" parameter

     bool
     getComputerParam();           // get the "computer" parameter

     bool
     getSexParam();                // get the "sex" parameter

     bool
     getAnsiParam();               // get the "ansi" parameter

     bool
     getOutputParam();             // get the "output" parameter

     bool
     getEditorParam();             // get the "editor" parameter

     bool
     getLangParam();               // get the "language" parameter

     VOID
     initTemplates();              // init onsuccess and onerror

     bool                          //   is a redirct?
     getOnParam(                   // get onxxx parameter
     CHAR const * paramName,       //   parameter to get
     CHAR** pStorePtr);            //   store redir path here

protected:

     acthUserID *m_usrPtr;         // user object
     dnfHandler *m_dnfPtr;         // dnfhandler object
     uieVar *m_pTvb;               // point to variables object
     CHAR m_pValBuf[PVALBUFSIZ];   // buffer - stores parameter values
     cycleTimer m_cyc;             // cyctle timer instance
     INT m_index;                  // index - used in ISPARAM
     SHORT m_ahState;              // state-tracking variable
     errorcodes m_err;             // error code
     string m_errparam;            // paramter that caused the error
     string m_errlength;           // allowed length of value
     string m_thisName;            // store current name
     bool m_templInit;             // are templates initalized?
     bool m_succRedir;             // redirect success response?
     bool m_errRedir;              // redirect error response?
     CHAR* m_onsuccessFile;        // ptr to store success redirect location
     CHAR* m_errParam;             // contents of onerror parameter
     string m_onerrorFile;         // error redirect location
     struct usracc *m_usrAccPtr;   // pointer to struct usracc
     struct bbsgen m_generic;      // inst of generic struct
     struct usracc m_account;      // instance of account structure
     string m_paramName;           // parameter name
     string m_langvar;             // language variable
     struct uaccext m_usrext;      // Structure for ext updates
};

#endif                             // __UIESYN_H
