/***************************************************************************
 *                                                                         *
 *   UIEAGT.CPP                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Account Agent Class.                                                  *
 *                                                  - N.C. Osterc 10/20/98 *
 *                                                                         *
 ***************************************************************************/

#include "uieagt.h"
#include "password.h"
#include "uiesyn.h"
#include "transsyn.h"
#include "majorbbs.h"

#define URLARG(x) sameas(ses->urlargv(0),x)

uieAgent *paccAgent;                // pointer to Account agent
VOID delAgent(VOID);                // delete agent

MARKSOURCE(uieagt);

uieAgent::uieAgent() : acthAgent("AH Account","account")  // default constructor
{
     registerAgent(acthVersion);
     hook_finalshutdown(delAgent);
}

uieAgent::~uieAgent()            // destructor
{
}

acthSynthesis *                    // synth obj ptr
uieAgent::newSynthesis(            // return a new synthesis object
acthSession *ses)                  // session object
{
     uieSynthesis *pSynth=NULL;

     if (ses->urlargc() >= 1) {
          if (URLARG("transcred")) {
               pSynth=new transCredSynthesis(ses);
          }
          else if (URLARG("password")) {
               pSynth=new passwordSynthesis(ses);
          }
     }
     if (pSynth == NULL) {
          pSynth=new uieSynthesis(ses);
     }
     return(pSynth);
}

extern "C" VOID EXPORT             // init our agent
init__galuieah(VOID)
{
     paccAgent=new uieAgent;
}

VOID
delAgent(                          // delete our agent
VOID)
{
     delete paccAgent;
}
