/***************************************************************************
 *                                                                         *
 *   TRANSSYN.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Transfer Credits Synthesis Class.                                     *
 *                                                  - N.C. Osterc 10/06/98 *
 *                                                                         *
 ***************************************************************************/

#include "transsyn.h"
#include "galuieah.h"
#include "uiemsg.h"
#include "dnfmgr.h"
#include "ahutil.h"

#define FILREV "$Revision: 6 $"

#define ISTRANSFER (ISPARAM("TRANSFER"))

enum {PARAMS, RESPONSE};

// dynafile stuff

dnfStep dnfTransErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfTransConfSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfTransDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfTransErrMap(PPFIX "/transcred/error.htm","Transfer error",dnfTransErrSteps);
dnfMap dnfTransConfMap(PPFIX "/transcred/confirm.htm","Transfer Success",dnfTransConfSteps);
dnfMap dnfTransDefMap(PPFIX "/transcred/index.htm","Transfer Default",dnfTransDefSteps);

// class method defs

MARKSOURCE(transsyn);

transCredSynthesis::transCredSynthesis(   // default constructor
                   acthSession *_ses):    // session object
                   uieSynthesis(_ses),
                   m_howMany(0)
{
     m_ahState=PARAMS;
}

transCredSynthesis::~transCredSynthesis()   // destructor
{
}

ACTHCODE
transCredSynthesis::proceed()       // proceed entry point
{
     ACTHCODE retval;

     if ((retval=isUserOK()) != ACTHMORE) {
          return (retval);
     }

     m_usrAccPtr=GetAccPtr(m_usrPtr->userid());

     if ((!shwcrd) || (m_usrAccPtr->creds < mincreds && ISTRANSFER)) {
          return (ACTHFORBID);
     }

     if (m_cyc.start()) {
          do {
               switch (m_ahState) {
               case PARAMS:
                    m_ahState=RESPONSE;
                    if (ISTRANSFER) {
                         GETPARAMVAL("USER");
                         if (m_pValBuf[0] != '\0') {
                             if (uidCaps(m_pValBuf) != NULL) {
                                  stlcpy(m_transUser,uidCaps(m_pValBuf),UIDSIZ);
                             }
                             else {
                                  setError(ERR_UNOTFOUND,m_pValBuf);
                                  break;
                             }
                         }
                         else {
                              setError(ERR_NOVAL,"user");
                              break;
                         }
                         GETPARAMVAL("CREDITS");
                         if (m_pValBuf[0] == '\0') {
                              setError(ERR_NOVAL,"credits");
                              break;
                         }
                         else if (!alldgs(m_pValBuf)) {
                              setError(ERR_INVALID,"credits");
                              break;
                         }
                         m_howMany=atol(m_pValBuf);
                         if (m_usrAccPtr->creds < m_howMany) {
                              setError(ERR_NOCREDITS);
                              break;
                         }
                         if (sameas(m_transUser,m_usrPtr->userid())) {
                              setError(ERR_NOTSELF);
                              break;
                         }
                         if (crdusr(m_transUser,m_pValBuf,0,0) < 0) {
                              setError(ERR_TRANSFAILED);
                              break;
                         }
                         else {
                              gdedcrd(m_usrPtr->userid(),m_howMany,1,1);
                              shocst("USER CREDIT TRANSFER","%s->%s (%d credits)",
                               m_usrPtr->userid(),m_transUser,m_howMany);
                              return(successResponse(dnfTransConfMap,PPFIX "/transcred/"));
                         }
                    }
                    else {
                         setMap(&dnfTransDefMap);
                    }
                    break;
               case RESPONSE:
                    if (m_err != ERR_NOERROR && m_dnfPtr == NULL) {
                         return(errorResponse(dnfTransErrMap,PPFIX "/transcred/"));
                    }
                    m_pTvb->setVars(m_usrAccPtr);
                    if (m_transUser[0] != '\0') {
                         m_pTvb->setCreditVars(m_howMany,m_transUser);
                    }
                    retval=dynafile();
                    break;
               }
          }
          while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
