/***************************************************************************
 *                                                                         *
 *   PASSWORD.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Password Synthesis Class.                                             *
 *                                                  - N.C. Osterc 10/25/98 *
 *                                                                         *
 ***************************************************************************/

#include "password.h"
#include "galuieah.h"
#include "uiemsg.h"
#include "dnfmgr.h"
#include "ahutil.h"
#include "majorbbs.h"

#define FILREV "$Revision: 4 $"

#define ISUPDATE (ISPARAM("update"))

enum {PARAMS, RESPONSE};

// dynafile stuff

dnfStep dnfPwdErrSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfPwdConfSteps[]={
     dnfStep(DNFMAPEND)
};

dnfStep dnfPwdDefSteps[]={
     dnfStep(DNFMAPEND)
};

dnfMap dnfPwdErrMap(PPFIX "/password/error.htm","Password error",dnfPwdErrSteps);
dnfMap dnfPwdConfMap(PPFIX "/password/confirm.htm","Password Success",dnfPwdConfSteps);
dnfMap dnfPwdDefMap(PPFIX "/password/index.htm","Password Default",dnfPwdDefSteps);

// class method defs

MARKSOURCE(password);

passwordSynthesis::passwordSynthesis(   // default constructor
                   acthSession *_ses):    // session object
                   uieSynthesis(_ses),
                   m_password("")
{
     m_ahState=PARAMS;
}

passwordSynthesis::~passwordSynthesis()   // destructor
{
}

ACTHCODE
passwordSynthesis::proceed()       // proceed entry point
{
     ACTHCODE retval;

     if ((retval=isUserOK()) != ACTHMORE) {
          return (retval);
     }
     if (!m_usrPtr->hasKey(pswchgky)) {
          return (ACTHFORBID);
     }

     m_usrAccPtr=GetAccPtr(m_usrPtr->userid());

     if (m_cyc.start()) {
          do {
               switch (m_ahState) {
               case PARAMS:
                    m_ahState=RESPONSE;
                    if (ISUPDATE) {
                         m_paramName="password";
                         GETPARAMVAL("curpass");
                         if (!sameas(m_pValBuf,m_usrAccPtr->psword)) {
                              setError(ERR_CURPW);
                              break;
                         }
                         GETPARAMVAL("newpass1");
                         if (m_pValBuf[0] == '\0') {
                              setError(ERR_NOVAL,"password");
                              break;
                         }
                         else if (!lengthOK(minpwd,PSWSIZ-1)) {
                              setError(ERR_INVALID,"password");
                              break;
                         }
                         else if (!safpsw
                          && sameas(m_usrPtr->userid(),m_pValBuf)) {
                              setError(ERR_NOTSEC);
                              break;
                         }
                         else {
                              m_password=m_pValBuf;
                         }
                         GETPARAMVAL("newpass2");
                         if (sameas(m_pValBuf,m_password.c_str())) {
                              stlcpy(m_usrAccPtr->psword,m_pValBuf,PSWSIZ);
                              movmem(m_usrAccPtr,&m_account,sizeof(struct usracc));
                              saveAccount();
                              return(successResponse(dnfPwdConfMap,PPFIX "/password/"));
                         }
                         else {
                              setError(ERR_NOMATCH);
                         }
                    }
                    else {
                         setMap(&dnfPwdDefMap);
                    }
                    break;
               case RESPONSE:
                    if (m_err != ERR_NOERROR && m_dnfPtr == NULL) {
                         return(errorResponse(dnfPwdErrMap,PPFIX "/password/"));
                    }
                    m_pTvb->setVars(m_usrAccPtr);
                    retval=dynafile();
                    break;
               }
          }
          while (m_cyc.haveTime() && retval != ACTHDONE);
     }
     return(retval);
}
