/***************************************************************************
 *                                                                         *
 *   CSUINFED.C                                                            *
 *                                                                         *
 *   Copyright (C) 1994-1997 Galacticomm, Inc.   All rights reserved.      *
 *                                                                         *
 *   This is the Galacticomm agent for Client/Server Account Display/Edit. *
 *                                                                         *
 *                                                - Bill Hyatt 7/13/94     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "wgssup.h"

#define FILREV "$Revision: 13 $"

#define MAXTKC 100000000L          /* max char count of tick xfer request  */

#define HASRKY 0x0001              /* user has AD/E agent read key         */
#define HASWKY 0x0002              /* user has AD/E agent write key        */

/* flags for user-specific editing keys */
#define KEYNAM 0x0001              /* user can edit name                   */
#define KEYCOM 0x0002              /* user can edit company                */
#define KEYADR 0x0004              /* user can edit address                */
#define KEYPHO 0x0008              /* user can edit phone number           */
#define KEYSYS 0x0010              /* user can edit system type            */
#define KEYANS 0x0020              /* user can edit ANSI setting           */
#define KEYSCW 0x0040              /* user can edit screen width           */
#define KEYSCL 0x0080              /* user can edit screen height          */
#define KEYEDT 0x0100              /* user can edit default editor         */
#define KEYPAU 0x0200              /* user can edit screen pause setting   */
#define KEYSEX 0x0400              /* user can edit sex                    */
#define KEYPSW 0x0800              /* user can edit password               */
#define KEYLNG 0x1000              /* user can change language preference  */

/* values indicating how birthdates are handled */
#define CANEDT 0                   /* can be changed                       */
#define NOEDT  1                   /* can't be changed                     */
#define NOBDY  2                   /* this system doesn't ask for DOB      */

struct uincfg {                    /* acc disp/edit config info            */
     GBOOL shwcrd;                 /*   show user's credits?               */
     GBOOL shwnam;                 /*   show user's name?                  */
     GBOOL shwcmp;                 /*   show user's company?               */
     GBOOL shwadr;                 /*   show user's address?               */
     GBOOL shwpho;                 /*   show user's phone number?          */
     SHORT bdycfg;                 /*   show birthdate/allow to edit?      */
     GBOOL shwsex;                 /*   show user's sex?                   */
     GBOOL shwsys;                 /*   show user's system type?           */
     SHORT usrkys;                 /*   user-specific key flags            */
} uincfg;                          /* info to send to client               */

struct flddef uincfgFDA[] = {
     { CVTFLD_SHORT,9,fldoff(uincfg,shwcrd),NULL },
     { CVTFLD_END  ,0,0                    ,NULL }
};

struct xfinfovb {                  /* credit-transfer info, VB form        */
     CHAR tranfid[UIDSIZ-1];       /*   transferee's User-ID               */
     LONG tikreq;                  /*   amount of the transfer             */
};

struct flddef xfinfovbFDA[]={
     { CVTFLD_RTEXT ,UIDSIZ-1 ,fldoff(xfinfovb,tranfid) ,NULL },
     { CVTFLD_LONG  ,1        ,fldoff(xfinfovb,tikreq)  ,NULL },
     { CVTFLD_END   ,0        ,0                        ,NULL }
};

static VOID uinread(INT direction,struct saunam *dpknam);
static VOID uinwrite(struct saunam *dpknam,USHORT length,VOID *value);
static VOID uinxdone(VOID);
static VOID uinabort(VOID);
static VOID reg_dpk(VOID);

static GBOOL xfrcrd(struct xfinfovb *xfinfovb);
VOID inicsuin(VOID);

struct agent uinagt={              /* agent information structure          */
     "GALUIE",                     /* appid                                */
     uinread,                      /* read-dynapak function pointer        */
     uinwrite,                     /* write-dynapak function pointer       */
     uinxdone,                     /* file xfer-done function pointer      */
     uinabort                      /* abort-request function pointer       */
};

CHAR *aderkey,                     /* key req'd to read from AD/E agent    */
     *adewkey;                     /* key req'd to write to AD/E agent     */

extern INT chgbdy;                 /* allow users to change birthdays?     */
extern LONG mincxf;                /* min credits a user may transfer      */

VOID
inicsuin(VOID)
{
     register_agent(&uinagt);
     reg_dpk();
     uincfg.shwcrd=(shwcrd ? VBTRUE : FALSE);
     uincfg.shwnam=(asktbl[TBLNAM][0] ? VBTRUE : FALSE);
     uincfg.shwcmp=(asktbl[TBLAD1][0] ? VBTRUE : FALSE);
     uincfg.shwadr=(asktbl[TBLAD2][0] ? VBTRUE : FALSE);
     uincfg.shwpho=(asktbl[TBLPHO][0] ? VBTRUE : FALSE);
     uincfg.bdycfg=(asktbl[TBLBDY][0] ? (chgbdy ? CANEDT : NOEDT) : NOBDY);
     uincfg.shwsex=(asktbl[TBLSEX][0] ? VBTRUE : FALSE);
     uincfg.shwsys=(asktbl[TBLSYS][0] ? VBTRUE : FALSE);
     aderkey=stgopt(ADERKEY);
     adewkey=stgopt(ADEWKEY);
}

static VOID
uinread(                           /* read-dynapak handler                 */
INT direction,                     /*   read direction: 0=eq, 1=gt, -1=lt  */
struct saunam *dpknam)             /*   dynapak name to read               */
{
     CHAR *dpkstg;
     SHORT adekys=0;

     if (stdchk("") && direction == 0) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sau:key")) {
               if (haskey(aderkey)) {
                    adekys|=HASRKY;
               }
               if (haskey(adewkey)) {
                    adekys|=HASWKY;
               }
               rsp2read(dpknam,sizeof(short),&adekys,shortFDA);
               return;
          }
          else if (haskey(aderkey)) {
               if (sameas(dpkstg,"sa:uincfg")) {
                    uincfg.usrkys=0;
                    if (asktbl[TBLNAM][0] && haskey(uiekytbl[UIEKYNAM])) {
                         uincfg.usrkys|=KEYNAM;
                    }
                    if (asktbl[TBLAD1][0] && haskey(uiekytbl[UIEKYCOM])) {
                         uincfg.usrkys|=KEYCOM;
                    }
                    if (asktbl[TBLAD2][0] && haskey(uiekytbl[UIEKYADR])) {
                         uincfg.usrkys|=KEYADR;
                    }
                    if (asktbl[TBLPHO][0] && haskey(uiekytbl[UIEKYPHO])) {
                         uincfg.usrkys|=KEYPHO;
                    }
                    if (asktbl[TBLSYS][0] && haskey(uiekytbl[UIEKYSYS])) {
                         uincfg.usrkys|=KEYSYS;
                    }
                    if (haskey(uiekytbl[UIEKYANS])) {
                         uincfg.usrkys|=KEYANS;
                    }
                    if (haskey(uiekytbl[UIEKYSCW])) {
                         uincfg.usrkys|=KEYSCW;
                    }
                    if (haskey(uiekytbl[UIEKYSCL])) {
                         uincfg.usrkys|=KEYSCL;
                    }
                    if (haskey(uiekytbl[UIEKYEDT])) {
                         uincfg.usrkys|=KEYEDT;
                    }
                    if (haskey(uiekytbl[UIEKYPAU])) {
                         uincfg.usrkys|=KEYPAU;
                    }
                    if (asktbl[TBLSEX][0] && haskey(uiekytbl[UIEKYSEX])) {
                         uincfg.usrkys|=KEYSEX;
                    }
                    if (haskey(uiekytbl[UIEKYPSW])) {
                         uincfg.usrkys|=KEYPSW;
                    }
                    if (haskey(langchg)) {
                         uincfg.usrkys|=KEYLNG;
                    }
                    rsp2read(dpknam,sizeof(struct uincfg),&uincfg,uincfgFDA);
                    return;
               }
          }
     }
     rejectreq();
}

static VOID
uinwrite(                          /* write-dynapak handler                */
struct saunam *dpknam,             /*   dynapak name to write              */
USHORT length,                     /*   length of dynapak value            */
VOID *value)                       /*   dynapak value to write             */
{
     CHAR *dpkstg;

     if (stdchk(adewkey) && sameas(dpknam->usrid,usaptr->userid)) {
          dpkstg=cnvs2d(dpknam);
          if (sameas(dpkstg,"sau:credxfr")) {
               if (length == sizeof(struct xfinfovb)) {
                    r2wprf(xfrcrd((struct xfinfovb *)value));
                    return;
               }
          }
     }
     rejectreq();
}

static GBOOL
xfrcrd(                            /* verify and transfer credits to user  */
struct xfinfovb *xfinfovb)         /*   credit transfer info               */
{
     CHAR tranfid[UIDSIZ];
     LONG tikreq;
     INT ison;

     setmbk(supmb);
     b2ccpy(tranfid,xfinfovb->tranfid,UIDSIZ);
     tikreq=xfinfovb->tikreq;
     if (usaptr->creds <= mincxf) {
          prfmsg(CSNOCRDX,l2as(mincxf));
          howbuy();
          return(FALSE);
     }
     if (tikreq < mincxf || tikreq > MAXTKC) {
          prfmsg(NUMBAD,l2as(mincxf),l2as(min(usaptr->creds-1,MAXTKC)));
          return(FALSE);
     }
     if (tikreq >= usaptr->creds) {
          prfmsg(NOTENO,l2as(usaptr->creds-1));
          howbuy();
          return(FALSE);
     }
     if (sameas(usaptr->userid,tranfid)) {
          prfmsg(NOTSELF);
          return(FALSE);
     }
     if ((ison=crdusr(tranfid,l2as(tikreq),0,0)) < 0) {
          prfmsg(INVACC,tranfid);
          return(FALSE);
     }
     prfmsg(DATATR,l2as(tikreq),usaptr->userid,tranfid);
     if (ison && !(usrptr->flags&INVISB)) {
          prfmlt(SENDUS,usaptr->userid,l2as(tikreq));
          if (injoth()) {
               prfmsg(NOTICE,tranfid);
          }
     }
     rdedcrd(tikreq,1);
     if (!haskey(syskey) && grpnum[usrnum] != 0) {  /* zap stats        */
          mdstats[usrptr->state].creds-=tikreq;     /* that were added  */
          sv3.crdghr[grpnum[usrnum]-1][dthour(now())]-=tikreq;
     }
     shocst("USER CREDIT TRANSFER","%s->%s (%s credits)",
               usaptr->userid,tranfid,l2as(tikreq));
     return(TRUE);
}

static VOID
uinxdone(VOID)                     /* file transfer-done handler           */
{
}

static VOID
uinabort(VOID)                     /* abort-request handler                */
{
}

static VOID
reg_dpk(VOID)
{
     register_dpkfda("GALUIE","sau:credxfr",xfinfovbFDA);
}
