/***************************************************************************
 *                                                                         *
 *   TLC.H                                                                 *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Common declarations between MJRTLC.C, CSMJRTLC.C, TLCUTL.C.           *
 *                                                                         *
 *                                            - Bill Hyatt 10/4/94         *
 *                                                                         *
 ***************************************************************************/

#ifndef __TLC_H
#define __TLC_H

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "gme.h"
#include "galtlc.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define TLCAID "GALTLC"       /* teleconference C/S appid                  */

                              /* teleconference user flags                 */
#define SHWCHN 0x0001         /* user's channel is displayed in scan       */
#define SQUCHD 0x0002         /* this guy has been "squelched" by modera   */
#define LUISSU 0x0004         /* list or unlist command has been issued    */
#define JUSTEX 0x0008         /* user "just exited" during current intvl   */
#define XTOOTH 0x0010         /* exit to "caller" module when finished     */
#define CCHVLD 0x0020         /* chat-channel value is valid               */
#define TYPING 0x0040         /* user is now typing (for chat colors)      */
#define RSTX2M 0x0080         /* reset X2MAIN when XTOOTH is invoked       */
#define TLCGCS 0x0100         /* tele user is in C/S mode                  */
#define DBRDUP 0x0200         /* C/S user has his drawing board up         */
#define TLCCHT 0x0400         /* C/S user is in chat mode                  */
#define TLCRCV 0x0800         /* C/S user is receiving a file now          */
#define JUSTDB 0x1000         /* C/S usr open/clsd drw bd during cur intrvl*/

/* send flags for outtlc() */
#define AA   0                     /* send to A/A users only               */
#define CS   1                     /* send to C/S users only               */
#define ALLU 2                     /* send to all users                    */

/* list flags for tlsrui() */
#define LSTALL 0                   /* all users in tele                    */
#define LSTSCH 1                   /* users in same chan as current user   */
#define LSTCS  2                   /* C/S tele users only                  */
#define LSTCRQ 3                   /* users who have req'd chat w/ cur user*/

/* states for user sending file (sndstt) */
#define NOSEND 0              /*   not currently sending file at all       */
#define WT4ROK 1              /*   waiting for receiver ok to send file    */
#define WT4DAT 2              /*   waiting for data to come from client    */
#define WT4RRM 3              /*   waiting to for room in receiver queue   */

/* results of ck4pfn() calls */
#define NOPFN  0                   /* input had no profanity               */
#define WARNED 1                   /* user was given warning message       */
#define HUNGUP 2                   /* user was hung up on                  */

#define MAXOPC 5              /* max # of outstanding file xfer packets    */

#define CTPSIZ 41             /* max size of teleconf channel topic        */
#define DBRDDN -DBRDUP        /* C/S user just shut down his drawing brd   */
#define CHANOK -1             /* chkchn(): ok to switch user to chan       */
#define TDBFSZ 512            /* size of buf for data sent w/ senddpk()    */

#define SQLFLS(u) sqlflg[(u)/32]   /* squelch flags bank, as func of user# */
#define SQLBIT(u) (1L<<((u)&0x1F))

#define tlcsex(c) ((c) == 'M' ? (c) : 'F') /* force vld sex byte in tele   */
#define tlcsxp(c) ((c) == 'M' ? "him" : "her") /* vld sex pronoun in tele  */

struct tlc {                  /* teleconference per-user volatile data     */
     INT flags;               /*   telecon user "flag" bits                */
     LONG sqlflg[8];          /*   "squelch" flags by modem number         */
     INT swchan;              /*   # of times switched chans in interval   */
     UINT channel;            /*   teleconference channel number in use    */
     UINT modchn;             /*   channel moderated by telecon user       */
     CHAR topic[CTPSIZ];      /*   channel topic as set by moderator       */
     INT inpcnt;              /*   input message counter for freeloaders   */
     INT reqcha;              /*   intervals-since-last-chat-request ctr.  */
     INT chatch;              /*   channel of other user being chatted with*/
     INT retstt;              /*   return state number when XTOOTH         */
     INT retsub;              /*   return sub-state number when XTOOTH     */
     INT retrat;              /*   return cred consumption rt when XTOOTH  */
     INT sndstt;              /*   sender's state, when sending file       */
     LONG sndbyt;             /*   sender's bytes to go, when sending file */
     INT rcvchn;              /*   receiver's channel number, when sending */
     INT sndchn;              /*   sender's chan #, when receiving file    */
     INT rcvopc;              /*   receiver's outstanding packet count     */
};

extern
struct tlc *tlclst,           /* dynamic array of tele volatile user area  */
           *tlcptr,*tptr;     /* handy pointers for speed                  */

extern HMCVFILE tlcmb;        /* teleconf named-message file block handle  */

extern
INT tlcstt,                   /* teleconferenc state number for A/A users  */
    nswchx,                   /* max times can switch chans or on-off/15sec*/
    tlcovr,                   /* does the tele cc rate over-ride Forums'?  */
    tlcccr,                   /* teleconference credit consumption rate    */
    reqint,                   /* minimum interval bewteen requesting a user*/
    npaymx,                   /* max times can talk per session if no pay  */
    tinpsz,                   /* allowable input size for teleconference   */
    swtfrm,                   /* alw A/A usrs to swt to & from Forum chans?*/
    cswto;                    /* allow C/S users to switch to Forum chans? */

extern
CHAR *modkey,                 /* key req'd to moderate tele channels       */
     *unlkey;                 /* key req'd for unlimited tele use          */

extern UINT maxfre;           /* top freeloader telecon channel            */

INT chkchn(LONG newchn);
VOID swtchn(LONG newchn);
VOID sndwsp(CHAR *what);
VOID tlcctx(VOID);
VOID inicstlc(VOID);
INT chncnt(VOID);
VOID initls(VOID);
CHAR *tlsrui(INT lsttyp);
GBOOL inscan(INT unum,struct tlc *tp);
CHAR *scnchn(INT unum,struct tlc *tp);
CHAR *scntpc(struct tlc *tp);
INT urinv(VOID);
INT ck4mod(INT excusr);
GBOOL xfrmod(CHAR *uid);
VOID ntfyres(UINT excchn);
GBOOL squsqu(CHAR *uid,GBOOL squel);
INT howmny(CHAR *stg,INT prec,GBOOL samas);
INT chkcht(CHAR *uid);
VOID reqcht(VOID);
VOID enttcht(VOID);
CHAR tlchat(INT chan,INT ch);
VOID rmvcht(INT excusr);
VOID xitcht(GBOOL hangup);
VOID tlchup(VOID);
VOID outtlc(INT msg,INT sendto,INT orgusr,INT excusr,CHAR *parm1,CHAR *parm2,
         CHAR *parm3);
INT ck4pfn(VOID);
CHAR *flgbyt(INT unum);
VOID abosnd(VOID);
VOID aborcv(INT sndchn);
VOID aboarcvs(VOID);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __TLC_H                              */
