/////////////////////////////////////////////////////////////////////////////
//
//   TLCSYSAH.CPP
//
//   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved
//
//   Active HTML Sysop Teleconference Options interface
//
//                                               - N. C. Osterc
//
/////////////////////////////////////////////////////////////////////////////

#define _RWSTDLL
#include "gcomm.h"
#include "majorbbs.h"
#include <stdcomp.h>
#define RWSTD_NO_BOOL
#include <deque>
#include <queue>
#include <string>
#include "iterand.h"
using namespace std;
#include "galacth.h"
#include "tlcapi.hpp"
#include "dnf.h"
#include "tvb.h"
#include <time.h>
#include "tlcdnf.h"

#define FILREV "$Revision: 23 $"

MARKSOURCE(tlcsysah);

#define TELESYSOP      0x001
#define ACTIONSYSOP    0x002
#define MENUSYSOP      0x004

CHAR gblChannelEditUserIDBuf[UIDSIZ];
CHAR gblActionEditUserIDBuf[UIDSIZ];
CHAR gblMenuEditUserIDBuf[UIDSIZ];

class systlcAgent : public acthAgent {
public:
     systlcAgent() : acthAgent("Active HTML Sysop Tlc Functions","systlc")
     {
          registerAgent(acthVersion);
     }

     acthSynthesis* newSynthesis(acthSession *ses);
};

class systlcSynthesis : public acthSynthesis {
public:
     systlcSynthesis(acthSession *_ses) : acthSynthesis(_ses)
     {
          usr=NULL;
          dnf=NULL;
          pChannel=NULL;
          pList=NULL;
          chan2CreateBuf[0]='\0';
          list2CreateBuf[0]='\0';
          word2CreateBuf[0]='\0';
          isysflags=0;
          pstructAList=NULL;
          pstructAction=NULL;
          pszAction=NULL;
          pUser=NULL;
          pOffUser=NULL;
     }

     ~systlcSynthesis()
     {

          if (dnf != NULL) {

               delete dnf;

               dnf=NULL;

          }

          if (pOffUser != NULL ) {

               delete pOffUser;

               pOffUser = NULL;

          }

     }

     ACTHCODE
     proceed();


private:

     CTlcChannel* pChannel;

     CHANINFO schaninf;

     CHANDSK cdsk;

     CHAR chan2CreateBuf[CHAN_MAX_SIZE];

     CHAR list2CreateBuf[ACTSIZ];

     CHAR word2CreateBuf[ACTSIZ];

     INT isysflags;

     CTlcAList* pList;

     CTlcUser* pUser;

     CTlcSysEdt* pOffUser;

     struct actlst* pstructAList;

     struct actlst structAList;

     ACTION* pstructAction;

     ACTION structAction;

     const CHAR* pszAction;

     acthUserID* usr;

     dnfHandler* dnf;

     ACTHCODE
     proceedGet();

     ACTHCODE
     proceedPost();

     ACTHCODE
     dnf_frame();

     ACTHCODE
     dnf_channelListing();

     ACTHCODE
     dnf_channelToView();

     ACTHCODE
     dnf_channelToEdit();

     ACTHCODE
     dnf_channelToDelete();

     ACTHCODE
     dnf_channelToCreate();

     ACTHCODE
     dnf_channelView();

     ACTHCODE
     dnf_channelEdit();

     ACTHCODE
     dnf_channelCreate();

     ACTHCODE
     dnf_ActionListToView();

     ACTHCODE
     dnf_ActionListToCreate();

     ACTHCODE
     dnf_ActionListToEdit();

     ACTHCODE
     dnf_ActionListToDelete();

     ACTHCODE
     dnf_ActionListListing();

     ACTHCODE
     dnf_SelectActionList();

     ACTHCODE
     dnf_ActionListInfoView();

     ACTHCODE
     dnf_ActionListEdit();

     ACTHCODE
     dnf_ActionListCreate();

     ACTHCODE
     dnf_ActionWordToView();

     ACTHCODE
     dnf_ActionWordToDelete();

     ACTHCODE
     dnf_ActionWordToCreate();

     ACTHCODE
     dnf_ActionWordToEdit();

     ACTHCODE
     dnf_ActionWordList();

     ACTHCODE
     dnf_ActionWordView();

     ACTHCODE
     dnf_ActionWordEdit();

     ACTHCODE
     dnf_ActionWordCreate();

     ACTHCODE
     dnf_ActionWordMenu();

     ACTHCODE
     dnf_UserToEdit();

     ACTHCODE
     dnf_UserEdit();

     VOID
     getChannelParameters();

     VOID
     getActionParameters();

     GBOOL
     checkAccess(
     INT iVal);

     GBOOL
     anyInActionEdit();

     GBOOL
     anyInChannelEdit();

     GBOOL
     anyInMenuEdit();

     /*GBOOL
     thisUserInActionEdit();

     GBOOL
     thisUserInChannelEdit();

     GBOOL
     thisUserInMenuEdit();

     VOID
     setActionEdit(
     INT isetVal);

     VOID
     setChannelEdit(
     INT isetVal);

     VOID
     setMenuEdit(
     INT isetVal);*/

     VOID
     handleSysEdt(
     CTlcUser *pUser);

     VOID
     handleSysEdt(
     CTlcSysEdt *pOffUser);

     CHAR *
     parsePiece(
     CHAR *piece,
     SHORT i);

     CHAR *
     getString(
     CHAR *buf,
     SHORT count);

     VOID
     noAcListsFound();

     VOID
     noAcWordsFound();

     VOID
     handleTableEntry(
     const CHAR *entry);
};

systlcAgent thesystlcAgent;

acthSynthesis*
systlcAgent::newSynthesis(acthSession* ses)
{

     return (new systlcSynthesis(ses));

}

ACTHCODE
systlcSynthesis::proceed()
{
     ACTHCODE retval=ACTHMORE;

     if (!tlcAPI->isinit()) {

          return ( ACTHMORE );

     }

     usr=ses->getUser();

     if (usr == NULL) {

          retval = ACTHNOANON;

     }
     else {

          setmbk (msgTlc);

          if ( usr->hasKey ( tlcAPI->keyGetSys() )) {

               isysflags|=TELESYSOP;

          }

          if ( usr->hasKey ( rawmsg( AEDTKEY ) ) ) {

               isysflags|=ACTIONSYSOP;

          }

          if ( usr->hasKey ( rawmsg( MNUKEY ) ) ) {

               isysflags|=MENUSYSOP;

          }

          if ( checkAccess(TELESYSOP) || checkAccess(ACTIONSYSOP)
               || checkAccess(MENUSYSOP) ) {

               if (ses->urlargc() == 0) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcFrameMap, bout );

                    }
                    else {

                         retval = dnf_frame();

                    }
               }
               else {

                    if (sameas(ses->method(),"GET")) {

                         retval=proceedGet();

                    }
                    else if (sameas(ses->method(),"POST")) {

                         retval=proceedPost();

                    }

               }
          }
          else {
               retval=ACTHFORBID;
          }

          rstmbk();

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::proceedGet()
{
     ACTHCODE retval;
     const CHAR *argv;
     INT nargs;

     nargs = ses->urlargc();

     if (nargs == 1) {

          argv = ses->urlargv(0);

          if (sameas ( argv ,"CHANNELMENU" ) ) {

               if ( checkAccess(TELESYSOP) ) {

                    ses->sndfile ( PPFIX "tlcchmnu.htm" );

               }
               else {

                    ses->sndfile ( PPFIX "tlccherr.htm" );

               }

               retval=ACTHDONE;

          }
          else if (sameas ( argv , "ACTIONLISTMENU" ) ) {

               if ( checkAccess(TELESYSOP) ) {

                    ses->sndfile ( PPFIX "tlcalmnu.htm" );

               }
               else {

                    ses->sndfile ( PPFIX "tlcalerr.htm" );

               }

               retval=ACTHDONE;

          }
          else if (sameas ( argv , "ACTIONWORDMENU" ) ) {

               if (!checkAccess(TELESYSOP) && !checkAccess(ACTIONSYSOP) ) {

                    ses->sndfile (PPFIX "tlcawerr.htm" );
                    retval = ACTHDONE;

               }
               else {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcSelectActionListMap, bout );

                    }
                    else {

                         retval = dnf_SelectActionList();

                    }
               }

          }
          else if (sameas ( argv , "USEREDITMENU" ) ) {

               if (!checkAccess (TELESYSOP) && !checkAccess(MENUSYSOP) ) {

                    ses->sndfile (PPFIX "tlcmnerr.htm" );
                    retval = ACTHDONE;

               }
               else {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcUsertoEditMap , bout );

                    }
                    else {

                         retval = dnf_UserToEdit();

                    }
               }

          }
          else if (sameas ( argv , "tlcmain" ) ) {

               bout << "<p align=center> Select an option </p>";
               retval = ACTHDONE;

          }
          else if (sameas ( argv , "tlcchlst" )) {

               if (checkAccess (TELESYSOP)) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcChannelListingMap, bout);

                    }
                    else {

                         retval = dnf_channelListing();

                    }

               }
               else {

                    bout << "You don't have access to Channel Listings.";
                    retval = ACTHDONE;

               }

          }
          else if (sameas ( argv , "tlcchvu" )) {


               if (checkAccess (TELESYSOP)) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcChanneltoViewMap, bout );

                    }
                    else {

                         retval = dnf_channelToView();


                    }

               }
               else {

                    bout << "You don't have access to View Channels.";
                    retval = ACTHDONE;

               }


          }
          else if (sameas ( argv , "tlcche" )) {

               if (checkAccess (TELESYSOP)) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcChanneltoEditMap, bout );

                    }
                    else {

                         retval = dnf_channelToEdit();

                    }

               }
               else {

                    bout << "You don't have access to Edit Channels.";
                    retval = ACTHDONE;

               }

          }
          else if (sameas ( argv , "tlcchd" )) {

               if (checkAccess (TELESYSOP)) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcChanneltoDeleteMap, bout );

                    }
                    else {

                         retval = dnf_channelToDelete();

                    }

               }
               else {

                    bout << "You don't have access to Delete Channels.";

               }

          }
          else if (sameas ( argv , "tlcreate" )) {

               if (checkAccess (TELESYSOP)) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcChanneltoCreateMap, bout );

                    }
                    else {

                         retval = dnf_channelToCreate();

                    }

               }
               else {

                    bout << "You don't have access to Create Channels.";

               }

          }
          else if (sameas ( argv, "tlcallst")) {

            if (checkAccess (TELESYSOP) ) {

               if ( dnf == NULL ) {


                    dnf = new dnfHandler ( systlcActionListListingMap, bout );

               }
               else {

                    retval = dnf_ActionListListing();

               }


            }
            else {

                 bout << "You don't have access to list action lists.";
                 retval = ACTHDONE;

            }

          }
          else if (sameas ( argv, "tlcalv")) {

            if (checkAccess (TELESYSOP)) {

               if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionListtoViewMap, bout );

               }
               else {

                    retval = dnf_ActionListToView();

               }

            }
            else {

                 bout << "You don't have access to view action lists.";
                 retval = ACTHDONE;

            }

          }
          else if (sameas ( argv, "tlcale")) {

            if (checkAccess (TELESYSOP)) {

               if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionListtoEditMap, bout );

               }
               else {

                    retval = dnf_ActionListToEdit();

               }


            }
            else {

                 bout << "You don't have access to edit actions lists.";
                 retval = ACTHDONE;

            }

          }
          else if (sameas ( argv, "tlcald")) {

            if (checkAccess (TELESYSOP) ) {

               if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionListtoDeleteMap, bout );

               }
               else {

                    retval = dnf_ActionListToDelete();

               }

            }
            else {

                 bout << "You don't have access to delete action lists.";
                 retval = ACTHDONE;

            }

          }
          else if (sameas ( argv, "tlcalc")) {

            if (checkAccess (TELESYSOP) ) {

               if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionListtoCreateMap, bout );

               }
               else {

                    retval = dnf_ActionListToCreate();

               }

            }
            else {

                 bout << "You don't have access to create action lists.";
                 retval = ACTHDONE;

            }

          }
          /*else if (sameas (argv, "actioncancel" )) {


               setActionEdit ( -1 );

               bout << "You are no longer in Action Edit Mode.";

               retval = ACTHDONE;


          }
          else if (sameas (argv, "channelcancel" )) {

               setChannelEdit ( -1 );

               bout << "You are no longer in Channel Edit Mode.";

               retval = ACTHDONE;


          }
          else if (sameas (argv, "menucancel" )) {

               setMenuEdit ( -1 );

               bout << "You are no longer in Menu Edit Mode.";

               retval = ACTHDONE;


          } */
          else if (strchr(ses->urlargv(0),'.') != NULL) {

               ostrstream ost;
               ost << PPFIX << ses->urlargv(0) << ends;
               ses->sndfile(ost.str());
               ost.rdbuf()->freeze(0);
               retval=ACTHDONE;

          }
          else {

               retval = ACTHDONE;

          }

     }
     else if (nargs == 2) {

          if (! checkAccess (TELESYSOP) && !checkAccess(ACTIONSYSOP) ) {

               bout << "You do not have access.";
               return ( ACTHDONE );

          }

          if (sameas (ses->urlargv(0),"tlcawlst")) {

              if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) == NULL) {
                  bout << "Action list not found.";
                  return(ACTHDONE);
              }
              if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionWordListMap, bout );

              }
              else {

                    retval = dnf_ActionWordList();

              }
          }
          else if (sameas ( ses->urlargv(0),"tlcawv")) {

              if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) == NULL) {
                  bout << "Action list not found.";
                  return ( ACTHDONE );
              }
              if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionWordtoViewMap, bout );

              }
              else {

                    retval = dnf_ActionWordToView();

              }
          }
          else if (sameas ( ses->urlargv(0),"tlcawe")) {

              if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) == NULL) {
                    bout << "Action list not found.";
                    return ( ACTHDONE );
              }

              if ( dnf == NULL ) {

                    dnf = new dnfHandler ( systlcActionWordtoEditMap, bout );

              }
              else {

                    retval = dnf_ActionWordToEdit();

              }

          }
          else if (sameas ( ses->urlargv(0),"tlcawd")) {

              if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) == NULL) {
                  bout << "Action list not found.";
                  return ( ACTHDONE );
              }
              if ( dnf == NULL ) {
                    dnf = new dnfHandler ( systlcActionWordtoDeleteMap, bout );


              }
              else {

                    retval = dnf_ActionWordToDelete();

              }
          }
          else if (sameas ( ses->urlargv(0),"tlcawc")) {

               if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) != NULL) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcActionWordtoCreateMap, bout );


                    }
                    else {

                         retval = dnf_ActionWordToCreate();

                    }
               }
               else {

                    retval = ACTHDONE;

               }
          }

          else {

               retval = ACTHNOTFND;

          }

     }
     else {

          retval = ACTHNOTFND;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::proceedPost()
{
     ACTHCODE retval=ACTHMORE;
     INT nargs;
     CHAR parambuf[CHAN_MAX_SIZE];

     nargs = ses->urlargc();

     if (nargs == 1) {

          if (sameas(ses->urlargv(0),"channeltoview") &&
              checkAccess ( TELESYSOP ) ) {

               ses->param("NAM_CHANVIEW", parambuf, CHAN_MAX_SIZE);

               pChannel = tlcAPI->chanGetByName(parambuf);

               if ( pChannel == NULL ) {

                    bout << "That channel does not exist." << endl;

                    retval = ACTHDONE;

               }
               else {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcChannelViewMap, bout );

                    }
                    else {

                         retval = dnf_channelView();

                    }

               }

          }
          else if (sameas(ses->urlargv(0),"channeltoedit") &&
                   checkAccess ( TELESYSOP ) )  {

               ses->param("NAM_CHANEDIT", parambuf, CHAN_MAX_SIZE);

               pChannel = tlcAPI->chanGetByName(parambuf);

               if ( pChannel == NULL ) {

                    bout << "That channel does not exist." << endl;

                    retval = ACTHDONE;

               }
               else {

                    if ( dnf == NULL ) {

                         /*if ( !anyInChannelEdit()) {

                              setChannelEdit ( -2 );

                         }
                         else {

                              bout << "Channel Edit Services are not available "
                                      "right now.";

                              return ( ACTHDONE );

                         } */

                         dnf = new dnfHandler ( systlcChannelEditMap, bout );

                    }
                    else {

                         retval = dnf_channelEdit();

                    }

               }

          }
          else if (sameas(ses->urlargv(0),"channeltocreate") &&
                   checkAccess ( TELESYSOP )) {

               ses->param("NAM_CREATECHAN", parambuf, CHAN_MAX_SIZE);

               if ( parambuf[0] == '\0' ) {

                    bout << "Cannot create blank channel." << endl;

                    retval = ACTHDONE;

               }
               else if ( !chkalph ( parambuf )) {

                    bout << "Channel name must be alphabetic." << endl;

                    retval = ACTHDONE;

               }
               else {


                    if ( dnf == NULL ) {


                         /*if ( !anyInChannelEdit()) {

                              setChannelEdit ( -2 );

                         }
                         else {

                              bout << "Channel Edit Services are not available "
                                      "right now.";

                              return ( ACTHDONE );

                         } */

                         stlcpy(chan2CreateBuf , parambuf, CHAN_MAX_SIZE);

                         dnf = new dnfHandler ( systlcChannelCreateMap, bout );

                    }
                    else {

                         retval = dnf_channelCreate();

                    }

               }

          }
          else if (sameas(ses->urlargv(0),"channeltodelete") &&
                   checkAccess ( TELESYSOP ) ) {

               ses->param ("NAM_CHANDELETE", parambuf, CHAN_MAX_SIZE);

               if (parambuf[0] == '\0') {


                    bout << "Cannot delete blank channel." << endl;

               }
               else {

                    if ( ( pChannel = tlcAPI->chanGetByName(parambuf) ) !=
                           NULL) {

                         if ( pChannel->GetType()&CHAN_TYPE_NOEDIT
                           || pChannel->GetType()&CHAN_TYPE_PRIVATE ) {
                              bout << "You can't delete this channel.";
                              return ( ACTHDONE );
                         }

                         if ( !anyInChannelEdit()) {

                              if (!sameas ( parambuf , mainchan )) {

                                   tlcAPI->chanMoveAllUsers( parambuf,
                                   dftchan , CHAN_SWITCH_DELETED , SCMSG_CHAN_DELETE);

                                   tlcAPI->chanRemoveByName( parambuf );

                                   bout << "Deleted channel." << endl;

                              }
                              else {

                                   bout << "Can't delete default Channel.";

                              }

                         }
                         else {

                              bout << "Channel Services are not available "
                                      "right now.";

                         }

                    }
                    else {

                         bout << "Unable to locate Channel." << endl;

                    }

               }

               retval = ACTHDONE;

          }
          else if (sameas(ses->urlargv(0),"actionlisttoview") &&
                   checkAccess ( TELESYSOP ) ) {

               ses->param ("NAM_ACTIONLISTVIEW" ,parambuf,  CHAN_MAX_SIZE );

               if ((pList = tlcAPI->actGetByName (parambuf)) != NULL ) {

                    if ( dnf == NULL ) {

                         pstructAList = pList->GetConfigPtr();

                         dnf = new dnfHandler ( systlcActionListInfoViewMap, bout );

                    }
                    else {

                         retval = dnf_ActionListInfoView();

                    }
               }
               else {

                    bout << "Unable to locate Action List." << endl;
                    retval=ACTHDONE;

               }
          }
          else if (sameas(ses->urlargv(0),"actionlisttoedit") &&
                   checkAccess ( TELESYSOP ) ) {

               ses->param ( "NAM_ACTIONLISTEDIT" , parambuf, CHAN_MAX_SIZE );

               if ((pList = tlcAPI->actGetByName (parambuf)) != NULL ) {

                    if ( dnf == NULL ) {

                         /*if ( !anyInActionEdit()) {

                              setActionEdit ( -2 );

                         }
                         else {

                              bout << "Action Edit Services are not available "
                                      "right now.";

                              return ( ACTHDONE );

                         } */

                         pstructAList = pList->GetConfigPtr();


                         dnf = new dnfHandler ( systlcActionListEditMap, bout );

                    }
                    else {

                         retval = dnf_ActionListEdit();

                    }
               }
               else {

                    bout << "Unable to locate Action List." << endl;
                    retval=ACTHDONE;
               }

          }
          else if (sameas(ses->urlargv(0),"actionlisttocreate") &&
                   checkAccess (TELESYSOP ) ) {

               ses->param ("NAM_ACTIONLIST", parambuf, CHAN_MAX_SIZE);

               if (!chkalph ( parambuf )) {

                    bout << "Action Lists names must be alphabetic." << endl;
                    retval = ACTHDONE;

               }
               else if ( tlcAPI->actGetByName ( parambuf ) == NULL ) { //good

                    if ( dnf == NULL ) {

                         /*if ( !anyInActionEdit()) {

                              setActionEdit ( -2 );

                         }
                         else {

                              bout << "Action Services are not available "
                                      "right now.";

                              return ( ACTHDONE );

                         } */

                         stzcpy (list2CreateBuf , parambuf, ACTSIZ );

                         dnf = new dnfHandler ( systlcActionListCreateMap,bout);


                    }
                    else {

                         retval = dnf_ActionListCreate();

                    }

               }
               else {

                    bout << "Action list already exists." << endl;
                    retval = ACTHDONE;

               }

          }
          else if (sameas(ses->urlargv(0),"actionlisttodelete") &&
                   checkAccess ( TELESYSOP ) ) {

               ses->param ("NAM_ACTIONLISTDEL" , parambuf, CHAN_MAX_SIZE );

               if ((pList = tlcAPI->actGetByName (parambuf)) != NULL ) {

                    if ( !anyInActionEdit()) {

                         pList->Delete();

                         bout << "Action List Deleted" << endl;

                    }
                    else {

                         bout << "Action Services are not available "
                                 "right now.";

                    }

               }
               else {

                    bout << "Action list wasn't found." << endl;

               }

               retval = ACTHDONE;
          }
          else if (sameas ( ses->urlargv(0),"selectactionlist") &&
                   (checkAccess ( TELESYSOP ) || checkAccess(ACTIONSYSOP))) {

               ses->param ("NAM_ACTIONLIST" , parambuf, CHAN_MAX_SIZE );

               if ((pList = tlcAPI->actGetByName ( parambuf )) != NULL ) {

                    if ( dnf == NULL ) {

                         dnf = new dnfHandler ( systlcActionWordMenuMap , bout);

                    }
                    else {

                         retval = dnf_ActionWordMenu();

                    }

               }
               else {

                    bout << "Couldn't locate Action List.";
                    retval = ACTHDONE;

               }

          }
          else if (sameas(ses->urlargv(0),"usertoedit") &&
                   (checkAccess (TELESYSOP) || checkAccess(MENUSYSOP)) ) {

               ses->param ( "NAM_UID2EDIT", parambuf, CHAN_MAX_SIZE );

               if ((pUser = tlcAPI->usrGetByName(parambuf)) != NULL ) {

                    if ( dnf == NULL ) {

                         /*if ( !anyInMenuEdit()) {

                              setMenuEdit ( -2 );

                         }
                         else {

                              bout << "Menu Edit Services are not available "
                                        "right now.";

                              return ( ACTHDONE );

                         } */

                         dnf = new dnfHandler ( systlcUserEditMap, bout );

                    }
                    else {

                         retval = dnf_UserEdit();

                    }

               }
               else {

                    if ( dnf == NULL ) {

                         /*if ( !anyInMenuEdit()) {

                              setMenuEdit ( -2 );

                         }
                         else {

                              bout << "Menu Edit Services are not available "
                                      "right now.";

                              return ( ACTHDONE );

                         } */

                         pOffUser = new CTlcSysEdt ( parambuf );

                         if (!pOffUser->foundUser()) {
                              USRDSK UserInfoDisk;
                              memset(&UserInfoDisk,0,sizeof(USRDSK));


                              dfaSetBlk( accbb );

                              if (dfaAcqEQ ( NULL, parambuf , 0 )) {
                                   struct usracc* usra=(struct usracc*)(accbb->data);
                                   stlcpy(UserInfoDisk.m_pszUserid,usra->userid,UIDSIZ);
                                   UserInfoDisk.m_iChatInterval=2;
                                   dfaSetBlk( dfaTlcUser);
                                   dfaInsert(&UserInfoDisk);
                                   dfaRstBlk();
                              }
                              else {
                                   bout << "Couldn't locate user.";
                                   dfaRstBlk();
                                   return  ( ACTHDONE );
                              }
                              if (!pOffUser->reload()) {
                                   ASSERTM(FALSE,"Couldn't reload inserted user profile");
                                   bout << "Couldn't locate user.";
                                   return  ( ACTHDONE );
                              }

                         }

                          dnf = new dnfHandler (systlcUserEditMap, bout );

                    }
                    else {

                         retval = dnf_UserEdit();

                    }

               }

          }
          else {

               retval = ACTHNOTFND;

          }

     }
     else if ( nargs == 2 ) {

          const CHAR *arg2;

          arg2 = ses->urlargv(1);

          if (sameas(ses->urlargv(0),"actionwordtoview") &&
              (checkAccess ( TELESYSOP) || checkAccess(ACTIONSYSOP)) ) {

               if ((pList = tlcAPI->actGetByName ( arg2 )) != NULL ) {

                    ses->param ( "NAM_WORDVIEW", parambuf, CHAN_MAX_SIZE );

                    if (pList->wordExists(parambuf) &&
                       (pstructAction = pList->actionGetCurrentPtr()) != NULL ) {

                         if ( dnf == NULL ) {

                              dnf = new dnfHandler ( systlcActionWordViewMap, bout );

                         }
                         else {

                              retval = dnf_ActionWordView();

                         }


                    }
                    else {

                         bout << "Couldn't locate word.";

                         retval = ACTHDONE;

                    }

               }
               else {

                    bout << "Couldn't locate Action List.";

                    retval = ACTHDONE;
               }



          }
          else if (sameas(ses->urlargv(0),"actionwordtoedit") &&
                   (checkAccess ( TELESYSOP) || checkAccess(ACTIONSYSOP)) ) {


               if ((pList = tlcAPI->actGetByName ( arg2 )) != NULL ) {

                    ses->param ( "NAM_WORDEDIT", parambuf, CHAN_MAX_SIZE );

                    if (pList->wordExists(parambuf) &&
                       (pstructAction = pList->actionGetCurrentPtr()) != NULL ) {

                         if ( dnf == NULL ) {

                              /*if ( !anyInActionEdit()) {

                                   setActionEdit ( -2 );

                              }
                              else {

                                   bout << "Action Edit Services are not available "
                                           "right now.";

                                   return ( ACTHDONE );

                              } */

                              dnf = new dnfHandler ( systlcActionWordEditMap, bout );

                         }
                         else {

                              retval = dnf_ActionWordEdit();

                         }


                    }
                    else {

                         bout << "Couldn't locate word.";

                         retval = ACTHDONE;

                    }

               }
               else {

                    bout << "Couldn't locate Action List.";

                    retval = ACTHDONE;
               }


          }
          else if (sameas(ses->urlargv(0),"actionwordtocreate") &&
                   (checkAccess ( TELESYSOP) || checkAccess(ACTIONSYSOP)) ) {

               if ((pList = tlcAPI->actGetByName ( arg2 )) != NULL ) {

                    ses->param ("NAM_WORDCREATE", parambuf, CHAN_MAX_SIZE );

                    if (!chkalph(parambuf)) {

                         bout << "Action word must be alphabetic.";
                         retval = ACTHDONE;

                    }
                    else if (!pList->wordExists(parambuf)) {

                         if ( dnf == NULL ) {

                              /*if ( !anyInActionEdit()) {

                                   setActionEdit ( -2 );

                              }
                              else {

                                   bout << "Action Creation Services are not available "
                                           "right now.";

                                   return ( ACTHDONE );

                              } */

                              dnf = new dnfHandler ( systlcActionWordCreateMap, bout );

                              stzcpy ( word2CreateBuf, parambuf , ACTSIZ );

                         }
                         else {

                              retval = dnf_ActionWordCreate();

                         }
                    }
                    else {

                         bout << "Word already exists.";

                         retval = ACTHDONE;

                    }

               }
               else {

                    bout << "Couldn't locate Action List.";

                    retval = ACTHDONE;
               }

          }
          else if (sameas(ses->urlargv(0),"actionwordtodelete") &&
                   (checkAccess ( TELESYSOP) || checkAccess(ACTIONSYSOP))) {


               if ((pList = tlcAPI->actGetByName ( arg2 )) != NULL ) {

                    ses->param ("NAM_WORDDELETE", parambuf, CHAN_MAX_SIZE );

                    if (pList->wordExists(parambuf) &&
                       (pstructAction = pList->actionGetCurrentPtr()) != NULL) {

                         if ( !anyInActionEdit()) {


                              if ((delact ( pstructAction )) == 0) {

                                   bout << "Deleted action.";

                              }
                              else {

                                   bout << "Couldn't delete action.";

                              }

                         }
                         else {

                              bout << "Action Services are not available "
                                        "right now.";

                              return ( ACTHDONE );

                         }

                    }
                    else {

                         bout << "Couldn't locate action list for word.";

                    }

               }

               retval = ACTHDONE;


          }
          else if (sameas(ses->urlargv(0),"channeledit") &&
                   checkAccess (TELESYSOP) ) {

               /*if (! thisUserInChannelEdit()) {

                    bout << "You aren't currently in Edit Mode.  "
                            "Re-select the Channel to Edit.";

                    return ( ACTHDONE );

               } */

               if ((pChannel = tlcAPI->chanGetByName ( ses->urlargv(1))) !=
                    NULL ) {

                    if ( pChannel->GetType()&CHAN_TYPE_NOEDIT
                      || pChannel->GetType()&CHAN_TYPE_PRIVATE ) {
                         bout << "You can't edit this channel.";
                         return ( ACTHDONE );
                    }

                    getChannelParameters();

                    pChannel->Update ( &schaninf );

                    bout << "Channel update.";
               }
               else {

                    bout << "Couldn't locate Channel.";


               }

               //setChannelEdit ( -1 );

               retval = ACTHDONE;

          }
          else if (sameas(ses->urlargv(0),"channelcreate") &&
                   checkAccess ( TELESYSOP )) {

               /*if (! thisUserInChannelEdit()) {

                    bout << "You aren't currently in Channel Create Mode.  "
                            "Re-select the Channel create.";

                    return ( ACTHDONE );

               } */

               if (!chkalph ( ses->urlargv(1) ) ) {

                    bout << "Channel names must be alphabetic." << endl;

                    return ( ACTHDONE );

               }

               if ((pChannel = tlcAPI->chanGetByName ( ses->urlargv(1))) ==
                    NULL ) {

                    setmem ( &schaninf , sizeof (CHANINFO) , 0);

                    stlcpy ( schaninf.m_strName , ses->urlargv(1) , CHAN_MAX_SIZE);

                    getChannelParameters();

                    memmove( &cdsk , &schaninf, sizeof ( CHANDSK ) );

                    if ((tlcChannelCreateLocal( &cdsk , TRUE )) == FALSE ) {

                         bout << "Failed to create channel" << endl;

                    }
                    else {

                         bout << "Channel created." << endl;

                    }

               }
               else {

                    bout << "Channel already exists." << endl;

               }

               //setChannelEdit ( -1 );

               retval = ACTHDONE;

          }
          else if (sameas (ses->urlargv(0),"actionlistedit") &&
                   checkAccess ( TELESYSOP )) {

               /*if (! thisUserInActionEdit()) {

                    bout << "You aren't currently in Action Edit Mode.  "
                            "Re-select the Action List to Edit.";

                    return ( ACTHDONE );

               } */

               if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) != NULL) {

                    if ((pstructAList = pList->GetConfigPtr()) != NULL ) {

                         ses->param ("NAM_SEEACTIONKEY",pstructAList->seekey,
                                     KEYSIZ);

                         ses->param ("NAM_USEACTIONKEY",pstructAList->usekey,
                                     KEYSIZ);

                         pList->SetConfig ( pstructAList );

                         bout << "Action List has been updated." << endl;

                    }
                    else {

                         bout << "Couldn't obtain Action List.";

                    }

               }
               else {

                    bout << "Action List doesn't exist." << endl;

               }

               //setActionEdit ( -1 );

               retval = ACTHDONE;

          }
          else if (sameas (ses->urlargv(0),"actionlistcreate") &&
                   checkAccess ( TELESYSOP )) {

               /*if (! thisUserInActionEdit()) {

                    bout << "You aren't currently in Action Create Mode.  "
                            "Re-select the Action List to Create.";

                    return ( ACTHDONE );

               } */

               if (!chkalph(ses->urlargv(0) ) ) {

                    bout << "List name must be alphabetic." << endl;

                    return ( ACTHDONE );

               }

               if ((pList = tlcAPI->actGetByName ( ses->urlargv(1))) == NULL) {

                   setmem (&structAList, sizeof(structAList) , 0);

                   stlcpy ( structAList.name, LSTNAM, ACTSIZ );

                   stlcpy ( structAList.name, ses->urlargv(1), ACTSIZ);

                   ses->param ("NAM_SEEACTIONKEY",structAList.seekey,
                               KEYSIZ);

                   ses->param ("NAM_USEACTIONKEY",structAList.usekey,
                               KEYSIZ);

                   addlst ( &structAList );


                   bout << "Action List has been created." << endl;


               }
               else {

                    bout << "Action List already exists." << endl;

               }

               //setActionEdit ( -1 );

               retval = ACTHDONE;

          }
          else if (sameas (ses->urlargv(0),"useredit") &&
                   (checkAccess ( TELESYSOP) || checkAccess(MENUSYSOP)) ) {

               /*if (! thisUserInMenuEdit()) {

                    bout << "You aren't currently in Menu Edit Mode.  "
                            "Re-select user to edit.";

                    return ( ACTHDONE );

               } */

               if ( (pUser= tlcAPI->usrGetByName(ses->urlargv(1))) != NULL ) {

                    handleSysEdt ( pUser );

                    bout << "Updated user settings.";

               }
               else {

                    pOffUser = new CTlcSysEdt ( ses->urlargv(1));

                    if (pOffUser->foundUser()) {

                         handleSysEdt ( pOffUser );

                         if (pOffUser->update()) {

                              bout << "Updated user settings.";

                         }
                         else {

                              bout << "Update failed.";

                         }

                    }
                    else {

                         bout << "Couldn't locate this user.";

                    }

               }

               //setMenuEdit ( -1 );

               retval = ACTHDONE;

          }
          else {

               retval = ACTHNOTFND;

          }

     }
     else if ( nargs == 3 ) {

          if (sameas (ses->urlargv(0),"actionwordedit") &&
              (checkAccess ( TELESYSOP) || checkAccess(ACTIONSYSOP))) {

               /*if (! thisUserInActionEdit()) {

                    bout << "You aren't currently in Action Edit Mode.  "
                            "Re-select the Action Word to Edit.";

                    return ( ACTHDONE );

               } */

               if ((pList = tlcAPI->actGetByName (ses->urlargv(1))) != NULL ) {

                    if ( pList->wordExists ( ses->urlargv(2) ) &&
                       ( pstructAction = pList->actionGetCurrentPtr()) != NULL) {

                         getActionParameters();

                         if ( chgact ( pstructAction ) == 0) {

                              bout << "Action saved.";

                         }
                         else {

                              bout << "An error occured when saving action.";

                         }

                    }
                    else {


                         bout << "Couldn't find action word.";

                    }

               }
               else {

                    bout << "Couldn't locate action word's Action List.";

               }

               //setActionEdit ( -1 );

               retval = ACTHDONE;

          }
          else if (sameas (ses->urlargv(0),"actionwordcreate") &&
                   (checkAccess ( TELESYSOP) || checkAccess(ACTIONSYSOP)) ) {

               if ((pList = tlcAPI->actGetByName (ses->urlargv(1))) != NULL ) {

                    /*if (! thisUserInActionEdit()) {

                         bout << "You aren't currently in Action Create Mode.  "
                                 "Re-select the Action Word to Create.";

                         return ( ACTHDONE );

                    } */

                    if (!chkalph(ses->urlargv(2))) {

                         bout << "Action words must be alphabetic.";

                         return ( ACTHDONE );

                    }

                    if (!pList->wordExists ( ses->urlargv(2) ) ) {

                         pstructAction = new ACTION;

                         setmem(pstructAction, sizeof ( ACTION ), '\0');

                         stzcpy ( pstructAction->list , ses->urlargv(1) , ACTSIZ );
                         stzcpy ( pstructAction->name , ses->urlargv(2) , ACTSIZ );

                         getActionParameters();

                         if ( addact ( pstructAction ) == 0) {

                              bout << "New action successfully created.";

                         }
                         else {

                              bout << "An error occured when saving action.";

                         }

                         delete pstructAction;

                    }
                    else {


                         bout << "This action already exists.";

                    }
               }
               else {

                    bout << "Couldn't locate Action List." << endl;

               }

               //setActionEdit ( -1 );

               retval = ACTHDONE;


          }
          else {

              retval = ACTHNOTFND;

          }

     }
     else {

          retval = ACTHNOTFND;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_frame()
{
     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {

     case TLCMNU:

          bout << "CHANNELMENU";

          break;

     case DNFEND:

          retval=ACTHDONE;

          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_channelListing()
{

     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {


     case DNFROWBEGIN:

          if ( pChannel == NULL && dnf->rowNumber() == 0) {

               pChannel = tlcAPI->chanGetFirst();
               if (pChannel == NULL ) {
                    dnf->tableDone();
                    break;
               }

          }
          else if ( pChannel == NULL ) {

               dnf->tableDone();
               break;

          }
          while ( pChannel->GetType()&CHAN_TYPE_NOEDIT
          || pChannel->GetType()&CHAN_TYPE_PRIVATE ) {

              pChannel = tlcAPI->chanGetGT(pChannel->GetName());

              if ( pChannel == NULL ) {
                    dnf->tableDone();
                    break;
              }
          }
          break;

     case CHANNEL:

          bout << pChannel->GetName();
          break;


     case TOPIC:

          handleTableEntry ( pChannel->GetTopic() );
          break;

     case DNFROWEND:

          pChannel = tlcAPI->chanGetGT(pChannel->GetName());
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );



}


ACTHCODE
systlcSynthesis::dnf_channelToView()
{

     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {

     case DNFROWBEGIN:

          if ( pChannel == NULL && dnf->rowNumber() == 0) {

               pChannel = tlcAPI->chanGetFirst();
               if (pChannel == NULL ) {
                    dnf->tableDone();
                    break;
               }

          }
          else if ( pChannel == NULL ) {

               dnf->tableDone();
               break;

          }
          while ( pChannel->GetType()&CHAN_TYPE_NOEDIT
          || pChannel->GetType()&CHAN_TYPE_PRIVATE ) {

              pChannel = tlcAPI->chanGetGT(pChannel->GetName());

              if ( pChannel == NULL ) {
                    dnf->tableDone();
                    break;
              }
          }
          break;

     case VIEWCHANNEL:

          bout << pChannel->GetName();
          break;

     case DNFROWEND:

          pChannel = tlcAPI->chanGetGT(pChannel->GetName());
          break;
     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_channelToEdit()
{
     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {

     case DNFROWBEGIN:

          if ( pChannel == NULL && dnf->rowNumber() == 0) {

               pChannel = tlcAPI->chanGetFirst();
               if (pChannel == NULL ) {
                    dnf->tableDone();
                    break;
               }

          }
          else if ( pChannel == NULL ) {

               dnf->tableDone();
               break;

          }
          while ( pChannel->GetType()&CHAN_TYPE_NOEDIT
          || pChannel->GetType()&CHAN_TYPE_PRIVATE ) {

              pChannel = tlcAPI->chanGetGT(pChannel->GetName());

              if ( pChannel == NULL ) {
                    dnf->tableDone();
                    break;
              }
          }

          break;
     case EDITCHANNEL:

          bout << pChannel->GetName();
          break;
     case DNFROWEND:

          pChannel = tlcAPI->chanGetGT(pChannel->GetName());
          break;


     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_channelToDelete()
{
     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {

     case DNFROWBEGIN:

          if ( pChannel == NULL && dnf->rowNumber() == 0) {

               pChannel = tlcAPI->chanGetFirst();
               if (pChannel == NULL ) {
                    dnf->tableDone();
                    break;
               }

          }
          else if ( pChannel == NULL ) {

               dnf->tableDone();
               break;

          }
          while ( pChannel->GetType()&CHAN_TYPE_NOEDIT
          || pChannel->GetType()&CHAN_TYPE_PRIVATE ) {

              pChannel = tlcAPI->chanGetGT(pChannel->GetName());

              if ( pChannel == NULL ) {
                    dnf->tableDone();
                    break;
              }
          }
          break;

     case DELCHANNEL:

          bout << pChannel->GetName();
          break;
     case DNFROWEND:

          pChannel = tlcAPI->chanGetGT(pChannel->GetName());
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_channelToCreate()
{
     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {

     case SZ_CHAN_MAX_SIZE:

          bout << CHAN_MAX_SIZE;
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_channelView()
{
     ACTHCODE retval=ACTHMORE;

     switch ( dnf->process() ) {

     case CHANNEL:

          bout << pChannel->GetName();
          break;

     case TOPIC:

          handleTableEntry (pChannel->GetTopic());
          break;

     case VISKEY:

          handleTableEntry (pChannel->GetKey(CHAN_AXS_SEE));
          break;

     case JOINKEY:

          handleTableEntry (pChannel->GetKey(CHAN_AXS_JOIN));
          break;

     case SPEAKKEY:

          handleTableEntry (pChannel->GetKey(CHAN_AXS_SPEAK));
          break;

     case SUPERKEY:

          handleTableEntry (pChannel->GetKey(CHAN_AXS_SUPER));
          break;

     case MODKEY:

          handleTableEntry (pChannel->GetKey(CHAN_AXS_MODERATOR));
          break;

     case PRIMEACTION:

          handleTableEntry (pChannel->m_actList1);
          break;

     case SECONDACTION:

          handleTableEntry (pChannel->m_actList2);
          break;

     case ALLOWPROFAN:

          if (pChannel->m_flags&CHAN_FLAG_PROFOK) {

               bout << "YES";

          }
          else {

               bout << "NO";

          }
          break;

     case ENTEXIT:

          if (pChannel->m_flags&CHAN_FLAG_NOENTMESSAGE) {

               bout << "NO";
          }
          else {

               bout << "YES";

          }

          break;

     case CLOSED:

          if (pChannel->m_flags&CHAN_FLAG_CLOSED) {

               bout << "YES";

          }
          else {

               bout << "NO";

          }
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_channelEdit()
{
    ACTHCODE retval=ACTHMORE;

    switch ( dnf->process() ) {

    case CHANNEL:

         bout << pChannel->GetName();
         break;

    case SZ_CHAN_MAX_TOPIC_SIZE:

         bout << CHAN_MAX_TOPIC_SIZE;
         break;

    case VAL_TOPIC:

         bout << pChannel->GetTopic();
         break;

    case SZ_KEYSIZ:

         bout << KEYSIZ;
         break;

    case VAL_VISKEY:

         bout << pChannel->GetKey(CHAN_AXS_SEE);
         break;

    case VAL_JOINKEY:

         bout << pChannel->GetKey(CHAN_AXS_JOIN);
         break;

    case VAL_SPEAKKEY:

         bout << pChannel->GetKey(CHAN_AXS_SPEAK);
         break;

    case VAL_SUPERKEY:

         bout << pChannel->GetKey(CHAN_AXS_SUPER);
         break;

    case VAL_MODKEY:

         bout << pChannel->GetKey(CHAN_AXS_MODERATOR);
         break;

    case SZ_ACTSIZ:

         bout << ACTSIZ;
         break;

    case PRIMEACTION:

         bout << pChannel->m_actList1;
         break;

    case SECONDACTION:

         bout << pChannel->m_actList2;
         break;

    case PROF_OP_1:

         pChannel->m_flags&CHAN_FLAG_PROFOK ? bout << "YES" : bout << "NO";
         break;

    case PROF_OP_2:

         pChannel->m_flags&CHAN_FLAG_PROFOK ? bout << "NO" : bout << "YES";
         break;

    case ENTEXT_OP_1:

         pChannel->m_flags&CHAN_FLAG_NOENTMESSAGE ? bout << "NO" :
                   bout << "YES";
         break;

    case ENTEXT_OP_2:

         pChannel->m_flags&CHAN_FLAG_NOENTMESSAGE ? bout << "YES" :
                   bout << "NO";
         break;

    case CLOSED_OP_1:

         pChannel->m_flags&CHAN_FLAG_CLOSED ? bout << "YES" : bout << "NO";
         break;


    case CLOSED_OP_2:

         pChannel->m_flags&CHAN_FLAG_CLOSED ? bout << "NO" : bout << "YES";
         break;

    case DNFEND:

//         if (!thisUserInChannelEdit()) {

              retval=ACTHDONE;

  //       }
         break;

    }

    return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_channelCreate()
{
    ACTHCODE retval=ACTHMORE;

    switch ( dnf->process() ) {

    case CHANNEL:

         bout << chan2CreateBuf;
         break;

    case SZ_CHAN_MAX_TOPIC_SIZE:

         bout << CHAN_MAX_TOPIC_SIZE;
         break;

    case SZ_KEYSIZ:

         bout << KEYSIZ;
         break;

    case VAL_VISKEY:

         //bout << pChannel->GetVisibleKey();
         bout << "";
         break;

    case VAL_JOINKEY:

         //bout << pChannel->GetJoinKey();
         bout << "";
         break;

    case VAL_SPEAKKEY:

         // bout << pChannel->GetSpeakKey();
         break;

    case VAL_SUPERKEY:

         //bout << pChannel->GetSuperKey();
         bout << "";
         break;

    case VAL_MODKEY:

         //bout << pChannel->GetModerateKey();
         bout << "";
         break;

    case SZ_ACTSIZ:

         bout << ACTSIZ;
         break;

    case DNFEND:

//          if (!thisUserInChannelEdit()) {

               retval=ACTHDONE;

  //        }
          break;

    }

    return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_ActionListToView()
{
     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ((pList = tlcAPI->actGetFirst()) == NULL) {

               noAcListsFound();
               retval = ACTHDONE;

          }
          break;

     case VIEWACTIONLIST:

          bout << pList->GetName();
          break;

     case DNFROWEND:

          if ( (pList=tlcAPI->actGetGT(pList->GetName())) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionListToCreate()
{
     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case SZ_ACTSIZ:

          bout << ACTSIZ;
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_ActionListToEdit()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ((pList = tlcAPI->actGetFirst()) == NULL) {

               noAcListsFound();
               retval = ACTHDONE;

          }
          break;

     case EDITACTIONLIST:

          bout << pList->GetName();
          break;

     case DNFROWEND:

          if ( (pList=tlcAPI->actGetGT(pList->GetName())) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionListToDelete()
{
     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ((pList = tlcAPI->actGetFirst()) == NULL) {


               noAcListsFound();
               retval = ACTHDONE;

          }
          break;

     case DELACTIONLIST:

          bout << pList->GetName();
          break;

     case DNFROWEND:

          if ( (pList=tlcAPI->actGetGT(pList->GetName())) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );


}

ACTHCODE
systlcSynthesis::dnf_ActionListListing()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ((pList = tlcAPI->actGetFirst()) == NULL) {

               noAcListsFound();
               retval = ACTHDONE;

          }
          break;

     case ACTION_LIST:

          bout << pList->GetName();
          break;

     case DNFROWEND:

          if ( (pList=tlcAPI->actGetGT(pList->GetName())) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_SelectActionList()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ((pList = tlcAPI->actGetFirst()) == NULL) {

               noAcListsFound();
               retval = ACTHDONE;

          }
          break;

     case ACTION_LIST:

          bout << pList->GetName();
          break;

     case DNFROWEND:

          if ( (pList=tlcAPI->actGetGT(pList->GetName())) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_ActionListInfoView()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case ACLIST:

          bout << pstructAList->name;
          break;

     case SEEACTIONKEY:

          handleTableEntry (pstructAList->seekey);
          break;

     case USEACTIONKEY:

          handleTableEntry (pstructAList->usekey);
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionListEdit()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case ACLIST:

          bout << pstructAList->name;
          break;

     case SZ_KEYSIZ:

          bout << KEYSIZ;
          break;

     case VAL_SEEACTIONKEY:

          bout << pstructAList->seekey;
          break;

     case VAL_USEACTIONKEY:

          bout << pstructAList->usekey;
          break;

     case DNFEND:

//          if (!thisUserInActionEdit()) {

               retval=ACTHDONE;

  //        }
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionListCreate()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case ACLIST:

          bout << list2CreateBuf;
          break;

     case SZ_KEYSIZ:

          bout << KEYSIZ;
          break;

     case DNFEND:

//          if (!thisUserInActionEdit()) {

               retval=ACTHDONE;

  //        }
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionWordToView()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ( (pszAction = pList->wordGetFirst()) == NULL ) {

               noAcWordsFound();
               retval = ACTHDONE;

          }

          break;

     case ALIST:

          bout << pList->GetName();
          break;

     case VIEW_WORD:

          bout << pszAction;
          break;

     case DNFROWEND:

          if (( pszAction = pList->wordGetGT(pszAction)) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );


}

ACTHCODE
systlcSynthesis::dnf_ActionWordToCreate()
{
     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case ALIST:

          bout << pList->GetName();
          break;

     case SZ_ACTSIZ:

          bout << ACTSIZ;
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_ActionWordToDelete()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ( (pszAction = pList->wordGetFirst()) == NULL ) {

               noAcWordsFound();
               retval = ACTHDONE;

          }

          break;

     case ALIST:

          bout << pList->GetName();
          break;

     case DEL_WORD:

          bout << pszAction;
          break;

     case DNFROWEND:

          if (( pszAction = pList->wordGetGT(pszAction)) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionWordToEdit()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ( (pszAction = pList->wordGetFirst()) == NULL ) {

               noAcWordsFound();
               retval = ACTHDONE;

          }

          break;

     case ALIST:

          bout << pList->GetName();
          break;

     case EDIT_WORD:

          bout << pszAction;
          break;

     case DNFROWEND:

          if (( pszAction = pList->wordGetGT(pszAction)) == NULL ) {

               dnf->tableDone();

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionWordList()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case DNFBEGIN:

          if ( (pszAction = pList->wordGetFirst()) == NULL ) {

               noAcWordsFound();
               retval = ACTHDONE;

          }

          break;

     case ACTION_WORD:

          bout << pszAction;
          break;

     case DNFROWEND:

          if ((pszAction=pList->wordGetGT(pszAction)) == NULL ) {

               dnf->tableDone();
               break;

          }
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionWordView()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case ACTWORD:

          bout << pstructAction->name;
          break;

     case SIMPACTION1:

          handleTableEntry ( parsePiece(pstructAction->simple,1));
          break;

     case SIMPACTION2:

          handleTableEntry ( parsePiece(pstructAction->simple,2));
          break;

     case SIMPACTION3:

          handleTableEntry (parsePiece(pstructAction->simple,3));
          break;

     case SIMPACTION4:

          handleTableEntry (parsePiece(pstructAction->simple,4));
          break;

     case COMPACTION1:

          handleTableEntry (parsePiece(pstructAction->complx,1));
          break;

     case COMPACTION2:

          handleTableEntry (parsePiece(pstructAction->complx,2));
          break;

     case COMPACTION3:

          handleTableEntry (parsePiece(pstructAction->complx,3));
          break;

     case COMPACTION4:

          handleTableEntry (parsePiece(pstructAction->complx,4));
          break;

     case RESPACTION1:

          handleTableEntry (parsePiece(pstructAction->resp,1));
          break;

     case RESPACTION2:

          handleTableEntry (parsePiece(pstructAction->resp,2));
          break;

     case RESPACTION3:

          handleTableEntry (parsePiece(pstructAction->resp,3));
          break;

     case RESPACTION4:

          handleTableEntry (parsePiece(pstructAction->resp,4));
          break;

     case KEYREQUIRED:

          handleTableEntry (pstructAction->actkey);
          break;

     case DNFEND:

          retval=ACTHDONE;
          break;

     }

     return ( retval );

}

ACTHCODE
systlcSynthesis::dnf_ActionWordEdit()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case SZ_KEYSIZ:

          bout << KEYSIZ;
          break;

     case ALIST:

          bout << pList->GetName();
          break;

     case ACTWORD:

          bout << pstructAction->name;
          break;

     case VAL_SIMPACTION1:

          bout << parsePiece(pstructAction->simple,1);
          break;

     case VAL_SIMPACTION2:

          bout << parsePiece(pstructAction->simple,2);
          break;

     case VAL_SIMPACTION3:

          bout << parsePiece(pstructAction->simple,3);
          break;

     case VAL_SIMPACTION4:

          bout << parsePiece(pstructAction->simple,4);
          break;

     case VAL_COMPACTION1:

          bout << parsePiece(pstructAction->complx,1);
          break;

     case VAL_COMPACTION2:

          bout << parsePiece(pstructAction->complx,2);
          break;

     case VAL_COMPACTION3:

          bout << parsePiece(pstructAction->complx,3);
          break;

     case VAL_COMPACTION4:

          bout << parsePiece(pstructAction->complx,4);
          break;

     case VAL_RESPACTION1:

          bout << parsePiece(pstructAction->resp,1);
          break;

     case VAL_RESPACTION2:

          bout << parsePiece(pstructAction->resp,2);
          break;

     case VAL_RESPACTION3:

          bout << parsePiece(pstructAction->resp,3);
          break;

     case VAL_RESPACTION4:

          bout << parsePiece(pstructAction->resp,4);
          break;

     case VAL_KEYREQUIRED:

          bout << pstructAction->actkey;
          break;

     case DNFEND:

//          if (!thisUserInActionEdit()) {

               retval=ACTHDONE;

  //        }
          break;

     }

     return ( retval );

}

CHAR *
systlcSynthesis::parsePiece(
CHAR *piece,
SHORT i)
{
     static CHAR buf[RESSIZ];

     setmem ( buf, RESSIZ , '\0');

     stlcpy ( buf, piece, RESSIZ );

     switch ( i ) {

     case 1:

          return ( getString ( buf, 1 ));

     case 2:

          return ( getString ( buf, 2 ));

     case 3:

          return ( getString ( buf, 3 ));

     case 4:

          return ( getString ( buf, 4 ));

     }

     return ( NULL );

}

CHAR *
systlcSynthesis::getString(
CHAR *buf,
SHORT count)
{
     SHORT cnt = 1;
     CHAR *ptr, *lastptr;

     lastptr = ptr = buf;

     count = count;

     while ((ptr=strchr(ptr,'\1')) != '\0') {

           if ( cnt == count ) {

                *ptr = '\0';

                return ( lastptr );

            }

            cnt++;
            ptr++;
            lastptr = ptr;
      }

      return ( lastptr );
}

ACTHCODE
systlcSynthesis::dnf_ActionWordCreate()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case SZ_KEYSIZ:

          bout << KEYSIZ;
          break;

     case ALIST:

          bout << pList->GetName();
          break;

     case ACTWORD:

          bout << word2CreateBuf;
          break;

     case DNFEND:

//          if (!thisUserInActionEdit()) {

               retval=ACTHDONE;

  //        }
          break;

     }

     return ( retval );

}



ACTHCODE
systlcSynthesis::dnf_ActionWordMenu()
{

     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case ALIST:

          bout << pList->GetName();
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_UserToEdit()
{
     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case SZ_UIDSIZ:

          bout << UIDSIZ;
          break;

     case DNFEND:

          retval = ACTHDONE;
          break;

     }

     return ( retval );
}

ACTHCODE
systlcSynthesis::dnf_UserEdit()
{
     const CHAR* pReqmsg;
     ACTHCODE retval = ACTHMORE;

     switch ( dnf->process() ) {

     case USER:

          if ( pUser != NULL ) {

               bout << pUser->GetName();

          }
          else if (pOffUser != NULL ) {

               bout << pOffUser->getName();

          }
          break;

     case SZ_EMSGSIZ:

          bout << EMSGSIZ;
          break;

     case VAL_ENTMESSAGE:

          if ( pUser != NULL ) {

               bout << pUser->GetEntrance(MSG_CURRENT);

          }
          else if ( pOffUser != NULL ) {

               bout << pOffUser->getEntrance(MSG_CURRENT);

          }
          break;

     case VAL_EXTMESSAGE:

          if ( pUser != NULL ) {

               bout << pUser->GetExit(MSG_CURRENT);

          }
          else {

               bout << pOffUser->getExit(MSG_CURRENT);

          }
          break;

     case REQENTMESSAGE:

          if ( pUser != NULL ) {

               pReqmsg = pUser->GetEntrance(MSG_REQUESTED);
               strlen (pReqmsg) == 0 ?  bout << "(none)" : bout << pReqmsg;

          }
          else if ( pOffUser != NULL ) {

               pReqmsg = pOffUser->getEntrance(MSG_REQUESTED);
               strlen (pReqmsg) == 0 ?  bout << "(none)" : bout << pReqmsg;

          }
          break;

     case REQEXTMESSAGE:

          if ( pUser != NULL ) {

               pReqmsg = pUser->GetExit(MSG_REQUESTED);
               strlen (pReqmsg ) == 0 ?  bout << "(none)" : bout << pReqmsg;

          }
          else if ( pOffUser != NULL ) {

               pReqmsg = pOffUser->getExit(MSG_REQUESTED);
               strlen (pReqmsg) == 0 ?  bout << "(none)" : bout << pReqmsg;

          }
          break;

     case SQUELCH_OP_1:


          if ( pUser != NULL ) {

               ((pUser->m_fFlags&USR_SQUELCH) == TRUE) ?
               bout << "YES" : bout << "NO";

          }
          else if ( pOffUser != NULL ) {

               (pOffUser->isSquelched() == TRUE) ?
               bout << "YES" : bout << "NO";

          }
          break;

     case SQUELCH_OP_2:

          if ( pUser != NULL ) {

               ((pUser->m_fFlags&USR_SQUELCH) == TRUE) ?
               bout << "NO" : bout << "YES";

          }
          else if ( pOffUser != NULL ) {

               (pOffUser->isSquelched() == TRUE) ?
               bout << "NO" : bout << "YES";

          }
          break;

     case CREDAMOUNT:

          if ( pUser != NULL ) {

               bout << pUser->GetCredits();

          }
          else if ( pOffUser != NULL ) {

               bout << pOffUser->getCredits();

          }
          break;

     case DNFEND:

//          if (!thisUserInMenuEdit()) {

               retval = ACTHDONE;


  //        }
          break;

     }

     return ( retval );

}


VOID
systlcSynthesis::getChannelParameters()
{

     CHAR selbuf[5];

     ses->param ("NAM_TOPIC",schaninf.m_strTopic,CHAN_MAX_TOPIC_SIZE);
     ses->param ("NAM_VISKEY",schaninf.m_keyVis,KEYSIZ);
     ses->param ("NAM_JOINKEY",schaninf.m_keyJoin,KEYSIZ);
     ses->param ("NAM_SPEAKKEY",schaninf.m_keySpeak,KEYSIZ);
     ses->param ("NAM_SUPERKEY",schaninf.m_keyByPass, KEYSIZ);
     ses->param ("NAM_MODKEY",schaninf.m_keyMod,KEYSIZ);
     ses->param ("NAM_PRIMEACTION",schaninf.m_actList1,LISTSIZ);
     ses->param ("NAM_SECONDACTION",schaninf.m_actList2,LISTSIZ);

     ses->param ("SEL_PROFANITY" , selbuf, 5);

     sameas (selbuf,"YES") ? schaninf.m_flags|=CHAN_FLAG_PROFOK :
                              schaninf.m_flags&=~CHAN_FLAG_PROFOK;

     ses->param ("SEL_ENTEXIT" ,selbuf, 5);

     sameas (selbuf,"YES") ? schaninf.m_flags&=~CHAN_FLAG_NOENTMESSAGE :
                              schaninf.m_flags|=CHAN_FLAG_NOENTMESSAGE;


     ses->param ("SEL_CHANCLOSED" ,selbuf, 5);

     sameas (selbuf,"YES") ? schaninf.m_flags|=CHAN_FLAG_CLOSED :
                              schaninf.m_flags&=~CHAN_FLAG_CLOSED;


}


VOID
systlcSynthesis::getActionParameters()
{

     const CHAR *simpArray[] = {"NAM_SIMPACTION1","NAM_SIMPACTION2","NAM_SIMPACTION3",
                         "NAM_SIMPACTION4"};

     const CHAR *compArray[] = {"NAM_COMPACTION1","NAM_COMPACTION2","NAM_COMPACTION3",
                          "NAM_COMPACTION4"};

     const CHAR *respArray[] = {"NAM_RESPACTION1","NAM_RESPACTION2","NAM_RESPACTION3",
                          "NAM_RESPACTION4"};


     CHAR wrkbuf[RESSIZ];
     CHAR tempbuf[81];

     wrkbuf[0] = '\0';

     for ( INT i = 0 ; i < 4 ; i++ ) {

          ses->param (simpArray[i], tempbuf , 81 );

          if ( tempbuf != NULL ) {

               stzcat( wrkbuf,tempbuf,RESSIZ );

          }

          if ( i < 3 ) {

               stzcat(wrkbuf,"\1",RESSIZ);

          }

     }

     stzcpy ( pstructAction->simple , wrkbuf , RESSIZ );

     wrkbuf[0] = '\0';

     for ( INT i = 0 ; i < 4 ; i++ ) {


          ses->param (compArray[i] , tempbuf , 81 );

          if ( tempbuf != NULL ) {

               stzcat( wrkbuf,tempbuf,RESSIZ );

          }

          if ( i < 3 ) {

               stzcat(wrkbuf,"\1",RESSIZ);

          }

     }

     stzcpy ( pstructAction->complx , wrkbuf , RESSIZ );

     wrkbuf[0] = '\0';

     for ( INT i = 0 ; i < 4 ; i++ ) {

          ses->param (respArray[i], tempbuf , 81);

          if ( tempbuf != NULL ) {

               stzcat(wrkbuf, tempbuf, RESSIZ );

          }

          if ( i < 3 ) {

               stzcat(wrkbuf,"\1",RESSIZ);

          }

     }

     stzcpy ( pstructAction->resp , wrkbuf , RESSIZ );

     ses->param ("NAM_KEYREQUIRED", wrkbuf, RESSIZ );

     stzcpy ( pstructAction->actkey , wrkbuf , KEYSIZ );

}

GBOOL
systlcSynthesis::checkAccess(
INT iVal)
{

     if ( isysflags&iVal ) {

          return ( TRUE );

     }

     return ( FALSE );

}

/*VOID
systlcSynthesis::setChannelEdit(  //  -1 means not in
INT isetVal)
{

     cedctrl.user = isetVal;

     if ( isetVal == -1 ) {

          gblChannelEditUserIDBuf[0] = '\0';

     }
     else {

          stzcpy ( gblChannelEditUserIDBuf, usr->userid() , UIDSIZ );

     }

}


VOID
systlcSynthesis::setActionEdit(
INT isetVal)
{


     aedctrl.user = isetVal;

     if ( isetVal == -1 ) {

          gblActionEditUserIDBuf[0] = '\0';

     }
     else {

          stzcpy ( gblActionEditUserIDBuf, usr->userid() , UIDSIZ );

     }

}

VOID
systlcSynthesis::setMenuEdit(
INT isetVal)
{

     tlcsysedt.m_usrnum = isetVal;

     if ( isetVal == -1 ) {

          gblMenuEditUserIDBuf[0] = '\0';

     }
     else {

          stzcpy (gblMenuEditUserIDBuf, usr->userid() , UIDSIZ );

     }

}*/


GBOOL
systlcSynthesis::anyInActionEdit()
{

     return ( aedctrl.user != -1 );

}

GBOOL
systlcSynthesis::anyInChannelEdit()
{
     return ( cedctrl.user != -1 );

}

GBOOL
systlcSynthesis::anyInMenuEdit()
{

     return ( tlcsysedt.m_usrnum != -1 );

}

/*GBOOL
systlcSynthesis::thisUserInActionEdit()
{

     return ( aedctrl.user == -2 &&
     sameas (gblActionEditUserIDBuf, usr->userid()) );

}

GBOOL
systlcSynthesis::thisUserInChannelEdit()
{
     return ( cedctrl.user == -2 &&
     sameas (gblChannelEditUserIDBuf, usr->userid()) );

}

GBOOL
systlcSynthesis::thisUserInMenuEdit()
{

     return ( tlcsysedt.m_usrnum == -2 &&
     sameas (gblMenuEditUserIDBuf, usr->userid()) );

} */

VOID
systlcSynthesis::handleSysEdt(
CTlcUser *pUser)
{
     const CHAR *preqMsg;
     CHAR parambuf[EMSGSIZ];

     ses->param ("NAM_ENTMESSAGE" , parambuf, EMSGSIZ );

     pUser->SetEntrance ( parambuf , MSG_CURRENT );

     ses->param ( "NAM_EXTMESSAGE" , parambuf, EMSGSIZ );

     pUser->SetExit ( parambuf, MSG_CURRENT );

     ses->param ( "SEL_REQENTMESSAGE", parambuf, EMSGSIZ );

     if ((preqMsg = pUser->GetEntrance(MSG_REQUESTED)) != NULL &&
          parambuf[0] == 'Y') {
          pUser->SetChangedMsg(FALSE);
          pUser->SetEntrance ( preqMsg, MSG_REQUESTED );

     }

     ses->param ( "SEL_REQEXTMESSAGE", parambuf, EMSGSIZ);

     if ((preqMsg = pUser->GetExit(MSG_REQUESTED)) != NULL &&
          parambuf[0] == 'Y') {
          pUser->SetChangedMsg(FALSE);
          pUser->SetExit ( preqMsg, MSG_REQUESTED );

     }

     ses->param ("SEL_SQUELCHED", parambuf, EMSGSIZ );

     if ( parambuf[0] == 'Y' ) {

          pUser->m_fFlags |= USR_SQUELCH;

     }
     else {

          pUser->m_fFlags &=~ USR_SQUELCH;

     }

}

VOID
systlcSynthesis::handleSysEdt(
CTlcSysEdt *pOffUser)
{
     const CHAR *preqMsg;
     CHAR parambuf[EMSGSIZ];

     ses->param ("NAM_ENTMESSAGE" , parambuf, EMSGSIZ );

     pOffUser->setEntrance ( parambuf , MSG_CURRENT );

     ses->param ( "NAM_EXTMESSAGE" , parambuf, EMSGSIZ );

     pOffUser->setExit ( parambuf, MSG_CURRENT );

     ses->param ( "SEL_REQENTMESSAGE", parambuf, EMSGSIZ );

     if ((preqMsg = pOffUser->getEntrance(MSG_REQUESTED)) != NULL &&
          parambuf[0] == 'Y') {
          if (onsysn(pOffUser->getName(),1)) {
               msgchanged[othusn]=FALSE;
          }
          pOffUser->setEntrance ( preqMsg, MSG_REQUESTED );

     }

     ses->param ( "SEL_REQEXTMESSAGE", parambuf, EMSGSIZ);

     if ((preqMsg = pOffUser->getExit(MSG_REQUESTED)) != NULL &&
          parambuf[0] == 'Y') {
          if (onsysn(pOffUser->getName(),1)) {
               msgchanged[othusn]=FALSE;
          }
          pOffUser->setExit ( preqMsg, MSG_REQUESTED );

     }

     ses->param ("SEL_SQUELCHED", parambuf, EMSGSIZ );

     if ( parambuf[0] == 'Y' ) {

          pOffUser->setSquelched ( TRUE );

     }
     else {

          pOffUser->setSquelched ( FALSE );

     }
}

VOID
systlcSynthesis::noAcListsFound()
{


     bout << "No action lists found.";


}

VOID
systlcSynthesis::noAcWordsFound()
{


     bout << "No action words found.";


}

VOID
systlcSynthesis::handleTableEntry(
const CHAR *entry)
{

     if ( strlen ( entry ) == 0 ) {

          bout << "*";

     }
     else {

          bout << entry;

     }

}



