/////////////////////////////////////////////////////////////////////////////
//
//   TLCSYEDT.CPP
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Teleconference Sysop Menu Edit Interface
//
//                                               - N.C. Osterc
//
/////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.hpp"

#define FILREV "$Revision: 2 $"

MARKSOURCE(tlcsysedt);

CTlcSysEdt::CTlcSysEdt(
const CHAR *usr)
{
     stlcpy(m_usr,usr,UIDSIZ);
     reload();
}

CTlcSysEdt::~CTlcSysEdt()
{
}

GBOOL
CTlcSysEdt::foundUser()
{
     return(m_bFound);
}

GBOOL
CTlcSysEdt::reload()
{
     dfaSetBlk(dfaTlcUser);
     m_bFound=dfaAcqEQ(&m_structuedit,m_usr,0);
     dfaRstBlk();
     return(m_bFound);
}

GBOOL
CTlcSysEdt::update()
{
     dfaSetBlk(dfaTlcUser);
     if (dfaAcqEQ(NULL,m_structuedit.m_pszUserid,0)) {
          dfaUpdate(&m_structuedit);
          dfaRstBlk();
          return(TRUE);
     }
     dfaRstBlk();
     return(FALSE);
}

const CHAR *
CTlcSysEdt::getName()
{
     return(m_structuedit.m_pszUserid);
}

VOID
CTlcSysEdt::setEntrance(
const CHAR *msg,
INT which)
{
     ASSERT(msg != NULL);

     if (which == MSG_CURRENT) {
          stzcpy(m_structuedit.m_pszEntCur,msg,EMSGSIZ);
     }
     else {
          stzcpy(m_structuedit.m_pszEntReq,msg,EMSGSIZ);
     }
}

const CHAR *
CTlcSysEdt::getEntrance(
INT which)
{
   if (which == MSG_CURRENT) {
        return(m_structuedit.m_pszEntCur);
   }
   else {
        return(m_structuedit.m_pszEntReq);
   }
}

VOID
CTlcSysEdt::setExit(
const CHAR *msg,
INT which)
{
     ASSERT ( msg != NULL );

     if (which == MSG_CURRENT) {
          stzcpy(m_structuedit.m_pszExitCur, msg, EMSGSIZ);
     }
     else {
          stzcpy(m_structuedit.m_pszExitReq,msg,EMSGSIZ);
     }
}

const CHAR *
CTlcSysEdt::getExit(
INT which)
{
     if (which == MSG_CURRENT) {
          return(m_structuedit.m_pszExitCur);
    }
     else {
          return(m_structuedit.m_pszExitReq);
    }
}

VOID
CTlcSysEdt::setDefaultChan(
SHORT defchan)
{
     m_structuedit.m_iChanDft=defchan;
}

SHORT
CTlcSysEdt::getDefaultChan()
{
     return(m_structuedit.m_iChanDft);
}

VOID
CTlcSysEdt::setInterval(
SHORT sInterval)
{
     m_structuedit.m_iChatInterval=sInterval;
}

SHORT
CTlcSysEdt::getInterval()
{
     return(m_structuedit.m_iChatInterval);
}

GBOOL
CTlcSysEdt::isSquelched()
{
     return(m_structuedit.m_bSquelched);
}

VOID
CTlcSysEdt::setSquelched(
GBOOL squelch)
{
     m_structuedit.m_bSquelched=squelch;
}

LONG
CTlcSysEdt::getCredits()
{
     dfaSetBlk(accbb);
     if (dfaAcqEQ(NULL,m_structuedit.m_pszUserid,0)) {
          dfaRstBlk();
          return(((struct usracc*)(accbb->data))->creds);
     }
     dfaRstBlk();
     return(0L);
}


