/***************************************************************************
 *                                                                         *
 *   TLCFSD.H                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1995 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Prototypes and definitions for Teleconference FSD routines.           *
 *                                                                         *
 *                                            - J. Moriarty  11/93         *
 *                                                                         *
 ***************************************************************************/

#ifndef __TLCFSD_H
#define __TLCFSD_H

#include "tlcchan.h"
#include "tlcact.h"
                                   // can user use ANSI FSD?
#define FULLSCREEN() ((usaptr->ansifl&ANSON) \
                   && usaptr->scnfse >= 23   \
                   && usaptr->scnwid >= 80)

#define CEDNAME 0                  // Channel editor defines
#define CEDTOPI 1
#define CEDVISK 2
#define CEDJOIK 3
#define CEDSPKK 4
#define CEDSUPK 5
#define CEDMODK 6
#define CEDACT1 7
#define CEDACT2 8
#define CEDCPRO 9
#define CEDCENT 10
#define CEDCOPE 11

#define LEDNAME 0                  // List editor defines
#define LEDSEEK 1
#define LEDUSEK 2

#define AEDNAME  0                 // Action editor defines
#define AEDSIMP1 1
#define AEDSIMP2 2
#define AEDSIMP3 3
#define AEDSIMP4 4
#define AEDCOMP1 5
#define AEDCOMP2 6
#define AEDCOMP3 7
#define AEDCOMP4 8
#define AEDRESP1 9
#define AEDRESP2 10
#define AEDRESP3 11
#define AEDRESP4 12
#define AEDKEY   13

typedef struct cedctrl {
     INT user;                     // User in channel editor
     bool sysop;                   // Is user a tele Sysop? (or moderator)
     CHAR channel[CHAN_MAX_SIZE];  // Channel being edited
} CEDCTRL, *LPCEDCTRL;             // Channel editor control block

extern CEDCTRL  cedctrl;           // Channel editor control block
extern CHANINFO cedtemp;           // Temp channel for FSD

typedef struct aedctrl {
     INT user;                     // User in action editor
} AEDCTRL, *LPAEDCTRL;             // Handles action editor


extern AEDCTRL aedctrl;            // Action editor control block
extern ACTLST ledtemp;             // List editor temp block
extern ACTION aedtemp;             // Word editor temp block

extern CHAR cedfsp[];
extern CHAR cedfmt[];

extern CHAR ledfsp[];
extern CHAR ledfmt[];

VOID initfsd(VOID);
CHAR *tfsdpft(VOID);

VOID
cedEnter(                          // enter channel editor
bool isCreate);                    //   are we creating?

VOID
cedprp(                            // Prepare channel editor
INT msgno,                         //   FSD template text block number
INT mode);                         //   FSD mode

VOID
cedptc(                            // Protect channel fields
bool isSysop);                     //   is user a tele Sysop (or moderator)

VOID
ceddun(                            // Done editing channel
GBOOL save);                       //   did user save info? (or abort)

VOID
cedcdun(                           // Done creating channel
GBOOL save);                       //   did user save info? (or abort)

INT
cedvfy(                            // Verify channel info
INT fldno,                         //   field ID to verify
CHAR *answer);                     //   proposed answer

VOID
ledEnter(                          // enter action list editor
bool isCreate);                    //   are we creating?

VOID leddun(GBOOL save);
VOID ledcdun(GBOOL save);
VOID ledprp(INT msgno,INT mode);
VOID ledptc(VOID);
INT ledvfy(INT fldno,CHAR *answer);

VOID
aedEnter(                          // enter action word editor
bool isCreate);                    //   are we creating?

VOID aeddun(GBOOL save);
VOID aedcdun(GBOOL save);
VOID aedprp(INT msgno,INT mode);
VOID aedptc(VOID);
INT aedvfy(INT fldno,CHAR *answer);

#endif // __TLCFSD_H
