
#ifndef __TLCDYNTR_HPP
#define __TLCDYNTR_HPP

#include "tlcdyntr.h"

class CDynamicTransport : public CTlcTransport
{
public:
     CDynamicTransport();
     CDynamicTransport(LPTFUNCPTRS ptrs);
     virtual ~CDynamicTransport();

     VOID  AddUser(CTlcUser* pUser);
     VOID  RemoveUser(CTlcUser* pUser);
     VOID  Output(CTlcUser* pUser);
     VOID  SendTabbedDbData(const CHAR* data, CTlcChannel* pChannel);
     VOID  SendAll(const CHAR* pszUseridFrom,const CHAR* pszUseridTo,
                    const CHAR* pMsg, SHORT fType, CTlcChannel* pChannel,
                    SHORT iMsgNum=0, const CHAR* ptr1=NULL,
                    const CHAR* ptr2=NULL,const CHAR* ptr3=NULL);
     VOID  SendAllBut(const CHAR* pszUseridFrom,const CHAR* pszUseridTo,
                    const CHAR* pMsg, SHORT fType, CTlcChannel* pChannel,
                    SHORT iMsgNum=0, const CHAR* ptr1=NULL,
                    const CHAR* ptr2=NULL, const CHAR* ptr3=NULL,
                    const CHAR* pszUseridNot1=NULL,
                    const CHAR* pszUseridNot2=NULL);
     VOID  CmdResult(CTlcUser* pUser,SHORT iOperation, GBOOL bSuccess,
                    SHORT iReason);


     VOID SetFuncPtrs(LPTFUNCPTRS ptrs);

protected:

     VOID
     RecvText(                     // Send text to one user by ID
     CTlcUser* pUserFrom,          //   user object sending text (NULL = system)
     CTlcUser* pUserTo,            //   user object receiving text
     const CHAR* pMsg,             //   Text to send
     SHORT fType,                  //   Type of text
     SHORT iMsgNum=0,              //   Type of event
     const CHAR* ptr1=NULL,        //   extra information
     const CHAR* ptr2=NULL,        //   extra information
     const CHAR* ptr3=NULL);       //   extra information

private:
     LPTFUNCPTRS pFuncs;
};

#endif // __TLCDYNTR_H
