
#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.hpp"
#include "tlcdyntr.hpp"

#define FILREV "$Revision: 9 $"
MARKSOURCE(tlcdyntr)

/***************************************************************************
 * dynamic transport class - for "C" interface                             *
 ***************************************************************************/

CDynamicTransport::CDynamicTransport() : CTlcTransport(), pFuncs(NULL)
{
}

CDynamicTransport::CDynamicTransport(LPTFUNCPTRS ptrs) : CTlcTransport(),
                                                         pFuncs(ptrs)
{
     if (CHECKFC(construct)) {
          pFuncs->construct();
     }
}

VOID
CDynamicTransport::SendTabbedDbData(
const CHAR* data,
CTlcChannel* pChannel)
{
     if (CHECKFC(sendtabbeddb)) {
          pFuncs->sendtabbeddb(data,pChannel->GetName());
     }
}

CDynamicTransport::~CDynamicTransport()
{
     if (CHECKFC(destruct)) {
          pFuncs->destruct();
     }
}

VOID
CDynamicTransport::SetFuncPtrs(LPTFUNCPTRS ptrs)
{
     if (CHECKFC(destruct)) {
          pFuncs->destruct();
     }
     pFuncs=ptrs;
     if (CHECKFC(construct)) {
          pFuncs->construct();
     }
}

VOID
CDynamicTransport::AddUser(CTlcUser* pUser)
{
     CTlcTransport::AddUser(pUser);
     if (CHECKFC(adduserfunc)) {
          LPUSRSTRUCT st=pUser->GetUserStruct();
          pFuncs->adduserfunc(st);
     }
}

VOID
CDynamicTransport::RemoveUser(CTlcUser* pUser)
{
     CTlcTransport::RemoveUser(pUser);
     if (CHECKFC(removeuserfunc)) {
          LPUSRSTRUCT st=pUser->GetUserStruct();
          pFuncs->removeuserfunc(st);
     }
}

VOID
CDynamicTransport::Output(CTlcUser* pUser)
{
     if (CHECKFC(outputfunc) && pUser != NULL) {
          LPUSRSTRUCT st=pUser->GetUserStruct();
          pFuncs->outputfunc(st);
     }
}

VOID
CDynamicTransport::RecvText(
CTlcUser* pUserFrom,
CTlcUser* pUserTo,
const CHAR* pMsg,
SHORT fType,
SHORT iMsgNum,
const CHAR* ptr1,
const CHAR* ptr2,
const CHAR* ptr3)
{
     if (CHECKFC(recvtextfunc)) {
          pFuncs->recvtextfunc(pUserFrom == NULL ? "" : pUserFrom->GetName()
                              ,pUserTo->GetName(),pMsg,fType,iMsgNum
                              ,ptr1,ptr2,ptr3);
     }
}

VOID
CDynamicTransport::SendAll(
const CHAR* pszUseridFrom,
const CHAR* pszUseridTo,
const CHAR* pMsg,
SHORT fType,
CTlcChannel* pChannel,
SHORT iMsgNum,
const CHAR* ptr1,
const CHAR* ptr2,
const CHAR* ptr3)
{
     if (CHECKFC(sendallfunc)) {
          pFuncs->sendallfunc(pszUseridFrom,pszUseridTo,pMsg,fType,
                              (pChannel == NULL ? NULL : pChannel->GetName()),
                              iMsgNum,ptr1,ptr2,ptr3);
     }
}

VOID
CDynamicTransport::SendAllBut(
const CHAR* pszUseridFrom,
const CHAR* pszUseridTo,
const CHAR* pMsg,
SHORT fType,
CTlcChannel* pChannel,
SHORT iMsgNum,
const CHAR* ptr1,
const CHAR* ptr2,
const CHAR* ptr3,
const CHAR* pszUseridNot1,
const CHAR* pszUseridNot2)
{
     if (CHECKFC(sendallbutfunc)) {
          pFuncs->sendallbutfunc(pszUseridFrom,pszUseridTo,pMsg,fType,
                                 (pChannel == NULL ? NULL : pChannel->GetName()),
                                 iMsgNum,ptr1,ptr2,ptr3,
                                 pszUseridNot1,pszUseridNot2);
     }
}

VOID
CDynamicTransport::CmdResult(
CTlcUser* pUser,
SHORT iOperation,
GBOOL bSuccess,
SHORT iReason)
{
     if (CHECKFC(cmdresultfunc) && pUser != NULL) {
          LPUSRSTRUCT st=pUser->GetUserStruct();
          if (!pFuncs->cmdresultfunc(st,iOperation,bSuccess,iReason)) {
               return;
          }
     }
     CTlcTransport::CmdResult(pUser,iOperation,bSuccess,iReason);
}
