////////////////////////////////////////////////////////////////////////////
//
//   TLCDCMD.HPP
//
//   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved
//
//   Default Command Handlers
//   Declaration
//                                               - Phil Henning 6/4/97
//
/////////////////////////////////////////////////////////////////////////////

#include "tlcdcmd.h"

#ifndef __TLCDCMD_HPP
#define __TLCDCMD_HPP

// Command definitions

class CcmdJoin : public CTlcCommand
{
public:
    CcmdJoin(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdJoin() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdMain : public CTlcCommand
{
public:
    CcmdMain(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdMain() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdScan : public CTlcCommand
{
public:
    CcmdScan(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdScan() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdList : public CTlcCommand
{
public:
    CcmdList(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdList() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdWhisper : public CTlcCommand
{
public:
    CcmdWhisper(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,NO_DELIM) { }
    ~CcmdWhisper() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdDirect : public CTlcCommand
{
public:
    CcmdDirect(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,NO_DELIM) { }
    ~CcmdDirect() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdHelp : public CTlcCommand
{
public:
    CcmdHelp(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdHelp() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdUnlist : public CTlcCommand
{
public:
    CcmdUnlist(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdUnlist() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdEdit : public CTlcCommand
{
public:
    CcmdEdit(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdEdit() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdTopic : public CTlcCommand
{
public:
    CcmdTopic(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdTopic() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdInvite : public CTlcCommand
{
public:
    CcmdInvite(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdInvite() { }
    SHORT DoCmd(CCommandParam* pParam);
};


class  CcmdUnInvite : public CTlcCommand
{
public:
    CcmdUnInvite(const CHAR* pszLong, const CHAR* pszShort)
                : CTlcCommand(pszLong,pszShort) { }
    ~CcmdUnInvite() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdForget : public CTlcCommand
{
public:
    CcmdForget(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdForget() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdRemember : public CTlcCommand
{
public:
    CcmdRemember(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdRemember() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdSquelch : public CTlcCommand
{
public:
    CcmdSquelch(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdSquelch() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdUnSquelch : public CTlcCommand
{
public:
    CcmdUnSquelch(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdUnSquelch() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdChat : public CTlcCommand
{
public:
    CcmdChat(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdChat() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdChannel : public CTlcCommand
{
public:
    CcmdChannel(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdChannel() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdAction : public CTlcCommand
{
public:
    CcmdAction(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdAction() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdMenu : public CTlcCommand
{
public:
    CcmdMenu(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdMenu() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class  CcmdPost : public CTlcCommand
{
public:
    CcmdPost(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM) { }
    ~CcmdPost() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdDiag : public CTlcCommand
{
public:
    CcmdDiag(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdDiag() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdClose : public CTlcCommand
{
public:
    CcmdClose(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM) { }
    ~CcmdClose() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdOpen : public CTlcCommand
{
public:
    CcmdOpen(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM) { }
    ~CcmdOpen() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdEcho : public CTlcCommand
{
public:
    CcmdEcho(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdEcho() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdUsers : public CTlcCommand
{
public:
    CcmdUsers(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort,SPACE_DELIM,TRUE) { }
    ~CcmdUsers() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdZappo : public CTlcCommand
{
public:
    CcmdZappo(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdZappo() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdNotice : public CTlcCommand
{
public:
    CcmdNotice(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdNotice() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdIgnore : public CTlcCommand
{
public:
    CcmdIgnore(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdIgnore() { }
    SHORT DoCmd(CCommandParam* pParam);
};

class CcmdPage : public CTlcCommand
{
public:
    CcmdPage(const CHAR* pszLong, const CHAR* pszShort)
            : CTlcCommand(pszLong,pszShort) { }
    ~CcmdPage() { }
    SHORT DoCmd(CCommandParam* pParam);
};


extern CcmdDiag* cmdDiag;

extern CcmdJoin* cmdJoin;
extern CcmdList* cmdList;
extern CcmdScan* cmdScan;
extern CcmdHelp* cmdHelp;
extern CcmdUnlist* cmdUnlist;

extern CcmdDirect* cmdDirect;
extern CcmdWhisper* cmdWhisper;
extern CcmdEdit* cmdEdit;
extern CcmdTopic* cmdTopic;
extern CcmdInvite* cmdInvite;
extern CcmdUnInvite* cmdUnInvite;
extern CcmdForget* cmdForget;
extern CcmdRemember* cmdRemember;
extern CcmdSquelch* cmdSquelch;
extern CcmdUnSquelch* cmdUnSquelch;
extern CcmdChat* cmdChat;
extern CcmdChannel* cmdChannel;
extern CcmdAction* cmdAction;
extern CcmdMenu* cmdMenu;
extern CcmdPost* cmdPost;
extern CcmdClose* cmdClose;
extern CcmdOpen* cmdOpen;
extern CcmdEcho* cmdEcho;
extern CcmdZappo* cmdZappo;
extern CcmdIgnore* cmdIgnore;
extern CcmdNotice* cmdNotice;
extern CcmdPage* cmdPage;
extern CcmdUsers* cmdUsers;
extern CcmdMain* cmdMain;


#endif // __TLCDCMD_H