/////////////////////////////////////////////////////////////////////////////
//
//   TLCCMDL.CPP
//
//   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved
//
//   Teleconference Command List
//   Implementation
//                                               - Phil Henning 5/14/97
//
/////////////////////////////////////////////////////////////////////////////


#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.hpp"

#define FILREV "$Revision: 4 $"

MARKSOURCE(tlccmdl);

CTlcCmdList::CTlcCmdList()
{
     m_cmdMap    = new CObjMap;
}

CTlcCmdList::~CTlcCmdList()
{
     delete  m_cmdMap;
}

GBOOL
CTlcCmdList::Register(
CTlcCommand* pCmd)
{
     ASSERT(m_cmdMap != NULL);
     if (m_cmdMap->AddTail(pCmd->m_pszCmd,pCmd) >= MAP_OK) {
          return TRUE;
     }
     return FALSE;
}

CTlcCommand*
CTlcCmdList::GetFirst()
{
     ASSERT(m_cmdMap != NULL);
     return(static_cast<CTlcCommand*>(m_cmdMap->GetHead()));
}

CTlcCommand*
CTlcCmdList::GetNext()
{
     ASSERT(m_cmdMap != NULL);
     return(static_cast<CTlcCommand*>(m_cmdMap->GetNext()));
}


