/////////////////////////////////////////////////////////////////////////////
//
//   TLCAHUSR.H
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Teleconference Active HTML User
//   Declaration
//                                               - Phil Henning 6/20/97
//
/////////////////////////////////////////////////////////////////////////////


#ifndef __TLCAHUSR_H
#define __TLCAHUSR_H

#define USR_TYPE_AHTML  3
#define USR_TYPE_AHLITE 4

typedef deque<const CHAR*> MSGQUE, *LPMSGQUE;

class CTlcAHUser : public CTlcUser {
friend class CTlcAPI;
public:
    CTlcAHUser();
    virtual ~CTlcAHUser();

public:
    VOID AddMsg(const CHAR* pszMsg);
    VOID AddLiteMsg(const CHAR* pszMsg);
    const CHAR* GetMsg();
    VOID PopMsg();
    VOID AddDbData(const CHAR* pszMsg);
    const CHAR* GetDbData();
    VOID PopDbData();
    VOID ClearDb();
    inline VOID SetTime(LONG lTime);
    inline LONG GetTime();
    inline LONG GetInitialTime();
    inline USHORT GetPackedTime();
    LONG GetCredits();
    VOID Cleanup();
    VOID Reinit();
    VOID SetQueues(LPMSGQUE msg, LPMSGQUE db);
    struct pageInfo* GetPageInfo();
    VOID LoadRecord();
    VOID SaveRecord();
    VOID ChatBegin(SHORT context);

protected:
    LONG m_lTime;
    LONG m_lInitTime;
    USHORT m_iPackedTime;
    LPMSGQUE msgQueue;
    LPMSGQUE dbQueue;
    struct pageInfo m_pageInfo;
};

#endif // __TLCAHUSR_H
