/////////////////////////////////////////////////////////////////////////////
//
//   AHLITE.HPP
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Active HTML Lite Transport Layer declaration.
//   CStringPosition class declaration.
//
//                                               - N.C. Osterc 3/17/98
//
/////////////////////////////////////////////////////////////////////////////

#include "tlcahusr.hpp"

class CStringPositions
{
public:

     CStringPositions(             // constructor
     INT beg,                      // beginning position of string
     INT end);                     // end position of string

     CStringPositions(             // constructor
     INT beg,                      // beginning position of string
     INT end,                      // end position of string
     INT idx);                     // general-purpose value marker

     ~CStringPositions();          // destructor

     INT                           // begin value
     getBegin();                   // return begin value

     INT
     getEnd();                     // return end value

     INT                           // marker value
     getIdx();                     // return value marker

private:

     INT m_begPos;                 // the beginning position
     INT m_endPos;                 // the end position
     INT m_idx;                    // general-purpose value marker
};

typedef deque<CStringPositions*> ANSIQUE, *LPANSIQUE;
typedef deque<const CHAR*> FILTERQUE, *LPFILTERQUE;

class CLiteAHTrans : public CTlcTransport {

public:
     CLiteAHTrans();               // constructor
     ~CLiteAHTrans();              // desctructor

     VOID
     Output(                       // overriden transport output method
     CTlcUser* pUser);

     VOID
     SendTabbedDbData(             // overriden (unused) transport method
     const CHAR *data,
     CTlcChannel* pChannel);

     VOID
     CmdResult(                    // Send output based on a command
     CTlcUser* pUser,              //   user to send to
     SHORT iOperation,             //   operation performed
     GBOOL bSuccess,               //   successful?
     SHORT iReason);               //   reason for success/failure

     const CHAR *                  // the doctored string
     ANSI2HTML(                    // convert HTML to ANSI
     CHAR *ansiStr);               // the string to operate on

     const CHAR *                  // the doctored string
     Color2ANSI(                   // convert <color> tags to ANSI
     CHAR *str);                   // the string to operate on

     VOID
     clearStoreBuf();              // delete alloced memory for m_storeBuf

     GBOOL                         // TRUE/FALSE
     allowedTag(                   // check if the tag at start of string is allowed
     CHAR *checkStr);              // the string to operate on

     CHAR *                        // the doctored string
     removeFilterTags(             // remove supported tags (for other transports)
     CHAR *tagStr);                // the string to operate on

     CHAR *                        // the doctored string
     encodeTags(                   // HTML-encode string as appropriate
     CHAR *tagStr,                 // the string to operate on
     GBOOL encodeAll);             // TRUE=encode everything

     CHAR *                        // the doctored string
     encodeSpaces(                 // HTML encode spaces
     CHAR *tagtr);                // the string to operate on

     CHAR *                        // the doctored string
     handleURLs(                   // make URLs browser friendly
     CHAR *stg);                   // the string to operate on

     VOID
     initTransport();              // initialize transport

     CHAR *                        // the doctored string
     belStrip(                     // replace bells with spaces
     CHAR *str);                   // the string to operate on

     VOID
     SupportedTags(                // generate a list of supported tags
     CTlcAHUser *pAHUser);         // the user to direct list to

     GBOOL                         // TRUE/FALSE
     IsJustTags(                   // does the message contain tags ONLY?
     CHAR *msg);                   // the string to operate on

private:                           // private member functions

     VOID
     delAnsQueue();                // free up alloced memory in ansiqueue

     VOID
     RecvText(                     // Send text to one user
     CTlcUser* pUserFrom,          // user object sending text (NULL = system)
     CTlcUser* pUserTo,            // user object receiving text
     const CHAR* pMsg,             // Text to send
     SHORT fType,                  // Type of text
     SHORT iMsgNum=0,              // MSG file template to use
     const CHAR* ptr1=NULL,        // extra information for MSG template
     const CHAR* ptr2=NULL,        // extra information for MSG template
     const CHAR* ptr3=NULL);       // extra information for MSG template

     CHAR* m_storeBuf;             // storage used in ANSI <--> HTML conversion

     LPANSIQUE ansiqueue;          // pointer to queue
     LPFILTERQUE filterqueue;      // point to filter queue
};

