/***************************************************************************
 *                                                                         *
 *   TLCUSER.HPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997-1998  Galacticomm, Inc.   All Rights Reserved      *
 *                                                                         *
 *   Teleconference Users                                                  *
 *   Class Definition                                                      *
 *                                               - Phil Henning 5/14/97    *
 *                                                                         *
 ***************************************************************************/

#ifndef __TLCUSER_HPP
#define __TLCUSER_HPP

#include "tlcuser.h"
#include "tlcapi.hpp"

class  CTlcUser : public tlcusrstruct {
public:
     CTlcUser();
     virtual ~CTlcUser();

public:
     inline const CHAR* GetName();      // get Userid
     VOID SetName(                      // set Userid
     const CHAR* pszUserid);

     inline SHORT GetType();            // get User type

     inline INT GetUsrnum();            // get WG usrnum
     VOID SetUsrnum(INT iUsrnum);       // set WG usrnum

     inline LPUSRSTRUCT
     GetUserStruct();                   // get user structure

     VOID
     SetUserStruct(                     // set user structure
     LPUSRSTRUCT news);                 //   structure to copy from

     inline
     CTlcTransport* GetTransport();     // get pointer to transport

     VOID
     SetTransport(                      // set Transport Object to Use
     CTlcTransport* pTransport);        //   Tranport Object


     inline CHAR GetSex();              // get Sex (M or F)
     inline VOID SetSex(CHAR sex);      // set Sex (M or F)

     inline SHORT GetAge();             // get age
     inline VOID SetAge(SHORT age);     // set age

     inline
     const CHAR* GetChannelName();      // get Current Channel Name

     inline
     VOID SetChannel(                   // set Current Channel Name
     const CHAR* pszChannel);           //   channel name

     inline GBOOL IsListed();           // does user have channel listed?

     VOID List();                       // toggle channel listing

     inline
     const CHAR*
     GetLastWhispered();                // get last user whispered to

     VOID
     SetLastWhispered(                  // set last user whispered to
     const CHAR* pszUserid);            //   userid

     inline
     GBOOL
     CheckAccess(                       // check if user has a key
     const CHAR* key);                  //   key to check

     VOID
     OnRecvText(                        // send text to user
     const CHAR* pszUseridFrom,         //   user from
     const CHAR* pszUseridTo,           //   user to
     const CHAR* pMsg,                  //   message
     SHORT fType,                       //   type defined in tlctrans.h
     SHORT iMsgNum=0,                   //   msg file number
     const CHAR* ptr1 = NULL,           //   opt param 1
     const CHAR* ptr2 = NULL,           //   opt param 2
     const CHAR* ptr3 = NULL);          //   opt param 3

     VOID
     CmdResult(                         // process results of command
     SHORT iOperation,                  //   command performed
     GBOOL bSuccess,                    //   success/failure?
     SHORT iReason);                    //   why?

     inline
     const CHAR*
     GetEntrance(                       // get entrance message
     SHORT iType);                      // current or requested?

     inline
     VOID
     SetEntrance(                       // set entrance message
     const CHAR* pszMsg,                //   message
     SHORT iType);                      //   current or requested?

     inline
     const CHAR*                        // get exit message
     GetExit(                           //   current or requested?
     SHORT iType);

     inline
     VOID
     SetExit(                           // set exit message
     const CHAR* pszMsg,                //   message
     SHORT iType);                      //   current or requested?

     inline
     SHORT
     GetDefaultChan();                  // get default channel (main or private)

     inline
     VOID
     SetDefaultChan(
     SHORT iChannel);                   // set default channel (main or private)

     inline
     SHORT
     GetChatInterval();                 // get chat interval

     inline
     SHORT                              // new interval
     SetChatInterval(                   //   set chat interval
     SHORT iInterval);                  //   2-9

     virtual VOID
     ChatBegin(                         // begin a chat session
     SHORT context);                    //   who accepted?

     VOID
     SetChatUser(                       // set the chat user
     const CHAR* pszUserid);            //   userid

     const CHAR*                        //   userid to chat with
     GetChatUser();                     // get the chat user

     LONG                               //   time of last chat request
     GetChatReqTime();                  // get time of last chat request

     VOID
     SetChatReqTime();                  // set time of last chat request

     SHORT
     IsTalkingTooFast();                // is user talking too fast?

     VOID
     Talked();                          // increment speak counter

     GBOOL
     IsSwitchingTooFast();              // is user switchin too fast

     VOID
     Switched();                        // increment switch counter

     VOID
     SetSwitchCount(                    // set the switch count
     USHORT sw);                        //   value to switch it to

     USHORT                             //   current count
     GetSwitchCount();                  // get the current switch count

     const CHAR*
     GetPrivateTopic();                 // get private channel topic

     VOID
     SetPrivateTopic(                   // set private channel topic
     const CHAR* pszTopic);             //   new topic

     GBOOL
     ChangedMsg();                      // did user change entrance or exit?

     VOID
     SetChangedMsg(GBOOL how);          // set flag indicating ent change

     virtual VOID
     LoadRecord();                      // load this user's record from disk

     virtual VOID
     SaveRecord();                      // save this user's record to disk

     virtual
     LONG
     GetCredits();                      // get current credit total

     ULONG
     GetTlcUnum();                      // get unique tlc usr number

     VOID
     SetTlcUnum(                        // set tlc user number
     ULONG num);                        //   user number

     USHORT
     GetTlcBoardNum();                  // get board number

     VOID
     SetTlcBoardNum(                    // set board number
     USHORT num);                       //   board number

     VOID
     InitArray();                       // initalize linked list arrays

     LPFLIST
     GetForgetListPtr();                // get ptr to forget linked list

     LPFLIST
     GetIgnoreListPtr();                // get ptr to ignore linked list

     LPFLIST
     GetInviteListPtr();                // get ptr to invite linked list

     GBOOL
     CheckInvite(                       // check invite status
     CTlcUser* pUser);                  //   user to check status on

     GBOOL
     ToggleInvite(                      // toggle invite status
     CTlcUser* pUser);                  //   user to toggle status on

    // in the following group of functions, pUser is the user object
    // to forget or whatever operation is being done.
    // Each function also has a sister function which takes a tlcusernumber
    // and board number as a parameter instead of a user object, this
    // is to facilitate networked telconferences, in particular,
    // Worldlink.
    //


     GBOOL
     ToggleForget(                      // toggle forget status
     CTlcUser* pUser);                  //   user to toggle status on

     GBOOL
     CheckForget(                       // check forget status
     CTlcUser* pUser);                  //   user to check status on

     GBOOL
     ToggleIgnore(                      // toggle ignore status
     CTlcUser* pUser);                  //   user to toggle status on

     GBOOL
     CheckIgnore(                       // check ignore status
     CTlcUser* pUser);                  //   user to check status on

     GBOOL
     ToggleNUM(                         // toggle by user-board number pair
     ULONG user,                        //   user number
     USHORT board,                      //   board number
     SHORT list=LIST_FORGET);           //   list to toggle

     GBOOL
     CheckNUM(                          // check by user-board number pair
     ULONG user,                        //   user number
     USHORT board,                      //   board number
     SHORT list=LIST_FORGET);           //   list to check

     VOID*
     FindUserInList(                    // find user in list
     CTlcUser* pUser,                   //   pointer to user object to find
     SHORT list=LIST_FORGET);           //   list to search on

     VOID*
     FindUserInListNUM(                 // find user in list by u-b pair
     ULONG user,                        //   user number
     USHORT board,                      //   board number
     SHORT list=LIST_FORGET);           //   list to seach on

     GBOOL
     AddUserToList(                     // add a user to a list
     CTlcUser* pUser,                   //   pointer to user object to add
     SHORT list=LIST_FORGET);           //   list to add to

     GBOOL
     AddUserToListNUM(                  // add a user to a list by u-b pair
     ULONG user,                        //   user number
     USHORT board,                      //   board number
     SHORT list=LIST_FORGET);           //   list to add to

     GBOOL
     RemoveUserFromList(                // remove a user from a list
     CTlcUser* pUser,                   //   pointer to user object to remove
     SHORT list=LIST_FORGET);           //   list to remove from

     GBOOL
     RemoveUserFromListNUM(             // remove a user from a list by u-b pair
     ULONG user,                        //   user number
     USHORT board,                      //   board number
     SHORT list=LIST_FORGET);           //   list to remove from

     virtual
     GBOOL
     IsTypeOf(                          // is user a certain type of user?
     SHORT type);                       //   type to check

     virtual VOID Reinit();
     virtual VOID Cleanup();
protected:
    CTlcTransport* m_pTransport;
    CHAR  m_strChatUser[TLCUIDSIZ];
    LONG  m_chatreqtime;
private:
    USHORT m_iSpeakThrottle;
    USHORT m_iSpeedWarn;
    USHORT m_iTalkCount;
    USHORT m_iSwitchThrottle;
    USHORT m_iSwitchCount;
    USHORT m_iSwitchWarn;
};

#endif // __TLCUSER_HPP

