/***************************************************************************
 *                                                                         *
 *   TLCTRANS.HPP                                                          *
 *                                                                         *
 *   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved      *
 *                                                                         *
 *   Base Teleconference Transport Class.                                  *
 *   Declarations                                                          *
 *                                               - Phil Henning 5/14/97    *
 *                                                                         *
 ***************************************************************************/

#ifndef __TLCTRANS_HPP
#define __TLCTRANS_HPP

#include "smbwrap.h"
#include "tlctrans.h"

class CTlcUser;
class CTlcChannel;

class  CTlcTransport {
private:
     friend class CTlcUser;

public:
     CTlcTransport();
     virtual ~CTlcTransport();

     CHAR*
     GetName();

     VOID SetName(
     const CHAR* name);

     virtual
     VOID
     AddUser(
     CTlcUser* pUser);

     virtual
     VOID
     RemoveUser(
     CTlcUser* pUser);

     CTlcUser*
     GetFirstUser(
     CTlcChannel* pChannel);

     CTlcUser*
     GetNextUser(
     CTlcChannel* pChannel);

     CTlcUser*                     //   Pointer to a CTlcUser
     GetUserGT(                    // Get greater-than user in transport
     const CHAR* pszUserid,        //   User-ID to get greater than
     CTlcChannel* pChannel);       //   Channel to limit to (NULL=all chans)

     virtual
     VOID
     Output(
     CTlcUser* pUser)=0;

     virtual
     VOID
     SendTabbedDbData(
     const CHAR*,
     CTlcChannel*)=0;

     virtual
     VOID
     SendAll(
     const CHAR* pszUseridFrom,
     const CHAR* pszUseridTo,
     const CHAR* pMsg,
     SHORT fType,
     CTlcChannel* pChannel,
     SHORT iMsgNum=0,
     const CHAR* ptr1=NULL,
     const CHAR* ptr2=NULL,
     const CHAR* ptr3=NULL);

     virtual
     VOID
     SendAllKey(
     const CHAR* pszUseridFrom,
     const CHAR* pszUseridTo,
     const CHAR* pMsg,
     SHORT fType,
     CTlcChannel* pChannel,
     SHORT iMsgNum=0,
     const CHAR* ptr1=NULL,
     const CHAR* ptr2=NULL,
     const CHAR* ptr3=NULL,
     const CHAR* key=NULL);

     virtual
     VOID
     SendAllBut(
     const CHAR* pszUseridFrom,
     const CHAR* pszUseridTo,
     const CHAR* pMsg,
     SHORT fType,
     CTlcChannel* pChannel,
     SHORT iMsgNum=0,
     const CHAR* ptr1=NULL,
     const CHAR* ptr2=NULL,
     const CHAR* ptr3=NULL,
     const CHAR* pszUseridNot1=NULL,
     const CHAR* pszUseridNot2=NULL);

     virtual
     VOID
     CmdResult(
     CTlcUser* pUser,
     SHORT iOperation,
     GBOOL bSuccess,
     SHORT iReason);

     virtual
     VOID
     OutputFinished();

protected:                         // protected member functions

     virtual
     bool
     NeedFromUser(                 // does RecvText need a from user context?
     SHORT fType,                  //   text type
     SHORT iMsgNum);               //   event code

     virtual
     VOID
     RecvText(                     // Send text to one user by ID
     CTlcUser* pUserFrom,          //   user object sending text (NULL = system)
     CTlcUser* pUserTo,            //   user object receiving text
     const CHAR* pMsg,             //   Text to send
     SHORT fType,                  //   Type of text
     SHORT iMsgNum=0,              //   Type of event
     const CHAR* ptr1=NULL,        //   extra information
     const CHAR* ptr2=NULL,        //   extra information
     const CHAR* ptr3=NULL)=0;     //   extra information

protected:
     CSmb* m_smbUsers;
     CHAR  m_transport[TRANSNAMSIZ];

public:
     SHORT m_fFlags;
};

#endif // __TLCTRANS_HPP
