/***************************************************************************
 *                                                                         *
 *   TLCTMTRA.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All Rights Reserved      *
 *                                                                         *
 *   Teleconference Terminal-Mode Transport Class.                         *
 *   Declarations                                                          *
 *                                           - J. Alvrus    02/24/1998     *
 *                                                                         *
 ***************************************************************************/

#ifndef __TLCTMTRA_H
#define __TLCTMTRA_H

#include "tlctrans.hpp"

class  CTerminalTransport : public CTlcTransport {
public:
     CTerminalTransport();         // default constructor

     ~CTerminalTransport() {}      // destructor

     VOID
     CmdResult(                    // Send output based on a command
     CTlcUser* pUser,              //   user to send to
     SHORT iOperation,             //   operation performed
     GBOOL bSuccess,               //   successful?
     SHORT iReason);               //   reason for success/failure

     VOID
     SendTabbedDbData(             // send drawing board data
     const CHAR* data,             //   drawing board data
     CTlcChannel* pChannel);       //   channel

     VOID
     Output(                       // output whatever is in buffer
     CTlcUser* pUser);             //   user to output to

     VOID
     OutputFinished();             // a user is done generating output

private:                           // private member functions

     VOID
     RecvText(                     // Send text to one user
     CTlcUser* pUserFrom,          //   user object sending text (NULL = system)
     CTlcUser* pUserTo,            //   user object receiving text
     const CHAR* pMsg,             //   Text to send
     SHORT fType,                  //   Type of text
     SHORT iMsgNum=0,              //   MSG file template to use
     const CHAR* ptr1=NULL,        //   extra information for MSG template
     const CHAR* ptr2=NULL,        //   extra information for MSG template
     const CHAR* ptr3=NULL);       //   extra information for MSG template

     VOID
     RecvTextLowLevel(             // Send text to one user
     CTlcUser* pUserFrom,          //   user object sending text (NULL = system)
     CTlcUser* pUserTo,            //   user object receiving text
     const CHAR* pMsg,             //   Text to send
     SHORT fType,                  //   Type of text
     SHORT iMsgNum=0,              //   MSG file template to use
     const CHAR* ptr1=NULL,        //   extra information for MSG template
     const CHAR* ptr2=NULL,        //   extra information for MSG template
     const CHAR* ptr3=NULL);       //   extra information for MSG template
};

extern CTerminalTransport* transTerm; // terminal-mode transport object

#endif // __TLCTMTRA_H
