/***************************************************************************
 *                                                                         *
 *   TLCTM.H                                                               *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Teleconference terminal mode interface.                               *
 *                                                                         *
 *                                            - J. Alvrus   02/23/1998     *
 *                                                                         *
 ***************************************************************************/


#ifndef __TLCTM_H
#define __TLCTM_H

#include "tlcuser.h"
#include <limits.h>                // for CHAR_BIT

// macros for dealing with bit flag arrays
#define INT_BIT          (CHAR_BIT*sizeof(INT))
#define FLAG_NUM(n)      (((n)+(INT_BIT-1))/INT_BIT)
#define FLAG_SIZE(n)     (FLAG_NUM(n)*sizeof(INT))
#define FLAG_INDEX(i)    ((i)/INT_BIT)
#define FLAG_BIT(i)      ((i)&(INT_BIT-1))
#define FLAG_MASK(i)     (1<<FLAG_BIT(i))
#define FLAG_ELEM(a,i)   (((INT*)(a))[FLAG_INDEX(i)])
#define FLAG_TEST(a,i)   (FLAG_ELEM((a),(i))&FLAG_MASK(i))
#define FLAG_SET(a,i)    (FLAG_ELEM((a),(i))|=FLAG_MASK(i))
#define FLAG_CLEAR(a,i)  (FLAG_ELEM((a),(i))&=~FLAG_MASK(i))
#define FLAG_TOGGLE(a,i) (FLAG_ELEM((a),(i))^=FLAG_MASK(i))
#define FLAG_SETTO(a,i,f)((f) ? FLAG_SET((a),(i)) : FLAG_CLEAR((a),(i)))

extern INT* OutFlagArr;            // output flag array
extern INT* PmtFlagArr;            // prompt flag array
extern bool tmEcho;                // echo typed text back to t-mode user?
extern bool tmInSysopMenu;         // are we already in sysop editor?

VOID
tlcInitTM(VOID);                   // initialize terminal-mode interface

VOID
tlcTMdwn(VOID);                    // shut down terminal-mode

VOID
DisplayEditMenu(                   // display user's profile editor menu
CTlcUser* pUser);                  //   user to display/put in editor

VOID
RetChanEditor(VOID);               // return to channel editor menu

VOID
RetListEditor(VOID);               // return to action list editor menu

VOID
RetActionEditor(VOID);             // return to action word editor menu

VOID
tmReturnChannel(                   // return to channel from chat/menu
CTlcUser* pUser,                   //   user's user object
CTlcChannel* pChannel);            //   user's channel object

VOID
tmEnterChannel(                    // set up everything on entry to channel
CTlcUser* pUser);                  //   user's user object

VOID
tmExitChannel(                     // set up everything when exiting a channel
CTlcUser* pUser);                  //   user's user object

#endif /* __TLCTM_H */
