
#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.hpp"
#include "tlcdynch.hpp"

#define FILREV "$Revision: 23 $"
MARKSOURCE(tlcdynch)

CDynamicChannel::CDynamicChannel(CTlcAPI* tlcAPI) : CTlcChannel(tlcAPI), pFuncs(NULL)
{
     if (CHECKFC(construct)) {
          pFuncs->construct();
     }
     m_iSize=sizeof(CDynamicChannel);
}

CDynamicChannel::CDynamicChannel(CTlcAPI* tlcAPI, LPCHFUNCPTRS ptrs) : CTlcChannel(tlcAPI),
                                                      pFuncs(ptrs)
{
     if (CHECKFC(construct)) {
          pFuncs->construct();
     }
     m_iSize=sizeof(CDynamicChannel);
}

CDynamicChannel::~CDynamicChannel()
{
     if (CHECKFC(destruct)) {
          pFuncs->destruct();
     }
}

VOID
CDynamicChannel::SetFuncPtrs(
LPCHFUNCPTRS ptrs)
{
     pFuncs=ptrs;
}

SHORT
CDynamicChannel::AddUser(
CTlcUser* pUser,
GBOOL bIsFirstEnter)
{
     if (CHECKFC(adduserfunc)) {
          pFuncs->adduserfunc(m_strName,pUser->GetUserStruct(),bIsFirstEnter);
     }
     return(CTlcChannel::AddUser(pUser,bIsFirstEnter));
}

SHORT
CDynamicChannel::RemoveUser(
CTlcUser* pUser,
SHORT fExitType)
{
     SHORT retval;
     USRSTRUCT usrinf;

     if (pUser == NULL) {
          return(CHAN_UNJOIN_NOTHERE);
     }
     memmove(&usrinf,pUser->GetUserStruct(),sizeof(USRSTRUCT));
     if ((retval=CTlcChannel::RemoveUser(pUser,fExitType)) == CHAN_JOIN_OK) {
          if (CHECKFC(removeuserfunc)) {
               pFuncs->removeuserfunc(m_strName,&usrinf,fExitType);
          }
     }
     return(retval);
}

VOID
CDynamicChannel::SendWelcome(
CTlcUser* pUser)
{
     LPUSRSTRUCT stUsr=pUser->GetUserStruct();

     if (CHECKFC(presendwelcome)) {
          pFuncs->presendwelcome(stUsr);
     }
     CTlcChannel::SendWelcome(pUser);
     if (CHECKFC(postsendwelcome)) {
          pFuncs->postsendwelcome(stUsr);
     }
}

GBOOL
CDynamicChannel::CanAccess(
CTlcUser* pUser,
INT access)
{
     if (CHECKFC(canaccess)) {
          LPUSRSTRUCT stUsr=pUser->GetUserStruct();
          return(pFuncs->canaccess(m_strName,stUsr,access));
     }
     return(CTlcChannel::CanAccess(pUser,access));
}

