/***************************************************************************
 *                                                                         *
 *   TLCCSTRA.H                                                            *
 *                                                                         *
 *   Copyright (c) 1998 Galacticomm, Inc.         All Rights Reserved      *
 *                                                                         *
 *   Teleconference Client/Server Transport Declarations                   *
 *                                                                         *
 *                                              - Phil Henning 8/14/97     *
 *                                                                         *
 ***************************************************************************/

#ifndef __TLCCSTRA_H
#define __TLCCSTRA_H

class CCSTransport : public CTlcTransport {
public:
     CCSTransport();
     ~CCSTransport() {}

     VOID
     SendTabbedDbData(
     const CHAR* data,
     CTlcChannel* pChannel);

     VOID
     Output(
     CTlcUser* pUser);

     VOID
     CmdResult(
     CTlcUser* pUser,
     SHORT iOperation,
     GBOOL bSuccess,
     SHORT iReason);

private:                           // private member functions

     VOID
     RecvText(                     // Send text to one user
     CTlcUser* pUserFrom,          //   user object sending text (NULL = system)
     CTlcUser* pUserTo,            //   user object receiving text
     const CHAR* pMsg,             //   Text to send
     SHORT fType,                  //   Type of text
     SHORT iMsgNum=0,              //   MSG file template to use
     const CHAR* ptr1=NULL,        //   extra information for MSG template
     const CHAR* ptr2=NULL,        //   extra information for MSG template
     const CHAR* ptr3=NULL);       //   extra information for MSG template

     VOID
     RecvTextLowLevel(             // Send text to one user
     CTlcUser* pUserFrom,          //   user object sending text (NULL = system)
     CTlcUser* pUserTo,            //   user object receiving text
     const CHAR* pMsg,             //   Text to send
     SHORT fType,                  //   Type of text
     SHORT iMsgNum=0,              //   Type of event
     const CHAR* ptr1=NULL,        //   extra information
     const CHAR* ptr2=NULL,        //   extra information
     const CHAR* ptr3=NULL);       //   extra information

};

#endif // __TLCCSTRA_H



