////////////////////////////////////////////////////////////////////////////
//
//   TLCCSDP.CPP
//
//   Copyright (c) 1997-1998  Galacticomm, Inc.    All Rights Reserved
//
//   Teleconference Client-Server Dynapak
//   Implentation
//                                           - Phil Henning 6/10/97
//
/////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "tlcapi.hpp"

#include "tlccs.h"
#include "tlccstra.h"

#define FILREV "$Revision: 74 $"

/***************************************************************************
 * Variable declarations                                                   *
 ***************************************************************************/
INT dpkdirection;                  //  Current dynapak direction
VOID* dpkvalue;                    //  Current dynapak value
USHORT dpklength;                  //  Current dynapak length
CHAR* dpkstg;                      //  Current dynapak as a string
CTlcUser* dpkUser;                 //  Current user from dynapak request
CTlcChannel* dpkChannel;           //  Current channel user is in

/***************************************************************************
 * Function & Structure declarations                                       *
 ***************************************************************************/
struct flddef vbtlcfilFDA[]={
     {CVTFLD_CHAR  ,TLCUIDSIZ-1+VBFILSIZ,fldoff(vbtlcfil,userid),NULL},
     {CVTFLD_DOUBLE,1                ,fldoff(vbtlcfil,tnd)   ,NULL},
     {CVTFLD_LONG  ,1                ,fldoff(vbtlcfil,size)  ,NULL},
     {CVTFLD_END   ,0                ,0                      ,NULL}
};

typedef struct entchg {
     GBOOL responded;
     GBOOL charged;
     SHORT msg;
     CHAR* text;
} ENTCHG, *LPENTCHG;

static SHORT                       //  Various flags
CSEntExit(                         //  Change enter/exit messages
CTlcUser* pUser,                   //  Pointer current user
LPENTCHG lpec);                    //  Pointer to entrance change structure

static SHORT                       //  Various flags
chgcsmsg(                          //  Change C/S entrance/exit message
CTlcUser* pUser,                   //  Pointer to current user
CHAR* msg,                         //  Message to change
SHORT which,                       //  Entrance or exit
GBOOL charge);                     //  Charge person?

static SHORT                       //  Various flags
chgcsmsg(                          //  Change C/S entrance/exit message
CTlcSysEdt* pUser,                 //  Pointer to a user
CHAR* msg,                         //  Message to change
SHORT which,                       //  Entrance or exit
GBOOL charge);                     //  Charge person?

/***************************************************************************
 * Source code                                                             *
 ***************************************************************************/
MARKSOURCE(tlccsdp);               //  Source code marker

VOID
register_dpks(VOID)                //  Register Dynapaks
{
     register_dpkfda(TLCAPID,"sau:bgnxfr",vbtlcfilFDA);
}

VOID
dpkr_sysedit(VOID)                 //  Sysop Edit functions
{
     struct saunam sdpk;
     CTlcUser* pUser;

     if (!cnvd2s(dpkstg,&sdpk)) {
          rejectreq();
     }
     else if ((pUser=tlcAPI->usrGetByName(sdpk.usrid)) != NULL) {
          strcpy(rsptmp,pUser->GetEntrance(MSG_CURRENT));
          strcat(rsptmp,"\t");
          strcat(rsptmp,pUser->GetExit(MSG_CURRENT));
          strcat(rsptmp,"\t");
          strcat(rsptmp,pUser->GetEntrance(MSG_REQUESTED));
          strcat(rsptmp,"\t");
          strcat(rsptmp,pUser->GetExit(MSG_REQUESTED));
          strcat(rsptmp,"\t");
          strcat(rsptmp,(pUser->m_fFlags&USR_SQUELCH ? "YES" : "NO"));
          strcat(rsptmp,"\t");
          strcat(rsptmp,(pUser->CheckAccess(rawmsg(AUTKEY)) ? "YES" : "NO"));
          rsp2read(NULL,STGLEN,rsptmp,NULL);
     }
     else {
          CTlcSysEdt sysedt(sdpk.usrid);
          if (!sysedt.foundUser()) {
               dfaSetBlk(accbb);
               if (dfaAcqEQ(NULL,sdpk.usrid,0)) {
                    USRDSK UserInfoDisk;
                    struct usracc* usra=(struct usracc*)(accbb->data);
                    memset(&UserInfoDisk,0,sizeof(USRDSK));
                    stlcpy(UserInfoDisk.m_pszUserid,usra->userid,UIDSIZ);
                    UserInfoDisk.m_iChatInterval=2;
                    dfaSetBlk(dfaTlcUser);
                    dfaInsert(&UserInfoDisk);
                    dfaRstBlk();
               }
               else {
                   rejectreq();
                   dfaRstBlk();
                   return;
               }
               if (!sysedt.reload()) {
                    rejectreq();
                    return;
               }
          }
          strcpy(rsptmp,sysedt.getEntrance(MSG_CURRENT));
          strcat(rsptmp,"\t");
          strcat(rsptmp,sysedt.getExit(MSG_CURRENT));
          strcat(rsptmp,"\t");
          strcat(rsptmp,sysedt.getEntrance(MSG_REQUESTED));
          strcat(rsptmp,"\t");
          strcat(rsptmp,sysedt.getExit(MSG_REQUESTED));
          strcat(rsptmp,"\t");
          strcat(rsptmp,(sysedt.isSquelched() ? "YES" : "NO"));
          strcat(rsptmp,"\t");
          strcat(rsptmp,(uhskey(sdpk.usrid,rawmsg(AUTKEY)) ? "YES" : "NO"));
          rsp2read(NULL,STGLEN,rsptmp,NULL);
     }
}

VOID
dpkr_chanl(                        //  Get Channel Lists
struct saunam *psau,               //  Pointer to current dyanapak structure
const CHAR *dpkstg,                //  Pointer to current dynapak string
CHAR *LastChannel)                 //  Last channel looked up by user
{
     INT spaces;
     ULONG number;
     CTlcChannel* pChannel;

     *namtmp=*psau;

     spaces=itemcntd(dpkstg," ");
     if (spaces < 1 || spaces > 2) {
          rejectreq();
          return;
     }

     if (spaces == 1) {
          number=0;
          setmem(LastChannel,CHAN_MAX_SIZE,0);
     }
     else {
          number=atol(itemidxd(dpkstg,1," "));
     }
     while ((pChannel=tlcAPI->chanGetGT(LastChannel)) != NULL) {
          strcpy(LastChannel,pChannel->GetName());
          if (pChannel->GetType()&CHAN_TYPE_PRIVATE) {
               CTlcPrivateChannel* pPrivate;
               pPrivate=dynamic_cast<CTlcPrivateChannel*>(pChannel);
               if (!pPrivate->CheckInvite(dpkUser)
                && !(dpkUser->IsTypeOf(USR_OPERATOR))
                && !sameas(dpkUser->GetName(),pPrivate->GetOwner())) {
                    continue;
               }
          }
          else if (pChannel->m_flags&CHAN_FLAG_NOLIST) {
               continue;
          }
          else if (!pChannel->CanAccess(dpkUser,CHAN_AXS_SEE)) {
               continue;
          }
          sprintf(rsptmp,"%s\t%s",pChannel->GetName(),pChannel->GetTopic());
          sprintf(namtmp->suffix,"chanlist %09ld",number+1);
          rsp2read(namtmp,STGLEN,rsptmp,NULL);
          return;
     }
     rejectreq();
}

VOID
dpkr_chanu(VOID)                   //  Get users in channel
{
     CTlcChannel* pChannel;
     CTlcUser* pUser;
     GBOOL response=FALSE;
     CHAR* chan;

     chan=skpwht(skpwrd(dpkstg));
     pChannel=tlcAPI->chanGetByName(chan);
     if (pChannel == NULL) {
          pChannel=tlcAPI->chanGetByName(tlcPrivateFromUser(usaptr->userid));
     }
     if (pChannel != NULL) {
          pUser=pChannel->GetFirstUser();
          while (pUser != NULL) {
               if (pUser->m_fFlags&USR_INCHAN
                    && !(pUser->m_fFlags&USR_INVISB)) {
                    if (response) {
                         strcat(rsptmp,"\t");
                    }
                    strcat(rsptmp,pUser->GetName());
                    response = TRUE;
               }
               pUser=pChannel->GetNextUser();
          }
     }
     if (!response) {
          strcat(rsptmp,"");
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_ticker(VOID)                  //  Get current ticker time
{
     strcat(rsptmp,pszTicker);
     strcat(rsptmp,spr("\t%d",iTickerTime));
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getpals(VOID)                 //  Get all of your pals
{
     GBOOL response=FALSE;
     PALDSK pdsk;

     memset(&pdsk,0,sizeof(PALDSK));
     stzcpy(pdsk.pszUserid,usaptr->userid,UIDSIZ);
     dfaSetBlk(dfaPal);
     strcat(rsptmp,spr("%d\t",pmax));
     if (dfaAcqGT(&pdsk,&pdsk,0) && sameas(pdsk.pszUserid,dpkUser->GetName())) {
          do {
               if (response) {
                    strcat(rsptmp,"\t");
               }
               strcat(rsptmp,pdsk.pszPal);
               response=TRUE;
          } while (dfaAcqNX(&pdsk));
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getprof(VOID)                 //  Get your profile
{
     strcat(rsptmp,dpkUser->GetEntrance(MSG_CURRENT));
     strcat(rsptmp,"\t");
     strcat(rsptmp,dpkUser->GetExit(MSG_CURRENT));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->GetDefaultChan() ? "Private" : "Main"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,spr("%d",dpkUser->GetChatInterval()));
     strcat(rsptmp,"\t");
     strcat(rsptmp,dpkUser->GetPrivateTopic());
     strcat(rsptmp,"\t");
     strcat(rsptmp,dpkUser->GetEntrance(MSG_REQUESTED));
     strcat(rsptmp,"\t");
     strcat(rsptmp,dpkUser->GetExit(MSG_REQUESTED));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->m_fFlags&USR_NOACTIONS ? "NO" : "YES"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(AUTKEY)) ? "YES" : "NO"));
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getaccess(VOID)               //  Get your access Level
{
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(FGTKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(INVKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->IsTypeOf(USR_MODERATOR) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->IsTypeOf(USR_OPERATOR) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(PALKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(IGNKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(TOPKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(CHTKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(ACTKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,spr("%d",tinpsz));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(AEDTKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(MNUKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->IsTypeOf(USR_OPERATOR) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(DELKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->CheckAccess(rawmsg(REQKEY)) ? "YES" : "NO"));
     strcat(rsptmp,"\t");
     strcat(rsptmp,(dpkUser->IsTypeOf(USR_OPERATOR) && tlcAPI->m_iEtlpst > 0) ? "YES" : "NO");
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_alists(VOID)                  //  Get action lists
{
     curChannel=tlcAPI->chanGetByName(dpkUser->GetChannelName());
     if (curChannel != NULL) {
          LPCHANINFO pchanInfo;
          pchanInfo=curChannel->GetConfig();
          CTlcAList* pList;
          pList=tlcAPI->actGetByName(pchanInfo->m_actList1);
          if (pList != NULL && !pList->IsDeleted()) {
               LPACTLST listcfg;
               listcfg=pList->GetConfigPtr();
               if (haskey(listcfg->usekey)) {
                    strcat(rsptmp,pchanInfo->m_actList1);
                    strcat(rsptmp,"\t");

               }
          }
          pList=tlcAPI->actGetByName(pchanInfo->m_actList2);
          if (pList != NULL && !pList->IsDeleted()) {
               LPACTLST listcfg;
               listcfg=pList->GetConfigPtr();
               if (haskey(listcfg->usekey)) {
                    strcat(rsptmp,pchanInfo->m_actList2);
               }
          }
          if (strlen(rsptmp) > 0) {
               rsp2read(NULL,STGLEN,rsptmp,NULL);
          }
          else {
               rejectreq();
          }
     }
     else {
          rejectreq();
     }
}

VOID
dpkr_awords(VOID)                  //  Get action lists
{
     GBOOL response=FALSE;
     CHAR* listName=skpwht(skpwrd(dpkstg));
     CTlcAList* pList;

     if ((pList=tlcAPI->actGetByName(listName)) != NULL) {
          if (pList->IsDeleted()) {
               rsp2read(NULL,STGLEN,NULL,NULL);
               return;
          }
          const CHAR* word=pList->wordGetFirst();
          while (word != NULL) {
               if (response) {
                    strcat(rsptmp,"\t");
                    response=FALSE;
               }
               LPACTION action;
               action=pList->actionGetCurrentPtr();
               if (haskey(action->actkey)) {
                    strcat(rsptmp,spr("%s\t%s\t%s\t%s",action->name,
                         action->isyell ? "Y" : "N",
                         isempty(action->complx) ? "N" : "Y",
                         isempty(action->simple) ? "N" : "Y" ));
                    response=TRUE;
               }
               word=pList->wordGetNext();
          }
          if (strlen(rsptmp) > 0) {
               rsp2read(NULL,STGLEN,rsptmp,NULL);
               return;
          }
     }
     rejectreq();
}

VOID
dpkr_getsquelch(VOID)              //  Get squelched users
{
     CTlcUser* pOthUser;
     GBOOL response=FALSE;

     pOthUser=tlcAPI->usrGetFirst();
     while (pOthUser != NULL) {
          if (response) {
               strcat(rsptmp,"\t");
               response=FALSE;
          }
          if (pOthUser->m_fFlags&USR_SQUELCH) {
               strcat(rsptmp,pOthUser->GetName());
               response=TRUE;
          }
          pOthUser=tlcAPI->usrGetNext();
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getinvite(VOID)               //  Get list of invited people
{
     CTlcUser* pOthUser;
     LPFLIST flist;
     int cnt;
     GBOOL response=FALSE;

     flist=dpkUser->GetInviteListPtr();
     cnt=0;
     while (cnt < n2inv && flist[cnt].user != 0) {
          pOthUser=tlcAPI->usrGetByTlcID(flist[cnt].board,flist[cnt].user);
          if (pOthUser != NULL) {
               if (response) {
                    strcat(rsptmp,"\t");
               }
               strcat(rsptmp,pOthUser->GetName());
               response=TRUE;
          }
          cnt++;
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getforget(VOID)               //  Get list of forgotten people
{
     CTlcUser* pOthUser;
     LPFLIST flist;
     int cnt;
     GBOOL response=FALSE;

     flist=dpkUser->GetForgetListPtr();
     cnt=0;
     while (cnt < n2fgt && flist[cnt].user != 0) {
          pOthUser=tlcAPI->usrGetByTlcID(flist[cnt].board,flist[cnt].user);
          if (pOthUser != NULL) {
               if (response) {
                    strcat(rsptmp,"\t");
               }
               strcat(rsptmp,pOthUser->GetName());
               response=TRUE;
          }
          cnt++;
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getignore(VOID)               //  Get list of forgotton people
{
     GBOOL response=FALSE;
     CTlcUser* pOthUser;
     LPFLIST flist;
     int cnt;

     flist=dpkUser->GetIgnoreListPtr();
     cnt=0;
     while (cnt < n2ign && flist[cnt].user != 0) {
          pOthUser=tlcAPI->usrGetByTlcID(flist[cnt].board,flist[cnt].user);
          if (pOthUser != NULL) {
               if (response) {
                    strcat(rsptmp,"\t");
               }
               strcat(rsptmp,pOthUser->GetName());
               response=TRUE;
          }
          cnt++;
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_allu(                         //  Get all users dynapak
struct saunam *psau,               //  Pointer to current dynapak
const CHAR *dpkstg,                //  Pointer to dynapak string
CHAR *LastUser)                    //  Last user picked up by current user
{
     CTlcUser* pOthUser;
     INT spaces;
     ULONG number;

     *namtmp=*psau;

     spaces=itemcntd(dpkstg," ");
     if (spaces < 1 || spaces > 2) {
          rejectreq();
          return;
     }
     if (spaces == 1) {
          setmem(LastUser,TLCUIDSIZ,0);
          number=0;
     }
     else {
          number=atol(itemidxd(dpkstg,1," "));
     }
     while ((pOthUser=tlcAPI->usrGetGT(LastUser)) != NULL) {
          strcpy(LastUser,pOthUser->GetName());
          if (pOthUser->m_fFlags&USR_INVISB) {
               continue;
          }
          sprintf(rsptmp,"%s\t%s\t%c\t%hd\t%d",pOthUser->GetName()
               ,pOthUser->GetChannelName(),pOthUser->GetSex()
               ,pOthUser->GetAge(),((pOthUser->m_fFlags&USR_UNLIST) != 0L));
          sprintf(namtmp->suffix,"allu %09ld",number+1);
          rsp2read(namtmp,STGLEN,rsptmp,NULL);
          return;
     }
     rejectreq();
}

VOID
dpkr_syschan(VOID)                 //  Sysop channel editing
{
     CTlcChannel* pChannel;
     GBOOL rsp=FALSE;

     pChannel=tlcAPI->chanGetFirst();
     while (pChannel != NULL) {
          if (!(pChannel->GetType()&CHAN_TYPE_NOEDIT)
            && pChannel->CanAccess(dpkUser,CHAN_AXS_MODERATOR)) {
               if (rsp) {
                    strcat(rsptmp,"\t");
               }
               strcat(rsptmp,pChannel->GetName());
               strcat(rsptmp,"\t");
               strcat(rsptmp,dpkUser->IsTypeOf(USR_OPERATOR) ? "Y" : "N");
               rsp=TRUE;
          }
          pChannel=tlcAPI->chanGetNext();
     }
     if (rsp) {
          rsp2read(NULL,STGLEN,rsptmp,NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkr_getchan(VOID)                 //  Get channel information
{
     CTlcChannel* pChannel;
     CHAR* chanName=skpwht(skpwrd(dpkstg));

     if ((pChannel=tlcAPI->chanGetByName(chanName)) == NULL) {
          rejectreq();
     }
     else if (pChannel->CanAccess(dpkUser,CHAN_AXS_MODERATOR)
      || hasmkey(TLCOPKY)
      || hasmkey(TSYSKEY)) {
          strcpy(rsptmp,pChannel->m_strTopic);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_keyVis);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_keyJoin);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_keySpeak);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_keyByPass);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_keyMod);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_actList1);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pChannel->m_actList2);
          strcat(rsptmp,"\t");
          strcat(rsptmp,(pChannel->m_flags&CHAN_FLAG_PROFOK ? "YES" : "NO"));
          strcat(rsptmp,"\t");
          strcat(rsptmp,(pChannel->m_flags&CHAN_FLAG_NOENTMESSAGE ? "NO" : "YES"));
          strcat(rsptmp,"\t");
          strcat(rsptmp,(pChannel->m_flags&CHAN_FLAG_CLOSED ? "YES" : "NO"));
          rsp2read(NULL,STGLEN,rsptmp,NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkr_sysalist(VOID)                //  Sysop action list retriever
{
     CTlcAList* pList;
     GBOOL rsp=FALSE;

     pList=tlcAPI->actGetFirst();
     while (pList != NULL) {
          if (rsp) {
               strcat(rsptmp,"\t");
          }
          if (!(pList->IsDeleted())) {
               strcat(rsptmp,pList->GetName());
               rsp=TRUE;
          }
          pList=tlcAPI->actGetNext();
     }
     rsp2read(NULL,STGLEN,rsptmp,NULL);
}

VOID
dpkr_getalist(VOID)                //  Get action list
{
     CTlcAList* pList;
     LPACTLST pConfig;

     pList=tlcAPI->actGetByName(skpwht(skpwrd(dpkstg)));
     if (pList != NULL && !pList->IsDeleted()) {
          pConfig=pList->GetConfigPtr();
          strcpy(rsptmp,pConfig->seekey);
          strcat(rsptmp,"\t");
          strcat(rsptmp,pConfig->usekey);
          rsp2read(NULL,STGLEN,rsptmp,NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkr_getaword(VOID)                //  Dynapak to retrieve action word
{
     CTlcAList* pList;
     CHAR* stg=itemidx(skpwht(skpwrd(dpkstg)),0);

     if ((pList=tlcAPI->actGetByName(stg)) != NULL && !pList->IsDeleted()) {
          stg=itemidx(skpwht(skpwrd(dpkstg)),1);
          if (pList->wordExists(stg)) {
               LPACTION action=pList->actionGetCurrentPtr();
               strcpy(rsptmp,action->actkey);
               strcat(rsptmp,"\t");
               strcat(rsptmp,UnFormatActionMsg(action->simple));
               strcat(rsptmp,"\t");
               strcat(rsptmp,UnFormatActionMsg(action->complx));
               strcat(rsptmp,"\t");
               strcat(rsptmp,UnFormatActionMsg(action->resp));
               rsp2read(NULL,STGLEN,rsptmp,NULL);
               return;
          }
     }
     rejectreq();
}

VOID
dpkr_sysaword(                     //  Ssop get action word
GBOOL all)                         //  Get all words at once?
{
     CTlcAList* pList=tlcAPI->actGetByName(skpwht(skpwrd(dpkstg)));
     GBOOL rsp=FALSE;

     if (pList != NULL && !pList->IsDeleted()) {
          const CHAR* word=pList->wordGetFirst();
          while (word != NULL) {
               if (rsp) {
                    strcat(rsptmp,"\t");
               }
               if (all) {
                    strcat(rsptmp,word);
                    rsp=TRUE;
               }
               else {
                    LPACTION pAction=pList->actionGetCurrentPtr();
                    if (haskey(pAction->actkey)) {
                         strcat(rsptmp,word);
                         rsp=TRUE;
                    }
               }
               word=pList->wordGetNext();
          }
          rsp2read(NULL,STGLEN,rsptmp,NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkw_delalist(VOID)                //  Delete an action list
{
     CTlcAList* pList;
     pList=tlcAPI->actGetByName((CHAR*)dpkvalue);
     if (pList != NULL && !pList->IsDeleted()) {
          pList->Delete();
          rsp2write(TRUE,0,NULL,NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkw_setalist(VOID)                //  Set current action list
{
     CTlcAList* pList;

     pList=tlcAPI->actGetByName(itemidx((CHAR*)dpkvalue,0));
     if (pList != NULL && !pList->IsDeleted()) {
          LPACTLST pConfig;
          pConfig=pList->GetConfigPtr();
          stzcpy(pConfig->seekey,itemidx((CHAR*)dpkvalue,1),KEYSIZ);
          stzcpy(pConfig->usekey,itemidx((CHAR*)dpkvalue,2),KEYSIZ);
     }
     else {
          ACTLST newList;
          stzcpy(newList.name,itemidx((CHAR*)dpkvalue,0),ACTSIZ);
          stzcpy(newList.seekey,itemidx((CHAR*)dpkvalue,1),KEYSIZ);
          stzcpy(newList.usekey,itemidx((CHAR*)dpkvalue,2),KEYSIZ);
          addlst(&newList);
     }
     rsp2write(TRUE,0,NULL,NULL);
}

VOID
dpkw_delaword(VOID)                //  Delete an action word
{
     CTlcAList* pList;

     CHAR* stg=itemidx((CHAR*)dpkvalue,0);
     if ((pList=tlcAPI->actGetByName(stg)) != NULL && !pList->IsDeleted()) {
          stg=itemidx((CHAR*)dpkvalue,1);
          if (pList->wordExists(stg)) {
               LPACTION action=pList->actionGetCurrentPtr();
               delact(action);
               rsp2write(TRUE,0,NULL,NULL);
               return;
          }
     }
     rejectreq();
}

VOID
dpkw_setaword(VOID)                //  Set current action word
{
     CTlcAList* pList;

     ACTION action;

     stzcpy(action.list,itemidx((CHAR*)dpkvalue,0),ACTSIZ);
     stzcpy(action.name,itemidx((CHAR*)dpkvalue,1),ACTSIZ);
     stlcpy(action.actkey,itemidx((CHAR*)dpkvalue,2),KEYSIZ);
     stlcpy(action.simple, FormatActionMsg(itemidx((CHAR*)dpkvalue,3), TRUE)
      ,RESSIZ);
     stlcpy(action.complx, FormatActionMsg(itemidx((CHAR*)dpkvalue,4), TRUE)
      ,RESSIZ);
     stlcpy(action.resp, FormatActionMsg(itemidx((CHAR*)dpkvalue,5), TRUE)
      ,RESSIZ);

     if ((pList=tlcAPI->actGetByName(action.list)) != NULL && !pList->IsDeleted()) {
          if (pList->wordExists(action.name) == NULL) {
               // create action
               rsp2write(!addact(&action),0,NULL,NULL);
          }
          else {
               // modify action
               rsp2write(!chgact(&action),0,NULL,NULL);
          }
     }
     else {
          // list not found
          rejectreq();
     }
}

VOID
dpkw_setchan(VOID)                 //  Set current channel Info
{
     CTlcChannel* pChannel;
     CHANINFO cinfo;
     GBOOL oper=FALSE;
     GBOOL addchan=FALSE;
     GBOOL mod=FALSE;

     memset(&cinfo,0,sizeof(CHANINFO));
     if (dpkUser->IsTypeOf(USR_OPERATOR)) {
          oper=TRUE;
     }
     if ((pChannel=tlcAPI->chanGetByName(itemidx((CHAR*)dpkvalue,0))) == NULL) {
          addchan=TRUE;
     }
     else {
          LPCHANINFO pCurInfo=pChannel->GetConfig();
          memmove(&cinfo,pCurInfo,sizeof(CHANINFO));
     }
     if (dpkUser->IsTypeOf(USR_MODERATOR)
      || (pChannel != NULL && pChannel->CanAccess(dpkUser,CHAN_AXS_MODERATOR))) {
          mod=TRUE;
     }
     if ((!mod && !oper) || (!oper && addchan)) {
          rejectreq();
          return;
     }
     else if (oper) {
          if (addchan) {
               stlcpy(cinfo.m_strName,itemidx((CHAR*)dpkvalue,0),CHAN_MAX_SIZE);
          }
          stlcpy(cinfo.m_keyVis,itemidx((CHAR*)dpkvalue,2),KEYSIZ);
          stlcpy(cinfo.m_keyJoin,itemidx((CHAR*)dpkvalue,3),KEYSIZ);
          stlcpy(cinfo.m_keySpeak,itemidx((CHAR*)dpkvalue,4),KEYSIZ);
          stlcpy(cinfo.m_keyByPass,itemidx((CHAR*)dpkvalue,5),KEYSIZ);
          stlcpy(cinfo.m_keyMod,itemidx((CHAR*)dpkvalue,6),KEYSIZ);
          stlcpy(cinfo.m_actList1,itemidx((CHAR*)dpkvalue,7),LISTSIZ);
          stlcpy(cinfo.m_actList2,itemidx((CHAR*)dpkvalue,8),LISTSIZ);
          if (sameas(itemidx((CHAR*)dpkvalue,9),"YES")) {
               cinfo.m_flags|=CHAN_FLAG_PROFOK;
          }
          else {
               cinfo.m_flags&=~CHAN_FLAG_PROFOK;
          }
          if (sameas(itemidx((CHAR*)dpkvalue,10),"NO")) {
               cinfo.m_flags|=CHAN_FLAG_NOENTMESSAGE;
          }
          else {
               cinfo.m_flags&=~CHAN_FLAG_NOENTMESSAGE;
          }
     }
     stlcpy(cinfo.m_strTopic,itemidx((CHAR*)dpkvalue,1),CHAN_MAX_TOPIC_SIZE);
     if (sameas(itemidx((CHAR*)dpkvalue,11),"YES")) {
          cinfo.m_flags|=CHAN_FLAG_CLOSED;
     }
     else {
          cinfo.m_flags&=~CHAN_FLAG_CLOSED;
     }
     if (addchan) {
          SHORT retval;
          if (!chkalph(itemidx((CHAR*)dpkvalue,0))) {
               strcat(rsptmp,"Must be alphanumeric!");
          }
          else if ((retval=tlcChannelCreateLocal(&cinfo,TRUE)) != CHAN_CREATE_OK) {
               if (retval&CHAN_CHNTOOLONG) {
                    strcat(rsptmp,"Channel too long");
               }
               if (retval&
                 (CHAN_VISTOOLONG|CHAN_JOINTOOLONG|CHAN_JOINTOOLONG|
                  CHAN_SPEAKTOOLONG|CHAN_BYPASSTOOLONG|CHAN_MODTOOLONG)) {
                    strcat(rsptmp,"Key Name too long");
               }
               if (retval&CHAN_TOPTOOLONG) {
                    strcat(rsptmp,"Topic too long");
               }
               if (retval&CHAN_API_CREATE_ERR) {
                    strcat(rsptmp,"Tele API error creating channel");
               }
               rsp2write(FALSE,STGLEN,rsptmp,NULL);
          }
          else {
               rsp2write(TRUE,0,NULL,NULL);
          }
     }
     else if (pChannel->GetType()&CHAN_TYPE_NOEDIT) {
          rejectreq();
     }
     else {
          GBOOL retval=pChannel->Update(&cinfo);
          pChannel->Save();
          rsp2write(retval,0,NULL,NULL);
     }
}

VOID
dpkw_delchan(VOID)                 //  Delete a channel
{
     CTlcChannel* pChannel;

     if ((pChannel=tlcAPI->chanGetByName((CHAR*)dpkvalue)) != NULL) {
          if (!(pChannel->GetType()&CHAN_TYPE_NOEDIT)) {
               tlcAPI->chanMoveAllUsers(pChannel->GetName()
                                       ,dftchan,CHAN_SWITCH_DELETED
                                       ,SCMSG_CHAN_DELETE);
               rsp2write(tlcAPI->chanRemoveByName((CHAR*)dpkvalue,TRUE),0,NULL,NULL);
               return;
          }
     }
     rejectreq();
}

VOID
dpkw_newu(VOID)                    //  New user entered
{
     const CHAR* lastchan=aachat[usrnum].lastchannel;
     if (dpkUser) {
          rsp2write(FALSE,STGLEN,spr("%d",FALSE),NULL);
     }
     else {
          CreateCSUser();
          if (*lastchan != '\0'
           && tlcAPI->chanGetByName(lastchan) != NULL
           && haskey(tlcAPI->chanGetByName(lastchan)->GetKey(CHAN_AXS_JOIN))) {
               rsp2write(TRUE,STGLEN,const_cast<CHAR*>(lastchan),NULL);
          }
          else if (dftchan[0] != '\0' && !sameas(dftchan,mainchan)
           && tlcAPI->chanGetByName(dftchan) != NULL
           && haskey(tlcAPI->chanGetByName(dftchan)->GetKey(CHAN_AXS_JOIN))) {
               rsp2write(TRUE,STGLEN,dftchan,NULL);
          }
          else if (haskey(tlcAPI->chanGetByName(mainchan)->GetKey(CHAN_AXS_JOIN))) {
               rsp2write(TRUE,STGLEN,spr("%d",VBTRUE),NULL);
          }
          else {
               rsp2write(TRUE,STGLEN,tlcPrivateFromUser(usaptr->userid),NULL);
          }
     }
}

VOID
dpkw_exit(VOID)                    //  User exited
{
     if (dpkUser != NULL) {
          if (dpkUser->m_fFlags&USR_CHATTING) {
               ExitChat(FALSE,dpkUser->GetChatUser(),FALSE);
          }
          if (sameas(dpkUser->GetChannelName(),"")) {
               dpkUser->SaveRecord();
               tlcAPI->usrDelete(dpkUser);
          }
          else {
               stlcpy(aachat[usrnum].lastchannel
                     ,dpkUser->GetChannelName(),CHAN_MAX_SIZE);
               dpkChannel=tlcAPI->chanGetByName(dpkUser->GetChannelName());
               transCS->RemoveUser(dpkUser);
               dpkUser->SaveRecord();
               dpkChannel->RemoveUser(dpkUser,LEAVE_TLC);
          }
     }
     rsp2write(TRUE,0,NULL,NULL);
}

VOID
dpkw_talk(VOID)                    //  User talked
{
     if (dpkUser == NULL || dpkChannel == NULL) {
          rsp2write(FALSE,STGLEN,TALK_E_NOCHN,NULL);
          return;
     }
     SHORT spd=curUser->IsTalkingTooFast();
     if (!dpkChannel->CommandParse(static_cast<CHAR*>(dpkvalue),
      dpkUser->GetName())) {
          if (!tlcAPI->Parse(static_cast<CHAR*>(dpkvalue),
           dpkUser->GetName(),curChannel)) {
               if (!dpkChannel->ActionParse(static_cast<CHAR*>(dpkvalue),
                dpkUser->GetName())) {
                    if (usrptr->flags&INVISB) {
                         prfmsg(URINVS2);
                         tlcreflow(prfbuf);
                         transCS->Output(dpkUser);
                         rejectreq();
                    }
                    else if (dpkUser->m_fFlags&USR_SQUELCH) {
                         prfmsg(SQLRBF3);
                         tlcreflow(prfbuf);
                         transCS->Output(dpkUser);
                         rejectreq();
                    }
                    else if (!dpkUser->IsTypeOf(USR_NORMAL)
                     && dpkUser->m_iTimesSpoken >= tlcAPI->m_npaymx) {
                         prfmsg(NPAYXC2,tlcAPI->m_npaymx);
                         tlcreflow(prfbuf);
                         transCS->Output(dpkUser);
                         rejectreq();
                    }
                    else if (spd == USR_SPEED_TOOFAST) {
                         prfmsg(TOOFAST);
                         tlcreflow(prfbuf);
                         transCS->Output(dpkUser);
                         rejectreq();
                    }
                    else if (spd == USR_SPEED_DROP) {
                         byenow(TOOANOY);
                    }
                    else {
                         SHORT prof;
                         strcpy(input,(CHAR*)dpkvalue);
                         CHAR* pfch=strdup(input);
                         (*setpfn)(stpans(pfch));
                         free(pfch);
                         parsin();
                         if ((prof=chk4pfn()) == HANGUP) {
                              prf("Disconnecting");
                              transCS->Output(dpkUser);
                              rejectreq();
                              btuinj(usrnum,RING);
                         }
                         else if (prof) {
                              tlcreflow(prfbuf);
                              transCS->Output(dpkUser);
                              rejectreq();
                         }
                         else if (strlen(input) == 0) {
                              dpkChannel->SendWelcome(dpkUser);
                              rsp2write(TRUE,0,NULL,NULL);
                         }
                         else {
                              dpkUser->CmdResult(CMD_SPEAK,TRUE,0);
                              dpkChannel->PublicSend(usaptr->userid,NULL,
                                 static_cast<CHAR*>(dpkvalue),0,0);
                              rsp2write(TRUE,0,NULL,NULL);
                         }
                    }
                    clrprf();
               }
               else {
                    rsp2write(TRUE,0,NULL,NULL);
               }
          }
          else {
               rsp2write(TRUE,0,NULL,NULL);
          }
     }
     else {
          rsp2write(TRUE,0,NULL,NULL);
     }
}

VOID
dpkw_join(VOID)                    //  Join a channel
{
     if (dpkUser == NULL) {
          rsp2write(FALSE,STGLEN,JOIN_E_NOTLC,NULL);
     }
     else {
          GBOOL joinpriv=FALSE;
          CHAR* chanName=static_cast<CHAR*>(dpkvalue);
          CTlcChannel* pNewChan;
          CTlcPrivateChannel* pPrivate;

          switch (tlcAPI->chanCheckPrivate(chanName,&pNewChan)) {
          case CHAN_PRIVATE_FOUND:
               ASSERT(pNewChan != NULL);
               pPrivate=dynamic_cast<CTlcPrivateChannel*>(pNewChan);
               // check invite status
               if (sameas(dpkUser->GetName(),pPrivate->GetOwner())
                    || dpkUser->IsTypeOf(USR_OPERATOR)
                    || pPrivate->CheckInvite(dpkUser)) {
                    joinpriv=TRUE;
                    break;
               }
               else {
                    prfmsg(NOTINV2,pPrivate->GetOwner());
                    tlcreflow(prfbuf);
                    r2wprf(FALSE);
                    rstmbk();
                    return;
               }
          }
          if (!joinpriv) {
               if ((pNewChan=tlcAPI->chanCheckPub(chanName)) == NULL) {
                    prfmsg(NAXSCHN2);
                    tlcreflow(prfbuf);
                    r2wprf(FALSE);
                    rstmbk();
                    return;
               }
               if (dpkChannel != NULL
                && (dpkChannel->GetType()&CHAN_TYPE_FORUM)
                && !tlcAPI->m_bForSameChg && !tlcAPI->m_bSwitFor) {
                    prfmsg(CANTEX2);
                    tlcreflow(prfbuf);
                    r2wprf(FALSE);
                    rstmbk();
                    return;
               }
               if ((pNewChan->GetType()&CHAN_TYPE_FORUM)
                && !tlcAPI->m_bForSameChg && !tlcAPI->m_bSwitFor) {
                    prfmsg(CANTJN2);
                    tlcreflow(prfbuf);
                    r2wprf(FALSE);
                    rstmbk();
                    return;
               }
               if (!pNewChan->CanAccess(dpkUser,CHAN_AXS_JOIN)
                || pNewChan->m_flags&CHAN_FLAG_CLOSED) {
                    if (!(pNewChan->CanAccess(dpkUser,CHAN_AXS_MODERATOR)
                     || dpkUser->IsTypeOf(USR_MODERATOR))) {
                         prfmsg(NAXSCHN2);
                         tlcreflow(prfbuf);
                         r2wprf(FALSE);
                         rstmbk();
                         return;
                    }
               }
          }
          if (curChannel == NULL || !sameas(curChannel->GetName(),pNewChan->GetName())) {
               if (dpkUser->IsSwitchingTooFast()) {
                   prfmsg(NANNOY);
                   tlcreflow(prfbuf);
                   r2wprf(FALSE);
               }
               else {
                    dpkUser->m_fFlags|=USR_INCHAN;
                    dpkUser->Switched();
                    if (pNewChan->AddUser(dpkUser,curChannel == NULL ? TRUE : FALSE)) {
                         if (curChannel != NULL) {
                              curChannel->RemoveUser(dpkUser);
                         }
                         else {
                              tlcAPI->usrDelete(dpkUser);
                         }
                    }
                    rsp2write(TRUE,0,NULL,NULL);
               }
          }
          else {
               // already in channel
               prfmsg(ALRCHN2);
               tlcreflow(prfbuf);
               r2wprf(FALSE);
          }
     }
}

VOID
dpkw_addpal(VOID)                  //  Add a pal to your list
{
     CHAR* user=static_cast<CHAR*>(dpkvalue);
     INT cnt=0;
     PALDSK pdsk;
     memset(&pdsk,0,sizeof(PALDSK));
     stzcpy(pdsk.pszUserid,usaptr->userid,UIDSIZ);
     dfaSetBlk(dfaPal);
     if (dfaAcqGT(&pdsk,&pdsk,0)) {
          do {
               if (!sameas(pdsk.pszUserid,usaptr->userid)) {
                    break;
               }
               cnt++;
          } while (dfaAcqNX(&pdsk));
     }
     if (cnt < pmax) {
          stzcpy(pdsk.pszUserid,usaptr->userid,UIDSIZ);
          stzcpy(pdsk.pszPal,user,TLCUIDSIZ);
          if (!dfaQueryEQ(&pdsk,0)) {
               dfaInsert(&pdsk);
          }
          rsp2write(TRUE,0,NULL,NULL);
     }
     else {
          rejectreq();
     }
     dfaRstBlk();
}

VOID
dpkw_rempal(VOID)                  //  Remove a pal from the list
{
     CHAR* user=static_cast<CHAR*>(dpkvalue);
     PALDSK pdsk;
     memset(&pdsk,0,sizeof(PALDSK));
     stzcpy(pdsk.pszUserid,usaptr->userid,UIDSIZ);
     stzcpy(pdsk.pszPal,user,TLCUIDSIZ);
     dfaSetBlk(dfaPal);
     if (dfaAcqEQ(NULL,&pdsk,0)) {
          dfaDelete();
     }
     dfaRstBlk();
     rsp2write(TRUE,0,NULL,NULL);
}

VOID
dpkw_setprof(VOID)                 //  Set teleconference profile
{
     ENTCHG ec;
     CHAR* item;
     CHAR* inpt;
     SHORT prfnum;

     inpt=static_cast<CHAR*>(dpkvalue);
     item=itemidx(inpt,0);
     if (sameas(item,"Private")) {
          dpkUser->SetDefaultChan(CHANDFT_PRIVATE);
     }
     else {
          dpkUser->SetDefaultChan(CHANDFT_MAIN);
     }
     item=itemidx(inpt,5);
     if (sameas(item,"YES")) {
          if (dpkUser->m_fFlags&USR_NOACTIONS) {
               dpkUser->m_fFlags&=~USR_NOACTIONS;
               dpkUser->CmdResult(CMD_ACTION,TRUE,CMD_ACTION_ON);
          }
     }
     else {
          if (!(dpkUser->m_fFlags&USR_NOACTIONS)) {
               dpkUser->m_fFlags|=USR_NOACTIONS;
               dpkUser->CmdResult(CMD_ACTION,TRUE,CMD_ACTION_OFF);
          }
     }
     item=itemidx(inpt,1);
     if (dpkUser->GetChatInterval() != atoi(item)) {
          SHORT interval;
          SHORT retval;
          interval=(SHORT)atoi(item);
          if ((retval=dpkUser->SetChatInterval(interval)) != interval) {
               switch(retval) {
               case INTERVAL_TOO_HIGH:
                    rsp2write(FALSE,STGLEN,
                         "The Chat interval you entered is too high!",NULL);
                    break;
               case INTERVAL_TOO_LOW:
                    rsp2write(FALSE,STGLEN,
                         "The Chat interval you entered is too high!",NULL);
                    break;
               }
               return;
          }
     }
     item=itemidx(inpt,2);
     if (dpkUser->CheckAccess(rawmsg(TOPKEY))) {
          dpkUser->SetPrivateTopic(item);
     }
     else if (*item != '\0' || !(sameas(item,dpkUser->GetPrivateTopic()))) {
          rsp2write(FALSE,STGLEN,"You don't have access to change your topic!",NULL);
          return;
     }
     memset(&ec,0,sizeof(ENTCHG));
     ec.text=itemidx(inpt,3);
     if (*(ec.text) == '\0') {
          dpkUser->SetEntrance("",MSG_REQUESTED);
          dpkUser->SetEntrance("",MSG_CURRENT);
     }
     else if (!sameas(ec.text,dpkUser->GetEntrance(MSG_REQUESTED))
      && !sameas(ec.text,dpkUser->GetEntrance(MSG_CURRENT)))      {
          ec.msg=REQENT3;
          prfnum=CSEntExit(dpkUser,&ec);
          switch (prfnum) {
          case OKSET2:
               prfmsg(OKSET2);
               tlcreflow(prfbuf);
               r2wprf(TRUE);
               break;
          case OKSETAT2:
               prfmsg(OKSETAT2);
               tlcreflow(prfbuf);
               r2wprf(TRUE);
               break;
          case YOUUPD3:
               prfmsg(YOUUPD3,tlcAPI->m_iEMsgChg);
               tlcreflow(prfbuf);
               r2wprf(TRUE);
               break;
          case CNTAFT2:
               prfmsg(CNTAFT2,"you");
               tlcreflow(prfbuf);
               r2wprf(FALSE);
               break;
          case REQACC:
               prfmsg(REQACC);
               tlcreflow(prfbuf);
               r2wprf(FALSE);
               break;
          default:
               break;
          }
          if (ec.responded) {
               return;
          }
     }
     ec.text=itemidx(inpt,4);
     if (*(ec.text) == '\0') {
          dpkUser->SetExit("",MSG_REQUESTED);
          dpkUser->SetExit("",MSG_CURRENT);
     }
     else if (!sameas(ec.text,dpkUser->GetExit(MSG_REQUESTED))
      && !sameas(ec.text,dpkUser->GetExit(MSG_CURRENT)))      {
          ec.msg=REQEXT3;
          prfnum=CSEntExit(dpkUser,&ec);
          switch (prfnum) {
          case OKSET2:
               prfmsg(OKSET2);
               tlcreflow(prfbuf);
               r2wprf(TRUE);
               break;
          case OKSETAT2:
               prfmsg(OKSETAT2);
               tlcreflow(prfbuf);
               r2wprf(TRUE);
               break;
          case YOUUPD3:
               prfmsg(YOUUPD3,tlcAPI->m_iEMsgChg);
               tlcreflow(prfbuf);
               r2wprf(TRUE);
               break;
          case CNTAFT2:
               prfmsg(CNTAFT2,"you");
               tlcreflow(prfbuf);
               r2wprf(FALSE);
               break;
          case REQACC:
               prfmsg(REQACC);
               tlcreflow(prfbuf);
               r2wprf(FALSE);
               break;

          default:
               break;
          }
          return;
     }
     rsp2write(TRUE,STGLEN,"",NULL);
}

VOID
dpkw_dbstart(VOID)                 //  Drawing board start
{
     if (dpkUser == NULL || dpkUser->m_fFlags&USR_DBOARD) {
          rejectreq();
     }
     else if (!(dpkUser->m_fFlags&USR_INVISB)) {
          curChannel->ToggleDb(dpkUser,TRUE);
          rsp2write(TRUE,STGLEN,"ok",NULL);
     }
     else {
          rejectreq();
     }
}


VOID
dpkw_dbstop(VOID)                  //  Drawing board stop
{
     if (dpkUser == NULL || !(dpkUser->m_fFlags&USR_DBOARD)) {
          rejectreq();
          return;
     }
     dpkUser->m_fFlags&=~USR_DBOARD;
     if (!(dpkUser->m_fFlags&USR_INVISB)) {
          curChannel->ToggleDb(dpkUser,FALSE);
     }
     rsp2write(TRUE,STGLEN,"ok",NULL);
}

VOID
dpkw_dbdata(VOID)                  //  Drawing board data received
{
     if (dpkUser == NULL  || !(dpkUser->m_fFlags&USR_DBOARD)
      || (dpkUser->m_fFlags&USR_INVISB)) {
          rejectreq();
     }
     else if (dpkvalue != NULL && dpkChannel != NULL) {
          dpkChannel->SendTabbedDbData(static_cast<CHAR*>(dpkvalue));
          rsp2write(TRUE,STGLEN,"ok",NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkw_squel(VOID)                   //  Squelch a person
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));

     if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     else if (dpkUser->IsTypeOf(USR_MODERATOR)) {
          strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
          if (pOthUser != NULL) {
               if (sameas(pOthUser->GetName(),dpkUser->GetName())) {
                    dpkUser->CmdResult(CMD_SQUELCH,FALSE,CMD_SQUELCH_NOSELF);
                    rsp2write(FALSE,STGLEN,"noself",NULL);
               }
               else if (pOthUser->IsTypeOf(USR_MODERATOR)
                && !(dpkUser->IsTypeOf(USR_OPERATOR))) {
                    dpkUser->CmdResult(CMD_SQUELCH,FALSE,CMD_SQUELCH_MODERATOR);
                    rsp2write(FALSE,STGLEN,"moderator",NULL);
               }
               else {
                    stzcpy((CHAR*)tlcwrk,pOthUser->GetName(),TLCUIDSIZ);
                    if (pOthUser->m_fFlags&USR_SQUELCH) {
                         dpkUser->CmdResult(CMD_SQUELCH,FALSE,CMD_SQUELCH_ALRDY);
                         rsp2write(FALSE,STGLEN,"already",NULL);
                    }
                    else {
                         pOthUser->m_fFlags|=USR_SQUELCH;
                         dpkUser->CmdResult(CMD_SQUELCH,TRUE,0);
                         CTlcUser* pNotifyUser=pNotifyUser=tlcAPI->usrGetFirst();
                         while (pNotifyUser != NULL) {
                              cschgstatus(pNotifyUser,pOthUser);
                              pNotifyUser=tlcAPI->usrGetNext();
                         }
                         rsp2write(TRUE,STGLEN,"ok",NULL);
                    }
               }
          }
          else {
               dpkUser->CmdResult(CMD_SQUELCH,FALSE,CMD_SQUELCH_NOSUCH);
               rsp2write(FALSE,STGLEN,"notfnd",NULL);
          }
     }
     else {
          rsp2write(FALSE,STGLEN,"noacs",NULL);
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_unsquel(VOID)                 //  Unsquelch a person
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));

     if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     else if (dpkUser->IsTypeOf(USR_MODERATOR)) {
          strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
          if (pOthUser != NULL) {
               pOthUser->m_fFlags&=~USR_SQUELCH;
               dpkUser->CmdResult(CMD_UNSQUELCH,TRUE,0);
               CTlcUser* pNotifyUser=pNotifyUser=tlcAPI->usrGetFirst();
               while (pNotifyUser != NULL) {
                    cschgstatus(pNotifyUser,pOthUser);
                    pNotifyUser=tlcAPI->usrGetNext();
               }
               rsp2write(TRUE,STGLEN,"ok",NULL);
          }
          else {
               dpkUser->CmdResult(CMD_UNSQUELCH,FALSE,CMD_UNSQUELCH_NOSUCH);
               rsp2write(FALSE,STGLEN,"notfnd",NULL);
          }
     }
     else {
          rsp2write(FALSE,STGLEN,"noacs",NULL);
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }

}

VOID
dpkw_invite(VOID)                  //  Invite someone
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));

     if (!dpkUser->CheckAccess(rawmsg(INVKEY))) {
          dpkUser->CmdResult(CMD_INVITE,FALSE,CMD_INVITE_NOACS);
          rsp2write(FALSE,STGLEN,"noacs",NULL);
     }
     else if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     else {
          strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
          if (pOthUser != NULL) {
               if (dpkUser->CheckInvite(pOthUser)) {
                    dpkUser->CmdResult(CMD_INVITE,FALSE,CMD_INVITE_ALRDY);
                    rsp2write(FALSE,STGLEN,"already",NULL);
               }
               else if (!(pOthUser->GetTransport()->m_fFlags&TRANS_IMPLPRIV)) {
                    strcat((CHAR*)tlcwrk,"\t");
                    strcat((CHAR*)tlcwrk,pOthUser->GetTransport()->GetName());
                    dpkUser->CmdResult(CMD_INVITE,FALSE,CMD_INVITE_CANT);
                    rsp2write(FALSE,STGLEN,"noinvite",NULL);
               }
               else {
                    dpkUser->ToggleInvite(pOthUser);
                    stlcpy((CHAR*)tlcwrk,dpkUser->GetName(),TLCUIDSIZ);
                    pOthUser->CmdResult(CMD_INVITE,TRUE,CMD_INVITE_NOTIFY);
                    stlcpy((CHAR*)tlcwrk,pOthUser->GetName(),TLCUIDSIZ);
                    dpkUser->CmdResult(CMD_INVITE,TRUE,0);
                    if (pOthUser->GetUsrnum() > -1) {
                        CTlcChannel* pChannel=tlcAPI->chanGetByName(tlcPrivateFromUser(dpkUser->GetName()));
                        csnotaddchan(pChannel,pOthUser->GetUsrnum());
                    }
                    rsp2write(TRUE,STGLEN,"ok",NULL);
               }
          }
          else {
               dpkUser->CmdResult(CMD_INVITE,FALSE,CMD_INVITE_NOSUCH);
               rsp2write(FALSE,STGLEN,"notfnd",NULL);
          }
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_uninvite(VOID)                //  Uninvite someone
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));
     strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
     if (pOthUser != NULL) {
          if (!dpkUser->CheckInvite(pOthUser)) {
               dpkUser->CmdResult(CMD_UNINVITE,FALSE,CMD_UNINVITE_NOTINV);
               rsp2write(FALSE,STGLEN,"already",NULL);
          }
          else {
               CTlcChannel *dpkChannel, *pNewChan;
               CTlcUser* pNewUser;
               dpkUser->ToggleInvite(pOthUser);
               tlcAPI->chanCheckPrivate(dpkUser->GetName(),&dpkChannel);
               if (sameas(dpkChannel->GetName(),pOthUser->GetChannelName())) {
                    pOthUser->CmdResult(CMD_UNINVITE,TRUE,CMD_UNINVITE_KICK);
                    if ((pNewChan=tlcAPI->chanGetByName(dftchan)) == NULL) {
                         pNewChan=tlcAPI->chanGetByName(mainchan);
                    }
                    pNewChan->AddUser(pOthUser);
                    pNewUser=tlcAPI->chanFindUser(pNewChan->GetName(),pOthUser->GetName());
                    dpkChannel->RemoveUser(pOthUser,LEAVE_PRIV_KICK);
                    pNewUser->CmdResult(CMD_JOIN,TRUE,0);
                    dpkUser->CmdResult(CMD_UNINVITE,TRUE,CMD_UNINVITE_MYKICK);
                    rsp2write(TRUE,STGLEN,"kicked",NULL);
               }
               else {
                    stzcpy((CHAR*)tlcwrk,pOthUser->GetName(),TLCUIDSIZ);
                    dpkUser->CmdResult(CMD_UNINVITE,TRUE,CMD_UNINVITE_MYUNINV);
                    rsp2write(TRUE,STGLEN,"ok",NULL);
               }
               if (pOthUser->GetUsrnum() > -1) {
                    CTlcChannel* pChannel=tlcAPI->chanGetByName(tlcPrivateFromUser(dpkUser->GetName()));
                    csnotdelchan(pChannel,pOthUser->GetUsrnum());
               }
          }
     }
     else {
          dpkUser->CmdResult(CMD_UNINVITE,FALSE,CMD_UNINVITE_NOSUCH);
          rsp2write(FALSE,STGLEN,"notfnd",NULL);
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_forget(VOID)                  //  Forget someone
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));

     if (!dpkUser->CheckAccess(rawmsg(FGTKEY))) {
          dpkUser->CmdResult(CMD_FORGET,FALSE,CMD_FORGET_NOACS);
          rsp2write(FALSE,STGLEN,"noacs",NULL);
     }
     else if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     else {
          strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
          if (pOthUser != NULL) {
               if (dpkUser->CheckForget(pOthUser)) {
                    dpkUser->CmdResult(CMD_FORGET,FALSE,CMD_FORGET_ALRDY);
                    rsp2write(FALSE,STGLEN,"already",NULL);
               }
               else if (sameas(pOthUser->GetName(),dpkUser->GetName())) {
                    dpkUser->CmdResult(CMD_FORGET,FALSE,CMD_FORGET_NOSELF);
                    rsp2write(FALSE,STGLEN,"noself",NULL);
               }
               else if (pOthUser->IsTypeOf(USR_MODERATOR)
                && !(dpkUser->IsTypeOf(USR_OPERATOR))) {
                    dpkUser->CmdResult(CMD_FORGET,FALSE,CMD_FORGET_MODERATOR);
                    rsp2write(FALSE,STGLEN,"moderator",NULL);
               }
               else if (pOthUser->CheckAccess(rawmsg(NFGTKEY))
                && !(dpkUser->IsTypeOf(USR_MODERATOR))) {
                    dpkUser->CmdResult(CMD_FORGET,FALSE,CMD_FORGET_NOFORGET);
                    rsp2write(FALSE,STGLEN,"noforget",NULL);
               }
               else {
                    dpkUser->ToggleForget(pOthUser);
                    if (dpkUser->CheckInvite(pOthUser)) {
                         CTlcChannel *pNewChan, *dpkChannel;
                         dpkUser->ToggleInvite(pOthUser);
                         tlcAPI->chanCheckPrivate(dpkUser->GetName(),&dpkChannel);
                         if (sameas(dpkChannel->GetName(),pOthUser->GetChannelName())) {
                              CTlcUser* pNewUser;
                              pOthUser->CmdResult(CMD_UNINVITE,TRUE,CMD_UNINVITE_KICK);
                              if ((pNewChan=tlcAPI->chanGetByName(dftchan)) == NULL) {
                                   pNewChan=tlcAPI->chanGetByName(mainchan);
                              }
                              pNewChan->AddUser(pOthUser);
                              pNewUser=tlcAPI->chanFindUser(pNewChan->GetName(),pOthUser->GetName());
                              dpkChannel->RemoveUser(pOthUser,LEAVE_PRIV_KICK);
                              pNewUser->CmdResult(CMD_JOIN,TRUE,0);
                              rsp2write(TRUE,STGLEN,"kicked",NULL);
                         }
                         else {
                              dpkUser->CmdResult(CMD_FORGET,TRUE,0);
                              rsp2write(TRUE,STGLEN,"ok",NULL);
                         }
                         if (pOthUser->GetUsrnum() > -1) {
                              CTlcChannel* pChannel=tlcAPI->chanGetByName(tlcPrivateFromUser(dpkUser->GetName()));
                              csnotdelchan(pChannel,pOthUser->GetUsrnum());
                         }
                    }
                    else {
                         dpkUser->CmdResult(CMD_FORGET,TRUE,0);
                         rsp2write(TRUE,STGLEN,"ok",NULL);
                    }
               }
          }
          else {
               dpkUser->CmdResult(CMD_FORGET,FALSE,CMD_FORGET_NOSUCH);
               rsp2write(FALSE,STGLEN,"notfnd",NULL);
          }
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_ignore(VOID)                  //  Ignore someone
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));

     if (!dpkUser->CheckAccess(rawmsg(IGNKEY))) {
          dpkUser->CmdResult(CMD_IGNORE,FALSE,CMD_IGNORE_NOACS);
          rsp2write(FALSE,STGLEN,"noacs",NULL);
     }
     else if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     else {
          strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
          if (pOthUser != NULL) {
               if (dpkUser->CheckIgnore(pOthUser)) {
                    dpkUser->CmdResult(CMD_IGNORE,FALSE,CMD_IGNORE_ALRDY);
                    rsp2write(FALSE,STGLEN,"already",NULL);
               }
               else if (sameas(pOthUser->GetName(),dpkUser->GetName())) {
                    dpkUser->CmdResult(CMD_IGNORE,FALSE,CMD_IGNORE_NOSELF);
                    rsp2write(FALSE,STGLEN,"noself",NULL);
               }
               else if (pOthUser->IsTypeOf(USR_MODERATOR)
                    && !dpkUser->IsTypeOf(USR_OPERATOR)) {
                    stzcpy((CHAR*)tlcwrk,pOthUser->GetName(),TLCUIDSIZ);
                    dpkUser->CmdResult(CMD_IGNORE,FALSE,CMD_IGNORE_NOSYS);
                    rsp2write(FALSE,STGLEN,"moderator",NULL);
               }
               else {
                    dpkUser->ToggleIgnore(pOthUser);
                    dpkUser->CmdResult(CMD_IGNORE,TRUE,0);
                    rsp2write(TRUE,STGLEN,"ok",NULL);
               }
          }
          else {
               dpkUser->CmdResult(CMD_IGNORE,FALSE,CMD_IGNORE_NOSUCH);
               rsp2write(FALSE,STGLEN,"notfnd",NULL);
          }
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_remember(VOID)                //  Remember someone
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));
     strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
     if (pOthUser != NULL) {
          if (dpkUser->CheckForget(pOthUser)) {
               dpkUser->ToggleForget(pOthUser);
               dpkUser->CmdResult(CMD_REMEMBER,TRUE,0);
               rsp2write(TRUE,STGLEN,"ok",NULL);
          }
          else {
               dpkUser->CmdResult(CMD_REMEMBER,FALSE,CMD_REMEMBER_NOTFGT);
               rsp2write(FALSE,STGLEN,"already",NULL);
          }
     }
     else {
          dpkUser->CmdResult(CMD_REMEMBER,FALSE,CMD_REMEMBER_NOSUCH);
          rsp2write(FALSE,STGLEN,"notfnd",NULL);
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_notice(VOID)                  //  Notice someone
{
     CTlcUser* pOthUser;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));
     strcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue);
     if (pOthUser != NULL) {
          if (dpkUser->CheckIgnore(pOthUser)) {
               dpkUser->ToggleIgnore(pOthUser);
               dpkUser->CmdResult(CMD_NOTICE,TRUE,0);
               rsp2write(TRUE,STGLEN,"ok",NULL);
          }
          else {
               dpkUser->CmdResult(CMD_NOTICE,FALSE,CMD_NOTICE_NOTIGN);
               rsp2write(FALSE,STGLEN,"already",NULL);
          }
     }
     else {
          dpkUser->CmdResult(CMD_NOTICE,FALSE,CMD_NOTICE_NOSUCH);
          rsp2write(FALSE,STGLEN,"notfnd",NULL);
     }
     if (pOthUser != NULL) {
          cschgstatus(dpkUser,pOthUser);
     }
}

VOID
dpkw_chat(VOID)                    //  Chat with someone
{
     CHAR* msg;
     CTlcUser* pUser;
     msg=static_cast<CHAR*>(dpkvalue);
     if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     else if ((pUser=tlcAPI->usrGetByName(dpkUser->GetChatUser())) != NULL
        && sameas(pUser->GetChatUser(),dpkUser->GetName())
        && pUser->m_fFlags&USR_CHATTING
        && dpkUser->m_fFlags&USR_CHATTING) {
          if (*((CHAR*)dpkvalue) != 'x' && *((CHAR*)dpkvalue) != 'X') {
               pUser->OnRecvText(dpkUser->GetName(),NULL,msg,RECV_TYPE_CHATMSG);
               rsp2write(TRUE,STGLEN,"sent",NULL);
               return;
          }
          ExitChat(FALSE,dpkUser->GetName(),TRUE);
          rsp2write(TRUE,STGLEN,"sent",NULL);
     }
     else {
          rejectreq();
     }
}

VOID
dpkw_reqchat(VOID)                 //  Request chat with someone
{
     CTlcWhisInf* pWhis;
     CTlcUser* pOthUser;
     LONG t;

     if (!dpkUser->CheckAccess(rawmsg(CHTKEY))) {
          rejectreq();
          return;
     }
     else if (dpkUser->m_fFlags&USR_INVISB) {
          dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
          rsp2write(FALSE,STGLEN,"invis",NULL);
     }
     if (dpkUser->m_fFlags&USR_CHATTING) {
          dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_YOUALREADY);
          rejectreq();
          return;
     }
     pWhis=(CTlcWhisInf*)tlcwrk;
     pOthUser=tlcAPI->usrGetByName(static_cast<CHAR*>(dpkvalue));
     if (pOthUser != NULL) {
          GBOOL req=FALSE;
          strcpy(pWhis->m_strName,pOthUser->GetName());
          if (sameas(pOthUser->GetChatUser(),dpkUser->GetName())) {
               INT oth, usr;
               dpkUser->SetChatUser(pOthUser->GetName());
               usr=dpkUser->GetUsrnum();
               oth=pOthUser->GetUsrnum();
               aachat[usr].chatch=oth;
               aachat[oth].chatch=usr;
               pOthUser->ChatBegin(CHAT_ACCEPTED);
               dpkUser->ChatBegin(CHAT_START);
               req=TRUE;
          }
          else if (dpkUser->CheckAccess(rawmsg(CHTKEY))) {
               if (!(pOthUser->GetTransport()->m_fFlags&TRANS_IMPLCHAT)) {
                    strcat((CHAR*)tlcwrk,"\t");
                    strcat((CHAR*)tlcwrk,pOthUser->GetTransport()->GetName());
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_CANT);
               }
               else if (pOthUser->m_fFlags&USR_CHATTING) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_ALREADY);
               }
               else if (pOthUser->m_fFlags&USR_INVISB) {
                    dpkUser->CmdResult(CMD_SPEAK,FALSE,CMD_SPEAK_INVIS);
               }
               else if (sameas(pOthUser->GetName(),dpkUser->GetName())) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_SELF);
               }
               else if (pagesetUid(pOthUser->GetName()) == PAGE_OFF) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_NOCHAT);
               }
               else if (pageIgnoredRou(pOthUser->GetName(),dpkUser->GetName())) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_NOCHATU);
               }
               else if (!(pOthUser->m_fFlags&USR_INCHAN)) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_CANTCHAT);
               }
               else if (pOthUser->CheckForget(dpkUser)) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_FGT);
               }
               else if ((t=pOthUser->GetChatReqTime()) > 0
                    && (time(NULL) - t < pOthUser->GetChatInterval()*60)) {
                    dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_TOOSOON);
               }
               else {
                    dpkUser->SetChatUser(pOthUser->GetName());
                    pOthUser->SetChatReqTime();
                    if (dpkUser->m_fFlags&USR_NOCHAT) {
                         dpkUser->m_fFlags&=~USR_NOCHAT;
                    }
                    // notify other user of chat request.
                    pOthUser->CmdResult(CMD_CHAT,TRUE,CMD_CHAT_NOTIFY);
                    dpkUser->CmdResult(CMD_CHAT,TRUE,CMD_CHAT_NOTIFIED);
                    req=TRUE;
               }
          }
          else {
               dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_NOACCESS);
          }
          rsp2write(req,STGLEN,"",NULL);
     }
     else {
          stlcpy((CHAR*)tlcwrk,(CHAR*)dpkvalue,TLCUIDSIZ);
          dpkUser->CmdResult(CMD_CHAT,FALSE,CMD_CHAT_NOSUCH);
          rsp2write(FALSE,STGLEN,"notfnd",NULL);
     }
}

VOID
dpkw_sysedit(VOID)                 //  Sysop edit
{
     struct saunam sdpk;
     CTlcUser* pUser;
     CHAR current[EMSGSIZ];
     CHAR* item;
     GBOOL reqent, reqext;
     GBOOL chg4chg;
     GBOOL rsp=FALSE;

     reqent=reqext=FALSE;
     chg4chg=TRUE;
     if (!cnvd2s(dpkstg,&sdpk)) {
          rejectreq();
          rsp=TRUE;
     }
     else if ((pUser=tlcAPI->usrGetByName(sdpk.usrid)) != NULL) {
          stlcpy(current,itemidx((CHAR*)dpkvalue,0),EMSGSIZ);
          item=itemidx((CHAR*)dpkvalue,2);
          if (*item == '\0' && *(pUser->GetEntrance(MSG_REQUESTED)) != '\0') {
                reqent=TRUE;
          }
          stlcpy(current,itemidx((CHAR*)dpkvalue,1),EMSGSIZ);
          item=itemidx((CHAR*)dpkvalue,3);
          if (*item == '\0' && *(pUser->GetExit(MSG_REQUESTED)) != '\0') {
               reqext=TRUE;
          }
          if (reqent) {
               GBOOL retval;
               retval=chgcsmsg(pUser,itemidx((CHAR*)dpkvalue,0),REQENT3,chg4chg);
               if (retval != 0) {
                    if (retval == CNTAFT2) {
                         tlcreflow(prfbuf);
                         r2wprf(FALSE);
                         rsp=TRUE;
                    }
                    else {
                         prfmsg(URCUPD2);
                         tlcreflow(prfbuf);
                         msgchanged[pUser->GetUsrnum()]=FALSE;
                         pUser->SetChangedMsg(FALSE);
                         r2wprf(TRUE);
                         rsp=TRUE;
                    }
               }
               chg4chg=FALSE;
          }
          if (reqext) {
               GBOOL retval;
               retval=chgcsmsg(pUser,itemidx((CHAR*)dpkvalue,1),REQEXT3,chg4chg);
               if (chg4chg == TRUE && retval != 0) {
                    if (retval == CNTAFT2 && !rsp) {
                         tlcreflow(prfbuf);
                         r2wprf(FALSE);
                         rsp=TRUE;
                    }
                    else if (!rsp) {
                         prfmsg(URCUPD2);
                         msgchanged[pUser->GetUsrnum()]=FALSE;
                         pUser->SetChangedMsg(FALSE);
                         tlcreflow(prfbuf);
                         r2wprf(TRUE);
                         rsp=TRUE;
                    }
               }
               chg4chg=FALSE;
          }
          if (chg4chg) {
               item=itemidx((CHAR*)dpkvalue,0);
               if (!sameas(item,pUser->GetEntrance(MSG_CURRENT))) {
                    pUser->SetEntrance(item,MSG_CURRENT);
               }
               item=itemidx((CHAR*)dpkvalue,1);
               if (!sameas(item,pUser->GetExit(MSG_CURRENT))) {
                    pUser->SetExit(item,MSG_CURRENT);
               }
          }
          if (sameas(itemidx((CHAR*)dpkvalue,4),"YES")) {
               pUser->m_fFlags|=USR_SQUELCH;
          }
          else {
               pUser->m_fFlags&=~USR_SQUELCH;
          }
     }
     else {
          CTlcSysEdt sysedt(sdpk.usrid);
          if (sysedt.foundUser()) {
               clrprf();
               stlcpy(current,itemidx((CHAR*)dpkvalue,0),EMSGSIZ);
               item=itemidx((CHAR*)dpkvalue,2);
               if (*item == '\0' && *(sysedt.getEntrance(MSG_REQUESTED)) != '\0') {
                    reqent=TRUE;
               }
               stlcpy(current,itemidx((CHAR*)dpkvalue,1),EMSGSIZ);
               item=itemidx((CHAR*)dpkvalue,3);
               if (*item == '\0' && *(sysedt.getExit(MSG_REQUESTED)) != '\0') {
                    reqext=TRUE;
               }
               if (reqent) {
                    GBOOL retval;
                    retval=chgcsmsg(&sysedt,itemidx((CHAR*)dpkvalue,0),REQENT3,chg4chg);
                    if (retval != 0) {
                         if (retval == CNTAFT2) {
                              tlcreflow(prfbuf);
                              r2wprf(FALSE);
                              rsp=TRUE;
                         }
                         else {
                              if (onsysn(sdpk.usrid,1)) {
                                   msgchanged[othusn]=FALSE;
                              }
                              tlcreflow(prfbuf);
                              r2wprf(TRUE);
                              rsp=TRUE;
                         }
                    }
                    chg4chg=FALSE;
               }
               if (reqext) {
                    GBOOL retval;
                    retval=chgcsmsg(&sysedt,itemidx((CHAR*)dpkvalue,1),REQEXT3,chg4chg);
                    if (chg4chg == TRUE && retval != 0) {
                         if (retval == CNTAFT2 && !rsp) {
                              tlcreflow(prfbuf);
                              r2wprf(FALSE);
                              rsp=TRUE;
                         }
                         else if (!rsp) {
                              if (onsysn(sdpk.usrid,1)) {
                                   msgchanged[othusn]=FALSE;
                              }
                              tlcreflow(prfbuf);
                              r2wprf(TRUE);
                              rsp=TRUE;
                         }
                    }
                    chg4chg=FALSE;
               }
               if (chg4chg) {
                    item=itemidx((CHAR*)dpkvalue,0);
                    if (!sameas(item,sysedt.getEntrance(MSG_CURRENT))) {
                         sysedt.setEntrance(item,MSG_CURRENT);
                    }
                    item=itemidx((CHAR*)dpkvalue,1);
                    if (!sameas(item,sysedt.getExit(MSG_CURRENT))) {
                         sysedt.setExit(item,MSG_CURRENT);
                    }
               }
               if (sameas(itemidx((CHAR*)dpkvalue,4),"YES")) {
                    sysedt.setSquelched(TRUE);
               }
               else {
                    sysedt.setSquelched(FALSE);
               }
          }
          else {
               rejectreq();
               rsp=TRUE;
          }
     }
     if (!rsp) {
          rsp2write(TRUE,0,NULL,NULL);
     }
}

static SHORT                       //  Various flags
CSEntExit(                         //  Change enter/exit messages
CTlcUser* pUser,                   //  Pointer current user
LPENTCHG lpec)                     //  Pointer to entrance change structure
{
     SHORT fMsg=MSG_REQUESTED;

     if (!pUser->CheckAccess(rawmsg(REQKEY))) {
          lpec->responded=TRUE;
          return(REQACC);
     }
     if (*(lpec->text) == '\0') {
          if (lpec->msg == REQENT3) {
               pUser->SetEntrance(lpec->text,MSG_CURRENT);
               pUser->SetEntrance(lpec->text,MSG_REQUESTED);
               lpec->msg=REQEXT3;
          }
          else {
               pUser->SetExit(lpec->text,MSG_CURRENT);
               pUser->SetExit(lpec->text,MSG_REQUESTED);
               if (!lpec->responded) {
                    rsp2write(TRUE,STGLEN,"",NULL);
               }
          }
          return(0);
     }
     if (pUser->CheckAccess(rawmsg(AUTKEY))) {
          if (tlcAPI->m_bEMsgChg) {
               if (!dedcrd((LONG)tlcAPI->m_iEMsgChg,0)) {
                    lpec->responded=TRUE;
                    return(CNTAFT2);
               }
               else {
                    if (tlcAPI->m_bLogEMsg) {
                         if (!(lpec->charged)) {
                              logcrd(pUser->GetName(),tlcAPI->m_iEMsgChg);
                         }
                         fMsg=MSG_CURRENT;
                    }
               }
          }
          else {
               fMsg=MSG_CURRENT;
          }
     }
     if (lpec->msg == REQENT3) {
          pUser->SetEntrance(lpec->text,fMsg);
     }
     else {
          pUser->SetExit(lpec->text,fMsg);
     }
     if (fMsg == MSG_CURRENT) {
          if (lpec->msg == REQENT3) {
               pUser->SetEntrance("",MSG_REQUESTED);
          }
          else {
               pUser->SetExit("",MSG_REQUESTED);
          }
          if (!lpec->charged) {
               lpec->msg=REQEXT3;
               lpec->charged=TRUE;
               if (tlcAPI->m_bEMsgChg) {
                    return(YOUUPD3);
               }
               else {
                    return(OKSETAT2);
               }
          }
     }
     else if (!lpec->charged) {
          if (!msgchanged[pUser->GetUsrnum()]) {
               chgnot(pUser->GetName(),EEMNOT);
               msgchanged[pUser->GetUsrnum()]=TRUE;
          }
          lpec->charged=TRUE;
          lpec->msg=REQEXT3;
          return(OKSET2);
     }
     return(0);
}

static SHORT                       //  Various flags
chgcsmsg(                          //  Change C/S entrance/exit message
CTlcUser* pUser,                   //  Pointer to current user
CHAR* msg,                         //  Message to change
SHORT which,                       //  Entrance or exit
GBOOL charge)                      //  Charge person?
{
     SHORT retval=0;

     if (msg == NULL || *msg == '\0') {
          return(retval);
     }
     if (charge && tlcAPI->m_bEMsgChg) {
          if (!gdedcrd(pUser->GetName(),(LONG)tlcAPI->m_iEMsgChg,0,0)) {
               prfmsg(CNTAFT2,pUser->GetName());
               return(CNTAFT2);
          }
          if (tlcAPI->m_bLogEMsg) {
               logcrd(pUser->GetName(),tlcAPI->m_iEMsgChg);
          }
          prfmsg(USRDED2,pUser->GetName(),tlcAPI->m_iEMsgChg);
          retval=USRDED2;

     }
     if (which == REQENT3) {
          pUser->SetEntrance(msg,MSG_CURRENT);
          pUser->SetEntrance("\0",MSG_REQUESTED);
     }
     else {
          pUser->SetExit(msg,MSG_CURRENT);
          pUser->SetExit("\0",MSG_REQUESTED);
     }
     return(retval);
}

static SHORT                       //  Various flags
chgcsmsg(                          //  Change C/S entrance/exit message
CTlcSysEdt* pUser,                 //  Pointer to a user
CHAR* msg,                         //  Message to change
SHORT which,                       //  Entrance or exit
GBOOL charge)                      //  Charge person?
{
     SHORT retval=0;

     if (msg == NULL || *msg == '\0') {
          return(retval);
     }
     if (charge && tlcAPI->m_bEMsgChg) {
          if (!gdedcrd(pUser->getName(),(LONG)tlcAPI->m_iEMsgChg,0,0)) {
               prfmsg(CNTAFT2,pUser->getName());
               return(CNTAFT2);
          }
          if (tlcAPI->m_bLogEMsg) {
               logcrd(pUser->getName(),tlcAPI->m_iEMsgChg);
          }
          prfmsg(USRDED2,pUser->getName(),tlcAPI->m_iEMsgChg);
          retval=USRDED2;
     }
     if (which == REQENT3) {
          pUser->setEntrance(msg,MSG_CURRENT);
          pUser->setEntrance("\0",MSG_REQUESTED);
     }
     else {
          pUser->setExit(msg,MSG_CURRENT);
          pUser->setExit("\0",MSG_REQUESTED);
     }
     pUser->update();
     return(retval);
}
