/***************************************************************************
 *                                                                         *
 *   TLCCS.H                                                               *
 *                                                                         *
 *   Copyright (c) 1997-1998  Galacticomm, Inc.    All Rights Reserved     *
 *                                                                         *
 *   Teleconference Client-Server Agent header file                        *
 *                                                                         *
 *                                           - Phil Henning 6/10/97        *
 *                                                                         *
 ***************************************************************************/
#ifndef __TLCCS_H
#define __TLCCS_H

#ifdef __cplusplus
extern "C" {
#endif

#define TLCAPID     "GALTELE"

// Write dynapaks
#define DPKS_JOIN "sau:join"        // send this to join a channel - MAIN
#define DPKS_NEWU "sau:enter"       // send this on app open, no params
#define DPKS_EXIT "sau:exit"        // send on app close - no param
#define DPKS_TALK "sau:talk"        // send message line
#define DPKS_SETPROF "sau:setprof"  // set profile
#define DPKS_ADDPAL "sau:addpal"    // add a pal
#define DPKS_REMPAL "sau:rempal"    // remove a pal
#define DPKS_DBSTART "sau:startdb"  // start drawing board
#define DPKS_DBSTOP "sau:stopdb"    // stop drawing board
#define DPKS_DBDATA "sau:snddbl"    // drawing board data
#define DPKS_BGNXFR "sau:bgnxfr"    // begin file transfer
#define DPKS_OK2XFR "sau:ok2xfr"    // ok to transfer
#define DPKS_FILDAT "sau:fildat"    // file transfer data
#define DPKS_GOTDAT "sau:gotdat"    // got data
#define DPKS_ABOSND "sau:abosnd"    // abort send
#define DPKS_ABORCV "sau:aborcv"    // abort recvieve
#define DPKS_SQUEL  "sau:squelch"   // squelch
#define DPKS_UNSQUEL "sau:unsquelch"// unsquelch
#define DPKS_INVITE "sau:invite"    // invite
#define DPKS_UNINVITE "sau:uninvite"// uninvite
#define DPKS_FORGET "sau:forget"    // forget
#define DPKS_REMEMBER "sau:remember"// remember
#define DPKS_IGNORE "sau:ignore"    // ignore
#define DPKS_NOTICE "sau:notice"    // notice
#define DPKS_CHAT   "sau:chat"      // chat msg
#define DPKS_REQCHAT "sau:reqchat"  // chat request
#define DPKS_SYSEDIT   "sau:sysedit" // user editor
#define DPKS_SETCHAN   "sau:setchan" // create/edit channel
#define DPKS_DELCHAN   "sau:delchan" // delete a channel
#define DPKS_SETALIST "sau:setalist" // set action list
#define DPKS_DELALIST "sau:delalist" // delete a list
#define DPKS_DELAWORD "sau:delaword" // delete a word
#define DPKS_SETAWORD "sau:setaword" // change/add a word

// Read Dynapaks
#define DPKS_CHANL "sau:chanlist"   // Chan TAB Topic TAB Chan etc..
#define DPKS_CHANU "sau:chanusers " // TAB delimited Users in chan
#define DPKS_ALLU  "sau:allu"       // TAB delimited Users and Channels
#define DPKS_TICKER "sau:ticker"    // Ticker text TAB speed (1-5)
#define DPKS_GETPROF "sau:getprof"  // get profile settings
#define DPKS_ACCESS "sau:access"    // access info
#define DPKS_ALISTS "sau:alists"    // get action lists for this channel
#define DPKS_AWORDS "sau:awords "   // get list of words and info for this list
#define DPKS_GETPALS "sau:getpals"  // get list of pals
#define DPKS_GETSQUELCH "sau:getsquelch"// get list of squleched
#define DPKS_GETINVITE "sau:getinvite"// get list of invited
#define DPKS_GETFORGET "sau:getforget"// get list of forgotten users
#define DPKS_GETIGNORE "sau:getignore"// get list of ignored users
#define DPKS_SYSCHAN "sau:syschan"   // list of edittable channels
#define DPKS_GETCHAN "sau:getchan"   // get info on a channel
#define DPKS_SYSALIST "sau:sysalist" // get list of action lists on system
#define DPKS_GETALIST "sau:getalist" // get a particular list info
#define DPKS_SYSAWORD "sau:sysaword" // get tab delimited list of ALL actions on a list
#define DPKS_GETAWORD "sau:getaword" // get a paricular word, and info

#define JOIN_E_NOTLC "Not in teleconference"
#define TALK_E_NOCHN "You are not in a channel at the moment"


class CCSTransport;

const SHORT CSSNDBUFSIZ     =16384; //  Sending buffer size

// notify dynapak priorities
const SHORT CSNOCOM         =0;
const SHORT CSNOPOP         =1;
const SHORT CSNOEXC         =2;
const SHORT CSNOSTP         =3;

const SHORT VBFILSIZ        =12;

/* sndstt */
const SHORT NOSEND  =0;
const SHORT WT4ROK  =1;
const SHORT WT4DAT  =2;
const SHORT WT4RRM  =3;
const SHORT MAXOPC  =4;

/* cs flags */
const SHORT TLCRCV      =1;

const SHORT DPKLEN      =32;

extern USHORT dpklength;           //  Current dynapak length
extern VOID* dpkvalue;             //  Current dynapak value
extern INT dpkdirection;           //  Current dynapak direction
extern CHAR* dpkstg;

extern CTlcUser* dpkUser;
extern CTlcChannel* dpkChannel;
extern CCSTransport* transCS;

typedef struct tlccsinf {
    INT sndstt;
    INT csflags;
    INT rcvchn;
    LONG sndbyt;
    INT rcvopc;
    INT sndchn;
    CHAR LastUser[TLCUIDSIZ];      //  Last Userid retrieved (User Get C/S)
    CHAR LastChannel[CHAN_MAX_SIZE];// Last channel read
} TLCCSINF, *LPTLCCSINF;

typedef struct vbtlcfil {
    CHAR userid[TLCUIDSIZ-1];
    CHAR name[VBFILSIZ];
    DOUBLE tnd;
    LONG size;
} VBTLCFIL, *LPVBTLCFIL;

typedef struct ctlcfil {
    CHAR userid[TLCUIDSIZ];
    CHAR name[VBFILSIZ+1];
    DOUBLE tnd;
    LONG size;
} CTLCFIL, *LPCTLCFIL;

extern CHAR tlcdpks[][DPKLEN];
extern CHAR* cssndbuf;
extern flddef vbtlcfilFDA[];

// unsolicited dpks
enum {
    DPK_WHISPER,        DPK_ENT,        DPK_EXIT,       DPK_DIRECTED,
    DPK_NEWTOPIC,       DPK_ENTEDIT,    DPK_ACTION,     DPK_SPEAK,
    DPK_MISC,           DPK_PALUPDATE,  DPK_DBTOGGLE,   DPK_CHANCHG,
    DPK_INTRO,          DPK_USERLIST,   DPK_WELCOME,    DPK_USERENTER,
    DPK_USEREXIT,       DPK_CHAT,       DPK_REQCHAT,    DPK_REJCHAT,
    DPK_STARTCHAT,      DPK_ADDCHAN,    DPK_DELCHAN,    DPK_RETEDIT,
    DPK_USERSTAT,       DPK_ACTIONADD,  DPK_ACTIONDEL,  DPK_ACTIONCHG,
    DPK_LISTADD,        DPK_LISTDEL,    DPK_LISTCHG
};

/***************************************************************************
 * Function declarations                                                   *
 ***************************************************************************/
VOID
tlcCSdwn(VOID);                    //  Client/Server shutdown routine

VOID
tlcConnect(VOID);                  //  Hooked connect routine

VOID
tlcDisconnect(VOID);               //  Disconnect routine

VOID
tlcInitCS(VOID);                   //  C/S Initialization

VOID
CreateCSUser(VOID);                //  Create C/S User

VOID
tlcreflow(                         // re-flow buffer for C/S output
CHAR *buf);                        //   buffer to re-flow

// READS

VOID
dpkr_chanu(VOID);                  //  Get users in channel

VOID
dpkr_ticker(VOID);                 //  Get current ticker time

VOID
dpkr_getpals(VOID);                //  Get all of your pals

VOID
dpkr_getprof(VOID);                //  Get your profile

VOID
dpkr_getaccess(VOID);              //  Get your access Level

VOID
dpkr_alists(VOID);                 //  Get action lists

VOID
dpkr_awords(VOID);                 //  Get action lists

VOID
dpkr_getsquelch(VOID);             //  Get squelched users

VOID
dpkr_getinvite(VOID);              //  Get list of invited people

VOID
dpkr_getforget(VOID);              //  Get list of forgotten people

VOID
dpkr_getignore(VOID);              //  Get list of forgotton people

VOID
dpkr_allu(                         //  Get all users dynapak
struct saunam *psau,               //  Pointer to current dynapak
const CHAR *dpkstg,                //  Pointer to dynapak string
CHAR *LastUser);                   //  Last user picked up by current user

VOID
dpkr_chanl(                        //  Get Channel Lists
struct saunam *psau,               //  Pointer to current dyanapak structure
const CHAR *dpkstg,                //  Pointer to current dynapak string
CHAR *LastChannel);                //  Last channel looked up by user

VOID
dpkr_sysedit(VOID);                //  Sysop edit

VOID
dpkr_syschan(VOID);                //  Sysop channel editing

VOID
dpkr_getchan(VOID);                //  Get channel information

VOID
dpkr_sysalist(VOID);               //  Sysop action list retriever

VOID
dpkr_getalist(VOID);               //  Get action list

VOID
dpkr_getaword(VOID);               //  Dynapak to retrieve action word

VOID
dpkr_sysaword(                     //  Ssop get action word
GBOOL all);                        //  Get all words at once?

// WRITES

VOID
dpkw_newu(VOID);                   //  New user entered

VOID
dpkw_exit(VOID);                   //  User exited

VOID
dpkw_talk(VOID);                   //  User talked

VOID
dpkw_join(VOID);                   //  Join a channel

VOID
dpkw_addpal(VOID);                 //  Add a pal to your list

VOID
dpkw_rempal(VOID);                 //  Remove a pal from the list

VOID
dpkw_setprof(VOID);                //  Set teleconference profile

VOID
dpkw_dbstart(VOID);                //  Drawing board start

VOID
dpkw_dbstop(VOID);                 //  Drawing board stop

VOID
dpkw_dbdata(VOID);                 //  Drawing board data received

VOID
dpkw_squel(VOID);                  //  Squelch a person

VOID
dpkw_unsquel(VOID);                //  Unsquelch a person

VOID
dpkw_invite(VOID);                 //  Invite someone

VOID
dpkw_uninvite(VOID);               //  Uninvite someone

VOID
dpkw_forget(VOID);                 //  Forget someone

VOID
dpkw_ignore(VOID);                 //  Ignore someone

VOID
dpkw_remember(VOID);               //  Remember someone

VOID
dpkw_notice(VOID);                 //  Notice someone

VOID
dpkw_reqchat(VOID);                //  Request chat with someone

VOID
dpkw_chat(VOID);                   //  Chat with someone

VOID
dpkw_sysedit(VOID);                //  Sysop edit

VOID
dpkw_setchan(VOID);                //  Set current channel Info

VOID
dpkw_delchan(VOID);                //  Delete a channel

VOID
dpkw_setalist(VOID);               //  Set current action list

VOID
dpkw_delalist(VOID);               //  Delete an action list

VOID
dpkw_setaword(VOID);               //  Set current action word

VOID
dpkw_delaword(VOID);               //  Delete an action word

VOID
register_dpks(VOID);

#ifdef __cplusplus
};
#endif
#endif //__TLCCS_H
