/////////////////////////////////////////////////////////////////////////////
//
//   TLCCMD.CPP
//
//   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved
//
//   Teleconference Command
//   Implementation
//                                               - Phil Henning 5/14/97
//
/////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.hpp"
#include "tlctmtra.h"

#define FILREV "$Revision: 8 $"

MARKSOURCE(tlccmd);

CTlcCommand::CTlcCommand(
const CHAR* pszLong,
const CHAR* pszShort,
SHORT fNSpace,                // 1 indicates that a space is needed in abbr
GBOOL bTOnly)
{
     if (pszShort != NULL) {
          m_pszAbbr=new CHAR[strlen(pszShort)+1];
          strcpy(m_pszAbbr,pszShort);
     }
     else {
          m_pszAbbr=new CHAR[1];
          m_pszAbbr[0]='\0';
     }

     m_pszCmd =new CHAR[strlen(pszLong)+1];
     strcpy(m_pszCmd,pszLong);
     m_bNeedSpace=fNSpace;
     m_bTermOnly=bTOnly;
     m_silent=FALSE;
}

CTlcCommand::CTlcCommand(
LPCMDSTRUCT stCmd)
{
     if (stCmd->pszShort[0] != '\0') {
          m_pszAbbr=new CHAR[strlen(stCmd->pszShort)+1];
          strcpy(m_pszAbbr,stCmd->pszShort);
     }
     else {
          m_pszAbbr=new CHAR[1];
          m_pszAbbr[0]='\0';
     }
     m_pszCmd=new CHAR[strlen(stCmd->pszLong)+1];
     strcpy(m_pszCmd,stCmd->pszShort);
     m_bNeedSpace=stCmd->fNSpace;
     m_bTermOnly=stCmd->bTOnly;
}

CTlcCommand::~CTlcCommand()
{
     delete [] m_pszAbbr;
     delete [] m_pszCmd;
}

SHORT
CTlcCommand::DoCmd(CCommandParam* pParam)
{
     (VOID)pParam;
     if (UserStructToClass(pParam->m_pUser)->GetTransport() != transTerm
      && m_bTermOnly == TRUE) {
          if (!m_silent) {
              UserStructToClass(pParam->m_pUser)->CmdResult(CMD_GENERIC,FALSE,0);
          }
          else {
              m_silent=FALSE;
          }
          return(0);
     }
     m_silent=FALSE;
     return(1);
}

SHORT
CTlcCommand::DoCmd(CCommandParam* pParam, GBOOL silentcheck)
{
    m_silent=silentcheck;
    return(CTlcCommand::DoCmd(pParam));
}

