
#ifndef __TLCCHAN_HPP
#define __TLCCHAN_HPP

#include "tlcchan.h"
#include "tlcapi.hpp"

class CTlcAPI;
class CTlcCommand;

class CTlcChannel : public CHANINFO {
public:
    CTlcChannel(CTlcAPI* ptlcAPI);
    virtual ~CTlcChannel();

public:
    USHORT
    Create(
    const CHAR* strName,     // Name of channel
    const CHAR* strTopic,    // Topic for Channel
    USHORT flagChan,         // channel flags
    USHORT flagMod,          // moderater flags
    const CHAR* keyVis,      // key to see channel
    const CHAR* keyJoin,     // key to join channel
    const CHAR* keySpeak,    // key to speak in channel
    const CHAR* keyByPass,   // key to by-pass channel rules
    const CHAR* keyMod,      // key to be a moderator in this channel
    const CHAR* m_actList1,  // 1st action list
    const CHAR* m_actList2,  // 2nd action list
    CTlcCmdList* pCmd,       // cmds for this channel
    VOID* pCustom=NULL);     // custom data for channel

    USHORT
    Create(
    LPCHANINFO pChanInfo);

    inline
    CTlcUser*
    GetUserByName(
    const CHAR* pszUserid);

    inline
    CTlcUser*
    GetFirstUser();

    GBOOL
    Update(
    LPCHANINFO pChanInfo);

    LPCHANINFO
    GetConfig();

    VOID
    SetCommandList(
    CTlcCmdList* pCmd);

    GBOOL
    Load(
    const CHAR* pszName);

    VOID
    Save();

    inline
    CTlcUser*
    GetNextUser();

    GBOOL
    cmdRegister(
    CTlcCommand* pCmd);

    inline
    CTlcCommand*
    cmdGetFirst();

    inline
    CTlcCommand*
    cmdGetNext();

    inline
    const CHAR*
    GetName();

    inline
    const CHAR*
    GetTopic();

    inline
    INT
    GetNumUsers();

    SHORT
    SetTopic(
    const CHAR* strTopic);

    inline
    SHORT
    GetType();

    inline
    const CHAR*
    GetKey(INT access);

    VOID
    SendTabbedDbData(
    const CHAR* data);

    VOID
    ToggleDb(
    CTlcUser* pUser,
    INT bOn);

    virtual
    SHORT
    GetNumVisible();

    virtual
    VOID
    ShowVisUsers(
    CTlcUser* pUser);

    virtual
    SHORT
    AddUser(
    CTlcUser* pUser,
    GBOOL bIsFirstEnter = FALSE);

    virtual
    SHORT
    RemoveUser(
    CTlcUser* pUser,
    SHORT fExitType = LEAVE_CHANNEL);

    virtual
    SHORT
    PublicSendToTrans(
    CTlcTransport *pTransport,
    const CHAR* pszUseridFrom,
    const CHAR* pszUseridTo,
    const CHAR* pMsg,
    SHORT fType,
    SHORT iMsgNum=0,
    const CHAR* ptr1=NULL,
    const CHAR* ptr2=NULL,
    const CHAR* ptr3=NULL);

    virtual
    SHORT
    PublicSend(
    const CHAR* pszUseridFrom,
    const CHAR* pszUseridTo,
    const CHAR* pMsg,
    SHORT fType,
    SHORT iMsgNum=0,
    const CHAR* ptr1=NULL,
    const CHAR* ptr2=NULL,
    const CHAR* ptr3=NULL);

    virtual
    SHORT
    PublicSendAllChan(
    const CHAR* pszUseridFrom,
    const CHAR* pszUseridTo,
    const CHAR* pMsg,
    SHORT fType,
    SHORT iMsgNum=0,
    const CHAR* ptr1=NULL,
    const CHAR* ptr2=NULL,
    const CHAR* ptr3=NULL);

    virtual
    SHORT
    PublicSendAllChanNoEx(
    const CHAR* pszUseridFrom,
    const CHAR* pszUseridTo,
    const CHAR* pMsg,
    SHORT fType,
    SHORT iMsgNum=0,
    const CHAR* ptr1=NULL,
    const CHAR* ptr2=NULL,
    const CHAR* ptr3=NULL);

    virtual
    SHORT
    PublicSendBut(
    const CHAR* pszUseridFrom,
    const CHAR* pszUseridTo,
    const CHAR* pMsg,
    SHORT fType,
    SHORT iMsgNum=0,
    const CHAR* ptr1=NULL,
    const CHAR* ptr2=NULL,
    const CHAR* ptr3=NULL,
    const CHAR* pszUseridNot1=NULL,
    const CHAR* pszUseridNot2=NULL);

    virtual
    SHORT
    PrivateSend(
    const CHAR* pszUseridFrom,
    const CHAR* pszUseridTo,
    const CHAR* pMsg,
    SHORT fType,
    SHORT iMsgNum=0,
    const CHAR* ptr1=NULL,
    const CHAR* ptr2=NULL,
    const CHAR* ptr3=NULL);

    virtual
    INT
    HowManyMatch(
    const CHAR* stg,
    CTlcUser** ppMatchUser,
    GBOOL samas);

    virtual
    CHAR*
    FindUser(
    const CHAR* pszStart,
    INT* count,
    CTlcUser** pUser);

    virtual
    GBOOL
    CommandParse(
    CHAR* pInput,
    const CHAR* pszUseridFrom);

    virtual
    GBOOL
    ActionParse(
    CHAR* pInput,
    const CHAR* pszUseridFrom);

    virtual
    VOID
    SendJoinAnnouncement(
    CTlcUser* pUser,
    GBOOL bIsFirstEnter=FALSE);

    virtual
    VOID
    SendExitAnnouncement(
    CTlcUser* pUser,
    GBOOL fExitType=LEAVE_CHANNEL);

    virtual
    VOID
    SendWelcome(
    CTlcUser* pUser);

    virtual
    GBOOL
    CanAccess(
    CTlcUser* pUser,
    INT access);



protected:
    VOID
    ClearUserList();

protected:
    CTlcAPI* m_pTlcApi;
public:
    CTlcCmdList* m_pfxCmds;
};

class CTlcLocalChannel : public CTlcChannel {
public:
    CTlcLocalChannel(
    CTlcAPI* tlcAPI);

    ~CTlcLocalChannel();
};


class CTlcLocPublicChannel : public CTlcLocalChannel {
public:
    CTlcLocPublicChannel(
    CTlcAPI* tlcAPI);

    ~CTlcLocPublicChannel();

public:
    VOID
    SendWelcome(
    CTlcUser* pUser);
};


class CTlcPrivateChannel : public CTlcChannel {
public:
    CTlcPrivateChannel(
    CTlcAPI* tlcAPI);

    ~CTlcPrivateChannel();

protected:
    CHAR m_strOwner[TLCUIDSIZ];
    LPFLIST m_arInviteList;

public:
    VOID
    SendWelcome(
    CTlcUser* pUser);

    VOID
    SetOwner(
    const CHAR* strOwnner);

    inline
    const CHAR*
    GetOwner();

    GBOOL
    ToggleInvite(CTlcUser* pUser);

    GBOOL
    CheckInvite(CTlcUser* pUser);

    GBOOL
    AddUserToList(CTlcUser* pUser);

    GBOOL
    RemoveUserFromList(CTlcUser* pUser);

    VOID*
    FindUserInList(CTlcUser* pUser);

    GBOOL
    ToggleInviteNUM(ULONG user, USHORT board);

    GBOOL
    CheckInviteNUM(ULONG user, USHORT board);

    GBOOL
    AddUserToListNUM(ULONG user, USHORT board);

    VOID*
    FindUserInListNUM(ULONG user, USHORT board);

    GBOOL
    RemoveUserFromListNUM(ULONG user, USHORT board);

    VOID
    InitArray();

    LPFLIST
    GetInviteListPtr();

};
#endif // __TLCCHAN_HPP

