
#ifndef __TLCAPI_HPP
#define __TLCAPI_HPP

#include "tlcapi.h"
#include "smbwrap.h"
#include "tlcfsd.h"
#include "tlccmdl.hpp"
#include "tlctrans.hpp"
#include "tlcchan.hpp"
#include "tlcuser.hpp"
#include "tlccmd.hpp"
#include "tlc.hpp"
#include "tlcdcmd.hpp"
#include "tlcactc.hpp"
#include "tlcfunc.hpp"
#include "tlcsyedt.hpp"

#define CHECKFC(Z)  ((pFuncs != NULL) && (pFuncs->Z != NULL))

class CTlcAPI {

public:
    CTlcAPI();                     // default constructor
    ~CTlcAPI();                    // default destructor
    bool isinit() { return _isinit; } // has API fully initialized?
    bool isshutdwn() { return _shutdwn; } // has API been shut down?

private:
    size_t m_UserSize;
    size_t m_ChanSize;
    size_t iChanSmbSize;
    size_t iUserSmbSize;
    bool _isinit;
    bool _shutdwn;

// General Methods
public:

    VOID
    DeclareObjSize(                // state object storage requirements
    size_t st_user,                //   user object
    size_t st_chan);               //   channel object

    VOID
    Init();                        // final initialiation

    size_t
    GetUserSize();                 // get size of largest user object

    size_t
    GetChanSize();                 // get size of largest channel object

// CHANNEL API
////////////////////////////

    CTlcChannel*                   //   newly created CTlcChannel derived obj
    chanNew(                       // construct a new channel object
    SHORT type);                   //   type of channel

    GBOOL
    chanDelete(                    // delete a channel object
    CTlcChannel* pChannel,         //   channel obj to delete
    GBOOL bDisk = FALSE);          //   from disk too?

    CTlcChannel*                   //   returns pointer to registered object
    chanRegister(                  // Register a channel with the API
    CTlcChannel* pChannel);        //   Pointer to constructed channel

    CTlcUser*
    chanFindUser(
    const CHAR* pszChannel,
    const CHAR* pszUserid);

    CTlcUser*
    chanAddUser(
    const CHAR* pszChannel,
    const CHAR* pszUserid);

    VOID
    chanRemoveUser(
    const CHAR* pszChannel,
    const CHAR* pszUserid);

    CTlcUser*
    chanUserLow(
    const CHAR* pszChannel);

    CTlcUser*
    chanUserNext(
    const CHAR* pszChannel);

    CTlcUser*
    chanUserGT(
    const CHAR* pszChannel,
    const CHAR* pszUserid);

    VOID*
    chanUserGetPos();              // get pos of users-in-channel list

    VOID
    chanUserSetPos(                // set pos of users-in-channel list
    VOID* pos);                    //   position to set to

    inline
    CTlcChannel*                   //   returned channel info
    chanGetByName(                 // Get ptr to a particular channel
    const CHAR* pszName);          //   Channel name to find

    CTlcChannel*
    chanGetGTE(
    const CHAR* pszName);

    GBOOL                          //   returns true if able to remove
    chanRemoveByName(              // Unregister a channel with the API
    const CHAR* pszName,           //   Channel name to remove
    GBOOL bDisk = FALSE);          //   from disk too?

    CTlcChannel*                   // returned channel info
    chanCheckPub(                  // Check for a public channel
    const CHAR* strName,           // by this name
    GBOOL bExact=FALSE);           // exact match?

    SHORT                          // returns CHAN_PRIVATE_XXXX
    chanCheckPrivate(              // Check for a private channel
    const CHAR* strName,           // by this name
    CTlcChannel** pSaved);         // ptr to use to store channel

    VOID
    chanMoveAllUsers(              // move all users from one channel to another
    const CHAR* pszChanFrom,       // channel to move FROM
    const CHAR* pszChanTo,         // channel to move TO
    SHORT reason,                  // reason for the move
    SHORT iMsgNum);                // msg num to use for displayed text

    inline CTlcChannel* chanGetFirst(VOID);
    inline CTlcChannel* chanGetNext(VOID);
    inline CTlcChannel* chanGetGT(const CHAR* name);

    VOID*
    chanGetPos();                  // get position of channel list

    VOID
    chanSetPos(                    // set position of channel list
    VOID* pos);                    //   position to set to

// COMMAND API
///////////////////////////

    GBOOL
    cmdRegister(                   // register a command
    CTlcCommand* pCmd);            // ptr to command to register

    GBOOL                          // was command handled?
    Parse(                         // parse a line of input
    CHAR* pInput,                  // ptr to input
    const CHAR* pszUseridFrom,     // uid this input is FROM
    CTlcChannel* pChannel);        // channel this is FROM

    inline CTlcCommand* cmdGetFirst(VOID);
    inline CTlcCommand* cmdGetNext(VOID);

// USERS API
////////////////////////////

    CTlcUser*
    usrAdd(                        // adds a user obj to tcon
    CTlcUser* pUser);              // user object to add

    VOID
    usrDelete(                     // removes a user from tcon
    CTlcUser* pUser);              // userid to remove

    inline CTlcUser* usrGetFirst(VOID);
    inline CTlcUser* usrGetNext(VOID);
    inline CTlcUser* usrGetGT(const CHAR* pszUser);
    inline CTlcUser* usrGetByName(const CHAR* pszUser);

    VOID*
    usrGetPos();                   // get pos of users list

    VOID
    usrSetPos(                     // set pos of users list
    VOID* pos);                    //   position to set to

    ULONG
    CTlcAPI::FindIDByUser(
    const CHAR* userid);

    ULONG
    CTlcAPI::CreateUniqueID(
    const CHAR* userid);

    CHAR*
    CTlcAPI::FindUserByID(
    ULONG num,
    CHAR** buf=NULL);

    SHORT
    CTlcAPI::usrFind(
    const CHAR* pszUser,
    CTlcUser** pUser);

    CTlcUser*
    CTlcAPI::usrGetByTlcID(
    USHORT board,
    ULONG unum);

    INT
    HowManyMatch(
    const CHAR* stg,
    CTlcUser** ppMatchUser,
    GBOOL samas);

    CHAR*                          // ptr to msg
    FindUserMsg(
    const CHAR* pszStart,          // start of UID to check
    INT* count,                    // ptr to an INT to hold number of matches
    CTlcUser** pUser);             // ptr to ptr to hold user info


// SECURITY API
//////////////////////////
                                   // GET key Funcs
    inline const CHAR* keyGetSys(VOID);    // Tele-Sysop Key
    inline const CHAR* keyGetUnl(VOID);    // Unlimited Use Key
    inline const CHAR* keyGetSeeUL(VOID);  // See Unlisted Users Key

                                   // SET key Funcs
    VOID keySetSys(CHAR* key);     // Tele-Sysop Key
    VOID keySetUnl(CHAR* key);     // Unlimited Use Key
    VOID keySetSeeUL(CHAR* key);   // See Unlisted Users Key


// TRANSPORT API
/////////////////////////

    INT
    transRegister(                 // register a transport method
    const CHAR* pszName,           // name of this method
    CTlcTransport* pTransport);    // ptr to constructed transport

    inline CTlcTransport* transGetFirst(VOID);
    inline CTlcTransport* transGetNext(VOID);
    inline CTlcTransport* transGetAt(INT idx);
    inline CTlcTransport* transGetNamed(const CHAR* name);
    inline INT transGetNumber();

    VOID OutputFinished();

//  Action API
/////////////////////////

    VOID
    actCreate(LPACTLST liststr);

    CTlcAList*
    actGetByName(const CHAR* pszList);

    CTlcAList*
    actGetFirst(
    GBOOL getdel=FALSE);

    CTlcAList*
    actGetNext(
    GBOOL getdel=FALSE);

    CTlcAList*
    actGetGT(
    const CHAR* pszList);

    VOID*
    actGetPos();                   // get pos of actions list

    VOID
    actSetPos(                     // set pos of actions list
    VOID* pos);                    //   position to set to

    VOID
    actRemove(
    const CHAR* pszList);


// Properities
protected:
    CSmb*           m_smbUsers;    // ptr to users
    CSmb*           m_smbChans;    // ptr to Channel mapping
    CSmb*           m_smbXrf;      // ptr to usr/channel xrf
    CSmb*           m_smbAct;      // ptr to action lists
    CObjMap*        m_pfxTrans;    // ptr to transports
    CTlcCmdList*    m_pfxCmds;     // ptr to commands
    DFAFILE*        m_dfaTlcXrf;


    CHAR m_keySys[KEYSIZ];         // Tele-sysop key
    CHAR m_keyUnl[KEYSIZ];         // Unlimited Use key
    CHAR m_keySeeUL[KEYSIZ];       // See Unlisted Users Key

public:
    GBOOL       m_bWhs2Pag;
    GBOOL       m_bLogEMsg;
    GBOOL       m_bEMsgChg;
    GBOOL       m_bSwitFor;
    GBOOL       m_bForSameChg;
    INT         m_iEMsgChg;
    INT         m_iEtlpst;
    INT         m_npaymx;
    INT         m_iTlcSur;
    USHORT      m_iSpeakThres;
    USHORT      m_iSpeedDrop;
    USHORT      m_iSwitchThres;
    CHAR*       m_actListP;
    CHAR*       m_actListS;
    VOID*       bufAddUser;
    VOID*       bufAddChan;

// Implementation
protected:

    VOID
    Shutdown(VOID);                // API shutdown routine

    VOID
    CloseDfa();                    // close data files
};

#endif // __TLCAPI_HPP
