/////////////////////////////////////////////////////////////////////////////
//
//   TLCAHUSR.CPP
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Teleconference Active HTML User
//   Implementation
//                                               - Phil Henning 6/20/97
//
/////////////////////////////////////////////////////////////////////////////

#pragma option -w-par    // fixes warning in memory.h
#define _RWSTDLL
#include "gcomm.h"
#include "majorbbs.h"
#include <stdcomp.h>
#define RWSTD_NO_BOOL
#include "tlcapi.hpp"
#pragma option -w-aus
#include <deque>
#pragma option -w-aus.
#include "iterand.h"
using namespace std;
#include "tlcahusr.hpp"
#include <time.h>

#define FILREV "$Revision: 42 $"

MARKSOURCE(tlcahusr);

CTlcAHUser::CTlcAHUser() : CTlcUser(), m_lTime(0L), m_lInitTime(0L)
{
     m_iType=USR_TYPE_AHTML;
     msgQueue=NULL;
     dbQueue=NULL;
     m_iSize=sizeof(CTlcAHUser);
}

CTlcAHUser::~CTlcAHUser()
{
     if (msgQueue != NULL) {
          delete msgQueue;
          msgQueue=NULL;
     }
     ClearDb();
     if (dbQueue != NULL) {
          delete dbQueue;
     }
}

VOID
CTlcAHUser::LoadRecord()
{
     CTlcUser::LoadRecord();
     pageLoadRecord(m_pszName,&m_pageInfo);
}

VOID
CTlcAHUser::SaveRecord()
{
     CTlcUser::SaveRecord();
     pageSaveRecord(m_pszName,&m_pageInfo);
}

VOID
CTlcAHUser::AddLiteMsg(
const CHAR* pszMsg)
{
     CHAR* bufNew;
     CHAR* bufStripped;
     CHAR* tmpptr;
     CHAR* endline;
     CHAR* hBuf;
     GBOOL one;

     size_t size,hLength;

     if (msgQueue != NULL && pszMsg != NULL) {

          size=strlen(pszMsg)+1;
          ASSERT(pszMsg != NULL);
          bufStripped=stpans((CHAR*)pszMsg);

          if ((endline=strrchr(bufStripped,'\r')) != 0) {
               // single line
               endline++;
          }
          else if ((endline=strrchr(bufStripped,'\n')) != 0) {
               endline++;
          }
          if (endline == 0) {
               CHAR *bufSingle = new CHAR[strlen(bufStripped)+1];
               stlcpy(bufSingle,bufStripped,strlen(bufStripped)+1);
               msgQueue->push_front(bufSingle);
               return;
          }

          hLength=strlen(endline)+1;
          hBuf=new CHAR[hLength];
          stlcpy(hBuf,endline,hLength);
          tmpptr=bufStripped;

          do {
               INT offset=0;
               CHAR* rpos;
               CHAR* npos;
               GBOOL done=FALSE;

               one=FALSE;
               while (*tmpptr == '\r' || *tmpptr == '\n') {
                    if (*tmpptr == '\0') {
                         done=TRUE;
                         break;
                    }
                    tmpptr++;
               }
               if (done || tmpptr == endline) {
                    break;
               }
               rpos=strchr(tmpptr,'\r');
               npos=strchr(tmpptr,'\n');
               if (npos == NULL && rpos == NULL) {
                    offset=endline-tmpptr-1;
                    one=TRUE;
               }
               else if (npos == NULL || (rpos != NULL && npos > rpos)) {
                    *rpos='\0';
                    offset=rpos-tmpptr;
               }
               else if (rpos == NULL || (npos != NULL && rpos > npos)) {
                    *npos='\0';
                    offset=npos-tmpptr;
               }
               else {
                    offset=endline-tmpptr-1;
                    one=TRUE;
               }
               if (tmpptr != NULL && strlen(tmpptr) > 0) {
                    bufNew=new CHAR[strlen(tmpptr)+1];
                    strcpy(bufNew,tmpptr);
                    msgQueue->push_front(bufNew);
               }
               tmpptr+=offset+1;
          } while (tmpptr != NULL && *tmpptr != '\0' && !one);
          if (strlen(hBuf) > 0) {
               msgQueue->push_front(hBuf);
          }
          else {
               delete [] hBuf;
          }
     }
}

VOID
CTlcAHUser::AddMsg(
const CHAR* pszMsg)
{
     CHAR* bufNew;
     CHAR* bufStripped;
     CHAR* tmpptr;
     CHAR* endline;
     CHAR* hBuf;
     GBOOL one;



     size_t size,hLength;


 //    GBOOL single=FALSE;

     if (msgQueue != NULL && pszMsg != NULL) {
          GBOOL justtab=FALSE;

          size=strlen(pszMsg)+1;
          ASSERT(pszMsg != NULL);
          bufStripped=stpans((CHAR*)pszMsg);

          if ((endline=strrchr(bufStripped,'\r')) != 0) {
               // single line
               endline++;
          }
          else if ((endline=strrchr(bufStripped,'\n')) != 0) {
               endline++;
          }
          else {
               endline=strchr(bufStripped,'\t');
               justtab=TRUE;
          }

          if (endline == 0) {
               return;
          }

          hLength=strlen(endline)+1;
          hBuf=new CHAR[hLength];
          stlcpy(hBuf,endline,hLength);
          if (justtab) {
               *endline='\0';
          }
          tmpptr=bufStripped;

          do {
               INT offset=0;
               CHAR* rpos;
               CHAR* npos;
               GBOOL done=FALSE;

               one=FALSE;
               while (*tmpptr == '\r' || *tmpptr == '\n') {
                    if (*tmpptr == '\0') {
                         done=TRUE;
                         break;
                    }
                    tmpptr++;
               }
               if (done || tmpptr == endline) {
                    break;
               }
               rpos=strchr(tmpptr,'\r');
               npos=strchr(tmpptr,'\n');
               if (npos == NULL && rpos == NULL) {
                    offset=endline-tmpptr-1;
                    one=TRUE;
               }
               else if (npos == NULL || (rpos != NULL && npos > rpos)) {
                    *rpos='\0';
                    offset=rpos-tmpptr;
               }
               else if (rpos == NULL || (npos != NULL && rpos > npos)) {
                    *npos='\0';
                    offset=npos-tmpptr;
               }
               else {
                    offset=endline-tmpptr-1;
                    one=TRUE;
               }
               if (tmpptr != NULL && strlen(tmpptr) > 0) {
                    bufNew=new CHAR[strlen(tmpptr)+hLength+1];
                    strcpy(bufNew,tmpptr);
                    strcat(bufNew,"\n");
                    strcat(bufNew,hBuf);
                    msgQueue->push_front(bufNew);
               }
               tmpptr+=offset+1;
          } while (tmpptr != NULL && *tmpptr != '\0' && !one);
          delete [] hBuf;
     }
}

const CHAR*
CTlcAHUser::GetMsg()
{
     if (msgQueue != NULL) {
          if (!msgQueue->empty()) {
               return(msgQueue->back());
          }
     }
     return(NULL);
}

struct pageInfo*
CTlcAHUser::GetPageInfo()
{
     return(&m_pageInfo);
}

VOID
CTlcAHUser::PopMsg()
{
     const CHAR* buf;

     if (msgQueue != NULL) {
          buf=msgQueue->back();
          delete [] buf;
          msgQueue->pop_back();
     }
}

VOID
CTlcAHUser::AddDbData(
const CHAR* data)
{
     CHAR* bufNew;

     if (dbQueue != NULL) {
          bufNew=new CHAR[strlen(data)+1];
          strcpy(bufNew,data);
          dbQueue->push_front(bufNew);
     }
}

const CHAR*
CTlcAHUser::GetDbData()
{
     if (dbQueue != NULL) {
          if (!dbQueue->empty()) {
               return(dbQueue->back());
          }
     }
     return(NULL);
}

VOID
CTlcAHUser::PopDbData()
{
     const CHAR* buf;

     if (dbQueue != NULL) {
          buf=dbQueue->back();
          delete [] buf;
          dbQueue->pop_back();
     }
}

VOID
CTlcAHUser::ClearDb()
{
     if (dbQueue != NULL) {
          while (!dbQueue->empty()) {
               PopDbData();
          }
     }
}

LONG
CTlcAHUser::GetTime()
{
     return (m_lTime);
}

VOID
CTlcAHUser::SetTime(LONG lTime)
{
     if (m_lTime == 0L) {
          m_lInitTime=lTime;
          m_iPackedTime=now();
     }
     m_lTime=lTime;
}

LONG
CTlcAHUser::GetInitialTime()
{
     return(m_lInitTime);
}

USHORT
CTlcAHUser::GetPackedTime()
{
     return(m_iPackedTime);
}

LONG
CTlcAHUser::GetCredits()
{
     struct usracc usr;
     LONG cred=0;

     dfaSetBlk(accbb);
     if (dfaAcqEQ(&usr,m_pszName,0)) {
          cred=usr.creds;
     }
     dfaRstBlk();
     return(cred);
}

VOID
CTlcAHUser::Cleanup()
{
     msgQueue=NULL;
     dbQueue=NULL;
     CTlcUser::Cleanup();
}

VOID
CTlcAHUser::Reinit()
{
     ClearDb();
     CTlcUser::Reinit();
}

VOID
CTlcAHUser::SetQueues(
LPMSGQUE msg,
LPMSGQUE db)
{
     msgQueue=msg;
     dbQueue=db;
}

VOID
CTlcAHUser::ChatBegin(
SHORT context)
{
     CTlcUser::ChatBegin(context);
     m_fFlags&=~USR_INCHAN;
}

