/////////////////////////////////////////////////////////////////////////////
//
//   TLCAHTVB.CPP
//
//   Copyright (c) 1998 Galacticomm, Inc.         All Rights Reserved
//
//   Active HTML LITE Teleconference Text Variables
//
//
//                                              - P Henning    9/23/98
//
////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "enctvb.h"
#include "tlcapi.hpp"
#include "tlcahtvb.h"
#include <strstrea.h>

#define FILREV "$Revision: 4 $"

enum tvbtype {TVB_BASIC,TVB_HTML,TVB_ENC,TVB_LINKED};

htmlEncodedTvb teleActionHelp("TELE_ACTION_HELP");
htmlEncodedTvb teleActionName("TELE_ACTION_NAME");
urlEncodedTvb teleActionNameURL("TELE_ACTION_NAME_URL");

htmlEncodedTvb teleChannelTopic("TELE_CHANNEL_TOPIC");
htmlEncodedTvb teleChannelName("TELE_CHANNEL_NAME");
urlEncodedTvb teleChannelNameURL("TELE_CHANNEL_NAME_URL");
htmlEncodedTvb teleNumInChannel("TELE_NUMUSERS_INCHAN");


htmlEncodedTvb teleErrorCode("TELE_ERR_CODE");
htmlEncodedTvb teleErrorMessage("TELE_ERR_MESSAGE");

htmlEncodedTvb teleEncodeNo("TELE_ENCTAGNO_SEL");
htmlEncodedTvb teleEncodeYes("TELE_ENCTAGYES_SEL");
htmlEncodedTvb teleEntranceMessage("TELE_ENTRANCE_MSG");
htmlEncodedTvb teleExitMessage("TELE_EXIT_MSG");
htmlEncodedTvb teleReqEntranceMessage("TELE_REQED_ENTMSG");
htmlEncodedTvb teleReqExitMessage("TELE_REQED_EXITMSG");
htmlEncodedTvb telePrivateTopic("TELE_PRIVATE_TOPIC");

htmlEncodedTvb teleHTMLSel("TELE_HTML_SEL");
htmlEncodedTvb teleJavaSel("TELE_JAVA_SEL");
basicTvb** pTeleIntValSel;              // TELE_INTVAL_SELn (n=1-9)
htmlEncodedTvb teleMainSel("TELE_MAIN_SEL");
htmlEncodedTvb telePrivateSel("TELE_PRIVATE_SEL");

basicTvb       teleRegistryLink("TELE_REGISTRY_LINK");
urlEncodedTvb  teleSesid("TELE_SESID");
htmlEncodedTvb teleUserid("TELE_USERID");
urlEncodedTvb  teleUseridURL("TELE_USERID_URL");

htmlEncodedTvb teleUserSex("TELE_USER_SEX");
htmlEncodedTvb teleUserAge("TELE_USER_AGE");

htmlEncodedTvb teleEMsgSize("TELE_MAX_EMSGSIZ");
htmlEncodedTvb teleMsgSize("TELE_MAX_MSGSIZ");
htmlEncodedTvb teleMaxTopicSize("TELE_MAX_TOPICSIZ");

#define NUMCHATINT   9

static VOID
registerRange(                          // register a range of Tvbs
basicTvb ** tvbPtr,                     //   pointer to tvbs
enum tvbtype ttype,                     //   tvb type to create
CHAR const * pszBody,                   //   body to set equal to
INT num,                                //   set from 0-num
CHAR const * anchor=NULL);              //   anchor to use for linking

static VOID
setTvbArray(                            // set tvbs to set or cleared state
basicTvb** tvbPtr,                      //   pointer to tvbs
CHAR** repStrings,                      //   strings to set with
INT numElems,                           //   number of tvbs/strings
bool bClear);                           //   clear them?

MARKSOURCE(tlcahtvb);

VOID
initTeleTvbs()                          //  init text variables
{
     pTeleIntValSel=new basicTvb* [NUMCHATINT];
     registerRange(pTeleIntValSel,TVB_HTML,"TELE_INTVAL_SEL",NUMCHATINT);
     setTvbArray(pTeleIntValSel,NULL,NUMCHATINT,true);
     teleMsgSize=tinpsz;
     teleMaxTopicSize=CHAN_MAX_TOPIC_SIZE-1;
}

VOID
setChatIntTvb(                          // set the proper chat tvar
INT num)                                //   chat interval to set
{
     INT arridx=num-1;
     setTvbArray(pTeleIntValSel,NULL,NUMCHATINT,true);
     if (arridx >= 0 && arridx < NUMCHATINT) {
          *(pTeleIntValSel[arridx])="Selected";
     }
     else {
          *(pTeleIntValSel[0])="Selected";
     }
}

static VOID
registerRange(                          // register a range of Tvbs
basicTvb ** tvbPtr,                     //   pointer to tvbs
enum tvbtype ttype,                     //   tvb type to create
CHAR const * pszBody,                   //   body to set equal to
INT num,                                //   set from 0-num
CHAR const * anchor)                    //   anchor to use for linking
{
     ASSERT(tvbPtr != NULL);
     ASSERT(pszBody != NULL);
     ASSERT(*pszBody != '\0');

     for (int i=0 ; i < num ; i++) {
          ostrstream ost;
          ost << pszBody << i+1 << ends;
          switch (ttype) {
          case TVB_BASIC:
               tvbPtr[i]=new basicTvb(ost.str());
               break;
          case TVB_HTML:
               tvbPtr[i]=new htmlEncodedTvb(ost.str());
               break;
          case TVB_ENC:
               tvbPtr[i]=new urlEncodedTvb(ost.str());
               break;
          case TVB_LINKED:
               if (anchor != NULL ) {
                    tvbPtr[i]=new linkedHtmlEncodedTvb(ost.str(),anchor);
               }
               else {
                    tvbPtr[i]=new htmlEncodedTvb(ost.str());
               }
               break;
          default:
               ASSERTM(FALSE,"Bad TVB type");
          }
          ost.rdbuf()->freeze(0);
     }
}

static VOID
setTvbArray(                            // set tvbs to set or cleared state
basicTvb** tvbPtr,                      //   pointer to tvbs
CHAR** repStrings,                      //   strings to set with
INT numElems,                           //   number of tvbs/strings
bool bClear)                            //   clear them?
{
     ASSERT(tvbPtr != NULL);
     if (tvbPtr == NULL || *tvbPtr == NULL) {
          return;
     }
     if (bClear || repStrings == NULL) {
          for (int i=0 ; i < numElems ; i++) {
               *(tvbPtr[i])="";
          }
          return;
     }
     for (int i=0 ; i < numElems ; i++) {
          *(tvbPtr[i])=repStrings[i];
     }
}


