/////////////////////////////////////////////////////////////////////////////
//
//   TLCAHPAG.CPP
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Teleconference Active HTML Paging
//   Implementation
//                                               - Phil Henning 11/18/97
//
/////////////////////////////////////////////////////////////////////////////


#pragma option -w-par              /* fixes warning in memory.h            */
#define _RWSTDLL
#include "gcomm.h"
#include "majorbbs.h"
#include <stdcomp.h>
#define RWSTD_NO_BOOL
#include "tlcapi.hpp"
#pragma option -w-aus
#include <deque>
#pragma option -w-aus.
#include "iterand.h"
using namespace std;
#include "tlcahusr.hpp"
#include "ahtrans.hpp"
#include "ahlite.hpp"

#define FILREV "$Revision: 9 $"

MARKSOURCE(tlcahpag);

/***************************************************************************
 *                                                                         *
 * Old paging vectors to be called if not a Teleconference AH user         *
 *                                                                         *
 ***************************************************************************/

GBOOL
(*oldcanPage)(                     /* Checks if user is online & not invis */
const CHAR* userid);               /*  userid to check                     */

GBOOL                              /*  returns if overiding output         */
(*oldpageOutput)(                  /* Sends paging message to user         */
const CHAR* userid);               /*  userid to check                     */

struct pageInfo*                   /*  page information                    */
(*oldpageGetInfo)(                 /* Get page information vector          */
const CHAR* userid);               /*  userid to get page information on   */

INT                                /*  how many uids were found            */
(*oldHowmny)(                      /* How many userids match the string    */
CHAR* stg,                         /*  string to match up with             */
GBOOL samas,                       /*  if sameas return(1)                 */
CHAR* match);                      /*  matching userid                     */

/***************************************************************************
 *                                                                         *
 * Teleconference AH interface for paging                                  *
 *                                                                         *
 ***************************************************************************/

static
GBOOL
mycanPage(                         /* Checks if user is online & not invis */
const CHAR* userid);               /*  userid to check for                 */

static GBOOL                       /*  returns if overiding output         */
mypageOutput(                      /* Sends paging message to user if AH   */
const CHAR* userid);               /*  userid to check                     */

static struct pageInfo*            /*  structure to return                 */
mypageGetInfo(                     /* Paging information on user           */
const CHAR* userid);               /*  userid to check for                 */

static INT                         /*  number of users found               */
howmny(                            /* How many users match this string     */
CHAR* stg,                         /*  string to match                     */
GBOOL samas,                       /*  if sameas or sameto                 */
CHAR* matchname);                  /*  exact matching userid               */

extern CAHTransport transAH;
extern CLiteAHTrans transLiteAH;

VOID
initahpag(VOID)
{
     oldcanPage=canPageHook;
     canPageHook=mycanPage;

     oldpageGetInfo=pageGetInfoHook;
     pageGetInfoHook=mypageGetInfo;

     oldpageOutput=pageOutputHook;
     pageOutputHook=mypageOutput;

     oldHowmny=pageHowmnyHook;
     pageHowmnyHook=howmny;
}

static
GBOOL
mycanPage(                         /* Checks if user is online & not invis */
const CHAR* userid)                /*  userid to check for                 */
{
     CTlcUser* pUser;

     if (tlcAPI->usrFind(userid,&pUser) == 1) {
         // returns if an AH user is invisible
         // currently invisibility is not implemented in AH
         // but may be added in a future release
         return(!(pUser->m_fFlags&USR_INVISB));
     }
     return(oldcanPage(userid));
}

static struct pageInfo*            /*  structure to return                 */
mypageGetInfo(                     /* Paging information on user           */
const CHAR* userid)                /*  userid to check for                 */
{
     CHAR* realid;
     bool bAlloc=false;

     ASSERT(userid != NULL);
     struct pageInfo* inf=NULL;
     if (*userid == '(') {
          bAlloc=((realid=new CHAR[strlen(userid)-1]) != NULL);
          ASSERT(realid != NULL);
          stlcpy(realid,userid+1,strlen(userid)-1);
     }
     else {
          realid=const_cast<CHAR*>(userid);
     }
     if ((inf=oldpageGetInfo(realid)) == NULL) {
          CTlcUser* pUser;
          if (tlcAPI->usrFind(realid,&pUser) != 1) {
               inf=NULL;
          }
          else if (pUser->m_iType == USR_TYPE_AHTML
            || pUser->m_iType == USR_TYPE_AHLITE) {
               inf=((CTlcAHUser*)pUser)->GetPageInfo();
          }
     }
     if (bAlloc) {
          delete [] realid;
     }
     return(inf);
}

static GBOOL                       /*  returns if overiding output         */
mypageOutput(                      /* Sends paging message to user if AH   */
const CHAR* userid)                /*  userid to check                     */
{
     if (!oldpageOutput(userid)) {
          CTlcUser* pUser;
          if (tlcAPI->usrFind(userid,&pUser) != 1) {
               return(FALSE);
          }
          else if (pUser->m_iType != USR_TYPE_AHTML
            && pUser->m_iType != USR_TYPE_AHLITE) {
               return(FALSE);
          }
          else {
               pUser->OnRecvText(SYSUID,NULL,NULL,RECV_TYPE_PAGE);
          }
     }
     return(TRUE);
}

static INT                         /*  number of users found               */
howmny(                            /* How many users match this string     */
CHAR* stg,                         /*  string to match                     */
GBOOL samas,                       /*  if sameas or sameto                 */
CHAR* matchname)                   /*  exact matching userid               */
{
     INT cnt=0;

     CTlcAHUser* pAHUser;
     pAHUser=(CTlcAHUser*)(transAH.GetFirstUser(NULL));
     while (pAHUser != NULL) {
          if (!samas && !(pAHUser->m_fFlags&USR_INVISB) && sameto(stg,pAHUser->GetName())) {
               if (matchname != NULL) {
                    stlcpy(matchname,pAHUser->GetName(),UIDSIZ);
               }
               ASSERT(matchname != NULL);
               cnt++;
          }
          if (samas && sameas(stg,pAHUser->GetName())) {
               if (matchname != NULL) {
                    stlcpy(matchname,pAHUser->GetName(),UIDSIZ);
               }
               ASSERT(matchname != NULL);
               return(1);
          }
          pAHUser=(CTlcAHUser*)(transAH.GetNextUser(NULL));
     }

     pAHUser=(CTlcAHUser*)(transLiteAH.GetFirstUser(NULL));
     while (pAHUser != NULL) {
          if (!samas && !(pAHUser->m_fFlags&USR_INVISB) && sameto(stg,pAHUser->GetName())) {
               if (matchname != NULL) {
                    stlcpy(matchname,pAHUser->GetName(),UIDSIZ);
               }
               ASSERT(matchname != NULL);
               cnt++;
          }
          if (samas && sameas(stg,pAHUser->GetName())) {
               if (matchname != NULL) {
                    stlcpy(matchname,pAHUser->GetName(),UIDSIZ);
               }
               ASSERT(matchname != NULL);
               return(1);
          }
          pAHUser=(CTlcAHUser*)(transLiteAH.GetNextUser(NULL));
     }

     return((cnt+(oldHowmny)(stg, samas, matchname)));
}

