/////////////////////////////////////////////////////////////////////////////
//
//   TLCAHLIT.H
//
//   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved
//
//   Active HTML LITE Teleconference interface
//
//                                              - N.C. Osterc  3/17/98
//   Text Variable changes
//
//                                              - P Henning    9/23/98
//
////////////////////////////////////////////////////////////////////////////

#ifndef __TLCAHLIT_H
#define __TLCAHLIT_H

enum errorcodes {ERR_NOERROR,ERR_EMPTYINPUT,ERR_TELENOTINIT,ERR_SESSIONFAILURE
                ,ERR_AFRDENT,ERR_AFRDEXT,ERR_ALREADIN,ERR_BADCHATINTERVAL};

#define SESIDSIZ 15                // size of session-id value
#define MAXHLPSIZ 1024             // maximum size of help string
#define URLSIZ 1024                // maximum URL size


class tlcBaseSyn : public acthSynthesis {
public:
     tlcBaseSyn(acthSession* _ses) : acthSynthesis(_ses)
                                    , m_SynState(SYNSTATE_REQUEST)

     {
     }

     virtual
     ~tlcBaseSyn()
     {
     }

     ACTHCODE
     proceed();                         // acthSynthesis proceed implementation

protected:
     virtual
     ACTHCODE
     proceedRequest()=0;                // setup request context

     virtual
     ACTHCODE
     proceedSynth()=0;                  // synthesise the response

     virtual
     ACTHCODE
     proceedResponse()=0;               // output the response

     enum synstate {SYNSTATE_REQUEST,SYNSTATE_SYNTH,SYNSTATE_RESPONSE};

     enum synstate m_SynState;          // request state
};

class tlcBaseAuthSyn : public tlcBaseSyn {   // tele HTML base class
public:
     tlcBaseAuthSyn(
     acthSession* _ses,
     INT lvlcnt=0 ) : tlcBaseSyn(_ses)
                    , m_lvlcnt(lvlcnt), m_sesID(0L)
                    , m_err(ERR_NOERROR)
                    , m_dnf(NULL), m_pUser(NULL)
                    , m_onsuccessFile(NULL)
                    , m_onerrorFile(NULL)
                    , m_succRedir(false)
                    , m_errRedir(false)



     {
          memset(&m_usaptr,0,sizeof(struct usracc));
     }

     virtual
     ~tlcBaseAuthSyn()
     {
          if (m_dnf != NULL) {
               delete m_dnf;
          }
          if (m_onsuccessFile != NULL) {
               delete [] m_onerrorFile;
          }
          if (m_onsuccessFile != NULL) {
               delete [] m_onerrorFile;
          }

     }

protected:
     virtual
     ACTHCODE
     proceedRequest();                  // setup request context

     virtual
     ACTHCODE
     proceedSynth()=0;                  // synthesise the response

     virtual
     ACTHCODE
     proceedDerivedResponse()=0;        // output response

     ACTHCODE                           //   continue synthesis?
     errorResponse(                     // an error was encountered
     dnfMap& map,                       //   map to use for error response
     CHAR const * path);                //   path to the template directory

     ACTHCODE                           //   continue synthesis?
     successResponse(                   // process onsuccess parameter
     dnfMap& map,                       //   map to use for error response
     CHAR const * path);                //   path to the template directory

     VOID getTeleParams();              // get session-specific parameters

     INT  m_lvlcnt;                     // how deep is this url (/forums/view/)
     acthUserID* m_usr;                 // the current user
     struct usracc m_usaptr;            // user account structure
     errorcodes m_err;                  // error status
     dnfHandler* m_dnf;                 // dnf Handler
     CTlcAHUser* m_pUser;               // pointer to active h user object
     LONG m_sesID;                      // session id value
     bool m_succRedir;                  // redirect on success?
     bool m_errRedir;                   // redirect on error?
     CHAR* m_onsuccessFile;             // path to redirect onsuccess to
     CHAR* m_onerrorFile;               // path to redirect onerror to
     CHAR m_sesIDBuf[SESIDSIZ];         // buffer to store session-id
     CHAR m_userIDBuf[UIDSIZ];          // buffer to store user-id

protected:
     VOID
     setusaptr(                         // set the current user acc pointer
     CHAR const * userid);


private:
     virtual
     ACTHCODE
     proceedResponse();                 // output the response

     VOID
     initTemplates();                   // init onerror/onsuccess templates

     VOID
     setProfileVars();                  // set global preference vars

     VOID
     clearAllTVars();                   // clear all text variables

     VOID
     setErrorVars();                    // set error text vars

     bool                               //   should we redirect?
     getOnParam(                        // get onsuccess/onerror parameter
     CHAR const * paramName,            //   name of param we're getting
     CHAR const * dftFileName,          //   default file name to use
     CHAR** pStorePtr);                 //   buffer to store param value


};

class teleLiteSynthesis : public tlcBaseAuthSyn {
public:
     teleLiteSynthesis(acthSession *_ses,INT lvl=0) : tlcBaseAuthSyn(_ses,lvl),
                                       m_pChannel(NULL),
                                       m_pszUserid(NULL),
                                       m_tickSave(0), m_tickCurrent(0),
                                       m_table(0), m_pPrivate(NULL),
                                       m_flag(FALSE),isbout(FALSE),
                                       m_psavUser(NULL),m_blogoff(FALSE),
                                       m_pszAction(NULL),m_pList(NULL)

     {
          m_strInp       = new CHAR[tinpsz];
     }

     ~teleLiteSynthesis()
     {
          delete m_strInp;
     }


protected:
     virtual
     ACTHCODE
     proceedSynth()=0;

     virtual
     ACTHCODE
     proceedDerivedResponse()=0;

     VOID ParseInput();            // handle inputted message

     VOID JoinDefault(             // join default channel
     const CHAR *requestedChannel);// passed channel

     GBOOL RequestEntExit(         // request an entrance/exit message
     SHORT iType,                  // which one?
     GBOOL change);                // actually change it?

     VOID ClearEntExit(            // remove entrance/exit message
     SHORT iType);                 // which one?


     GBOOL validSession(           // low-level session validation
     const CHAR *user,             // the user in question
     const CHAR *sesid);           // the session-id

     GBOOL isValidSession();       // check if session is valid

     VOID abort();                 // overriden web-request abortion method

     GBOOL myCommandHandler();     // commands I need to handle myself

     VOID saveChanName();          // save channel name in member variable

     VOID saveUserName();          // save user name in member variable

     VOID setUpRegLink();          // set up registry link

     VOID openTableTags();         // opening <TABLE> tags

     VOID updateScript();          // channel update script code

     VOID termTableTags();         // closing </TABLE> tags



     CTlcUser* m_psavUser;              // pointer to user class object
     const CHAR* m_pszAction;           // action word
     CTlcAList* m_pList;                // pointer to action list class object
     CHAR m_helpbuf[MAXHLPSIZ];         // buffer to store action help info
     CTlcChannel* m_pChannel;           // pointer to channel class object
     CHAR m_saveUserBuf[TLCUIDSIZ];     // buffer to store tele user id
     CHAR m_saveChanBuf[CHAN_MAX_SIZE]; // buffer to store channel name

protected:
     GBOOL m_flag;                      // general-purpose flag
     CHAR* m_strInp;                    // input string
     CTlcPrivateChannel *m_pPrivate;    // pointer to private channel object
     const CHAR* m_pszUserid;           // pointer to userid string
     GBOOL isbout;                      // we have something to << bout?
     CHAR regLinkBuf[URLSIZ];           // buffer to store registry link
     LONG m_tickSave;                   // saved "tick" value for time-out
     LONG m_tickCurrent;                // current "tick" value
     SHORT m_table;                     // track which table we are on
     GBOOL m_blogoff;                   // log off this session?
};

class fileSyn : public teleLiteSynthesis {   // generic file output
public:
     fileSyn(
     acthSession* _ses,
     INT lvlcnt=1) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~fileSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};

class userSyn : public teleLiteSynthesis {   // user output
public:
     userSyn(
     acthSession* _ses,
     INT lvlcnt=2) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~userSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};

class channelSyn : public teleLiteSynthesis {   // channel output
public:
     channelSyn(
     acthSession* _ses,
     INT lvlcnt=2) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~channelSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};

class sendSyn : public teleLiteSynthesis {   // send output
public:
     sendSyn(
     acthSession* _ses,
     INT lvlcnt=1) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~sendSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};

class receiveSyn : public teleLiteSynthesis {   // receive output
public:
     receiveSyn(
     acthSession* _ses,
     INT lvlcnt=1) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~receiveSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};


class profileSyn : public teleLiteSynthesis {   // profile output
public:
     profileSyn(
     acthSession* _ses,
     INT lvlcnt=1) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~profileSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};


class actionSyn : public teleLiteSynthesis {   // action output
public:
     actionSyn(
     acthSession* _ses,
     INT lvlcnt=2) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~actionSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};


class initialSyn : public teleLiteSynthesis {   // initial output
public:
     initialSyn(
     acthSession* _ses,
     INT lvlcnt=0) : teleLiteSynthesis(_ses,lvlcnt)
     {
     }

     ~initialSyn()
     {
     }

protected:
     ACTHCODE
     proceedRequest();                  // setup request context

     ACTHCODE
     proceedSynth();                    // synthesise the response

     ACTHCODE
     proceedDerivedResponse();                 // output the response
};

#endif // __TLCAHLIT_H

