/////////////////////////////////////////////////////////////////////////////
//
//   TLCACTC.CPP
//
//   Copyright (c) 1997  Galacticomm, Inc.        All Rights Reserved
//
//   Teleconference Action List Class
//   Implementation
//                                               - Phil Henning 8/12/97
//
/////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "tlcapi.hpp"

#define FILREV "$Revision: 19 $"

CTlcAList* tmpAList;

MARKSOURCE(tlcactc);

CTlcAList::CTlcAList() : m_abspos(0L) , m_delTag(FALSE)
{
     *m_name='\0';
     memset(&m_action,0,sizeof(ACTION));
     memset(&m_config,0,sizeof(ACTLST));
}

CTlcAList::~CTlcAList()
{
}

const CHAR*
CTlcAList::GetName()
{
     return(m_name);
}

VOID
CTlcAList::SetName(
const CHAR* name)
{
     stzcpy(m_name,name,LISTSIZ);
}

const CHAR*
CTlcAList::wordGetFirst()
{
     ACTION action;

     dfaSetBlk(dfaAct);
     memset(&action,0,sizeof(ACTION));
     stlcpy(action.list,m_name,LISTSIZ);
     if (dfaAcqGT(&m_action,&action,0) && sameas(m_action.list,m_name)) {
          m_abspos=dfaAbs();
          dfaRstBlk();
          return(m_action.name);
     }
     m_abspos=0L;
     dfaRstBlk();
     return(NULL);
}

const CHAR*
CTlcAList::wordGetNext()
{
     dfaSetBlk(dfaAct);
     if (m_abspos == 0L) {
          return(NULL);
     }
     else {
          dfaGetAbs(&m_action,m_abspos,0);
          if (dfaAcqNX(&m_action) && sameas(m_action.list,m_name)) {
               m_abspos=dfaAbs();
               dfaRstBlk();
               return(m_action.name);
          }
     }
     m_abspos=0L;
     dfaRstBlk();
     return(NULL);
}

const CHAR*
CTlcAList::wordGetGT(
const CHAR* word)
{
     ACTION action;

     dfaSetBlk(dfaAct);
     stzcpy(action.list,m_name,ACTSIZ);
     stzcpy(action.name,word,ACTSIZ);
     if (dfaAcqGT(&m_action,&action,0) && sameas(m_action.list,m_name)) {
          m_abspos=dfaAbs();
          dfaRstBlk();
          return(m_action.name);
     }
     m_abspos=0L;
     dfaRstBlk();
     return(NULL);
}

GBOOL
CTlcAList::wordExists(
const CHAR* word)
{
     GBOOL retval=FALSE;
     ACTION action;

     dfaSetBlk(dfaAct);
     stzcpy(action.list,m_name,ACTSIZ);
     stzcpy(action.name,word,ACTSIZ);
     if (dfaAcqEQ(&m_action,&action,0)) {
          retval=TRUE;
     }
     dfaRstBlk();
     return(retval);
}

ACTION&
CTlcAList::actionGetCurrent()
{
     return(m_action);
}

LPACTION
CTlcAList::actionGetCurrentPtr()
{
     return(&m_action);
}

VOID
CTlcAList::SetConfig(
LPACTLST config)
{
     memmove(&m_config,config,sizeof(ACTLST));
}

LPACTLST
CTlcAList::GetConfigPtr()
{
     return(&m_config);
}

ACTLST&
CTlcAList::GetConfig()
{
     return(m_config);
}

VOID
CTlcAList::Delete()
{
     m_delTag=TRUE;
     listDeleteHook(&m_config);
}

GBOOL
CTlcAList::IsDeleted()
{
     return(m_delTag);
}

