/***************************************************************************
 *                                                                         *
 *   REMHDL.H                                                              *
 *                                                                         *
 *   Copyright 1997, Galacticomm, Inc.   All Rights Reserved               *
 *                                                                         *
 *   Object handler for Remote Sysop                                       *
 *                                                                         *
 *                                                 - 4/10/97 N.C. Osterc   *
 *                                                                         *
 ***************************************************************************/

#ifndef __REMHDL_H
#define __REMHDL_H

#include "remote.h"

class RemHdl {
public:
     RemHdl();                         // default constructor
     RemHdl(CHAR *user, CHAR *data, SHORT channel, SHORT status);
     RemHdl(CHAR *user, CHAR *cwd);
     RemHdl(CHAR *user, INT legend);
     ~RemHdl();
     SHORT GetStatus();
     SHORT GetChannel();
     CHAR *GetData();
     CHAR *GetUser();
     CHAR *GetCwd(CHAR *user);
     INT GetLegend(CHAR *user);
     VOID PutLegend(CHAR *user, INT legend);
     VOID UpdLegend(CHAR *user, INT legend);
     VOID PutCwd(CHAR *user, CHAR *cwd);
     VOID UpdCwd(CHAR *user, CHAR *cwd);
     VOID PutObj(CHAR *user, CHAR *data, SHORT channel, SHORT status);
     VOID DelObj();
     RemHdl *GetObj();
     INT TotObj();
     VOID CullObj();
private:
     CHAR _data[INPSIZ];
     CHAR _user[UIDSIZ];
     CHAR _cwd[FNDSIZE];
     SHORT _status;
     SHORT _channel;
     INT _legend;
};

#endif // __REMHDL_H
