////////////////////////////////////////////////////////////////////////////
//                                                                        //
//   REMHDL.CPP                                                           //
//                                                                        //
//                                                                        //
//   Vector-Mapped Object Handling for Remote Sysop AH.                   //
//                                                                        //
//                                                   -N.C. Osterc         //
//                                                                        //
////////////////////////////////////////////////////////////////////////////

#include "gcomm.h"
#include "majorbbs.h"
#include "remhdl.h"
#include "remote.h"
#include <functional>
#include <vector>
#include <cstring>
using namespace std;

#ifdef min(a,b)
#undef min(a,b)
#endif
#ifdef max(a,b)
#undef max(a,b)
#endif
using namespace std;

#pragma warn -par

typedef vector< RemHdl*> REMVEC;
typedef vector< RemHdl*> CWDVEC;
typedef vector< RemHdl*> LEGENDVEC;

REMVEC curRemVec;
CWDVEC cwdRemVec;
LEGENDVEC LegendRemVec;

#define FILREV "$Revision: 4 $"

RemHdl::RemHdl()                  // default constructor
{
}

RemHdl::RemHdl(                   // My constructor
CHAR *user,
CHAR *data,
SHORT channel,
SHORT status)
{

     ASSERT (user != NULL && data != NULL);

     stzcpy(_user,user,UIDSIZ);
     stzcpy(_data,data,INPSIZ);
     _channel=channel;
     _status=status;
}

RemHdl::RemHdl(
CHAR *user,
CHAR *cwd)
{
     ASSERT (user != NULL && cwd != NULL);

     stzcpy(_user,user,UIDSIZ);
     stzcpy(_cwd,cwd,FNDSIZE);
}

RemHdl::RemHdl(
CHAR *user,
INT legend)
{
     ASSERT (user != NULL);

     stzcpy(_user,user,UIDSIZ);
     _legend=legend;
}

RemHdl::~RemHdl()                 // default destructor
{
}

CHAR *
RemHdl::GetData()                 // gets current object's data
{
     return(_data);
}

CHAR *
RemHdl::GetCwd(
CHAR *user)
{
     CWDVEC::iterator p;

     ASSERT (user != NULL);

     for (p=cwdRemVec.begin() ; p != cwdRemVec.end() ; p++) {
          if (sameas(user,(*p)->_user)) {
               return((*p)->_cwd);
          }
     }
     return(NULL);
}

INT
RemHdl::GetLegend(
CHAR *user)
{
     LEGENDVEC::iterator p;

     ASSERT (user != NULL);

     for (p=LegendRemVec.begin() ; p != LegendRemVec.end() ; p++) {
          if (sameas(user,(*p)->_user)) {
               return((*p)->_legend);
          }
     }
     return(16);
}

VOID
RemHdl::UpdCwd(
CHAR *user,
CHAR *cwd)
{
     CWDVEC::iterator p;

     ASSERT (user != NULL && cwd != NULL);

     for (p=cwdRemVec.begin() ; p != cwdRemVec.end() ; p++) {
          if (sameas(user,(*p)->_user) && (*p)->_cwd[0] != '\0') {
               stlcpy((*p)->_cwd,cwd,FNDSIZE);
          }
     }
}

VOID
RemHdl::UpdLegend(
CHAR *user,
INT legend)
{
     LEGENDVEC::iterator p;

     ASSERT (user != NULL);

     for (p=LegendRemVec.begin() ; p != LegendRemVec.end() ; p++) {
          if (sameas(user,(*p)->_user)) {
               (*p)->_legend=legend;
          }
     }
}

SHORT
RemHdl::GetChannel()              // gets current objects code
{
     return(_channel);
}

SHORT
RemHdl::GetStatus()                // gets current objects status
{
     return(_status);
}

CHAR *                             // Get the user id
RemHdl::GetUser()
{
     return(_user);
}

INT
RemHdl::TotObj()                   // Count total objects
{
     REMVEC::iterator p;
     INT cnt=0;

     for (p=curRemVec.begin() ; p != curRemVec.end() ; p++) {
          cnt++;
     }
     return(cnt);
}

VOID
RemHdl::PutObj(                    // Put object to vector
CHAR *user,                        // the user
CHAR *data,                        // the data
SHORT channel,                     // the code
SHORT status)                      // the status
{
     RemHdl* pNewHdl;

     ASSERT(user != NULL);

     pNewHdl=new RemHdl(user,data,channel,status);
     curRemVec.push_back(pNewHdl);
}

VOID
RemHdl::PutCwd(
CHAR *user,
CHAR *cwd)
{
     RemHdl* pNewHdl;

     ASSERT (user != NULL && cwd != NULL);

     pNewHdl=new RemHdl(user,cwd);
     cwdRemVec.push_back(pNewHdl);
}

VOID
RemHdl::PutLegend(
CHAR *user,
INT legend)
{
     RemHdl* pNewHdl;

     ASSERT (user!= NULL);

     pNewHdl=new RemHdl(user,legend);
     LegendRemVec.push_back(pNewHdl);
}

RemHdl *
RemHdl::GetObj()                 // Is there data?
{
     REMVEC::iterator p;

     if (!curRemVec.empty()) {
          p=curRemVec.begin();
          return(*p);
     }
     return(NULL);
}

VOID
RemHdl::DelObj()                 // Delete first object
{
     REMVEC::iterator p;

     p=curRemVec.begin();
     delete (*p);
     curRemVec.erase(p);
}

VOID
RemHdl::CullObj()                // Get rid of extras objects
{
     REMVEC::iterator p;
     SHORT cntobj=0, i;

     for (p = curRemVec.begin() ; p != curRemVec.end() ; p++) {
          cntobj++;
     }
     for (i = 0 ; i < (cntobj-15) ; i++) {
          p=curRemVec.begin();
          delete(*p);
          curRemVec.erase(p);
     }
}
