/***************************************************************************
 *                                                                         *
 *   GCSASYS.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.   All rights reserved.      *
 *                                                                         *
 *   This is the header file for the Galacticomm Client/Server             *
 *   "System Agent", and auxiliary files.                                  *
 *                                                                         *
 *                                                - Bill Hyatt 6/21/94     *
 *                                                                         *
 *   Added support for Remote System Console agent.                        *
 *                                                                         *
 *                                                - Joe Delekto 1/10/96    *
 *                                                                         *
 ***************************************************************************/

#ifndef __GCSASYS_H
#define __GCSASYS_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define OSMSUBDR  "gcsvcman"SLS    /* OSM directory path                   */
#define OSMUPDDR  "gcsupdat"SLS    /* OSM update directory path            */

/* constants for access flags in remote system console */
#define   OPSALL    11        /* can send message to all                   */
#define   OPSEND    12        /* can send a message to individual          */
#define   OPLOGN    13        /* can change logon message                  */
#define   OPDETL    22        /* can view detail on a particular user      */
#define   OPAUDT    23        /* can view the audit trail information      */
#define   OPUSRS    24        /* can view users online                     */
#define   OPSRCH    25        /* can search for users                      */
#define   OPHNGP    31        /* can hangup a channel                      */
#define   OPSUSP    32        /* can suspend a user                        */
#define   OPPROT    33        /* can protect a user                        */
#define   OPDELT    34        /* can delete a user                         */
#define   OPSHDN    35        /* can shut down the server remotely         */
#define   OPCLNP    36        /* can force a cleanup or event              */
#define   OPSYSS    41        /* can view system statistics                */
#define   OPMODS    42        /* can view module statistics                */
#define   OPDEMS    43        /* can view demographics                     */
#define   OPCLSS    44        /* can view class statistics                 */
#define   OPEMUL    51        /* can emulate a channel                     */
#define   OPMNTR    52        /* can monitor all I/O                       */
#define   OPINPT    53        /* can monitor input only                    */
#define   OPCHNG    54        /* can change a channel's status             */
#define   OPTYPE    61        /* can 'type' files                          */
#define   OPCOPY    62        /* can 'copy' files                          */
#define   OPRENM    63        /* can rename files                          */
#define   OPDIR     64        /* can perform a directory listing           */
#define   OPMD      65        /* can make directories                      */
#define   OPRD      66        /* can remove directories                    */
#define   OPDEL     67        /* can delete files                          */
#define   OPACCT    71        /* can perform class accounting              */
#define   OPTRNF    73        /* can perform file transfers                */
#define   OPSYSP    99        /* can change access flags of other users    */

#define   ACCESS(op) hasaxs(usaptr,(op))     /* check for remote privs.    */
#define   ISMASTER() ((usrptr->flags&MASTER) != 0) /* check for master flag*/

GBOOL hasaxs(struct usracc *uacptr,INT op);
VOID inigenagt(VOID);
GBOOL newgenagt(CHAR *appid);
CHAR *copyuser(CHAR *baseu,CHAR *newuid,CHAR *psword,struct usracc *uaptr);

extern HMCVFILE gcsmb;             /* BBSERVER.MCV message block handle    */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __GCSASYS_H                          */
