/***************************************************************************
 *                                                                         *
 *   GALRSYAH.H                                                            *
 *                                                                         *
 *   Copyright 1997, Galacticomm, Inc.   All Rights Reserved               *
 *                                                                         *
 *   AH Remote Sysop Header                                                *
 *                                                                         *
 *                                                 - 4/10/97 N.C. Osterc   *
 *                                                                         *
 ***************************************************************************/

#ifndef __GALRSYAH_H
#define __GALRSYAH_H

#define PPFIX "galacth/galrsyah/"
#define copydata(s) stlcpy(acth_data,(s),INPSIZ)
#define NUMROPTS 30
#define NUMAUD 10                  // number of brief audit entries on summary
#define KEYLEN 16
#define BUSYOUT 0
#define NORMALIZE 1
#define NOANSWER  2
#define HANGUP 3
#define CLEANUP 0
#define EVENT1 11
#define EVENT2 12
#define EVENT3 13
#define EVENT4 14
#define NOEVENT -1                 // no valid event specified
#define CPYSIZ 2000
#define DRVLST 0
#define DIRLST 1
#define PUT 0
#define UPDATE 1
#define GET 2
#define CREATECLASS 0
#define EDITCLASS 1
#define DIRTRK 0x0001
#define CPYTRK 0x0002L                  /* track use of copy command       */
#define DELTRK 0x0004L                  /* track use of delete command     */
#define PUTTRK 0x0008L                  /* track use of upload command     */
#define GETTRK 0x0010L                  /* track use of download command   */
#define MDTRK  0x0020L                  /* track use of directory create   */
#define RDTRK  0x0040L                  /* track use of directory destroy  */
#define RENTRK 0x0080L                  /* track use of file rename        */
#define TYPTRK 0x0100L                  /* track use of type command       */
#define LNCTRK 0x0200L                  /* track use of lauch command      */
#define PSTTRK 0x0400L                  /* track use of credit posting     */
#define KILTRK 0x0800L                  /* track use of channel killing    */
#define EVTTRK 0x1000L                  /* track use of event takedown     */
#define KSYTRK 0x2000L                  /* track use of system kill        */
#define LOGTRK 0x4000L                  /* track use of logon announcement */
#define CHPTRK 0x8000L                  /* track use of channel operations */
#define MSGTRK 0x00010000L              /* track messages sent to users    */
#define AMSTRK 0x00020000L              /* track messages sent to all      */

static INT glthrv[5][3]={{0,1,0},{0,0,1},{1,0,0},{0,1,1},{1,1,0}};
static CHAR *rsmahkey;
IMPORT_VARIABLE(DFAFILE*) clsbb;
IMPORT_VARIABLE(struct clstab*) clshead;
IMPORT_VARIABLE(DFAFILE*) keysbb;
static CHAR drvs[][26]={"A:\\","B:\\","C:\\","D:\\","E:\\","F:\\","G:\\",
                        "H:\\","I:\\","J:\\","K:\\","L:\\","M:\\","N:\\",
                        "O:\\","P:\\","Q:\\","R:\\","S:\\","T:\\","U:\\",
                        "V:\\","W:\\","X:\\","Y:\\","Z:\\"};

static CHAR htmldrvs[][26]={"A:","B:","C:","D:","E:","F:","G:",
                        "H:","I:","J:","K:","L:","M:","N:",
                        "O:","P:","Q:","R:","S:","T:","U:",
                        "V:","W:","X:","Y:","Z:"};

IMPORT_VARIABLE(INT) sysload[60];     /* lines in use from SUMMARY.C load grph*/

static VOID acthshomal(VOID);
static VOID (*oldshomal)(VOID);
static USHORT track;

enum {ABOUTITLE, REGNO, BTRPARM, VERSINF, DSKFRE, CHANS, DLLSONSYS,
      OSINF, CREDTITLE, CREDITS, COPYRIGHT};

dnfStep rsyAboutSteps[]={
     dnfStep(DNFWATCH,ABOUTITLE,"ABOUTITLE"),
     dnfStep(DNFWATCH,REGNO,"REGNO"),
     dnfStep(DNFWATCH,BTRPARM,"BTRPARM"),
     dnfStep(DNFWATCH,VERSINF,"VERSINF"),
     dnfStep(DNFWATCH,DSKFRE,"DSKFRE"),
     dnfStep(DNFWATCH,CHANS,"CHANS"),
     dnfStep(DNFWATCH,DLLSONSYS,"DLLSONSYS"),
     dnfStep(DNFWATCH,OSINF,"OSINF"),
     dnfStep(DNFWATCH,CREDTITLE,"CREDTITLE"),
     dnfStep(DNFWATCH,CREDITS,"CREDITS"),
     dnfStep(DNFWATCH,COPYRIGHT,"COPYRIGHT"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAboutMap(PPFIX "rsyabout.htm",
              "About Screen",rsyAboutSteps);

enum {AUDENTRY};

dnfStep rsyAuditSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,AUDENTRY,"AUDENTRY"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAudEndMap(PPFIX "rsyadend.htm",
             "Audit Trail",rsyAuditSteps);

enum {AUDITZIP};

dnfStep rsyAuditTrailSteps[] =
{
     dnfStep(DNFWATCH,AUDITZIP,"ZIP"),
     dnfStep(DNFMAPEND)
};

dnfMap rsyAuditTrailMap( PPFIX "audit.htm", "Audit Trail", rsyAuditTrailSteps );

enum {POSTUID,ACC_USERID,ACC_CREATE,ACC_NAME,ACC_DAYLEFT,ACC_ADDR1,
      ACC_LASTLOG,ACC_ADDR2,ACC_USEDTDY,ACC_ADDR3,ACC_COLUMNS,
      ACC_LINES,ACC_PAUSE,ACC_ADDR4,VISPSW,ACC_PSW,ACC_PHONE,ACC_BORN,
      ACC_COMP1,ACC_COMP2,ACC_COMP3,ACC_COMP4,ACC_EDITORCHECK1,
      ACC_EDITORCHECK2,ACC_LANGVAL,ACC_LANGDESC,
      ACC_SEXCHECK1,ACC_SEXCHECK2,ACC_CLASSDESC,
      ACC_CREDAVAIL,ACC_MASTCHECK,ACC_SUSPENDCHECK,ACC_CREDTOTAL,
      ACC_TAG4KILCHECK,ACC_PROTECTCHECK,ACC_CREDPAID,
      ACC_PSWHINT,ACC_ALTEMAIL};

dnfStep rsyAccmainSteps[]={
          dnfStep(DNFWATCH,POSTUID,"POSTUID"),
          dnfStep(DNFWATCH,ACC_USERID,"ACC_USERID"),
          dnfStep(DNFWATCH,ACC_CREATE,"ACC_CREATE"),
          dnfStep(DNFWATCH,ACC_NAME,"ACC_NAME"),
          dnfStep(DNFWATCH,ACC_DAYLEFT,"ACC_DAYLEFT"),
          dnfStep(DNFWATCH,ACC_ADDR1,"ACC_ADDR1"),
          dnfStep(DNFWATCH,ACC_LASTLOG,"ACC_LASTLOG"),
          dnfStep(DNFWATCH,ACC_ADDR2,"ACC_ADDR2"),
          dnfStep(DNFWATCH,ACC_USEDTDY,"ACC_USEDTDY"),
          dnfStep(DNFWATCH,ACC_ADDR3,"ACC_ADDR3"),
          dnfStep(DNFWATCH,ACC_COLUMNS,"ACC_COLUMNS"),
          dnfStep(DNFWATCH,ACC_LINES,"ACC_LINES"),
          dnfStep(DNFWATCH,ACC_PAUSE,"ACC_PAUSE"),
          dnfStep(DNFWATCH,ACC_ADDR4,"ACC_ADDR4"),
          dnfStep(DNFWATCH,VISPSW,"VISPSW"),
          dnfStep(DNFWATCH,ACC_PSW,"ACC_PSW"),
          dnfStep(DNFWATCH,ACC_PHONE,"ACC_PHONE"),
          dnfStep(DNFWATCH,ACC_BORN,"ACC_BORN"),
          dnfStep(DNFWATCH,ACC_COMP1,"ACC_COMP1"),
          dnfStep(DNFWATCH,ACC_COMP2,"ACC_COMP2"),
          dnfStep(DNFWATCH,ACC_COMP3,"ACC_COMP3"),
          dnfStep(DNFWATCH,ACC_COMP4,"ACC_COMP4"),
          dnfStep(DNFWATCH,ACC_EDITORCHECK1,"ACC_EDITORCHECK1"),
          dnfStep(DNFWATCH,ACC_EDITORCHECK2,"ACC_EDITORCHECK2"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,ACC_LANGVAL,"ACC_LANGVAL"),
          dnfStep(DNFCOLUMN,ACC_LANGDESC,"ACC_LANGDESC"),
     dnfStep(DNFTABLEEND),
          dnfStep(DNFWATCH,ACC_SEXCHECK1,"ACC_SEXCHECK1"),
          dnfStep(DNFWATCH,ACC_SEXCHECK2,"ACC_SEXCHECK2"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,ACC_CLASSDESC,"ACC_CLASSDESC"),
     dnfStep(DNFTABLEEND),
          dnfStep(DNFWATCH,ACC_CREDAVAIL,"ACC_CREDAVAIL"),
          dnfStep(DNFWATCH,ACC_MASTCHECK,"ACC_MASTCHECK"),
          dnfStep(DNFWATCH,ACC_SUSPENDCHECK,"ACC_SUSPENDCHECK"),
          dnfStep(DNFWATCH,ACC_CREDTOTAL,"ACC_CREDTOTAL"),
          dnfStep(DNFWATCH,ACC_TAG4KILCHECK,"ACC_TAG4KILCHECK"),
          dnfStep(DNFWATCH,ACC_PROTECTCHECK,"ACC_PROTECTCHECK"),
          dnfStep(DNFWATCH,ACC_CREDPAID,"ACC_CREDPAID"),
          dnfStep(DNFWATCH,ACC_PSWHINT,"ACC_PSWHINT"),
          dnfStep(DNFWATCH,ACC_ALTEMAIL,"ACC_ALTEMAIL"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAccmainMap(PPFIX "rsyaccnt.htm",
                 "Account Screen",rsyAccmainSteps);


enum {VAR_TIME,VAR_DATE,VAR_MEMAVAIL,VAR_RESPONSE,VAR_HDROOM,
      VAR_OPENEMAIL,VAR_OPENFORUM,VAR_ACTIVEACCTS, VAR_TOTMSG,
      VAR_TOTCALLS,VAR_UPLOADS,VAR_DOWNLOADS};

dnfStep rsyVariableSteps[]={
     dnfStep(DNFWATCH,VAR_TIME,"VAR_TIME"),
     dnfStep(DNFWATCH,VAR_DATE,"VAR_DATE"),
     dnfStep(DNFWATCH,VAR_MEMAVAIL,"VAR_MEMAVAIL"),
     dnfStep(DNFWATCH,VAR_RESPONSE,"VAR_RESPONSE"),
     dnfStep(DNFWATCH,VAR_HDROOM,"VAR_HDROOM"),
     dnfStep(DNFWATCH,VAR_OPENEMAIL,"VAR_OPENEMAIL"),
     dnfStep(DNFWATCH,VAR_OPENFORUM,"VAR_OPENFORUM"),
     dnfStep(DNFWATCH,VAR_TOTMSG,"VAR_TOTMSG"),
     dnfStep(DNFWATCH,VAR_ACTIVEACCTS,"VAR_ACTIVEACCTS"),
     dnfStep(DNFWATCH,VAR_TOTCALLS,"VAR_TOTCALLS"),
     dnfStep(DNFWATCH,VAR_UPLOADS,"VAR_UPLOADS"),
     dnfStep(DNFWATCH,VAR_DOWNLOADS,"VAR_DOWNLOADS"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyVariableMap(PPFIX "rsyvari.htm",
               "System Variables",rsyVariableSteps);

enum {LGD_CHAN,LGD_USER};
dnfStep rsyLegendSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,LGD_CHAN,"LGD_CHAN"),
          dnfStep(DNFCOLUMN,LGD_USER,"LGD_USER"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyLegendMap(PPFIX "rsylegnd.htm",
               "User Legend",rsyLegendSteps);

enum {TXT_LOGMSG};
dnfStep rsyLoganoSteps[]={
     dnfStep(DNFWATCH,TXT_LOGMSG,"TXT_LOGMSG"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyLoganoMap(PPFIX "rsylgano.htm",
               "Logon Announcement",rsyLoganoSteps);

enum {DIRNAM,FULDIR,FDIR,FSIZ,FDATE,FTIME,URL,FLONGNAME};
dnfStep rsyDirSteps[]={
     dnfStep(DNFWATCH,DIRNAM,"DIRNAM"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,URL,"URL"),
          dnfStep(DNFCOLUMN,FULDIR,"FULDIR"),
          dnfStep(DNFCOLUMN,FDIR,"FDIR"),
          dnfStep(DNFCOLUMN,FSIZ,"FSIZ"),
          dnfStep(DNFCOLUMN,FDATE,"FDATE"),
          dnfStep(DNFCOLUMN,FTIME,"FTIME"),
          dnfStep(DNFCOLUMN,FLONGNAME,"FLONGNAME"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyDirMap(PPFIX "rsydout2.htm",
               "Directory Listing",rsyDirSteps);

enum {CYC};
dnfStep rsyCycleSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CYC,"CYC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyCopyMap(PPFIX "rsycycle.htm",
               "Copy files",rsyCycleSteps);
dnfMap rsyDeleteMap(PPFIX "rsycycle.htm",
               "Copy files",rsyCycleSteps);

enum {SRCH_UID,SRCHLNK_UID,SRCH_UIDNAM};
dnfStep rsySearchProcSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,SRCHLNK_UID,"SRCHLNK_UID"),
          dnfStep(DNFCOLUMN,SRCH_UID,"SRCH_UID"),
          dnfStep(DNFCOLUMN,SRCH_UIDNAM,"SRCH_UIDNAM"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsySearchProcMap(PPFIX "rsyscout.htm",
               "Search for Matches",rsySearchProcSteps);

enum {UID};
dnfStep rsyAccframeSteps[]={
     dnfStep(DNFWATCH,UID,"UID"),
     dnfStep(DNFWATCH,UID,"UID"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAccframeMap(PPFIX "rsyacfrm.htm",
                 "Account Functions",rsyAccframeSteps);

enum {TAB_USER,TAB_CHAN,TAB_LOC,TAB_CLS,TAB_CRED,TAB_TIMEON,TAB_INVIS};
dnfStep rsyUsersonSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,TAB_USER,"TAB_USER"),
          dnfStep(DNFCOLUMN,TAB_CHAN,"TAB_CHAN"),
          dnfStep(DNFCOLUMN,TAB_LOC,"TAB_LOC"),
          dnfStep(DNFCOLUMN,TAB_CLS,"TAB_CLS"),
          dnfStep(DNFCOLUMN,TAB_CRED,"TAB_CRED"),
          dnfStep(DNFCOLUMN,TAB_TIMEON,"TAB_TIMEON"),
          dnfStep(DNFCOLUMN,TAB_INVIS,"TAB_INVIS"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyUsersonMap(PPFIX "rsyusron.htm",
               "Users Online",rsyUsersonSteps);

enum {FUNCUID,FUID};

dnfStep rsyAccfuncSteps[]={
     dnfStep(DNFWATCH,FUNCUID,"FUNCUID"),
     dnfStep(DNFWATCH,FUID,"FUID"),
     dnfStep(DNFWATCH,FUID,"FUID"),
     dnfStep(DNFWATCH,FUID,"FUID"),
     dnfStep(DNFWATCH,FUID,"FUID"),
     dnfStep(DNFWATCH,FUID,"FUID"),
     dnfStep(DNFWATCH,FUID,"FUID"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAccfuncMap(PPFIX "rsyacbot.htm",
                 "Accounting Frame",rsyAccfuncSteps);

enum {RSYLINK,RSYUSER};
dnfStep rsyAccfindSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,RSYLINK,"RSYLINK"),
          dnfStep(DNFCOLUMN,RSYUSER,"RSYUSER"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAccfindMap(PPFIX "rsyaccls.htm",
                 "List of Users",rsyAccfindSteps);

enum {ACCOPUID,CHK_SENDALL,CHK_OVERALL,CHK_CHANEMU,CHK_SENDUSER,CHK_MODSTATS,
      CHK_CHANIO,CHK_LOGONMSG,CHK_SYSDEMO,CHK_CHANINP,CHK_CLSSTAT,
      CHK_CHANSTAT,CHK_DISFCON,CHK_DISCONU,CHK_DETAIL,CHK_LISTFDIR,
      CHK_SUSPENU,CHK_INFONU,CHK_COPYFIL,CHK_UNDAXS,CHK_SEARCH,
      CHK_RENFIL,CHK_DELETEU,CHK_AUDIT,CHK_DELFIL,CHK_SHUTDWN,
      CHK_ACCOUNT,CHK_CREATEDIR,CHK_FORCE,CHK_REMDIR,CHK_ACCFLG,
      CHK_FTOP};

dnfStep rsyAccopSteps[]={
      dnfStep(DNFWATCH,ACCOPUID,"ACCOPUID"),
      dnfStep(DNFWATCH,CHK_SENDALL,"CHK_SENDALL"),
      dnfStep(DNFWATCH,CHK_OVERALL,"CHK_OVERALL"),
      dnfStep(DNFWATCH,CHK_CHANEMU,"CHK_CHANEMU"),
      dnfStep(DNFWATCH,CHK_SENDUSER,"CHK_SENDUSER"),
      dnfStep(DNFWATCH,CHK_MODSTATS,"CHK_MODSTATS"),
      dnfStep(DNFWATCH,CHK_CHANIO,"CHK_CHANIO"),
      dnfStep(DNFWATCH,CHK_LOGONMSG,"CHK_LOGONMSG"),
      dnfStep(DNFWATCH,CHK_SYSDEMO,"CHK_SYSDEMO"),
      dnfStep(DNFWATCH,CHK_CHANINP,"CHK_CHANINP"),
      dnfStep(DNFWATCH,CHK_CLSSTAT,"CHK_CLSSTAT"),
      dnfStep(DNFWATCH,CHK_CHANSTAT,"CHK_CHANSTAT"),
      dnfStep(DNFWATCH,CHK_DISFCON,"CHK_DISFCON"),
      dnfStep(DNFWATCH,CHK_DISCONU,"CHK_DISCONU"),
      dnfStep(DNFWATCH,CHK_DETAIL,"CHK_DETAIL"),
      dnfStep(DNFWATCH,CHK_LISTFDIR,"CHK_LISTFDIR"),
      dnfStep(DNFWATCH,CHK_SUSPENU,"CHK_SUSPENU"),
      dnfStep(DNFWATCH,CHK_INFONU,"CHK_INFONU"),
      dnfStep(DNFWATCH,CHK_COPYFIL,"CHK_COPYFIL"),
      dnfStep(DNFWATCH,CHK_UNDAXS,"CHK_UNDAXS"),
      dnfStep(DNFWATCH,CHK_SEARCH,"CHK_SEARCH"),
      dnfStep(DNFWATCH,CHK_RENFIL,"CHK_RENFIL"),
      dnfStep(DNFWATCH,CHK_DELETEU,"CHK_DELETEU"),
      dnfStep(DNFWATCH,CHK_AUDIT,"CHK_AUDIT"),
      dnfStep(DNFWATCH,CHK_DELFIL,"CHK_DELFIL"),
      dnfStep(DNFWATCH,CHK_SHUTDWN,"CHK_SHUTDWN"),
      dnfStep(DNFWATCH,CHK_ACCOUNT,"CHK_ACCOUNT"),
      dnfStep(DNFWATCH,CHK_CREATEDIR,"CHK_CREATEDIR"),
      dnfStep(DNFWATCH,CHK_FORCE,"CHK_FORCE"),
      dnfStep(DNFWATCH,CHK_REMDIR,"CHK_REMDIR"),
      dnfStep(DNFWATCH,CHK_ACCFLG,"CHK_ACCFLG"),
      dnfStep(DNFWATCH,CHK_FTOP,"CHK_FTOP"),
      dnfStep(DNFMAPEND)
};
dnfMap rsyAccopMap(PPFIX "rsyaccop.htm",
              "Remote Access Options",rsyAccopSteps);

struct AccOp {
     CHAR *opname;
     INT op;
} AccOps[]={
     {"NAM_SENDALL",11},
     {"NAM_OVERALL",41},
     {"NAM_CHANEMU",51},
     {"NAM_SENDUSER",12},
     {"NAM_MODSTATS",42},
     {"NAM_CHANIO",52},
     {"NAM_LOGONMSG",13},
     {"NAM_SYSDEMO",43},
     {"NAM_CHANINP",53},
     {"NAM_CLSSTAT",44},
     {"NAM_CHANSTAT",54},
     {"NAM_DISFCON",61},
     {"NAM_DISCONU",31},
     {"NAM_DETAIL",22},
     {"NAM_LISTFDIR",64},
     {"NAM_SUSPENU",32},
     {"NAM_INFONU",24},
     {"NAM_COPYFIL",62},
     {"NAM_UNDAXS",33},
     {"NAM_SEARCH",25},
     {"NAM_RENFIL",63},
     {"NAM_DELETEU",34},
     {"NAM_AUDIT",23},
     {"NAM_DELFIL",67},
     {"NAM_SHUTDWN",35},
     {"NAM_ACCOUNT",71},
     {"NAM_CREATEDIR",65},
     {"NAM_FORCE",36},
     {"NAM_REMDIR",66},
     {"NAM_ACCFLG",99},
     {"NAM_FTOP",73}
};

enum {HID_IMPCLS,KEYUID,KEYUIDS,CLS_OPDESC,KEY_OPDESC,LST_KEYDESC};
dnfStep rsyAcckeySteps[]={
     dnfStep(DNFWATCH,KEYUID,"KEYUID"),
     dnfStep(DNFWATCH,HID_IMPCLS,"HID_IMPCLS"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLS_OPDESC,"CLS_OPDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,KEYUID,"KEYUID"),
     dnfStep(DNFWATCH,HID_IMPCLS,"HID_IMPCLS"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,KEY_OPDESC,"KEY_OPDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,KEYUID,"KEYUID"),
     dnfStep(DNFWATCH,HID_IMPCLS,"HID_IMPCLS"),
     dnfStep(DNFWATCH,KEYUID,"KEYUID"),
     dnfStep(DNFWATCH,HID_IMPCLS,"HID_IMPCLS"),
     dnfStep(DNFWATCH,KEYUIDS,"KEYUIDS"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,KEY_OPDESC,"LST_KEYDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAcckeyMap(PPFIX "rsyackey.htm",
              "Edit User Keyring",rsyAcckeySteps);

enum {DEM_COMP,DEM_19,DEM_29,DEM_39,DEM_49,DEM_99,DEM_TOTAL,DEM_MALE,
      DEM_FEMALE,DEM_CORPORATE,DEM_ANSI};

dnfStep rsyDemoSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,DEM_COMP,"DEM_COMP"),
          dnfStep(DNFCOLUMN,DEM_19,"DEM_19"),
          dnfStep(DNFCOLUMN,DEM_29,"DEM_29"),
          dnfStep(DNFCOLUMN,DEM_39,"DEM_39"),
          dnfStep(DNFCOLUMN,DEM_49,"DEM_49"),
          dnfStep(DNFCOLUMN,DEM_99,"DEM_99"),
          dnfStep(DNFCOLUMN,DEM_TOTAL,"DEM_TOTAL"),
     dnfStep(DNFTABLEEND),
          dnfStep(DNFWATCH,DEM_MALE,"DEM_MALE"),
          dnfStep(DNFWATCH,DEM_FEMALE,"DEM_FEMALE"),
          dnfStep(DNFWATCH,DEM_CORPORATE,"DEM_CORPORATE"),
          dnfStep(DNFWATCH,DEM_ANSI,"DEM_ANSI"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyDemoMap(PPFIX "rsydemgr.htm",
              "Demographics",rsyDemoSteps);

enum {CST_NAME,CST_HRSU,CST_AVGDAY,CST_TOTU,CST_AVGMINDAY};

dnfStep rsyCstSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CST_NAME,"CST_NAME"),
          dnfStep(DNFCOLUMN,CST_HRSU,"CST_HRSU"),
          dnfStep(DNFCOLUMN,CST_AVGDAY,"CST_AVGDAY"),
          dnfStep(DNFCOLUMN,CST_TOTU,"CST_TOTU"),
          dnfStep(DNFCOLUMN,CST_AVGMINDAY,"CST_AVGMINDAY"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyCstMap(PPFIX "rsyclsst.htm",
              "Class Statistics",rsyCstSteps);

enum {MST_NAME,MST_HRSU,MST_CRSU,MST_CALLS,MST_UPLOADS,MST_DOWNLOADS,
      MST_MESSAGES,MST_EMAIL,MST_FORUMS,MST_FREECRED,MST_PAIDCRED};

dnfStep rsyMstSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,MST_NAME,"MST_NAME"),
          dnfStep(DNFCOLUMN,MST_HRSU,"MST_HRSU"),
          dnfStep(DNFCOLUMN,MST_CRSU,"MST_CRSU"),
     dnfStep(DNFTABLEEND),
          dnfStep(DNFWATCH,MST_CALLS,"MST_CALLS"),
          dnfStep(DNFWATCH,MST_UPLOADS,"MST_UPLOADS"),
          dnfStep(DNFWATCH,MST_DOWNLOADS,"MST_DOWNLOADS"),
          dnfStep(DNFWATCH,MST_MESSAGES,"MST_MESSAGES"),
          dnfStep(DNFWATCH,MST_EMAIL,"MST_EMAIL"),
          dnfStep(DNFWATCH,MST_FORUMS,"MST_FORUMS"),
          dnfStep(DNFWATCH,MST_FREECRED,"MST_FREECRED"),
          dnfStep(DNFWATCH,MST_PAIDCRED,"MST_PAIDCRED"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyMstMap(PPFIX "rsymscst.htm",
              "Miscellaneous Statistics",rsyMstSteps);

enum {COPYUID,VAL_NEWPAS,VISNEWPSW};
dnfStep rsyAcccpySteps[]={
     dnfStep(DNFWATCH,COPYUID,"COPYUID"),
     dnfStep(DNFWATCH,VISNEWPSW,"VISNEWPSW"),
     dnfStep(DNFWATCH,VAL_NEWPAS,"VAL_NEWPAS"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAcccpyMap(PPFIX "rsyaccpy.htm",
              "Copy a user Account",rsyAcccpySteps);

enum {PSTUID, PUID, CHK_CREDFREE, CHK_CREDPAID, VAL_DAYSLEFT};
dnfStep rsyAccpostSteps[]={
     dnfStep(DNFWATCH,PSTUID,"PSTUID"),
     dnfStep(DNFWATCH,PUID,"PUID"),
     dnfStep(DNFWATCH,CHK_CREDPAID,"CHK_CREDPAID"),
     dnfStep(DNFWATCH,CHK_CREDFREE,"CHK_CREDFREE"),
     dnfStep(DNFWATCH,PSTUID,"PSTUID"),
     dnfStep(DNFWATCH,PUID,"PUID"),
     dnfStep(DNFWATCH,VAL_DAYSLEFT,"VAL_DAYSLEFT"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyAccpostMap(PPFIX "rsypstac.htm",
             "Post Credits/Days to User",rsyAccpostSteps);

enum {USER, CHNUM, STCODE, CHDATA};
dnfStep rsyMonitorSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,USER,"USER"),
          dnfStep(DNFCOLUMN,CHNUM,"CHNUM"),
          dnfStep(DNFCOLUMN,STCODE,"STCODE"),
          dnfStep(DNFCOLUMN,CHDATA,"CHDATA"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyMonitorMap(PPFIX "rsymontr.htm",
              "Monitor Screen",rsyMonitorSteps);

enum {CLASSDESC};
dnfStep rsyEditClassSteps[]={
    dnfStep(DNFTABLE),
         dnfStep(DNFCOLUMN,CLASSDESC,"CLASSDESC"),
    dnfStep(DNFTABLEEND),
    dnfStep(DNFMAPEND)
};
dnfMap rsyEditClassMap(PPFIX "rsyiclse.htm",
              "Edit which class?",rsyEditClassSteps);

dnfStep rsyKillClassSteps[]={
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASSDESC,"CLASSDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFMAPEND)
};
dnfMap rsyKillClassMap(PPFIX "rsyiclsd.htm",
              "Delete which class?",rsyKillClassSteps);

enum {NAM_USER};
dnfStep rsyMsg2UserSteps[]={
     dnfStep(DNFWATCH,NAM_USER,"NAM_USER"),
     dnfStep(DNFWATCH,NAM_USER,"NAM_USER"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyMsg2UserMap(PPFIX "rsymsg2u.htm",
              "Send message to user",rsyMsg2UserSteps);

enum {CLASSWATCH,EDITWATCH,VAL_MINPERSESS,MINPERSESSCHECKED,
      VAL_MINPERDAY,MINPERDAYCHECKED,SOFFCHECKED,RESTOFDAYCHECKED,
      VAL_CLASSTRANS,CREDEXEMPTCHECKED,ACCRUECHECKED,
      VAL_DEBTLIMIT,DEBTLIMITCHECKED,VAL_GENREP,RADGENREP0CHECKED,
      RADGENREP1CHECKED,RADGENREP2CHECKED,RADGENREP3CHECKED,
      VAL_REPDAYS,LOGGEDINCHECKED,VAL_DAYSNOLOG,
      DAYSINCHECKED,VAL_DAYSIN,CREDOUTCHECKED,CREDPOSTCHECKED,
      REACHLIMCHECKED,VAL_CLASSTRANS1,VAL_TXTKEYLIST,CLASDESC,
      VAL_HIDCLS,NOCHECKED,NONECHECKED};

dnfStep rsyDoCreateClassSteps[]={
     dnfStep(DNFWATCH,CLASSWATCH,"CLASSWATCH"),
     dnfStep(DNFWATCH,VAL_HIDCLS,"VAL_HIDCLS"),
     dnfStep(DNFWATCH,VAL_MINPERSESS,"VAL_MINPERSESS"),
     dnfStep(DNFWATCH,MINPERSESSCHECKED,"MINPERSESSCHECKED"),
     dnfStep(DNFWATCH,VAL_MINPERDAY,"VAL_MINPERDAY"),
     dnfStep(DNFWATCH,MINPERDAYCHECKED,"MINPERDAYCHECKED"),
     dnfStep(DNFWATCH,SOFFCHECKED,"4SOFFCHECKED"),
     dnfStep(DNFWATCH,RESTOFDAYCHECKED,"RESTOFDAYCHECKED"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,VAL_CLASSTRANS,"VAL_CLASSTRANS"),
     dnfStep(DNFWATCH,CREDEXEMPTCHECKED,"CREDEXEMPTCHECKED"),
     dnfStep(DNFWATCH,ACCRUECHECKED,"ACCRUECHECKED"),
     dnfStep(DNFWATCH,NOCHECKED,"NOCHECKED"),
     dnfStep(DNFWATCH,VAL_DEBTLIMIT,"VAL_DEBTLIMIT"),
     dnfStep(DNFWATCH,DEBTLIMITCHECKED,"DEBTLIMITCHECKED"),
     dnfStep(DNFWATCH,VAL_GENREP,"VAL_GENREP"),
     dnfStep(DNFWATCH,RADGENREP0CHECKED,"RADGENREP0CHECKED"),
     dnfStep(DNFWATCH,RADGENREP1CHECKED,"RADGENREP1CHECKED"),
     dnfStep(DNFWATCH,RADGENREP2CHECKED,"RADGENREP2CHECKED"),
     dnfStep(DNFWATCH,RADGENREP3CHECKED,"RADGENREP3CHECKED"),
     dnfStep(DNFWATCH,VAL_REPDAYS,"VAL_REPDAYS"),
     dnfStep(DNFWATCH,LOGGEDINCHECKED,"LOGGEDINCHECKED"),
     dnfStep(DNFWATCH,VAL_DAYSNOLOG,"VAL_DAYSNOLOG"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,DAYSINCHECKED,"DAYSINCHECKED"),
     dnfStep(DNFWATCH,VAL_DAYSIN,"VAL_DAYSIN"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,CREDOUTCHECKED,"CREDOUTCHECKED"),
     dnfStep(DNFWATCH,CREDPOSTCHECKED,"CREDPOSTCHECKED"),
     dnfStep(DNFWATCH,REACHLIMCHECKED,"REACHLIMCHECKED"),
     dnfStep(DNFWATCH,NONECHECKED,"NONECHECKED"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,VAL_CLASSTRANS1,"VAL_CLASSTRANS1"),
     dnfStep(DNFWATCH,VAL_TXTKEYLIST,"VAL_TXTKEYLIST"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyDoCreateMap(PPFIX "rsyclasc.htm",
              "Creating Class",rsyDoCreateClassSteps);

dnfStep rsyDoEditClassSteps[]={
     dnfStep(DNFWATCH,CLASSWATCH,"CLASSWATCH"),
     dnfStep(DNFWATCH,VAL_HIDCLS,"VAL_HIDCLS"),
     dnfStep(DNFWATCH,VAL_MINPERSESS,"VAL_MINPERSESS"),
     dnfStep(DNFWATCH,MINPERSESSCHECKED,"MINPERSESSCHECKED"),
     dnfStep(DNFWATCH,VAL_MINPERDAY,"VAL_MINPERDAY"),
     dnfStep(DNFWATCH,MINPERDAYCHECKED,"MINPERDAYCHECKED"),
     dnfStep(DNFWATCH,SOFFCHECKED,"4SOFFCHECKED"),
     dnfStep(DNFWATCH,RESTOFDAYCHECKED,"RESTOFDAYCHECKED"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,VAL_CLASSTRANS,"VAL_CLASSTRANS"),
     dnfStep(DNFWATCH,CREDEXEMPTCHECKED,"CREDEXEMPTCHECKED"),
     dnfStep(DNFWATCH,ACCRUECHECKED,"ACCRUECHECKED"),
     dnfStep(DNFWATCH,NOCHECKED,"NOCHECKED"),
     dnfStep(DNFWATCH,VAL_DEBTLIMIT,"VAL_DEBTLIMIT"),
     dnfStep(DNFWATCH,DEBTLIMITCHECKED,"DEBTLIMITCHECKED"),
     dnfStep(DNFWATCH,VAL_GENREP,"VAL_GENREP"),
     dnfStep(DNFWATCH,RADGENREP0CHECKED,"RADGENREP0CHECKED"),
     dnfStep(DNFWATCH,RADGENREP1CHECKED,"RADGENREP1CHECKED"),
     dnfStep(DNFWATCH,RADGENREP2CHECKED,"RADGENREP2CHECKED"),
     dnfStep(DNFWATCH,RADGENREP3CHECKED,"RADGENREP3CHECKED"),
     dnfStep(DNFWATCH,VAL_REPDAYS,"VAL_REPDAYS"),
     dnfStep(DNFWATCH,LOGGEDINCHECKED,"LOGGEDINCHECKED"),
     dnfStep(DNFWATCH,VAL_DAYSNOLOG,"VAL_DAYSNOLOG"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,DAYSINCHECKED,"DAYSINCHECKED"),
     dnfStep(DNFWATCH,VAL_DAYSIN,"VAL_DAYSIN"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,CREDOUTCHECKED,"CREDOUTCHECKED"),
     dnfStep(DNFWATCH,CREDPOSTCHECKED,"CREDPOSTCHECKED"),
     dnfStep(DNFWATCH,REACHLIMCHECKED,"REACHLIMCHECKED"),
     dnfStep(DNFWATCH,NONECHECKED,"NONECHECKED"),
     dnfStep(DNFTABLE),
          dnfStep(DNFCOLUMN,CLASDESC,"CLASDESC"),
     dnfStep(DNFTABLEEND),
     dnfStep(DNFWATCH,VAL_CLASSTRANS1,"VAL_CLASSTRANS1"),
     dnfStep(DNFWATCH,VAL_TXTKEYLIST,"VAL_TXTKEYLIST"),
     dnfStep(DNFMAPEND)
};
dnfMap rsyDoEditMap(PPFIX "rsyclase.htm",
              "Editing Class",rsyDoEditClassSteps);

#endif // __GALRSYAH_H
