/***************************************************************************
 *                                                                         *
 *   CMDPARSE.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1999 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Remote Sysop command line parser implementation.          *
 *                                                                         *
 *                                           - J. Alvrus    01/04/1999     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include <cstring.h>               // change if use different string impl.
#include "cmdparse.h"

#define FILREV "$Revision: 1 $"

#define isCmdChar(c) isalpha(c)

MARKSOURCE(cmdparse)

rsyCommandParser::rsyCommandParser() :
     m_pCur(NULL)
{
}

rsyCommandParser::~rsyCommandParser()
{
}

CHAR const *                       //   returns pointer to internal buffer
rsyCommandParser::GetCommand(      // get command string from new command line
CHAR const * s)                    //   new command line to parse
{
     m_CommandLine=s;
     m_pCur=::skptwht(m_CommandLine.c_str());
     while (isCmdChar(*m_pCur)) {
          m_cmd+=*m_pCur++;
     }
     return(m_cmd.c_str());
}

CHAR const *                       //   returns pointer to internal buffer
rsyCommandParser::GetNextArg()     // get next argument from command line
{
     // handle lack of initialization
     ASSERT(m_pCur != NULL);
     if (m_pCur == NULL) {
          return("");
     }

     // skip to start of next command
     m_arg="";
     m_pCur=::skptwht(m_pCur);
     while (*m_pCur != '\0') {

          // check for quoted section
          if (*m_pCur == '\"') {

               // find end of quoted section
               ++m_pCur;
               CHAR const * pEnd=::strchr(m_pCur,'\"');
               if (pEnd == NULL) {
                    pEnd=m_pCur+::strlen(m_pCur);
               }

               // append to argument
               m_arg.append(m_pCur,0,pEnd-m_pCur);
               if (*pEnd == '\"') {
                    ++pEnd;
               }
               m_pCur=pEnd;
          }
          // else if found end of argument, exit loop
          else if (isspace(*m_pCur)) {
               break;
          }
          // else add char to argument
          else {
               m_arg+=*m_pCur++;
          }
     }
     return(m_arg.c_str());
}
