/***************************************************************************
 *                                                                         *
 *   REGTVB.H                                                              *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML Registry Text Variables                                   *
 *                                                                         *
 *                                                                         *
 *                                                - Phil Henning 8/20/98   *
 *                                                                         *
 ***************************************************************************/

#include "enctvb.h"
#include "dnf.h"
#include "dnfmgr.h"

#ifndef __REGTVB_H
#define __REGTVB_H

extern basicTvb regIsAuth;                   // REG_ISAUTH
extern basicTvb regHasCompleted;             // REG_HASCOMPLETED
extern htmlEncodedTvb regHasCompletedText;   // REG_HASCOMPLETED_TEXT

extern basicTvb regErrCode;                  // RERR_CODE
extern htmlEncodedTvb regErrMessage;         // RERR_MESSAGE

extern htmlEncodedTvb regUserid;             // REG_USERID
extern urlEncodedTvb regUseridURL;           // REG_USERID_URL

extern basicTvb** regQuestionN;              // REG_QUESTION_n
extern basicTvb** regAnswerN;                // REG_ANSWER_n
extern basicTvb** regMaxAnsN;                // REG_MAXANS_n

extern linkedHtmlEncodedTvb* regQuestion;    // REG_QUESTION
extern linkedHtmlEncodedTvb* regAnswer;      // REG_ANSWER
extern basicTvb regMaxAns;                   // REG_MAXANS
extern basicTvb regQuestionNumber;           // REG_QUESTION_NUMBER

extern linkedHtmlEncodedTvb* regSummaryQ;    // REG_SUMMARYQ
extern linkedHtmlEncodedTvb* regSummaryA;    // REG_SUMMARYA

extern basicTvb regLargestAns;               // REG_LARGESTANS

extern basicTvb regCanDelete;                // REG_CANDELETE
extern htmlEncodedTvb regCanDeleteText;      // REG_CANDELETE_TEXT

extern basicTvb regListCount;                // RLST_COUNT
extern basicTvb regListOrder;                // RLST_ORDER
extern basicTvb regListMoreHigh;             // RLST_MORE_HIGH
extern basicTvb regListMoreLow;              // RLST_MORE_LOW
extern urlEncodedTvb regListUserHigh;        // RLST_USER_HIGH
extern urlEncodedTvb regListUserLow;         // RLST_USER_LOW

extern htmlEncodedTvb regNew;                // REG_NEW
extern htmlEncodedTvb regNewText;            // REG_NEW_TEXT

extern CHAR* g_pszAnchor;                    // anchor format string

VOID
setupUserContext(                       // setup question/summary answers
const struct regrec& rec);              //   based on this registry record

VOID
linkAnswers(                            // toggle linking on answer tvbs
bool link);                             //   link on/off

VOID
clearAllTVars();                        // clear all registry tvbs

VOID
setNewTvb(                              // set REG_NEW and REG_NEW_TEXT
bool isnew);                            //   is new?

VOID
setNoList(                              // set REG_NOLIST tvbs
bool bIsList);                          //   was there a list?

VOID
setTarget(                              // set REG_TARGET tvbs
bool bTarget);                          //   set them?

VOID
setAllQuestions();                      // setup all the REG_QUESTION_n vars

VOID
setCurrentQuestion(                     // setup REG_QUESTION
INT idx);                               //   to this question index

VOID
setCurrentAnswer(                       // setup REG_ANSWER
INT idx);                               //  to this answer index

VOID
clearAllAnswers();                      // clear all REG_ANSWER_n vars

VOID
initQuestionTxv(                        // init Q/A text variables
INT num);                               //  number of tvbs to create

VOID
finishQuestionTxv();                    // shutdown Q/A vars

VOID
initMcvText();                          // initialize MCV options

VOID
finishMcvText();                        // free up stored MCV options

VOID
setHasCompletedTvb(                     // set REG_HASCOMPLETED tvars
CHAR const * userid);                   //   userid to check

VOID
setCanDelete(                           // set REG_CANDELETE tvar
bool candelete);                        //   does user have delete access?

VOID
setErrorVars(                           // set error code vars
errorcodes code);                       //   error code

#endif // __REGTVB_H

