/***************************************************************************
 *                                                                         *
 *   REGISTRY.H                                                            *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   These are common declarations for REGISTRY.C and CSREGIS.C.           *
 *                                                                         *
 *                                                - Bill Hyatt 9/4/94      *
 *                                                                         *
 ***************************************************************************/

#ifndef __REGISTRY_H
#define __REGISTRY_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#if defined(GCWINNT)
#ifdef __BUILDGALREG
#define REGEXP _export
#else
#define REGEXP _import
#endif // __BUILDGALREG
#else
#define REGEXP
#endif // GCWINNT


#define   PROSIZ 900               /* profile size (gen purp. text block)  */
#define   SUMSIZ 40                /* number of bytes allowed for summary  */
#define   MAXFLD 30                /* maximum number of fields in profile  */

                 /* used for obtaining registry field info from CNF blocks */
#define   fldmsg(n) (FLDPMT1+4*(n))/* beg. msg# for a field's blocks       */
#define   PMTOFF 0                 /* offset for A/A prompt                */
#define   SIZOFF 1                 /* offset for answer size               */
#define   LBLOFF 2                 /* offset for C/S label                 */
#define   CSQOFF 3                 /* offset for C/S version of question   */

extern HMCVFILE REGEXP regmb;      /* registry message file block handle   */

extern DFAFILE * REGEXP regbb;     /* registry btrieve file pointer        */

struct regrec {                    /* user registry structure              */
     CHAR userid[UIDSIZ];          /* user-id of registry record           */
     CHAR sumlin[SUMSIZ];          /* one-line summary for directory       */
     CHAR profil[PROSIZ];          /* user's "profile"                     */
};

struct reginf {                    /* registry field info                  */
     INT ansidx;                   /*   index to beg of ans in profile     */
     INT anssiz;                   /*   size of answer in profile          */
};

extern struct reginf REGEXP reginf[MAXFLD];/* array of registry field info        */

extern INT REGEXP numfds;                 /* number of configured fields   */

extern
CHAR *regakey,                     /* key req'd to access registry agent   */
     * REGEXP regkey,              /* key req'd to create registry entries */
     * REGEXP viewkey,             /* key req'd to view other entries      */
     * REGEXP delkey;              /* key req'd to delete other entries    */

extern GBOOL regnag;               /* nag users to fill out their registry?*/


VOID inicsregis(VOID);             /* initialize the registry agent        */
VOID init__galreg(VOID);           /* main initalization routine           */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __REGISTRY_H                         */
