/***************************************************************************
 *                                                                         *
 *   ENCTVB.H                                                              *
 *                                                                         *
 *   Copyright (c) 1998       Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Active HTML Encoded Text Variable Classes                             *
 *   Declarations                                                          *
 *                                                                         *
 *                                                - Phil Henning 8/20/98   *
 *                                                                         *
 ***************************************************************************/

#include "tvb.h"
#include <cstring.h>


#ifndef __ENCTVB_H
#define __ENCTVB_H

class basicTvb : public tvbDefinition {
public:
     basicTvb(                          // tvb constructor
     CHAR const * pszName);             // name of tvb

     basicTvb(                          // tvb copy constructor
     basicTvb const & rhs);             // not implemented, not safe to copy
                                        // tvbsx

     virtual
     ~basicTvb();                       // tvb destructor

     virtual
     CHAR const *                       //  text to output
     resolve(                           // resolve tvb
     CHAR const * nam);                 //  name of tvb

     virtual
     string const                       //  string value
     str() const;                       // get string value of tvb

     virtual
     CHAR const *                       //  value of tvb
     get() const;                       // get value of tvb

     string&
     remove(                            // remove characters from string
     size_t pos);                       // starting here

     string&
     remove(                            // remove characters from string
     size_t pos,                        // starting here
     size_t n);                         // this many characters

     size_t
     length() const;                    // get length of the string


     // assignment operators

     virtual
     basicTvb&
     operator= (CHAR const * stg);

     virtual
     basicTvb&
     operator+= (CHAR const * stg);

     virtual
     basicTvb&
     operator= (CHAR ch);

     virtual
     basicTvb&
     operator+= (CHAR ch);

     virtual
     basicTvb&
     operator= (string const & str);

     virtual
     basicTvb&
     operator+= (string const & str);

     virtual
     basicTvb&
     operator= (LONG num);

     virtual
     basicTvb&
     operator+= (LONG num);

     virtual
     basicTvb&
     operator= (ULONG num);

     virtual
     basicTvb&
     operator+= (ULONG num);

     virtual
     basicTvb&
     operator= (INT num);

     virtual
     basicTvb&
     operator+= (INT num);

     virtual
     basicTvb&
     operator= (UINT num);

     virtual
     basicTvb&
     operator+= (UINT num);

     virtual
     basicTvb&
     operator= (SHORT num);

     virtual
     basicTvb&
     operator+= (SHORT num);

     virtual
     basicTvb&
     operator= (USHORT num);

     virtual
     basicTvb&
     operator+= (USHORT num);

     virtual
     basicTvb&
     operator= (double num);

     virtual
     basicTvb&
     operator+= (double num);

     virtual
     basicTvb&
     operator= (basicTvb const & rhs);

     virtual
     basicTvb&
     operator+= (basicTvb const & rhs);

protected:
     // assignment/concat utility functs

     VOID
     Concat(
     CHAR const * stg);

     VOID
     Assign(
     CHAR const * stg);

     VOID
     Concat(
     CHAR ch);

     VOID
     Assign(
     CHAR ch);

     VOID
     Concat(
     string const & str);

     VOID
     Assign(
     string const & str);

     VOID
     Concat(
     LONG num);

     VOID
     Assign(
     LONG num);

     VOID
     Concat(
     ULONG num);

     VOID
     Assign(
     ULONG num);

     VOID
     Concat(
     INT num);

     VOID
     Assign(
     INT num);

     VOID
     Concat(
     UINT num);

     VOID
     Assign(
     UINT num);

     VOID
     Concat(
     SHORT num);

     VOID
     Assign(
     SHORT num);

     VOID
     Concat(
     USHORT num);

     VOID
     Assign(
     USHORT num);

     VOID
     Concat(
     double num);

     VOID
     Assign(
     double num);

protected:
     string m_pValue;                   // value of tvb
     bool m_Changed;                    // has value changed since last output
};

class encodedTvb : public basicTvb {
public:
     encodedTvb(                        // tvb constructor
     CHAR const * pszName);             //  name of tvb

     virtual
     ~encodedTvb();                     // tvb destructor

     CHAR const *                       //  text to output
     resolve(                           // resolve tvb
     CHAR const * nam);                 //  name of tvb

     VOID
     toggleEncode(                      // toggle encoding
     bool enc);                         //  encode on/off

protected:
     virtual
     CHAR const *                       //  encoded text
     encode()=0;                        // encoding method

     string* m_pEncodedString;          // encoded string
     bool m_doencode;                   // should we perform encoding?
};

class htmlEncodedTvb : public encodedTvb {
public:
     htmlEncodedTvb(                    // tvb constructor
     CHAR const * pszName);             //  name of tvb

     virtual
     ~htmlEncodedTvb();                 // tvb destructor

     // assignment operators

     virtual
     htmlEncodedTvb&
     operator= (CHAR const * stg);

     virtual
     htmlEncodedTvb&
     operator+= (CHAR const * stg);

     virtual
     htmlEncodedTvb&
     operator= (CHAR ch);

     virtual
     htmlEncodedTvb&
     operator+= (CHAR ch);

     virtual
     htmlEncodedTvb&
     operator= (string const & str);

     virtual
     htmlEncodedTvb&
     operator+= (string const & str);

     virtual
     htmlEncodedTvb&
     operator= (LONG num);

     virtual
     htmlEncodedTvb&
     operator+= (LONG num);

     virtual
     htmlEncodedTvb&
     operator= (ULONG num);

     virtual
     htmlEncodedTvb&
     operator+= (ULONG num);

     virtual
     htmlEncodedTvb&
     operator= (INT num);

     virtual
     htmlEncodedTvb&
     operator+= (INT num);

     virtual
     htmlEncodedTvb&
     operator= (UINT num);

     virtual
     htmlEncodedTvb&
     operator+= (UINT num);

     virtual
     htmlEncodedTvb&
     operator= (SHORT num);

     virtual
     htmlEncodedTvb&
     operator+= (SHORT num);

     virtual
     htmlEncodedTvb&
     operator= (USHORT num);

     virtual
     htmlEncodedTvb&
     operator+= (USHORT num);

     virtual
     htmlEncodedTvb&
     operator= (double num);

     virtual
     htmlEncodedTvb&
     operator+= (double num);

     virtual
     htmlEncodedTvb&
     operator= (basicTvb const & rhs);

     virtual
     htmlEncodedTvb&
     operator+= (basicTvb const & rhs);

protected:
     CHAR const *                       //  encoded string
     encode();                          // encoding method
};

class urlEncodedTvb : public encodedTvb {
public:
     urlEncodedTvb(                     // tvb constructor
     CHAR const * pszName);             //  name of tvb

     ~urlEncodedTvb();                  // tvb destructor

     // assignment operators

     urlEncodedTvb&
     operator= (CHAR const * stg);

     urlEncodedTvb&
     operator+= (CHAR const * stg);

     urlEncodedTvb&
     operator= (CHAR ch);

     urlEncodedTvb&
     operator+= (CHAR ch);

     urlEncodedTvb&
     operator= (string const & str);

     urlEncodedTvb&
     operator+= (string const & str);

     urlEncodedTvb&
     operator= (LONG num);

     urlEncodedTvb&
     operator+= (LONG num);

     urlEncodedTvb&
     operator= (ULONG num);

     urlEncodedTvb&
     operator+= (ULONG num);

     urlEncodedTvb&
     operator= (INT num);

     urlEncodedTvb&
     operator+= (INT num);

     urlEncodedTvb&
     operator= (UINT num);

     urlEncodedTvb&
     operator+= (UINT num);

     urlEncodedTvb&
     operator= (SHORT num);

     urlEncodedTvb&
     operator+= (SHORT num);

     urlEncodedTvb&
     operator= (USHORT num);

     urlEncodedTvb&
     operator+= (USHORT num);

     urlEncodedTvb&
     operator= (double num);

     urlEncodedTvb&
     operator+= (double num);

     urlEncodedTvb&
     operator= (basicTvb const & rhs);

     urlEncodedTvb&
     operator+= (basicTvb const & rhs);

protected:
     CHAR const *                       //  encoded text
     encode();                          // encoding method
};

class linkedHtmlEncodedTvb : public htmlEncodedTvb {
public:
     linkedHtmlEncodedTvb(              // tvb constructor
     CHAR const * pszName,              //  name of tvb
     CHAR const * pszAnchor);           //  anchor format to use

     ~linkedHtmlEncodedTvb();           // tvb destructor

     VOID
     toggleLink(                        // toggle URL linking
     bool link);                        //  on/off

     // assignment operators

     linkedHtmlEncodedTvb&
     operator= (CHAR const * stg);

     linkedHtmlEncodedTvb&
     operator+= (CHAR const * stg);

     linkedHtmlEncodedTvb&
     operator= (CHAR ch);

     linkedHtmlEncodedTvb&
     operator+= (CHAR ch);

     linkedHtmlEncodedTvb&
     operator= (string const & str);

     linkedHtmlEncodedTvb&
     operator+= (string const & str);

     linkedHtmlEncodedTvb&
     operator= (LONG num);

     linkedHtmlEncodedTvb&
     operator+= (LONG num);

     linkedHtmlEncodedTvb&
     operator= (ULONG num);

     linkedHtmlEncodedTvb&
     operator+= (ULONG num);

     linkedHtmlEncodedTvb&
     operator= (INT num);

     linkedHtmlEncodedTvb&
     operator+= (INT num);

     linkedHtmlEncodedTvb&
     operator= (UINT num);

     linkedHtmlEncodedTvb&
     operator+= (UINT num);

     linkedHtmlEncodedTvb&
     operator= (SHORT num);

     linkedHtmlEncodedTvb&
     operator+= (SHORT num);

     linkedHtmlEncodedTvb&
     operator= (USHORT num);

     linkedHtmlEncodedTvb&
     operator+= (USHORT num);

     linkedHtmlEncodedTvb&
     operator= (double num);

     linkedHtmlEncodedTvb&
     operator+= (double num);

     linkedHtmlEncodedTvb&
     operator= (basicTvb const & rhs);

     linkedHtmlEncodedTvb&
     operator+= (basicTvb const & rhs);

protected:
     CHAR const *                       //  encoded/linked string
     encode();                          // encoding method

     string m_Anchor;                   // string to do build anchor with
     bool m_dolink;                     // do URL linking?
};


string                                  //   new, encoded string
htmlEncode(                             // html encode a string
string const & str);                    //   string to encode

string                                  //   new, encoded string
urlEncode(                              // url encode a string
string const & str);                    //   string to encode

string                                  // linked string
linkURLs(                               // parse URLs, and create links
string const & txt,                     // text to check for URLS
string const & anchor);                 // anchor tag to use for linking

bool                                    // TRUE if char should be encoded
isUrlEncChar(                           // is character a URL "special" char
unsigned char c);                       // character to check

string                                  // decoded String
urlDecode(                              // decode a String for CGI "safety"
const string& str);                     // original String

BYTE                                    // value of the hex digit
hexVal(                                 // get the value of a hex character
CHAR ch);                               // char to evaluate

#endif // __ENCTVB_H
