/***************************************************************************
 *                                                                         *
 *   TAKESYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Take Synthesis Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __TAKESYN_H
#define __TAKESYN_H

#include "gcomm.h"
#include "pollsyn.h"

enum QUESSTATE {                   // states for take question synthesis
    AH_POLLSTAT,
    AH_QPARAMS,
    AH_QSAVE,
    AH_QSEND,
    AH_QDONE,
    AH_QERROR,
    AH_QDYNA};

class takeSynthesis: public pollSynthesis {
public:

     takeSynthesis(                // default constructor
     acthSession *_ses);           // session object

     ~takeSynthesis();             // destructor

     const CHAR *
     getSynthDir();                // synth directory

     VOID
     initMCArray();                // init. multiple choice array

     VOID
     getTemplatePrefix();          // get the template prefix

     dnfMap *
     lookupMap(                    // handle pre-pending lookup_
     dnfMap *map);

     dnfMap *
     prefixMap(                    // handle prefix map
     dnfMap *map);

     ACTHCODE
     proceed();                    // proceed entry point

     QUESSTATE
     saveAnswers();                // save answers to questions

     bool
     moreQuestions();              // are there more questions after this one?

     VOID
     saveOrTally(                  // save/tally answer
     string &answer);

     bool
     answerValid(                  // check question answer for error
     const CHAR *answer);

     bool
     getPollNameParam();           // get "pollname" parameter

     bool
     getQNumberParam();            // get "qnumber" parameter

     bool
     getLookup();                  // get "look-up" parameter

     dnfMap *
     thisMap();                    // gets current map

     ACTHCODE
     dynafile();                   // process a dynafile

     VOID
     setTableVbs();                // set up table variables

private:

     string m_tmplPfx;             // store template prefix
     SHORT m_currentQ;             // current question number
     string m_pollName;            // poll name
     string m_lookUser;            // look-up user
     SHORT m_iter;                 // iterator (multi-cycle)
     bool m_didOne;                // saved an answer
     bool m_bChosen;               // is this answer chosen?
     const CHAR *m_pAnsChoice;     // answer choice
     bool m_doingTable;            // are we processing table?
     SHORT m_rowCount;             // which row are we on?
     const CHAR *m_pValue;         // value of value
};

#endif                             // __TAKESYN_H
