/***************************************************************************
 *                                                                         *
 *   RESSYN.H                                                              *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Results Synthesis Class.                                              *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __RESSYN_H
#define __RESSYN_H

#include "gcomm.h"
#include "pollsyn.h"

class resultsSynthesis: public pollSynthesis {
public:

     resultsSynthesis(             // default constructor
     acthSession *_ses);           // session object

     ~resultsSynthesis();          // destructor

     const CHAR *
     getSynthDir();                // synth directory

     ACTHCODE
     proceed();                    // proceed entry point

     bool
     getQNumberParam();            // get "qnumber" parameter

     bool
     getPollNameParam();           // get "pollname" parameter

     VOID
     setVariables();               // set up variables

     ACTHCODE
     dynafile();                   // overriden dynafile

private:

     string m_pollName;            // store the poll name
     bool m_error;                 // boolean - did error occur?
     INT m_currentQ;               // question for which results being gen'ed
     SHORT m_talQnum;              // pointer to tallied qnumber
     bool m_doingTable;            // processing table
     SHORT m_rowCount;             // which row we're processing
};

#endif                             // __RESSYN_H
