/**************************************************************************
 *                                                                         *
 *   QUESTION.H                                                            *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   question Class.                                                       *
 *                                                  - N.C. Osterc  9/08/98 *
 *                                                                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __QUESTION_H
#define __QUESTION_H

#include "gcspsrv.h"
#include "galpnqh.h"

#define ACCFLD_NAME0       0
#define ACCFLD_NAME1       1
#define ACCFLD_ADR_LINE_1  2
#define ACCFLD_ADR_LINE_2  3
#define ACCFLD_ADR_LINE_3  4
#define ACCFLD_ADR_LINE_4  5
#define ACCFLD_PHONE       6
#define ACCFLD_BDAY        7
#define ACCFLD_SEX         8
#define ACCFLD_ANSI        9
#define ACCFLD_EDITOR      10
#define ACCFLD_PASSWORD    11

class question {                   // Class objectifies a "question"
public:

     question();                   // default constructor

     question(                     // constructor
     const CHAR *pollname);        // name of poll question is in

     question(                     // constructor
     const CHAR *pollname,         // the name of the poll
     SHORT qnumber);               // the question number

     ~question();                  // destructor

     VOID
     initQues();                   // common initializer method

     bool
     create();                     // create the question

     bool
     load();                       // load question data from disk

     bool
     remove();                     // delete this question

     bool
     update();                     // update question data to disk

     SHORT
     getAccountField();            // get the accoutning field

     const CHAR *
     getAnswerString(              // get answer string
     SHORT idx);                   // for this index in array

     SHORT
     getBranch(                    // get branch
     SHORT idx);                   // for this index in array

     SHORT
     getSelectedBranch(            // gets branch user selected
     const CHAR *userid);          // user

     SHORT
     getFlags();                   // get flags

     LONG
     getMaxLen();                  // get maximum length of answer

     LONG
     getMinLen();                  // get minimum length of answer

     SHORT
     getNext();                    // get next question number

     SHORT
     getNumAnswers();              // number of answers that can be submitted

     SHORT
     getNumber();                  // get the question number

     const CHAR *
     getPollName();                // get the poll name

     SHORT
     getPrevious();                // get previous question number

     SHORT
     getQType();                   // get the type of question

     const CHAR *
     getTextMsg();                 // get question text

     VOID
     setAccountField(              // set accounting field
     SHORT accfield);              // the accounting field

     VOID
     setAnswerString(              // set answer string
     SHORT idx,                    // the index
     const CHAR *answerString);    // answer string

     VOID
     setBranch(                    // is this poll closed?
     SHORT idx,                    // index
     SHORT branch);                // question to branch to

     VOID
     setFlags(                     // set flags
     SHORT flag);                  // variable containing flag values

     VOID
     setMaxLen(                    // set max length
     LONG max);                    // length

     VOID
     setMinLen(                    // set minimum length
     LONG min);                    // minimum length

     VOID
     setNext(                      // set next question number
     SHORT next);                  // next

     VOID
     setNumAnswers(                // number of answers per question
     SHORT numAnswers);            // the number

     VOID
     setNumber(                    // set this question number
     SHORT number);                // this question number

     VOID
     setPoll(                      // set pollname for which this question resides
     const CHAR *pollname);        // name of the poll

     VOID
     setPrevious(                  // set the previous question number
     SHORT prev);                  // previous question

     VOID
     setQType(                     // Set the questin type
     SHORT type);                  // the type

     VOID
     setTextMsg(                   // set text message
     const CHAR *text);            // the text

     const CHAR *
     getAnswer(                    // Get a user's answer for this question
     const CHAR *userid);          // the user-ID

     bool
     isMultiAnswerSelected(        // Determine if answer is selected.
     SHORT idx,                    // the answer number (0-15)
     const CHAR *userid);          // current user

     bool
     isAnswerSelected(             // Determine if answer is selected.
     SHORT idx,                    // the answer number (0-15)
     const CHAR *userid);          // current user

     bool
     isValMultiAnswer(             // determine if this is a valid answer
     SHORT idx);                   // the index

     bool
     question::isBooleanSelected(  // Check a YESNO or TRUEFALSE question for selection
     bool idx,                     // 0 == YES, 1 == NO
     const CHAR *userid);          // current userid

     VOID
     setQuestionData(              // set all question data
     struct quesdata qd);          // via passed struct

     const struct quesdata
     getQuestionData();            // get question data structure

     bool
     saveAnswer(                   // save answer
     const CHAR *userid,           // the user
     const CHAR *answerString);    // the answer string

     VOID
     setMinMaxDefaults();          // set min/max default values

     VOID
     addTally(                     // add question to tally
     const CHAR *answerString);    // the answer

     bool
     checkMinMaxPfnAdr(            // check min, max, profan on answer
     const CHAR *userid,           // user in question
     const CHAR *answer);          // for address field

     bool
     checkMaxPfnAdr(               // check max and profanity on answer
     const CHAR *userid,           // user in question
     const CHAR *answer);          // for address field

     bool
     checkMinMaxPw(                // check min and max psword size on answer
     const CHAR *answer);          // for pw field

private:

     VOID
     setupQCompKey(                // set up question composite key
     const CHAR *pollname,         // passed pollname
     SHORT number);                // passed question number

     VOID
     removeTally();                // remove question from tally

     VOID
     updateAnswer(                 // write to data file
     const CHAR *userid,           // user
     const CHAR *answerString);    // answer

     VOID
     insertAnswer(                 // write to data file
     const CHAR *userid,           // user
     const CHAR *answerString);    // answer

     VOID
     updateAccount(                // update account field
     const CHAR *userid,           // userid
     INT accountField,             // the accounting field
     const CHAR *answerString);    // the answer

     VOID
     writeASCII(                   // store data in ASCII file
     const CHAR *userid,           // the user
     const CHAR *answerString);    // the answer

     struct ansrcomp m_acomp;      // composite key struct for answers
     struct ansrdata m_adata;      // struct for answer data
     struct quescomp m_qcomp;      // composite key struct for questions
     struct quesdata m_qdata;      // struct for question data
     struct polltally m_tally;     // tally structure
};

#endif                             // __QUESTION_H

