/***************************************************************************
 *                                                                         *
 *   POLLVAR.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Variables Class.                                                 *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __POLLVAR_H
#define __POLLVAR_H

#include "gcomm.h"

#undef min(a,b)
#undef max(a,b)

#include "enctvb.h"
#include "poll.h"
#include "question.h"
#include "pollmsg.h"

#define CHK "CHECKED"
#define SEL "SELECTED"
#define SPRINTFSIZ 1024

class pollVar {                    // Class objectifies "poll" text variables
public:

     pollVar();                    // default constructor (not used)

     ~pollVar();                   // destructor

     VOID
     setErrorVariables(            // set error text vbs
     const CHAR * errMsg,          // the error message.
     SHORT errQID);                // ID of question error occured on.
                                   // if "-1", don't use

     VOID
     setTargetVbs();               // set up target text variables (for frames)

     VOID
     setResultsVbs(                // set up results text variables
     question *qobj,               // pointer to question object
     SHORT answer);                // which answer to handle

     VOID
     setTakeVbs(                   // set up take/lookup text variables
     question *qobj,               // pointer to question object
     const CHAR *userid,           // user-id
     bool lookup);

     VOID
     setListVariables(             // set up list text variables
     poll *pobj,                   // pointer to poll object
     const CHAR *userid);          // current userid

     VOID
     setTableMCVbs(                // set up table-based MC questions
     bool chosen,                  // is it chosen?
     const CHAR *answerChoice,     // whats the answer choice
     const CHAR *theValue);        // whats the value

     VOID
     clearAllVars();               // clear all text variables

     VOID
     setTemplatePrefix(            // set the template prefix variable
     const CHAR *prefix);          // the prefix

     const CHAR *
     format(                       // format a string
     const CHAR *fmt,              // string to format
     ...);                         // specifiers

private:

     pollMsg *m_pMessage;          // pointer to poll message object
     CHAR m_formatBuf[SPRINTFSIZ]; // buffer used to put formatting string in
};

// Text variable declarations

extern basicTvb t_ClassGranted;                       // PCOMP_CLS_GRANTED
extern basicTvb t_CredGranted;                        // PCOMP_CRED_GRANTED
extern basicTvb t_FileGranted;                        // PCOMP_FILE_GRANTED
extern basicTvb t_KeyGranted;                         // PCOMP_KEY_GRANTED

extern basicTvb t_ErrMessage;                         // PERR_MESSAGE
extern basicTvb t_ErrQID;                             // PERR_QID

extern basicTvb t_LookupUser;                         // PLRP_USER
extern urlEncodedTvb t_EncLookupUser;                 // PRLP_USER_U

extern basicTvb t_PollNone1;                          // POLL_NONE_1
extern basicTvb t_PollNone2;                          // POLL_NONE_2
extern basicTvb t_PollNone3;                          // POLL_NONE_3
extern basicTvb t_PollNone4;                          // POLL_NONE_4
extern basicTvb t_PollNone5;                          // POLL_NONE_5
extern basicTvb t_PollNone6;                          // POLL_NONE_6
extern basicTvb t_PollNone7;                          // POLL_NONE_7
extern basicTvb t_PollNone8;                          // POLL_NONE_8
extern basicTvb t_PollNone9;                          // POLL_NONE_9
extern basicTvb t_DispTxt;                            // PQUES_DISPTXT

extern basicTvb t_AnswerType;                         // POLL_ANSWER
extern basicTvb t_AnswerNum;                          // POLL_ANSWER_NUM
extern basicTvb t_CanGetRslts;                        // POLL_CAN_GETRSLTS
extern basicTvb t_CanLookUp;                          // POLL_CAN_LOOK-UP
extern basicTvb t_Class2Grant;                        // POLL_CLASS_GRANTED
extern basicTvb t_DCloseDate;                         // POLL_CLDATE_D
extern basicTvb t_D0CloseDate;                        // POLL_CLDATE_D0
extern basicTvb t_EurLCloseDate;                      // POLL_CLDATE_EUR_L
extern basicTvb t_EurSCloseDate;                      // POLL_CLDATE_EUR_S
extern basicTvb t_MLCloseDate;                        // POLL_CLDATE_M_L
extern basicTvb t_MNCloseDate;                        // POLL_CLDATE_M_N
extern basicTvb t_MN0CloseDate;                       // POLL_CLDATE_M_N0
extern basicTvb t_MSCloseDate;                        // POLL_CLDATE_M_S
extern basicTvb t_USLCloseDate;                       // POLL_CLDATE_USA_L
extern basicTvb t_USSCloseDate;                       // POLL_CLDATE_USA_S
extern basicTvb t_WLCloseDate;                        // POLL_CLDATE_W_L
extern basicTvb t_WSCloseDate;                        // POLL_CLDATE_W_S
extern basicTvb t_YLCloseDate;                        // POLL_CLDATE_Y_L
extern basicTvb t_YSCloseDate;                        // POLL_CLDATE_Y_S
extern basicTvb t_DCreateDate;                        // POLL_CRDATE_D
extern basicTvb t_D0CreateDate;                       // POLL_CRDATE_D0
extern basicTvb t_EurLCreateDate;                     // POLL_CRDATE_EUR_L
extern basicTvb t_EurSCreateDate;                     // POLL_CRDATE_EUR_S
extern basicTvb t_MLCreateDate;                       // POLL_CRDATE_M_L
extern basicTvb t_MNCreateDate;                       // POLL_CRDATE_M_N
extern basicTvb t_MN0CreateDate;                      // POLL_CRDATE_M_N0
extern basicTvb t_MSCreateDate;                       // POLL_CRDATE_M_S
extern basicTvb t_USLCreateDate;                      // POLL_CRDATE_USA_L
extern basicTvb t_USSCreateDate;                      // POLL_CRDATE_USA_S
extern basicTvb t_WLCreateDate;                       // POLL_CRDATE_W_L
extern basicTvb t_WSCreateDate;                       // POLL_CRDATE_W_S
extern basicTvb t_YLCreateDate;                       // POLL_CRDATE_Y_L
extern basicTvb t_YSCreateDate;                       // POLL_CRDATE_Y_S
extern basicTvb t_Credits2Grant;                      // POLL_CREDITS_GRANTED
extern htmlEncodedTvb t_Description;                  // POLL_DESCRIPTION
extern basicTvb t_File2Grant;                         // POLL_FILE_GRANTED
extern basicTvb t_Key2Grant;                          // POLL_KEY_GRANTED
extern basicTvb t_KeyLogon;                           // POLL_KEY_LOGON
extern basicTvb t_KeyLookUp;                          // POLL_KEY_LOOK-UP
extern basicTvb t_KeyResults;                         // POLL_KEY_RESULTS
extern basicTvb t_KeyTake;                            // POLL_KEY_TAKE
extern htmlEncodedTvb t_Name;                         // POLL_NAME
extern urlEncodedTvb t_EncName;                       // POLL_NAME_U
extern basicTvb t_PollType;                           // POLL_POLLTYPE
extern basicTvb t_Status;                             // POLL_STATUS
extern basicTvb t_StatusImage;                        // POLL_STATUS_IMG
extern basicTvb t_StatusNum;                          // POLL_STATUS_NUM
extern basicTvb t_Storage;                            // POLL_STORAGE
extern basicTvb t_StorageNum;                         // POLL_STORAGE_NUM
extern basicTvb t_PollTypeImg;                        // POLL_TYPE_IMG
extern basicTvb t_PollTypeNum;                        // POLL_TYPE_NUM

extern basicTvb t_Target1;                            // PNQ_TARGET_1
extern basicTvb t_Target2;                            // PNQ_TARGET_2
extern basicTvb t_Target3;                            // PNQ_TARGET_3
extern basicTvb t_Target4;                            // PNQ_TARGET_4
extern basicTvb t_Target5;                            // PNQ_TARGET_5
extern basicTvb t_Target6;                            // PNQ_TARGET_6
extern basicTvb t_Target7;                            // PNQ_TARGET_7
extern basicTvb t_Target8;                            // PNQ_TARGET_8
extern basicTvb t_Target9;                            // PNQ_TARGET_9

extern basicTvb t_Count;                              // POLL_COUNT
extern urlEncodedTvb t_Low;                           // POLL_LIST_LOW
extern basicTvb t_ListStatus;                         // POLL_LIST_STATUS
extern basicTvb t_Priority;                           // POLL_LOGON_TYPE
extern basicTvb t_PollMoreHi;                         // POLL_MORE_HI
extern basicTvb t_PollMoreLo;                         // POLL_MORE_LOW
extern basicTvb t_Order;                              // POLL_ORDER
extern urlEncodedTvb t_Hi;                            // POLL_LIST_HI

extern basicTvb t_AnswerChecked1;                     // PQUES_ANS_CHECK_1
extern basicTvb t_AnswerChecked2;                     // PQUES_ANS_CHECK_2
extern basicTvb t_AnswerChecked3;                     // PQUES_ANS_CHECK_3
extern basicTvb t_AnswerChecked4;                     // PQUES_ANS_CHECK_4
extern basicTvb t_AnswerChecked5;                     // PQUES_ANS_CHECK_5
extern basicTvb t_AnswerChecked6;                     // PQUES_ANS_CHECK_6
extern basicTvb t_AnswerChecked7;                     // PQUES_ANS_CHECK_7
extern basicTvb t_AnswerChecked8;                     // PQUES_ANS_CHECK_8
extern basicTvb t_AnswerChecked9;                     // PQUES_ANS_CHECK_9
extern basicTvb t_AnswerChecked10;                    // PQUES_ANS_CHECK_10
extern basicTvb t_AnswerChecked11;                    // PQUES_ANS_CHECK_11
extern basicTvb t_AnswerChecked12;                    // PQUES_ANS_CHECK_12
extern basicTvb t_AnswerChecked13;                    // PQUES_ANS_CHECK_13
extern basicTvb t_AnswerChecked14;                    // PQUES_ANS_CHECK_14
extern basicTvb t_AnswerChecked15;                    // PQUES_ANS_CHECK_15
extern basicTvb t_AnswerChecked16;                    // PQUES_ANS_CHECK_16

extern basicTvb t_AnswerSelected1;                    // PQUES_ANS_SEL_1
extern basicTvb t_AnswerSelected2;                    // PQUES_ANS_SEL_2
extern basicTvb t_AnswerSelected3;                    // PQUES_ANS_SEL_3
extern basicTvb t_AnswerSelected4;                    // PQUES_ANS_SEL_4
extern basicTvb t_AnswerSelected5;                    // PQUES_ANS_SEL_5
extern basicTvb t_AnswerSelected6;                    // PQUES_ANS_SEL_6
extern basicTvb t_AnswerSelected7;                    // PQUES_ANS_SEL_7
extern basicTvb t_AnswerSelected8;                    // PQUES_ANS_SEL_8
extern basicTvb t_AnswerSelected9;                    // PQUES_ANS_SEL_9
extern basicTvb t_AnswerSelected10;                   // PQUES_ANS_SEL_10
extern basicTvb t_AnswerSelected11;                   // PQUES_ANS_SEL_11
extern basicTvb t_AnswerSelected12;                   // PQUES_ANS_SEL_12
extern basicTvb t_AnswerSelected13;                   // PQUES_ANS_SEL_13
extern basicTvb t_AnswerSelected14;                   // PQUES_ANS_SEL_14
extern basicTvb t_AnswerSelected15;                   // PQUES_ANS_SEL_15
extern basicTvb t_AnswerSelected16;                   // PQUES_ANS_SEL_16

extern htmlEncodedTvb t_AnswerString1;                // PQUES_ANSSTG_1
extern htmlEncodedTvb t_AnswerString2;                // PQUES_ANSSTG_2
extern htmlEncodedTvb t_AnswerString3;                // PQUES_ANSSTG_3
extern htmlEncodedTvb t_AnswerString4;                // PQUES_ANSSTG_4
extern htmlEncodedTvb t_AnswerString5;                // PQUES_ANSSTG_5
extern htmlEncodedTvb t_AnswerString6;                // PQUES_ANSSTG_6
extern htmlEncodedTvb t_AnswerString7;                // PQUES_ANSSTG_7
extern htmlEncodedTvb t_AnswerString8;                // PQUES_ANSSTG_8
extern htmlEncodedTvb t_AnswerString9;                // PQUES_ANSSTG_9
extern htmlEncodedTvb t_AnswerString10;               // PQUES_ANSSTG_10
extern htmlEncodedTvb t_AnswerString11;               // PQUES_ANSSTG_11
extern htmlEncodedTvb t_AnswerString12;               // PQUES_ANSSTG_12
extern htmlEncodedTvb t_AnswerString13;               // PQUES_ANSSTG_13
extern htmlEncodedTvb t_AnswerString14;               // PQUES_ANSSTG_14
extern htmlEncodedTvb t_AnswerString15;               // PQUES_ANSSTG_15
extern htmlEncodedTvb t_AnswerString16;               // PQUES_ANSSTG_16

extern basicTvb t_Branch1;                            // PQUES_BRANCH_1
extern basicTvb t_Branch2;                            // PQUES_BRANCH_2
extern basicTvb t_Branch3;                            // PQUES_BRANCH_3
extern basicTvb t_Branch4;                            // PQUES_BRANCH_4
extern basicTvb t_Branch5;                            // PQUES_BRANCH_5
extern basicTvb t_Branch6;                            // PQUES_BRANCH_6
extern basicTvb t_Branch7;                            // PQUES_BRANCH_7
extern basicTvb t_Branch8;                            // PQUES_BRANCH_8
extern basicTvb t_Branch9;                            // PQUES_BRANCH_9
extern basicTvb t_Branch10;                           // PQUES_BRANCH_10
extern basicTvb t_Branch11;                           // PQUES_BRANCH_11
extern basicTvb t_Branch12;                           // PQUES_BRANCH_12
extern basicTvb t_Branch13;                           // PQUES_BRANCH_13
extern basicTvb t_Branch14;                           // PQUES_BRANCH_14
extern basicTvb t_Branch15;                           // PQUES_BRANCH_15
extern basicTvb t_Branch16;                           // PQUES_BRANCH_16

extern basicTvb t_AnswerLimit;                        // PQUES_ANS_LIM
extern basicTvb t_Answer;                             // PQUES_ANSWER
extern basicTvb t_IsAnswered;                         // PQUES_IS_ANSWERED
extern basicTvb t_IsBranch;                           // PQUES_ISBRANCH
extern basicTvb t_MaxLen;                             // PQUES_MAX_LEN
extern basicTvb t_MinLen;                             // PQUES_MIN_LEN
extern basicTvb t_QuesMoreLo;                         // PQUES_MORE_LOW
extern basicTvb t_QuesMoreHi;                         // PQUES_MORE_HI
extern basicTvb t_Nex;                                // PQUES_NEXT
extern basicTvb t_Number;                             // PQUES_NUM
extern basicTvb t_DisplayNumber;                      // PQUES_NUM_DISPLAY
extern basicTvb t_Previous;                           // PQUES_PREV
extern basicTvb t_QTypeNumber;                        // PQUES_QTYPE_NUM
extern basicTvb t_TemplatePrefix;                     // PQUES_TEMPLATE_PREF                          IX
extern basicTvb t_TotalAnswersInQuestion;             // PQUES_TOTANS
extern basicTvb t_QuestionType;                       // PQUES_TYPE
extern basicTvb t_AccountFieldNum;                    // PQUES_UAC_NUM

extern basicTvb t_ValOfValue;                         // PQUES_VAL_VALUE
extern basicTvb t_AnswerCheck;                        // PQUES_ANS_CHECK
extern basicTvb t_AnswerSelect;                       // PQUES_ANS_SEL
extern htmlEncodedTvb t_AnswerString;                 // PQUES_ANS_STG

extern basicTvb t_HtmlQName;                          // PQUES_NAME_VALUE

extern basicTvb t_ResultsAnswer;                      // PRES_ANSWER
extern basicTvb t_ResultsMatches;                     // PRES_MATCHES
extern basicTvb t_ResultsPercent;                     // PRES_PERCENT
extern basicTvb t_ResultsTotAns;                      // PRES_TOTANS

#endif                             // __POLLVAR_H
