/***************************************************************************
 *                                                                         *
 *   POLLVAR.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Variables Class.                                                 *
 *                                                  - N.C. Osterc  9/08/98 *
 *                                                                         *
 ***************************************************************************/

#include "galpnqah.h"
#include "pollvar.h"
#include "galpnqh.h"
#include "locknkey.h"
#include "dntapi.h"
#include "ahutil.h"
#include "majorbbs.h"

#define FILREV "$Revision: 26 $"

#define DOFWEEK(X)  (dayFromDate(ddyear(X),ddmon(X),ddday(X)))
#define ANSWER1   0                // character buffer index of first answer in mc q
#define ANSWER2   1                // char buffer index ofsecond answer in mc q
#define MAXNUMSIZ 10               // max size of numeric answer
#define DATESIZE  10               // "MM/DD/YYYY"

CHAR shortDays[7][6]={"Sun","Mon","Tue","Wed","Thurs","Fri","Sat"};

// Text variable instantiations

basicTvb t_ClassGranted("PCOMP_CLS_GRANTED");  // PCOMP_CLS_GRANTED
basicTvb t_CredGranted("PCOMP_CRED_GRANTED");  // PCOMP_CRED_GRANTED
basicTvb t_FileGranted("PCOMP_FILE_GRANTED");  // PCOMP_FILE_GRANTED
basicTvb t_KeyGranted("PCOMP_KEY_GRANTED");    // PCOMP_KEY_GRANTED

basicTvb t_ErrMessage("PERR_MESSAGE");         // PERR_MESSAGE
basicTvb t_ErrQID("PERR_QID");                 // PERR_QID

basicTvb t_LookupUser("PLRP_USER");            // PLRP_USER
urlEncodedTvb t_EncLookupUser("PLRP_USER_U");  // PRLP_USER_U

basicTvb t_AnswerType("POLL_ANSWER");          // POLL_ANSWER
basicTvb t_AnswerNum("POLL_ANSWER_NUM");       // POLL_ANSWER_NUM
basicTvb t_CanGetRslts("POLL_CAN_GETRSLTS");   // POLL_CAN_GETRSLTS
basicTvb t_CanLookUp("POLL_CAN_LOOK-UP");      // POLL_CAN_LOOK-UP
basicTvb t_Class2Grant("POLL_CLASS_GRANTED");  // POLL_CLASS_GRANTED
basicTvb t_DCloseDate("POLL_CLDATE_D");        // POLL_CLDATE_D
basicTvb t_D0CloseDate("POLL_CLDATE_D0");      // POLL_CLDATE_D0
basicTvb t_EurLCloseDate("POLL_CLDATE_EUR_L"); // POLL_CLDATE_EUR_L
basicTvb t_EurSCloseDate("POLL_CLDATE_EUR_S"); // POLL_CLDATE_EUR_S
basicTvb t_MLCloseDate("POLL_CLDATE_M_L");     // POLL_CLDATE_M_L
basicTvb t_MNCloseDate("POLL_CLDATE_M_N");     // POLL_CLDATE_M_N
basicTvb t_MN0CloseDate("POLL_CLDATE_M_N0");   // POLL_CLDATE_M_N0
basicTvb t_MSCloseDate("POLL_CLDATE_M_S");     // POLL_CLDATE_M_S
basicTvb t_USLCloseDate("POLL_CLDATE_USA_L");  // POLL_CLDATE_USA_L
basicTvb t_USSCloseDate("POLL_CLDATE_USA_S");  // POLL_CLDATE_USA_S
basicTvb t_WLCloseDate("POLL_CLDATE_W_L");     // POLL_CLDATE_W_L
basicTvb t_WSCloseDate("POLL_CLDATE_W_S");     // POLL_CLDATE_W_S
basicTvb t_YLCloseDate("POLL_CLSDAT_Y_L");     // POLL_CLDATE_Y_L
basicTvb t_YSCloseDate("POLL_CLDATE_Y_S");     // POLL_CLDATE_Y_S
basicTvb t_DCreateDate("POLL_CRDATE_D");       // POLL_CRDATE_D
basicTvb t_D0CreateDate("POLL_CRDATE_D0");     // POLL_CRDATE_D0
basicTvb t_EurLCreateDate("POLL_CRDATE_EUR_L");// POLL_CRDATE_EUR_L
basicTvb t_EurSCreateDate("POLL_CRDATE_EUR_S");// POLL_CRDATE_EUR_S
basicTvb t_MLCreateDate("POLL_CRDATE_M_L");    // POLL_CRDATE_M_L
basicTvb t_MNCreateDate("POLL_CRDATE_M_N");    // POLL_CRDATE_M_N
basicTvb t_MN0CreateDate("POLL_CRDATE_M_N0");  // POLL_CRDATE_M_N0
basicTvb t_MSCreateDate("POLL_CRDATE_M_S");    // POLL_CRDATE_M_S
basicTvb t_USLCreateDate("POLL_CRDATE_USA_L"); // POLL_CRDATE_USA_L
basicTvb t_USSCreateDate("POLL_CRDATE_USA_S"); // POLL_CRDATE_USA_S
basicTvb t_WLCreateDate("POLL_CRDATE_W_L");    // POLL_CRDATE_W_L
basicTvb t_WSCreateDate("POLL_CRDATE_W_S");    // POLL_CRDATE_W_S
basicTvb t_YLCreateDate("POLL_CRSDAT_Y_L");    // POLL_CRDATE_Y_L
basicTvb t_YSCreateDate("POLL_CRDATE_Y_S");    // POLL_CRDATE_Y_S
basicTvb t_Credits2Grant("POLL_CREDITS_GRANTED");// POLL_CREDITS_GRANTED
htmlEncodedTvb t_Description("POLL_DESCRIPTION");// POLL_DESCRIPTION
basicTvb t_File2Grant("POLL_FILE_GRANTED");    // POLL_FILE_GRANTED
basicTvb t_Key2Grant("POLL_KEY_GRANTED");      // POLL_KEY_GRANTED
basicTvb t_KeyLogon("POLL_KEY_LOGON");         // POLL_KEY_LOGON
basicTvb t_KeyLookUp("POLL_KEY_LOOK-UP");      // POLL_KEY_LOOK-UP
basicTvb t_KeyResults("POLL_KEY_RESULTS");     // POLL_KEY_RESULTS
basicTvb t_KeyTake("POLL_KEY_TAKE");           // POLL_KEY_TAKE
htmlEncodedTvb t_Name("POLL_NAME");            // POLL_NAME
urlEncodedTvb t_EncName("POLL_NAME_U");        // POLL_NAME_U
basicTvb t_PollType("POLL_POLLTYPE");          // POLL_POLLTYPE
basicTvb t_Status("POLL_STATUS");              // POLL_STATUS
basicTvb t_StatusImage("POLL_STATUS_IMG");     // POLL_STATUS_IMG
basicTvb t_StatusNum("POLL_STATUS_NUM");       // POLL_STATUS_NUM
basicTvb t_Storage("POLL_STORAGE");            // POLL_STORAGE
basicTvb t_StorageNum("POLL_STORAGE_NUM");     // POLL_STORAGE_NUM
basicTvb t_PollTypeImg("POLL_TYPE_IMG");       // POLL_TYPE_IMG
basicTvb t_PollTypeNum("POLL_TYPE_NUM");       // POLL_TYPE_NUM

basicTvb t_Target1("PNQ_TARGET_1");            // PNQ_TARGET_1
basicTvb t_Target2("PNQ_TARGET_2");            // PNQ_TARGET_2
basicTvb t_Target3("PNQ_TARGET_3");            // PNQ_TARGET_3
basicTvb t_Target4("PNQ_TARGET_4");            // PNQ_TARGET_4
basicTvb t_Target5("PNQ_TARGET_5");            // PNQ_TARGET_5
basicTvb t_Target6("PNQ_TARGET_6");            // PNQ_TARGET_6
basicTvb t_Target7("PNQ_TARGET_7");            // PNQ_TARGET_7
basicTvb t_Target8("PNQ_TARGET_8");            // PNQ_TARGET_8
basicTvb t_Target9("PNQ_TARGET_9");            // PNQ_TARGET_9

basicTvb t_Count("POLL_COUNT");                // POLL_COUNT
urlEncodedTvb t_Low("POLL_LIST_LOW");          // POLL_LIST_LOW
basicTvb t_ListStatus("POLL_LIST_STATUS");     // POLL_LIST_STATUS
basicTvb t_Priority("POLL_LOGON_TYPE");        // POLL_LOGON_TYPE
basicTvb t_PollMoreHi("POLL_MORE_HI");         // POLL_MORE_HI
basicTvb t_PollMoreLo("POLL_MORE_LOW");        // POLL_MORE_LOW
basicTvb t_Order("POLL_ORDER");                // POLL_ORDER
urlEncodedTvb t_Hi("POLL_LIST_HI");            // POLL_LIST_HI

basicTvb t_ValOfValue("PQUES_VAL_VALUE");      // PQUES_VAL_VALUE
basicTvb t_AnswerCheck("PQUES_ANS_CHECK");     // PQUES_ANS_CHECK
basicTvb t_AnswerSelect("PQUES_ANS_SEL");      // PQUES_ANS_SEL
htmlEncodedTvb t_AnswerString("PQUES_ANS_STG");// PQUES_ANS_STG

basicTvb t_AnswerChecked1("PQUES_ANS_CHECK_1");   // PQUES_ANS_CHECK_1
basicTvb t_AnswerChecked2("PQUES_ANS_CHECK_2");   // PQUES_ANS_CHECK_2
basicTvb t_AnswerChecked3("PQUES_ANS_CHECK_3");   // PQUES_ANS_CHECK_3
basicTvb t_AnswerChecked4("PQUES_ANS_CHECK_4");   // PQUES_ANS_CHECK_4
basicTvb t_AnswerChecked5("PQUES_ANS_CHECK_5");   // PQUES_ANS_CHECK_5
basicTvb t_AnswerChecked6("PQUES_ANS_CHECK_6");   // PQUES_ANS_CHECK_6
basicTvb t_AnswerChecked7("PQUES_ANS_CHECK_7");   // PQUES_ANS_CHECK_7
basicTvb t_AnswerChecked8("PQUES_ANS_CHECK_8");   // PQUES_ANS_CHECK_8
basicTvb t_AnswerChecked9("PQUES_ANS_CHECK_9");   // PQUES_ANS_CHECK_9
basicTvb t_AnswerChecked10("PQUES_ANS_CHECK_10"); // PQUES_ANS_CHECK_10
basicTvb t_AnswerChecked11("PQUES_ANS_CHECK_11"); // PQUES_ANS_CHECK_11
basicTvb t_AnswerChecked12("PQUES_ANS_CHECK_12"); // PQUES_ANS_CHECK_12
basicTvb t_AnswerChecked13("PQUES_ANS_CHECK_13"); // PQUES_ANS_CHECK_13
basicTvb t_AnswerChecked14("PQUES_ANS_CHECK_14"); // PQUES_ANS_CHECK_14
basicTvb t_AnswerChecked15("PQUES_ANS_CHECK_15"); // PQUES_ANS_CHECK_15
basicTvb t_AnswerChecked16("PQUES_ANS_CHECK_16"); // PQUES_ANS_CHECK_16

basicTvb *t_CheckArray[]={
     &t_AnswerChecked1,
     &t_AnswerChecked2,
     &t_AnswerChecked3,
     &t_AnswerChecked4,
     &t_AnswerChecked5,
     &t_AnswerChecked6,
     &t_AnswerChecked7,
     &t_AnswerChecked8,
     &t_AnswerChecked9,
     &t_AnswerChecked10,
     &t_AnswerChecked11,
     &t_AnswerChecked12,
     &t_AnswerChecked13,
     &t_AnswerChecked14,
     &t_AnswerChecked15,
     &t_AnswerChecked16,
};

basicTvb t_AnswerSelected1("PQUES_ANS_SEL_1");    // PQUES_ANS_SEL_1
basicTvb t_AnswerSelected2("PQUES_ANS_SEL_2");    // PQUES_ANS_SEL_2
basicTvb t_AnswerSelected3("PQUES_ANS_SEL_3");    // PQUES_ANS_SEL_3
basicTvb t_AnswerSelected4("PQUES_ANS_SEL_4");    // PQUES_ANS_SEL_4
basicTvb t_AnswerSelected5("PQUES_ANS_SEL_5");    // PQUES_ANS_SEL_5
basicTvb t_AnswerSelected6("PQUES_ANS_SEL_6");    // PQUES_ANS_SEL_6
basicTvb t_AnswerSelected7("PQUES_ANS_SEL_7");    // PQUES_ANS_SEL_7
basicTvb t_AnswerSelected8("PQUES_ANS_SEL_8");    // PQUES_ANS_SEL_8
basicTvb t_AnswerSelected9("PQUES_ANS_SEL_9");    // PQUES_ANS_SEL_9
basicTvb t_AnswerSelected10("PQUES_ANS_SEL_10");  // PQUES_ANS_SEL_10
basicTvb t_AnswerSelected11("PQUES_ANS_SEL_11");  // PQUES_ANS_SEL_11
basicTvb t_AnswerSelected12("PQUES_ANS_SEL_12");  // PQUES_ANS_SEL_12
basicTvb t_AnswerSelected13("PQUES_ANS_SEL_13");  // PQUES_ANS_SEL_13
basicTvb t_AnswerSelected14("PQUES_ANS_SEL_14");  // PQUES_ANS_SEL_14
basicTvb t_AnswerSelected15("PQUES_ANS_SEL_15");  // PQUES_ANS_SEL_15
basicTvb t_AnswerSelected16("PQUES_ANS_SEL_16");  // PQUES_ANS_SEL_16

basicTvb *t_SelectArray[]={
     &t_AnswerSelected1,
     &t_AnswerSelected2,
     &t_AnswerSelected3,
     &t_AnswerSelected4,
     &t_AnswerSelected5,
     &t_AnswerSelected6,
     &t_AnswerSelected7,
     &t_AnswerSelected8,
     &t_AnswerSelected9,
     &t_AnswerSelected10,
     &t_AnswerSelected11,
     &t_AnswerSelected12,
     &t_AnswerSelected13,
     &t_AnswerSelected14,
     &t_AnswerSelected15,
     &t_AnswerSelected16,
};

htmlEncodedTvb t_AnswerString1("PQUES_ANSSTG_1");       // PQUES_ANSSTG_1
htmlEncodedTvb t_AnswerString2("PQUES_ANSSTG_2");       // PQUES_ANSSTG_2
htmlEncodedTvb t_AnswerString3("PQUES_ANSSTG_3");       // PQUES_ANSSTG_3
htmlEncodedTvb t_AnswerString4("PQUES_ANSSTG_4");       // PQUES_ANSSTG_4
htmlEncodedTvb t_AnswerString5("PQUES_ANSSTG_5");       // PQUES_ANSSTG_5
htmlEncodedTvb t_AnswerString6("PQUES_ANSSTG_6");       // PQUES_ANSSTG_6
htmlEncodedTvb t_AnswerString7("PQUES_ANSSTG_7");       // PQUES_ANSSTG_7
htmlEncodedTvb t_AnswerString8("PQUES_ANSSTG_8");       // PQUES_ANSSTG_8
htmlEncodedTvb t_AnswerString9("PQUES_ANSSTG_9");       // PQUES_ANSSTG_9
htmlEncodedTvb t_AnswerString10("PQUES_ANSSTG_10");     // PQUES_ANSSTG_10
htmlEncodedTvb t_AnswerString11("PQUES_ANSSTG_11");     // PQUES_ANSSTG_11
htmlEncodedTvb t_AnswerString12("PQUES_ANSSTG_12");     // PQUES_ANSSTG_12
htmlEncodedTvb t_AnswerString13("PQUES_ANSSTG_13");     // PQUES_ANSSTG_13
htmlEncodedTvb t_AnswerString14("PQUES_ANSSTG_14");     // PQUES_ANSSTG_14
htmlEncodedTvb t_AnswerString15("PQUES_ANSSTG_15");     // PQUES_ANSSTG_15
htmlEncodedTvb t_AnswerString16("PQUES_ANSSTG_16");     // PQUES_ANSSTG_16

basicTvb *t_AnswerStringArray[]={
    &t_AnswerString1,
    &t_AnswerString2,
    &t_AnswerString3,
    &t_AnswerString4,
    &t_AnswerString5,
    &t_AnswerString6,
    &t_AnswerString7,
    &t_AnswerString8,
    &t_AnswerString9,
    &t_AnswerString10,
    &t_AnswerString11,
    &t_AnswerString12,
    &t_AnswerString13,
    &t_AnswerString14,
    &t_AnswerString15,
    &t_AnswerString16,
};

basicTvb t_Branch1("PQUES_BRANCH_1");             // PQUES_BRANCH_1
basicTvb t_Branch2("PQUES_BRANCH_2");             // PQUES_BRANCH_2
basicTvb t_Branch3("PQUES_BRANCH_3");             // PQUES_BRANCH_3
basicTvb t_Branch4("PQUES_BRANCH_4");             // PQUES_BRANCH_4
basicTvb t_Branch5("PQUES_BRANCH_5");             // PQUES_BRANCH_5
basicTvb t_Branch6("PQUES_BRANCH_6");             // PQUES_BRANCH_6
basicTvb t_Branch7("PQUES_BRANCH_7");             // PQUES_BRANCH_7
basicTvb t_Branch8("PQUES_BRANCH_8");             // PQUES_BRANCH_8
basicTvb t_Branch9("PQUES_BRANCH_9");             // PQUES_BRANCH_9
basicTvb t_Branch10("PQUES_BRANCH_10");           // PQUES_BRANCH_10
basicTvb t_Branch11("PQUES_BRANCH_11");           // PQUES_BRANCH_11
basicTvb t_Branch12("PQUES_BRANCH_12");           // PQUES_BRANCH_12
basicTvb t_Branch13("PQUES_BRANCH_13");           // PQUES_BRANCH_13
basicTvb t_Branch14("PQUES_BRANCH_14");           // PQUES_BRANCH_14
basicTvb t_Branch15("PQUES_BRANCH_15");           // PQUES_BRANCH_15
basicTvb t_Branch16("PQUES_BRANCH_16");           // PQUES_BRANCH_16

basicTvb *t_BranchArray[]={
     &t_Branch1,
     &t_Branch2,
     &t_Branch3,
     &t_Branch4,
     &t_Branch5,
     &t_Branch6,
     &t_Branch7,
     &t_Branch8,
     &t_Branch9,
     &t_Branch10,
     &t_Branch11,
     &t_Branch12,
     &t_Branch13,
     &t_Branch14,
     &t_Branch15,
     &t_Branch16,
};

basicTvb t_AnswerLimit("PQUES_ANS_LIM");           // PQUES_ANS_LIM
basicTvb t_Answer("PQUES_ANSWER");                 // PQUES_ANSWER
basicTvb t_IsAnswered("PQUES_IS_ANSWERED");        // PQUES_IS_ANSWERED
basicTvb t_IsBranch("PQUES_ISBRANCH");             // PQUES_ISBRANCH
basicTvb t_MaxLen("PQUES_MAX_LEN");                // PQUES_MAX_LEN
basicTvb t_MinLen("PQUES_MIN_LEN");                // PQUES_MIN_LEN
basicTvb t_QuesMoreLo("PQUES_MORE_LOW");           // PQUES_MORE_LOW
basicTvb t_QuesMoreHi("PQUES_MORE_HI");            // PQUES_MORE_HI
basicTvb t_Next("PQUES_NEXT");                     // PQUES_NEXT
basicTvb t_Number("PQUES_NUM");                    // PQUES_NUM
basicTvb t_DisplayNumber("PQUES_NUM_DISPLAY");     // PQUES_NUM_DISPLAY
basicTvb t_Previous("PQUES_PREV");                 // PQUES_PREV
basicTvb t_QTypeNumber("PQUES_QTYPE_NUM");         // PQUES_QTYPE_NUM
basicTvb t_TemplatePrefix("PQUES_TEMPLATE_PREFIX");// PQUES_TEMPLATE_PREFIX
basicTvb t_TotalAnswersInQuestion("PQUES_TOTANS"); // PQUES_TOTANS
basicTvb t_QuestionType("PQUES_TYPE");             // PQUES_TYPE
basicTvb t_AccountFieldNum("PQUES_UAC_NUM");       // PQUES_UAC_NUM

basicTvb t_HtmlQName("PQUES_NAME_VALUE");          // PQUES_NAME_VALUE

basicTvb t_ResultsAnswer("PRES_ANSWER");           // PRES_ANSWER
basicTvb t_ResultsMatches("PRES_MATCHES");         // PRES_MATCHES
basicTvb t_ResultsPercent("PRES_PERCENT");         // PRES_PERCENT
basicTvb t_ResultsTotAns("PRES_TOTANS");           // PRES_TOTANS

basicTvb t_PollNone1("POLL_NONE_1");               // POLL_NONE1
basicTvb t_PollNone2("POLL_NONE_2");               // POLL_NONE1
basicTvb t_PollNone3("POLL_NONE_3");               // POLL_NONE1
basicTvb t_PollNone4("POLL_NONE_4");               // POLL_NONE1
basicTvb t_PollNone5("POLL_NONE_5");               // POLL_NONE1
basicTvb t_PollNone6("POLL_NONE_6");               // POLL_NONE1
basicTvb t_PollNone7("POLL_NONE_7");               // POLL_NONE1
basicTvb t_PollNone8("POLL_NONE_8");               // POLL_NONE1
basicTvb t_PollNone9("POLL_NONE_9");               // POLL_NONE1
basicTvb t_DispTxt("PQUES_DISPTXT");               // PQUES_DISPTXT

MARKSOURCE(pollvar);

template <class T>
string stringFormat(T val)         // format any value to a string
{
     string str;
     ostrstream ost;
     ost << val << ends;
     str=ost.str();
     ost.rdbuf()->freeze(0);
     return(str);
}

pollVar::pollVar()                 // default constructor
{
}

pollVar::~pollVar()                // destructor
{
}

VOID
pollVar::setErrorVariables(        // set error text vbs
const CHAR * errMsg,               // the error message.
SHORT errQID)                      // ID of question error occured on.
{
     t_ErrMessage=errMsg;
     if (errQID != -1) {
          t_ErrQID=errQID;
     }
}

VOID
pollVar::setTargetVbs()            // set up target text variables (for frames)
{
     t_Target1=ptarget1;
     t_Target2=ptarget2;
     t_Target3=ptarget3;
     t_Target4=ptarget4;
     t_Target5=ptarget5;
     t_Target6=ptarget6;
     t_Target7=ptarget7;
     t_Target8=ptarget8;
     t_Target9=ptarget9;
}

VOID
pollVar::setResultsVbs(            // set up results text variables
question *qobj,                    // pointer to question object (or NULL)
SHORT answer)                      // which answer to set up
{
     ASSERT(answer >= ANSWER1 && answer < MAXASTGS);

     if (qobj == NULL) {
          return;
     }

     poll *pobj=new poll(qobj->getPollName());

     t_ResultsAnswer=qobj->getAnswerString(answer);
     t_ResultsMatches=pobj->getTalliedAnswers(qobj->getNumber(),answer);
     t_ResultsPercent=pobj->getTalliedPercent(qobj->getNumber(),answer);
     t_ResultsTotAns=pobj->getTalliedTotal(qobj->getNumber());
     SHORT stal;
     t_Next="";
     t_Previous="";
     t_QuesMoreLo=t_QuesMoreHi=0;
     if (pobj->nextTallied(qobj->getNumber()+1,&stal)) {
          t_Next=stal;
          t_QuesMoreHi=1;
     }
     if (pobj->prevTallied(qobj->getNumber()-1,&stal)) {
          t_Previous=stal;
          t_QuesMoreLo=1;
     }

     delete pobj;
}

VOID
pollVar::setTableMCVbs(            // set up table-based MC questions
bool chosen,
const CHAR *answerChoice,
const CHAR *theValue)
{
     ASSERT(theValue != NULL);
     ASSERT(answerChoice != NULL);

     t_ValOfValue=theValue;
     t_AnswerString=answerChoice;
     if (chosen) {
          t_AnswerCheck=CHK;
          t_AnswerSelect=SEL;
     }
}

VOID
pollVar::setTemplatePrefix(        // set the template prefix tvb
const CHAR *prefix)
{
     ASSERT(prefix != NULL);

     t_TemplatePrefix=prefix;
}

VOID
pollVar::setTakeVbs(               // set up take/lookup text variables
question *qobj,                    // pointer to question object
const CHAR *userid,                // user-id (can be NULL for anonymous)
bool lookup)
{
     ASSERT(qobj != NULL);
     SHORT qtype, ansit;
     SHORT totAns=0;

     poll *pobj=new poll(qobj->getPollName());

     t_QTypeNumber=qtype=qobj->getQType();
     switch (qtype) {
     case CREDIT:
          t_QuestionType=qcredit;
          break;
     case DATE:
          t_QuestionType=qdate;
          break;
     case DISONLY:
          t_QuestionType=qdisonly;
          break;
     case MULTICHC:
          t_QuestionType=qmulti;

          for (ansit=ANSWER1; ansit < MAXASTGS; ansit++) {
               if (strlen(qobj->getAnswerString(ansit)) == 0) {
                    continue;
               }
               ++totAns;
               if (userid != NULL) {
                    if (qobj->getNumAnswers() > 1
                     && qobj->isMultiAnswerSelected(ansit,userid)) {
                         *t_CheckArray[ansit]=CHK;
                         *t_SelectArray[ansit]=SEL;
                    }
                    else if (qobj->isAnswerSelected(ansit,userid)) {
                         *t_CheckArray[ansit]=CHK;
                         *t_SelectArray[ansit]=SEL;
                    }
               }
               *t_AnswerStringArray[ansit]=qobj->getAnswerString(ansit);
               if (qobj->getFlags()&BRANCH) {
                    *t_BranchArray[ansit]=qobj->getBranch(ansit);
               }
          }
          t_TotalAnswersInQuestion=totAns;
          break;
     case NUMERIC:
          t_QuestionType=qnumeric;
          break;
     case OPEN_ENDED:
          t_QuestionType=qopen;
          break;
     case TRUEFALSE:
          t_QuestionType=qtf;
          break;
     case YESNO:
          t_QuestionType=qyn;
          break;
     case USERACCT:
          t_QuestionType=quacc;
          t_AccountFieldNum=qobj->getAccountField();
     }

     t_AnswerLimit=qobj->getNumAnswers();
     const CHAR *ptxt;
     if ((ptxt=qobj->getTextMsg()) != NULL) {
          t_DispTxt=htmlFormatMessage(linkURLs(htmlEncode(ptxt),anchor).c_str(),
           TRUE,TRUE);
     }
     if (userid != NULL) {
          const CHAR *ansptr=qobj->getAnswer(userid);
          (ansptr == NULL) ? t_IsAnswered=0 : t_IsAnswered=1;
     }
     qobj->getFlags()&BRANCH ? t_IsBranch=1: t_IsBranch=0;
     if (qobj->getQType() == DATE) {  // year 2000 friendly
          t_MaxLen=DATESIZE;
          t_MinLen=DATESIZE;
     }
     else if (qobj->getQType() == NUMERIC) {
          t_MaxLen=MAXNUMSIZ;
     }
     else {
          t_MaxLen=qobj->getMaxLen();
     }
     t_MinLen=qobj->getMinLen();

     if (!lookup) {
          pobj->isQuestion(qobj->getNext()) ? t_QuesMoreLo=1 : t_QuesMoreLo=0;
          pobj->isQuestion(qobj->getPrevious()) ? t_QuesMoreHi=1: t_QuesMoreLo=0;
     }

     SHORT slook;
     if (lookup) {
          if (pobj->nextLookup(userid,qobj->getNumber()+1,&slook)) {
               t_Next=slook;
               t_QuesMoreHi=1;
          }
     }
     else if (pobj->isQuestion(qobj->getNext())) {
          t_Next=qobj->getNext();
     }
     t_Number=qobj->getNumber();
     t_DisplayNumber=qobj->getNumber()+1;
     if (lookup) {
          if (pobj->prevLookup(userid,qobj->getNumber()-1,&slook)) {
               t_Previous=slook;
               t_QuesMoreLo=1;
          }
     }
     else if (pobj->isQuestion(qobj->getPrevious()) && qobj->getNumber() != 0) {
          t_Previous=qobj->getPrevious();
     }
     t_HtmlQName=qparam;
     t_HtmlQName+=qobj->getNumber();

     if (qobj->getQType() == YESNO || qobj->getQType() == TRUEFALSE) {
          t_TotalAnswersInQuestion=2;
          if (userid != NULL
           && qobj->isBooleanSelected(ANSWER2,userid)) {
               t_AnswerChecked1=CHK;
               t_AnswerSelected1=SEL;
          }
          else if (userid != NULL
           && qobj->isBooleanSelected(ANSWER1,userid)) {
               t_AnswerChecked2=CHK;
               t_AnswerSelected2=SEL;
          }
     }
     else {
          t_TotalAnswersInQuestion=1;
          if (userid != NULL) {
               const CHAR *ansptr=qobj->getAnswer(userid);
               if (ansptr != NULL) {
                    t_Answer=ansptr;
               }
          }
     }

     if (userid != NULL) {
          t_LookupUser=userid;
          t_EncLookupUser=userid;
     }

     delete pobj;
}

VOID
pollVar::setListVariables(         // set up list text variables
poll *pobj,                        // pointer to poll object
const CHAR *userid)                // userid (can be NULL for anon)
{
     if (pobj == NULL) {
          t_PollNone1=linkURLs(htmlEncode(nopoll1),anchor);
          t_PollNone2=linkURLs(htmlEncode(nopoll2),anchor);
          t_PollNone3=linkURLs(htmlEncode(nopoll3),anchor);
          t_PollNone4=linkURLs(htmlEncode(nopoll4),anchor);
          t_PollNone5=linkURLs(htmlEncode(nopoll5),anchor);
          t_PollNone6=linkURLs(htmlEncode(nopoll6),anchor);
          t_PollNone7=linkURLs(htmlEncode(nopoll7),anchor);
          t_PollNone8=linkURLs(htmlEncode(nopoll8),anchor);
          t_PollNone9=linkURLs(htmlEncode(nopoll9),anchor);
     }
     else {
          SHORT answerType;

          t_AnswerNum=answerType=pobj->getAnswerType();
          switch (answerType) {
          case ONCE:
               t_AnswerType=paonce;
               break;
          case REPLACE:
               t_AnswerType=parepl;
               break;
          case ACCUMULATE:
               t_AnswerType=paacum;
          }
          if (userid != NULL) {
               uhskey(userid,pobj->getResultKey()) ? t_CanGetRslts=1 : t_CanGetRslts=0;
               uhskey(userid,pobj->getLookupKey()) ? t_CanLookUp=1 : t_CanLookUp=0;
          }
          t_Class2Grant=pobj->getGrantClass();

          USHORT closeDate=pobj->getCloseDate();
          USHORT createDate=pobj->getCreateDate();

          t_DCloseDate=format("%d",ddday(closeDate));
          t_D0CloseDate=format("%.2d",ddday(closeDate));
          t_EurLCloseDate=format("%d %s %d",ddday(closeDate),
           strMonths[ddmon(closeDate)-1],ddyear(closeDate));
          t_EurSCloseDate=prndat(PRND_DMMY,closeDate,'/');
          t_MLCloseDate=strMonths[ddmon(closeDate)-1];
          t_MNCloseDate=format("%d",ddmon(closeDate));
          t_MN0CloseDate=format("%.2d",ddmon(closeDate));
          t_MSCloseDate=moname[ddmon(closeDate)];
          t_USLCloseDate=prndat(PRND_MMMDYY,closeDate,' ');
          t_USSCloseDate=prndat(PRND_MDY,closeDate,'/');
          t_WLCloseDate=strDays[DOFWEEK(closeDate)];
          t_WSCloseDate=shortDays[DOFWEEK(closeDate)];
          t_YLCloseDate=format("%d",ddyear(closeDate));
          string shortyear=stringFormat(ddyear(closeDate));
          t_YSCloseDate=format(shortyear.c_str()+2);

          t_DCreateDate=format("%d",ddday(createDate));
          t_D0CreateDate=format("%.2d",ddday(createDate));
          t_EurLCreateDate=format("%d %s %d",ddday(createDate),
           strMonths[ddmon(createDate)-1],ddyear(createDate));
          t_EurSCreateDate=prndat(PRND_DMMY,createDate,'/');
          t_MLCreateDate=strMonths[ddmon(createDate)-1];
          t_MNCreateDate=format("%d",ddmon(createDate));
          t_MN0CreateDate=format("%.2d",ddmon(createDate));
          t_MSCreateDate=moname[ddmon(createDate)];
          t_USLCreateDate=prndat(PRND_MMMDYY,createDate,' ');
          t_USSCreateDate=prndat(PRND_MDY,createDate,'/');
          t_WLCreateDate=strDays[DOFWEEK(createDate)];
          t_WSCreateDate=shortDays[DOFWEEK(createDate)];
          t_YLCreateDate=format("%d",ddyear(createDate));
          shortyear=stringFormat(ddyear(createDate));
          t_YSCreateDate=format(shortyear.c_str()+2);

          t_Credits2Grant=pobj->getGrantCredits();
          t_Description=pobj->getDescription();
          t_File2Grant=pobj->getGrantFile();
          t_Key2Grant=pobj->getGrantKey();
          t_KeyLogon=pobj->getLogonKey();
          t_KeyLookUp=pobj->getLookupKey();
          t_KeyResults=pobj->getResultKey();
          t_KeyTake=pobj->getTakeKey();
          t_Name=pobj->getName();
          t_EncName=pobj->getName();

          SHORT ptype;

          t_PollTypeNum=ptype=pobj->getType();

          if (ptype == POLL) {
               t_PollTypeImg=ptypimg;
               t_PollType=ptypep;
          }
          else {
               t_PollTypeImg=qtypimg;
               t_PollType=ptypeq;
          }

          SHORT var;

          if (userid != NULL) {
               t_StatusNum=var=pobj->getStatus(userid);
          }

          switch (var) {
          case STAT_NEW:
               t_StatusImage=newimg;
               t_Status=pstat[var];
               break;
          case STAT_DONE:
               t_StatusImage=doneimg;
               t_Status=pstat[var];
               break;
          case STAT_DEL:
               t_StatusImage=delimg;
               t_Status=pstat[var];
               break;
          case STAT_MAINT:
               t_StatusImage=mntimg;
               t_Status=pstat[var];
          }

          t_StorageNum=var=pobj->getStorageMethod();

          switch(var) {
          case ASCII:
               t_Storage=psasc;
               break;
          case BTRIEVE:
               t_Storage=psbtv;
               break;
          case BOTH:
               t_Storage=psbth;
               break;
          case DISCARD:
               t_Storage=psnone;
          }

          if (userid != NULL && pobj->isComplete(userid)) {
               setmbk(pAHmsg);
               if (t_Class2Grant.length() > 0) {
                    clrprf();
                    prfmsg(PCLSGRNT,pobj->getGrantClass());
                    t_ClassGranted=stpans(prfbuf);
               }
               if (pobj->getGrantCredits() > 0) {
                    clrprf();
                    prfmsg(PCRDGRNT,pobj->getGrantCredits());
                    t_CredGranted=stpans(prfbuf);
               }
               if (t_File2Grant.length() > 0) {
                    clrprf();
                    string link=pobj->getFileLink();
                    string name=pobj->getGrantFileName();
                    prfmsg(PFILGRNT,link.c_str(),name.c_str());
                    t_FileGranted=stpans(prfbuf);
               }
               if (t_Key2Grant.length() > 0) {
                    clrprf();
                    prfmsg(PKEYGRNT,pobj->getGrantKey());
                    t_KeyGranted=stpans(prfbuf);
               }
               rstmbk();
          }
     }
}

const CHAR *
pollVar::format(                   // variable argument formatter
const CHAR *fmt
...)
{
     setmem(m_formatBuf,SPRINTFSIZ,0);
     va_list ap;
     va_start(ap,fmt);
     vsprintf(m_formatBuf,fmt,ap);
     return(m_formatBuf);
}

VOID
pollVar::clearAllVars()            // clear all text variables
{
     t_ClassGranted="";
     t_CredGranted="";
     t_FileGranted="";
     t_KeyGranted="";

     t_ErrMessage="";
     t_ErrQID="";

     t_LookupUser="";
     t_EncLookupUser="";

     t_AnswerType="";
     t_AnswerNum="";
     t_CanGetRslts="";
     t_CanLookUp="";
     t_Class2Grant="";
     t_DCloseDate="";
     t_D0CloseDate="";
     t_EurLCloseDate="";
     t_EurSCloseDate="";
     t_MLCloseDate="";
     t_MNCloseDate="";
     t_MN0CloseDate="";
     t_MSCloseDate="";
     t_USLCloseDate="";
     t_USSCloseDate="";
     t_WLCloseDate="";
     t_WSCloseDate="";
     t_YLCloseDate="";
     t_YSCloseDate="";
     t_DCreateDate="";
     t_D0CreateDate="";
     t_EurLCreateDate="";
     t_EurSCreateDate="";
     t_MLCreateDate="";
     t_MNCreateDate="";
     t_MN0CreateDate="";
     t_MSCreateDate="";
     t_USLCreateDate="";
     t_USSCreateDate="";
     t_WLCreateDate="";
     t_WSCreateDate="";
     t_YLCreateDate="";
     t_YSCreateDate="";
     t_Credits2Grant="";
     t_Description="";
     t_File2Grant="";
     t_Key2Grant="";
     t_KeyLogon="";
     t_KeyLookUp="";
     t_KeyResults="";
     t_KeyTake="";
     t_Name="";
     t_EncName="";
     t_PollType="";
     t_Status="";
     t_StatusImage="";
     t_Storage="";
     t_StorageNum="";
     t_PollTypeImg="";
     t_PollTypeNum="";

     t_Target1="";
     t_Target2="";
     t_Target3="";
     t_Target4="";
     t_Target5="";
     t_Target6="";
     t_Target7="";
     t_Target8="";
     t_Target9="";

     t_PollNone1="";
     t_PollNone2="";
     t_PollNone3="";
     t_PollNone4="";
     t_PollNone5="";
     t_PollNone6="";
     t_PollNone7="";
     t_PollNone8="";
     t_PollNone9="";

     t_Count="";
     t_Low="";
     t_Status="";
     t_Priority="";
     t_PollMoreHi=0;
     t_PollMoreLo=0;
     t_Order="";
     t_Hi="";

     t_AnswerChecked1="";
     t_AnswerChecked2="";
     t_AnswerChecked3="";
     t_AnswerChecked4="";
     t_AnswerChecked5="";
     t_AnswerChecked6="";
     t_AnswerChecked7="";
     t_AnswerChecked8="";
     t_AnswerChecked9="";
     t_AnswerChecked10="";
     t_AnswerChecked11="";
     t_AnswerChecked12="";
     t_AnswerChecked13="";
     t_AnswerChecked14="";
     t_AnswerChecked15="";
     t_AnswerChecked16="";

     t_AnswerSelected1="";
     t_AnswerSelected2="";
     t_AnswerSelected3="";
     t_AnswerSelected4="";
     t_AnswerSelected5="";
     t_AnswerSelected6="";
     t_AnswerSelected7="";
     t_AnswerSelected8="";
     t_AnswerSelected9="";
     t_AnswerSelected10="";
     t_AnswerSelected11="";
     t_AnswerSelected12="";
     t_AnswerSelected13="";
     t_AnswerSelected14="";
     t_AnswerSelected15="";
     t_AnswerSelected16="";

     t_AnswerString1="";
     t_AnswerString2="";
     t_AnswerString3="";
     t_AnswerString4="";
     t_AnswerString5="";
     t_AnswerString6="";
     t_AnswerString7="";
     t_AnswerString8="";
     t_AnswerString9="";
     t_AnswerString10="";
     t_AnswerString11="";
     t_AnswerString12="";
     t_AnswerString13="";
     t_AnswerString14="";
     t_AnswerString15="";
     t_AnswerString16="";

     t_Branch1="";
     t_Branch2="";
     t_Branch3="";
     t_Branch4="";
     t_Branch5="";
     t_Branch6="";
     t_Branch7="";
     t_Branch8="";
     t_Branch9="";
     t_Branch10="";
     t_Branch11="";
     t_Branch12="";
     t_Branch13="";
     t_Branch14="";
     t_Branch15="";
     t_Branch16="";

     t_AnswerLimit="";
     t_Answer="";
     t_DispTxt="";
     t_IsAnswered="";
     t_IsBranch="";
     t_MaxLen="";
     t_MinLen="";
     t_QuesMoreLo=0;
     t_QuesMoreHi=0;
     t_Next="";
     t_Number="";
     t_Previous="";
     t_QTypeNumber="";
     t_TemplatePrefix="";
     t_TotalAnswersInQuestion="";
     t_QuestionType="";
     t_AccountFieldNum="";

     t_ResultsAnswer="";
     t_ResultsMatches=0;
     t_ResultsPercent=0;
     t_ResultsTotAns=0;

     t_ValOfValue="";
     t_AnswerString="";
     t_AnswerSelect="";
     t_AnswerCheck="";
}
