/***************************************************************************
 *                                                                         *
 *   POLLSYN.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.                                  *
 *                                                                         *
 *                                                                         *
 *   Poll Class.                                                           *
 *                                                  - N.C. Osterc  9/06/98 *
 *                                                                         *
 ***************************************************************************/

#ifndef __POLLSYN_H
#define __POLLSYN_H

#include "poll.h"
#include "galacth.h"
#include "dnf.h"
#include "pollapi.h"
#include "pollvar.h"
#include "question.h"
#include "cyctimer.h"

#define URLSIZ 1024
#define PVALBUFSIZ 16384
#define PPFIX "galacth/galpnqah/"
#define GETPARAMVAL(x) ses->param(x,m_pValBuf,PVALBUFSIZ)
#define ISPARAM(x) ses->paramIndex(x,m_index)
#define QUESTIONNAIRE 2

class pollSynthesis: public acthSynthesis {
public:

     pollSynthesis(                // default constructor
     acthSession *_ses);           // session object

     virtual
     ~pollSynthesis();             // destructor

     virtual
     ACTHCODE
     proceed();                    // proceed entry point

protected:

     VOID
     getRedirects();               // get onerror/onsuccess params

     VOID
     setError(                     // set up error tvbs
     INT messageOpt,               // the message option
     const CHAR *arg1=NULL,        // first argument
     const CHAR *arg2=NULL,        // second argument
     SHORT qnum=-1);               // the question number

     VOID
     setErrorVbs();                // set error tvbs up

     virtual const CHAR *
     getSynthDir();                // get the synthesis directory

     virtual ACTHCODE
     dynafile();                   // dynafile

     bool
     hasAgentAccess();             // does user have access?

     ACTHCODE
     initRequest();                // initialize request stuff

     ACTHCODE
     isUserOK();                   // check user specific stuff

     VOID
     getHandler(                   // set m_dnfPtr given arguments below
     bool error,                   // error?
     dnfMap *defMap);              // default response map

     ACTHCODE
     handleDynaResp(               // handle response
     bool error,                   // an error occured?
     dnfMap *errorMap,             // default error map to use
     dnfMap *successMap);          // default success map to use

     CHAR m_onErrorBuf[URLSIZ];    // buffer to hold onerror param
     CHAR m_onSuccessBuf[URLSIZ];  // buffer to hold onsuccess param
     acthUserID *m_usrPtr;         // user object
     dnfHandler *m_dnfPtr;         // dnfhandler object
     pollAPI *m_pAPI;              // pointer to poll api object
     pollVar *m_pTvb;              // point to poll variables object
     poll *m_pPoll;                // point to poll object
     question *m_pQues;            // point to question object
     CHAR m_pValBuf[PVALBUFSIZ];   // buffer - stores parameter values
     bool m_checkedFramePref;      // did we check frame pref yet?
     bool m_framesOn;              // are frames on?
     cycleTimer m_cyc;             // cyctle timer instance
     INT m_index;                  // index - used in ISPARAM
     SHORT m_ahState;              // state-tracking variable
     string m_errMessage;          // save error message
     SHORT m_errQid;               // save question id
     bool m_errorStatus;           // did error occur?
};

#endif                             // __POLLSYN_H
